/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.perspective;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.ResourceActivatorSetType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.TabType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tab
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private List<Tab> children;
    private String qualifiedName;
    private String name;
    private String displayName;
    private String url;
    private String iconUrl;
    private transient List<ResourceActivatorSetType> currentResourceOrGroupActivatorSet;

    public Tab(TabType tab) {
        this.qualifiedName = tab.getName();
        int lastDotIndex = this.qualifiedName.lastIndexOf(".");
        this.name = this.qualifiedName.substring(lastDotIndex + 1);
        this.displayName = tab.getDisplayName();
        this.url = tab.getUrl();
        if (tab.getApplication() != null) {
            this.url = this.url + "&tab=" + this.qualifiedName;
        }
        this.iconUrl = tab.getIconUrl();
        this.currentResourceOrGroupActivatorSet = tab.getCurrentResourceOrGroupActivatorSet() != null ? tab.getCurrentResourceOrGroupActivatorSet() : Collections.emptyList();
        this.children = new ArrayList<Tab>();
    }

    @NotNull
    public List<Tab> getChildren() {
        return this.children;
    }

    public void setChildren(List<Tab> children) {
        this.children = children != null ? children : new ArrayList();
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getUrl() {
        return this.url;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    @NotNull
    public List<ResourceActivatorSetType> getCurrentResourceOrGroupActivatorSets() {
        return this.currentResourceOrGroupActivatorSet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tab tab = (Tab)o;
        return this.name.equals(tab.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.name + ", displayName=" + this.displayName + ", url=" + this.url + ", iconUrl=" + this.iconUrl + "]";
    }

    public Tab clone() throws CloneNotSupportedException {
        Object obj = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(this);
            out.flush();
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
            obj = in.readObject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Tab tab = (Tab)obj;
        if (tab != null) {
            tab.currentResourceOrGroupActivatorSet = this.currentResourceOrGroupActivatorSet;
            List<Tab> subtabs = tab.getChildren();
            if (subtabs != null) {
                int subtabsSize = subtabs.size();
                for (int i = 0; i < subtabsSize; ++i) {
                    Tab subtab = subtabs.get(i);
                    subtab.currentResourceOrGroupActivatorSet = this.children.get((int)i).currentResourceOrGroupActivatorSet;
                }
            }
        }
        return tab;
    }
}

