/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDataMap;
import org.rhq.core.domain.plugin.PluginKey;
import org.rhq.enterprise.server.plugin.pc.ConcurrentJobWrapper;
import org.rhq.enterprise.server.plugin.pc.MasterServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.ServerPluginContext;
import org.rhq.enterprise.server.plugin.pc.ServerPluginEnvironment;
import org.rhq.enterprise.server.plugin.pc.ServerPluginManager;
import org.rhq.enterprise.server.plugin.pc.ServerPluginType;
import org.rhq.enterprise.server.plugin.pc.StatefulJobWrapper;
import org.rhq.enterprise.server.scheduler.SchedulerLocal;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.xmlschema.CronScheduleType;
import org.rhq.enterprise.server.xmlschema.PeriodicScheduleType;
import org.rhq.enterprise.server.xmlschema.ScheduledJobDefinition;

public abstract class AbstractTypeServerPluginContainer {
    private final Log log = LogFactory.getLog(this.getClass());
    private final MasterServerPluginContainer master;
    private ServerPluginManager pluginManager;

    public AbstractTypeServerPluginContainer(MasterServerPluginContainer master) {
        this.master = master;
    }

    public abstract ServerPluginType getSupportedServerPluginType();

    public MasterServerPluginContainer getMasterServerPluginContainer() {
        return this.master;
    }

    public ServerPluginManager getPluginManager() {
        return this.pluginManager;
    }

    public synchronized void initialize() throws Exception {
        this.log.debug((Object)"Server plugin container initializing");
        this.pluginManager = this.createPluginManager();
        this.pluginManager.initialize();
    }

    public synchronized void start() {
        this.log.debug((Object)"Server plugin container starting");
        this.pluginManager.startPlugins();
    }

    public synchronized void stop() {
        this.log.debug((Object)"Server plugin container stopping");
        this.pluginManager.stopPlugins();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        this.log.debug((Object)"Server plugin container shutting down");
        if (this.pluginManager != null) {
            Collection<ServerPluginEnvironment> envs = this.pluginManager.getPluginEnvironments();
            for (ServerPluginEnvironment env : envs) {
                try {
                    this.unloadPlugin(env.getPluginKey());
                }
                catch (Exception e) {
                    this.log.warn((Object)("Failed to unload plugin [" + env.getPluginKey().getPluginName() + "]."), (Throwable)e);
                }
            }
            try {
                this.pluginManager.shutdown();
            }
            finally {
                this.pluginManager = null;
            }
        }
    }

    public synchronized void loadPlugin(ServerPluginEnvironment env, boolean enabled) throws Exception {
        if (this.pluginManager == null) {
            throw new Exception("Cannot load a plugin; plugin container is not initialized yet");
        }
        this.pluginManager.loadPlugin(env, enabled);
    }

    public synchronized void unloadPlugin(PluginKey pluginKey) throws Exception {
        if (this.pluginManager == null) {
            throw new Exception("Cannot unload a plugin; plugin container has been shutdown");
        }
        this.pluginManager.unloadPlugin(pluginKey.getPluginName());
    }

    public synchronized void reloadPlugin(PluginKey pluginKey, boolean enabled) throws Exception {
        if (this.pluginManager == null) {
            throw new Exception("Cannot reload a plugin; plugin container has been shutdown");
        }
        this.pluginManager.reloadPlugin(pluginKey.getPluginName(), enabled);
    }

    public synchronized void scheduleAllPluginJobs() throws Exception {
        if (this.pluginManager != null) {
            for (ServerPluginEnvironment pluginEnv : this.pluginManager.getPluginEnvironments()) {
                this.schedulePluginJobs(pluginEnv.getPluginKey());
            }
        } else {
            throw new Exception("Cannot schedule plugins jobs; plugin container is not initialized yet");
        }
    }

    public synchronized void schedulePluginJobs(PluginKey pluginKey) throws Exception {
        block9: {
            if (this.pluginManager != null) {
                try {
                    String pluginName = pluginKey.getPluginName();
                    if (!this.pluginManager.isPluginEnabled(pluginName)) break block9;
                    ServerPluginEnvironment pluginEnv = this.pluginManager.getPluginEnvironment(pluginName);
                    if (pluginEnv != null) {
                        ServerPluginContext serverPluginContext = this.pluginManager.getServerPluginContext(pluginEnv);
                        List<ScheduledJobDefinition> jobs = serverPluginContext.getSchedules();
                        if (jobs != null) {
                            for (ScheduledJobDefinition job : jobs) {
                                try {
                                    this.scheduleJob(job, pluginKey);
                                }
                                catch (Throwable t) {
                                    this.log.warn((Object)("Failed to schedule job [" + job + "] for server plugin [" + pluginKey + "]"), t);
                                }
                            }
                        }
                        break block9;
                    }
                    this.log.warn((Object)("Failed to get server plugin env for [" + pluginKey + "]; cannot schedule jobs"));
                }
                catch (Throwable t) {
                    this.log.warn((Object)("Failed to get scheduled jobs for server plugin [" + pluginKey + "]"), t);
                }
            } else {
                throw new Exception("Cannot schedule plugins jobs for server plugin [" + pluginKey + "]; plugin container is not initialized yet");
            }
        }
    }

    public void unschedulePluginJobs(PluginKey pluginKey) throws Exception {
        SchedulerLocal scheduler = LookupUtil.getSchedulerBean();
        String groupName = pluginKey.getPluginName();
        scheduler.pauseJobGroup(groupName);
        String[] jobNames = scheduler.getJobNames(groupName);
        if (jobNames != null) {
            for (String jobName : jobNames) {
                boolean deleted = scheduler.deleteJob(jobName, groupName);
                if (deleted) {
                    this.log.info((Object)("Job [" + jobName + "] for plugin [" + pluginKey + "] has been unscheduled!"));
                    continue;
                }
                this.log.warn((Object)("Job [" + jobName + "] for plugin [" + pluginKey + "] failed to be unscheduled!"));
            }
        }
    }

    protected ServerPluginManager createPluginManager() {
        return new ServerPluginManager(this);
    }

    protected Log getLog() {
        return this.log;
    }

    protected void scheduleJob(ScheduledJobDefinition schedule, PluginKey pluginKey) throws Exception {
        if (!schedule.isEnabled()) {
            return;
        }
        String groupName = pluginKey.getPluginName();
        boolean rescheduleIfExists = true;
        boolean isVolatile = true;
        Class jobClass = schedule.getScheduleType().isConcurrent() ? ConcurrentJobWrapper.class : StatefulJobWrapper.class;
        JobDataMap jobData = new JobDataMap();
        jobData.put("__pluginName", pluginKey.getPluginName());
        jobData.put("__pluginType", pluginKey.getPluginType().toString());
        jobData.put("__jobId", schedule.getJobId());
        jobData.put("__scheduleType", schedule.getScheduleType().getTypeName());
        jobData.put("__scheduleTrigger", schedule.getScheduleType().getScheduleTrigger());
        jobData.putAsString("__isConcurrent", schedule.getScheduleType().isConcurrent());
        jobData.put("__jobMethodName", schedule.getMethodName());
        if (schedule.getClassName() != null) {
            jobData.put("__jobClass", schedule.getClassName());
        }
        if (schedule.getCallbackData() != null) {
            jobData.putAll((Map)schedule.getCallbackData());
        }
        SchedulerLocal scheduler = LookupUtil.getSchedulerBean();
        if (schedule.getScheduleType() instanceof CronScheduleType) {
            String cronExpression = ((CronScheduleType)schedule.getScheduleType()).getCronExpression();
            this.log.info((Object)("Scheduling server plugin cron job: jobName=" + schedule.getJobId() + ", groupName=" + groupName + ", jobClass=" + jobClass + ", cron=" + cronExpression));
            scheduler.scheduleCronJob(schedule.getJobId(), groupName, jobData, jobClass, rescheduleIfExists, isVolatile, cronExpression);
        } else {
            long initialDelay = 10000L;
            long interval = ((PeriodicScheduleType)schedule.getScheduleType()).getPeriod();
            this.log.info((Object)("Scheduling server plugin periodic job: jobName=" + schedule.getJobId() + ", groupName=" + groupName + ", jobClass=" + jobClass + ", interval=" + interval));
            scheduler.scheduleRepeatingJob(schedule.getJobId(), groupName, jobData, jobClass, rescheduleIfExists, isVolatile, initialDelay, interval);
        }
    }
}

