/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.plugin.PluginKey;
import org.rhq.enterprise.server.plugin.pc.ServerPluginClassLoader;
import org.rhq.enterprise.server.plugin.pc.ServerPluginType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.ServerPluginDescriptorType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderManager {
    private final Log log = LogFactory.getLog(ClassLoaderManager.class);
    private final File tmpDir;
    private final Map<PluginKey, URL> pluginKeysUrls;
    private final ClassLoader rootClassLoader;
    private final Map<PluginKey, ClassLoader> serverPluginClassLoaders;

    public ClassLoaderManager(Map<URL, ? extends ServerPluginDescriptorType> plugins, ClassLoader rootClassLoader, File tmpDir) {
        this.rootClassLoader = rootClassLoader;
        this.tmpDir = tmpDir;
        this.serverPluginClassLoaders = new HashMap<PluginKey, ClassLoader>();
        this.pluginKeysUrls = new HashMap<PluginKey, URL>(plugins.size());
        for (Map.Entry<URL, ? extends ServerPluginDescriptorType> entry : plugins.entrySet()) {
            ServerPluginType pluginType = new ServerPluginType(entry.getValue());
            PluginKey pluginKey = PluginKey.createServerPluginKey((String)pluginType.stringify(), (String)entry.getValue().getName());
            this.pluginKeysUrls.put(pluginKey, entry.getKey());
        }
    }

    public synchronized void shutdown() {
        for (ClassLoader doomedCL : this.getUniqueServerPluginClassLoaders()) {
            if (!(doomedCL instanceof ServerPluginClassLoader)) continue;
            try {
                ((ServerPluginClassLoader)doomedCL).destroy();
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to destroy classloader: " + doomedCL), (Throwable)e);
            }
        }
        this.serverPluginClassLoaders.clear();
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.getClass().getSimpleName());
        str.append(" tmp-dir=[").append(this.tmpDir).append(']');
        Set<ClassLoader> classLoaders = this.getUniqueServerPluginClassLoaders();
        str.append(", #plugin CLs=[").append(classLoaders.size());
        classLoaders.clear();
        str.append(']');
        return str.toString();
    }

    public ClassLoader getRootClassLoader() {
        return this.rootClassLoader;
    }

    public synchronized ClassLoader obtainServerPluginClassLoader(PluginKey pluginKey) throws Exception {
        ClassLoader cl = this.serverPluginClassLoaders.get(pluginKey);
        if (cl == null) {
            URL pluginJarUrl = this.pluginKeysUrls.get(pluginKey);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Creating classloader for plugin [" + pluginKey + "] from URL [" + pluginJarUrl + ']'));
            }
            ClassLoader parentClassLoader = this.rootClassLoader;
            cl = this.createClassLoader(pluginJarUrl, null, parentClassLoader);
            this.serverPluginClassLoaders.put(pluginKey, cl);
        }
        return cl;
    }

    public synchronized int getNumberOfServerPluginClassLoaders() {
        return this.serverPluginClassLoaders.size();
    }

    public synchronized Map<PluginKey, ClassLoader> getServerPluginClassLoaders() {
        return new HashMap<PluginKey, ClassLoader>(this.serverPluginClassLoaders);
    }

    private synchronized Set<ClassLoader> getUniqueServerPluginClassLoaders() {
        HashSet<ClassLoader> uniqueClassLoaders = new HashSet<ClassLoader>(this.serverPluginClassLoaders.values());
        return uniqueClassLoaders;
    }

    private ClassLoader createClassLoader(URL mainJarUrl, List<URL> additionalJars, ClassLoader parentClassLoader) throws Exception {
        ClassLoader classLoader;
        if (parentClassLoader == null) {
            parentClassLoader = this.getClass().getClassLoader();
        }
        if (mainJarUrl != null) {
            String pluginJarName = new File(mainJarUrl.getPath()).getName();
            if (additionalJars == null || additionalJars.size() == 0) {
                classLoader = ServerPluginClassLoader.create(pluginJarName, mainJarUrl, true, parentClassLoader, this.tmpDir);
            } else {
                ArrayList<URL> allJars = new ArrayList<URL>(additionalJars.size() + 1);
                allJars.add(mainJarUrl);
                allJars.addAll(additionalJars);
                classLoader = ServerPluginClassLoader.create(pluginJarName, allJars.toArray(new URL[allJars.size()]), true, parentClassLoader, this.tmpDir);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Created classloader for plugin jar [" + mainJarUrl + "] with additional jars [" + additionalJars + "]"));
            }
        } else {
            classLoader = parentClassLoader;
        }
        return classLoader;
    }
}

