/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.plugin.ServerPlugin;
import org.rhq.enterprise.server.plugin.ServerPluginsLocal;
import org.rhq.enterprise.server.plugin.pc.AbstractTypeServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.MasterServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.MasterServerPluginContainerConfiguration;
import org.rhq.enterprise.server.plugin.pc.ServerPluginComponent;
import org.rhq.enterprise.server.plugin.pc.ServerPluginContext;
import org.rhq.enterprise.server.plugin.pc.ServerPluginEnvironment;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.xmlschema.ServerPluginDescriptorMetadataParser;
import org.rhq.enterprise.server.xmlschema.ServerPluginDescriptorUtil;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.ServerPluginDescriptorType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerPluginManager {
    private final Log log = LogFactory.getLog(this.getClass());
    private final AbstractTypeServerPluginContainer parentPluginContainer;
    private final Map<String, ServerPluginEnvironment> loadedPlugins;
    private final Map<String, Boolean> enabledPlugins;
    private final Map<String, ServerPluginContext> pluginContextCache;
    private final Map<String, ServerPluginComponent> pluginComponentCache;

    public ServerPluginManager(AbstractTypeServerPluginContainer pc) {
        this.parentPluginContainer = pc;
        this.loadedPlugins = new HashMap<String, ServerPluginEnvironment>();
        this.pluginContextCache = new HashMap<String, ServerPluginContext>();
        this.pluginComponentCache = new HashMap<String, ServerPluginComponent>();
        this.enabledPlugins = new HashMap<String, Boolean>();
    }

    public AbstractTypeServerPluginContainer getParentPluginContainer() {
        return this.parentPluginContainer;
    }

    public Collection<ServerPluginEnvironment> getPluginEnvironments() {
        return new ArrayList<ServerPluginEnvironment>(this.loadedPlugins.values());
    }

    public ServerPluginEnvironment getPluginEnvironment(String pluginName) {
        return this.loadedPlugins.get(pluginName);
    }

    protected void initialize() throws Exception {
        this.log.debug((Object)"Plugin manager initializing");
    }

    protected void shutdown() {
        this.log.debug((Object)"Plugin manager shutting down");
        if (this.loadedPlugins.size() > 0) {
            this.log.warn((Object)("Server plugin manager is being shutdown while some plugins are still loaded: " + this.loadedPlugins));
        }
        this.loadedPlugins.clear();
        this.pluginContextCache.clear();
        this.pluginComponentCache.clear();
        this.enabledPlugins.clear();
    }

    protected void loadPlugin(ServerPluginEnvironment env, boolean enabled) throws Exception {
        String pluginName = env.getPluginKey().getPluginName();
        this.log.debug((Object)("Loading server plugin [" + pluginName + "] from: " + env.getPluginUrl()));
        if (enabled) {
            ServerPluginComponent component = this.createServerPluginComponent(env);
            if (component != null) {
                ServerPluginContext context = this.getServerPluginContext(env);
                this.log.debug((Object)("Initializing plugin component for server plugin [" + pluginName + "]"));
                ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(env.getPluginClassLoader());
                    component.initialize(context);
                }
                catch (Throwable t) {
                    throw new Exception("Plugin component failed to initialize server plugin", t);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalContextClassLoader);
                }
                this.pluginComponentCache.put(pluginName, component);
            }
        } else {
            this.log.info((Object)("Server plugin [" + pluginName + "] is loaded but disabled"));
        }
        this.loadedPlugins.put(pluginName, env);
        this.enabledPlugins.put(pluginName, enabled);
    }

    protected void startPlugins() {
        this.log.debug((Object)"Starting server plugins");
        for (String pluginName : this.pluginComponentCache.keySet()) {
            this.startPlugin(pluginName);
        }
        this.log.debug((Object)"Server plugins started.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startPlugin(String pluginName) {
        ServerPluginComponent component;
        if (this.isPluginEnabled(pluginName) && (component = this.pluginComponentCache.get(pluginName)) != null) {
            ServerPluginEnvironment env = this.loadedPlugins.get(pluginName);
            this.log.debug((Object)("Starting plugin component for server plugin [" + pluginName + "]"));
            ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                if (env == null) {
                    throw new Exception("Plugin [" + pluginName + "] was never loaded");
                }
                Thread.currentThread().setContextClassLoader(env.getPluginClassLoader());
                component.start();
            }
            catch (Throwable t) {
                this.log.warn((Object)("Plugin component failed to start plugin [" + pluginName + "]"), t);
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalContextClassLoader);
            }
        }
    }

    protected void stopPlugins() {
        this.log.debug((Object)"Stopping server plugins");
        for (String pluginName : this.pluginComponentCache.keySet()) {
            this.stopPlugin(pluginName);
        }
        this.log.debug((Object)"Server plugins stopped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopPlugin(String pluginName) {
        ServerPluginComponent component = this.pluginComponentCache.get(pluginName);
        if (component != null) {
            ServerPluginEnvironment env = this.loadedPlugins.get(pluginName);
            this.log.debug((Object)("Stopping plugin component for server plugin [" + pluginName + "]"));
            ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                if (env == null) {
                    throw new Exception("Plugin [" + pluginName + "] was never loaded");
                }
                Thread.currentThread().setContextClassLoader(env.getPluginClassLoader());
                component.stop();
            }
            catch (Throwable t) {
                this.log.warn((Object)("Plugin component failed to stop plugin [" + pluginName + "]"), t);
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalContextClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unloadPlugin(String pluginName) throws Exception {
        block10: {
            try {
                ServerPluginEnvironment env = this.getPluginEnvironment(pluginName);
                if (env == null) {
                    this.log.debug((Object)("Server plugin [" + pluginName + "] was never loaded, ignoring unload request"));
                    return;
                }
                this.log.debug((Object)("Unloading server plugin [" + pluginName + "]"));
                ServerPluginComponent component = this.pluginComponentCache.get(pluginName);
                if (component == null) break block10;
                this.log.debug((Object)("Shutting down plugin componentfor server plugin [" + pluginName + "]"));
                ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(env.getPluginClassLoader());
                    component.shutdown();
                }
                catch (Throwable t) {
                    throw new Exception("Plugin plugin componentfailed to initialize plugin", t);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalContextClassLoader);
                    this.pluginComponentCache.remove(pluginName);
                }
            }
            finally {
                this.loadedPlugins.remove(pluginName);
                this.enabledPlugins.remove(pluginName);
                this.pluginContextCache.remove(pluginName);
            }
        }
    }

    protected void reloadPlugin(String pluginName, boolean enabled) throws Exception {
        if (enabled) {
            this.enablePlugin(pluginName);
        } else {
            this.disablePlugin(pluginName);
        }
    }

    protected void enablePlugin(String pluginName) throws Exception {
        this.log.info((Object)("Enabling server plugin [" + pluginName + "]"));
        ServerPluginEnvironment env = this.getPluginEnvironment(pluginName);
        if (env == null) {
            throw new IllegalArgumentException("Server plugin [" + pluginName + "] was never loaded, cannot enable it");
        }
        this.stopPlugin(pluginName);
        this.unloadPlugin(pluginName);
        env = this.rebuildServerPluginEnvironment(env);
        try {
            this.loadPlugin(env, true);
        }
        catch (Exception e) {
            this.loadPlugin(env, false);
            throw e;
        }
        this.startPlugin(pluginName);
    }

    protected void disablePlugin(String pluginName) throws Exception {
        this.log.info((Object)("Disabling server plugin [" + pluginName + "]"));
        ServerPluginEnvironment env = this.getPluginEnvironment(pluginName);
        if (env == null) {
            throw new IllegalArgumentException("Server plugin [" + pluginName + "] was never loaded, cannot disable it");
        }
        this.stopPlugin(pluginName);
        this.unloadPlugin(pluginName);
        env = this.rebuildServerPluginEnvironment(env);
        this.loadPlugin(env, false);
    }

    protected boolean isPluginLoaded(String pluginName) {
        return this.loadedPlugins.containsKey(pluginName);
    }

    protected boolean isPluginEnabled(String pluginName) {
        return Boolean.TRUE.equals(this.enabledPlugins.get(pluginName));
    }

    protected ServerPluginComponent getServerPluginComponent(String pluginName) {
        return this.pluginComponentCache.get(pluginName);
    }

    protected Log getLog() {
        return this.log;
    }

    protected ServerPluginContext getServerPluginContext(ServerPluginEnvironment env) {
        List schedules;
        String pluginName = env.getPluginKey().getPluginName();
        ServerPluginContext context = this.pluginContextCache.get(pluginName);
        if (context != null) {
            return context;
        }
        MasterServerPluginContainer masterPC = this.parentPluginContainer.getMasterServerPluginContainer();
        MasterServerPluginContainerConfiguration masterConfig = masterPC.getConfiguration();
        File dataDir = new File(masterConfig.getDataDirectory(), pluginName);
        File tmpDir = masterConfig.getTemporaryDirectory();
        Configuration pluginConfig = null;
        try {
            ServerPlugin plugin = this.getPlugin(env);
            pluginConfig = plugin.getPluginConfiguration();
            Configuration scheduledJobsConfig = plugin.getScheduledJobsConfiguration();
            schedules = ServerPluginDescriptorMetadataParser.getScheduledJobs((Configuration)scheduledJobsConfig);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get plugin config/schedules from the database", e);
        }
        context = new ServerPluginContext(env, dataDir, tmpDir, pluginConfig, schedules);
        this.pluginContextCache.put(pluginName, context);
        return context;
    }

    protected ServerPluginEnvironment rebuildServerPluginEnvironment(ServerPluginEnvironment env) throws Exception {
        URL url = env.getPluginUrl();
        ClassLoader classLoader = env.getPluginClassLoader();
        ServerPluginDescriptorType descriptor = ServerPluginDescriptorUtil.loadPluginDescriptorFromUrl((URL)url);
        ServerPluginEnvironment newEnv = new ServerPluginEnvironment(url, classLoader, descriptor);
        return newEnv;
    }

    protected ServerPlugin getPlugin(ServerPluginEnvironment pluginEnv) {
        ServerPluginsLocal serverPluginsManager = LookupUtil.getServerPlugins();
        ServerPlugin plugin = serverPluginsManager.getServerPlugin(pluginEnv.getPluginKey());
        plugin = serverPluginsManager.getServerPluginRelationships(plugin);
        return plugin;
    }

    protected ServerPluginComponent createServerPluginComponent(ServerPluginEnvironment environment) throws Exception {
        String pluginName = environment.getPluginKey().getPluginName();
        ServerPluginComponent instance = null;
        ServerPluginDescriptorType descriptor = environment.getPluginDescriptor();
        String className = ServerPluginDescriptorMetadataParser.getPluginComponentClassName((ServerPluginDescriptorType)descriptor);
        if (className != null) {
            this.log.debug((Object)("Creating plugin component [" + className + "] for plugin [" + pluginName + "]"));
            instance = (ServerPluginComponent)this.instantiatePluginClass(environment, className);
            this.log.debug((Object)("Plugin component created [" + instance.getClass() + "] for plugin [" + pluginName + "]"));
        }
        return instance;
    }

    protected Object instantiatePluginClass(ServerPluginEnvironment environment, String className) throws Exception {
        ClassLoader loader = environment.getPluginClassLoader();
        this.log.debug((Object)("Loading server plugin class [" + className + "]..."));
        try {
            Class<?> clazz = Class.forName(className, true, loader);
            this.log.debug((Object)("Loaded server plugin class [" + clazz + "]."));
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new Exception("Could not instantiate plugin class [" + className + "] from plugin environment [" + environment + "]", e);
        }
        catch (IllegalAccessException e) {
            throw new Exception("Could not access plugin class " + className + "] from plugin environment [" + environment + "]", e);
        }
        catch (ClassNotFoundException e) {
            throw new Exception("Could not find plugin class " + className + "] from plugin environment [" + environment + "]", e);
        }
        catch (NullPointerException npe) {
            throw new Exception("Plugin class was 'null' in plugin environment [" + environment + "]", npe);
        }
    }
}

