/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc.alert;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.rhq.core.domain.alert.notification.AlertNotification;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.plugin.PluginKey;
import org.rhq.core.domain.plugin.ServerPlugin;
import org.rhq.enterprise.server.alert.AlertNotificationManagerLocal;
import org.rhq.enterprise.server.plugin.ServerPluginsLocal;
import org.rhq.enterprise.server.plugin.pc.AbstractTypeServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.ServerPluginContext;
import org.rhq.enterprise.server.plugin.pc.ServerPluginEnvironment;
import org.rhq.enterprise.server.plugin.pc.ServerPluginManager;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSender;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSenderInfo;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.alert.AlertPluginDescriptorType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.alert.CustomUi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlertSenderPluginManager
extends ServerPluginManager {
    private final Log log = this.getLog();
    private Map<String, String> pluginClassByName = new HashMap<String, String>();
    private Map<String, ServerPluginEnvironment> pluginEnvByName = new HashMap<String, ServerPluginEnvironment>();
    private Map<String, AlertSenderInfo> senderInfoByName = new HashMap<String, AlertSenderInfo>();

    public AlertSenderPluginManager(AbstractTypeServerPluginContainer pc) {
        super(pc);
    }

    @Override
    public void loadPlugin(ServerPluginEnvironment env, boolean enable) throws Exception {
        this.log.info((Object)("Start loading alert plugin " + env.getPluginKey().getPluginName()));
        super.loadPlugin(env, enable);
        AlertPluginDescriptorType type = (AlertPluginDescriptorType)env.getPluginDescriptor();
        String className = type.getPluginClass();
        if (!className.contains(".")) {
            className = type.getPackage() + "." + className;
        }
        try {
            Class.forName(className, false, env.getPluginClassLoader());
        }
        catch (Exception e) {
            this.log.error((Object)("Can't find pluginClass " + className + ". Plugin " + env.getPluginKey().getPluginName() + " will be ignored"));
            try {
                this.unloadPlugin(env.getPluginKey().getPluginName());
            }
            catch (Throwable t) {
                this.log.warn((Object)("  +--> unload failed too " + t.getMessage()));
            }
            return;
        }
        String shortName = type.getShortName();
        this.pluginClassByName.put(shortName, className);
        URL uiSnippetUrl = null;
        CustomUi customUI = type.getCustomUi();
        if (customUI != null) {
            String uiSnippetPath = customUI.getUiSnippetName();
            try {
                uiSnippetUrl = env.getPluginClassLoader().getResource(uiSnippetPath);
                this.log.info((Object)("UI snipped for " + shortName + " is at " + uiSnippetUrl));
            }
            catch (Exception e) {
                this.log.error((Object)("No valid ui snippet provided, but <custom-ui> given for sender plugin " + shortName + "Error is " + e.getMessage()));
                this.log.error((Object)"Plugin will be ignored");
                return;
            }
            className = customUI.getBackingBeanName();
            if (!className.contains(".")) {
                className = type.getPackage() + "." + className;
            }
            try {
                Class.forName(className, true, env.getPluginClassLoader());
            }
            catch (Throwable t) {
                this.log.error((Object)("Backing bean " + className + " not found for plugin " + shortName));
            }
        }
        AlertSenderInfo info = new AlertSenderInfo(shortName, type.getDescription(), env.getPluginKey());
        info.setUiSnippetUrl(uiSnippetUrl);
        this.senderInfoByName.put(shortName, info);
        this.pluginEnvByName.put(shortName, env);
    }

    @Override
    protected void unloadPlugin(String pluginName) throws Exception {
        this.log.info((Object)("Unloading plugin " + pluginName));
        super.unloadPlugin(pluginName);
        String shortName = null;
        for (AlertSenderInfo info : this.senderInfoByName.values()) {
            if (!info.getPluginName().equals(pluginName)) continue;
            shortName = info.getShortName();
            break;
        }
        this.pluginClassByName.remove(shortName);
        this.senderInfoByName.remove(shortName);
        this.pluginEnvByName.remove(shortName);
    }

    public AlertSender getAlertSenderForNotification(AlertNotification notification) {
        AlertSender sender;
        Class<?> clazz;
        String senderName = notification.getSenderName();
        String className = this.pluginClassByName.get(senderName);
        if (className == null) {
            this.log.error((Object)("getAlertSender: No pluginClass found for sender: " + senderName));
            return null;
        }
        ServerPluginEnvironment env = this.pluginEnvByName.get(senderName);
        try {
            clazz = Class.forName(className, true, env.getPluginClassLoader());
        }
        catch (Exception e) {
            this.log.error((Object)e);
            return null;
        }
        try {
            sender = (AlertSender)clazz.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        ServerPluginContext ctx = this.getServerPluginContext(env);
        AlertNotificationManagerLocal mgr = LookupUtil.getAlertNotificationManager();
        sender.alertParameters = mgr.getAlertPropertiesConfiguration(notification);
        if (sender.alertParameters == null) {
            sender.alertParameters = new Configuration();
        }
        ServerPluginsLocal pluginsMgr = LookupUtil.getServerPlugins();
        PluginKey key = ctx.getPluginEnvironment().getPluginKey();
        ServerPlugin plugin = pluginsMgr.getServerPlugin(key);
        plugin = pluginsMgr.getServerPluginRelationships(plugin);
        sender.preferences = plugin.getPluginConfiguration();
        if (sender.preferences == null) {
            sender.preferences = new Configuration();
        }
        sender.pluginComponent = this.getServerPluginComponent(key.getPluginName());
        return sender;
    }

    public List<String> getPluginList() {
        return new ArrayList<String>(this.pluginClassByName.keySet());
    }

    public AlertSenderInfo getAlertSenderInfo(String shortName) {
        return this.senderInfoByName.get(shortName);
    }
}

