/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc.content;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.content.ContentSource;
import org.rhq.core.domain.content.ContentSourceSyncResults;
import org.rhq.core.domain.content.ContentSourceSyncStatus;
import org.rhq.core.domain.content.ContentSourceType;
import org.rhq.core.domain.content.Distribution;
import org.rhq.core.domain.content.DistributionFile;
import org.rhq.core.domain.content.Package;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.PackageVersionContentSource;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.criteria.RepoCriteria;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.content.ContentSourceManagerLocal;
import org.rhq.enterprise.server.content.DistributionManagerLocal;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.content.metadata.ContentSourceMetadataManagerLocal;
import org.rhq.enterprise.server.plugin.pc.ServerPluginEnvironment;
import org.rhq.enterprise.server.plugin.pc.content.ContentProvider;
import org.rhq.enterprise.server.plugin.pc.content.ContentProviderPackageDetails;
import org.rhq.enterprise.server.plugin.pc.content.ContentProviderPackageDetailsKey;
import org.rhq.enterprise.server.plugin.pc.content.ContentServerPluginManager;
import org.rhq.enterprise.server.plugin.pc.content.DistributionDetails;
import org.rhq.enterprise.server.plugin.pc.content.DistributionFileDetails;
import org.rhq.enterprise.server.plugin.pc.content.DistributionSource;
import org.rhq.enterprise.server.plugin.pc.content.DistributionSyncReport;
import org.rhq.enterprise.server.plugin.pc.content.InitializationException;
import org.rhq.enterprise.server.plugin.pc.content.PackageSource;
import org.rhq.enterprise.server.plugin.pc.content.PackageSyncReport;
import org.rhq.enterprise.server.plugin.pc.content.RepoImportReport;
import org.rhq.enterprise.server.plugin.pc.content.RepoSource;
import org.rhq.enterprise.server.plugin.pc.content.metadata.ContentSourcePluginMetadataManager;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentProviderManager {
    private static final Log log = LogFactory.getLog(ContentProviderManager.class);
    private ContentServerPluginManager pluginManager;
    private Map<ContentSource, ContentProvider> adapters;
    private final Object synchronizeContentSourceLock = new Object();

    public InputStream loadPackageBits(int contentSourceId, String location) throws Exception {
        ContentProvider adapter = this.getIsolatedContentProvider(contentSourceId);
        PackageSource packageSource = (PackageSource)((Object)adapter);
        InputStream inputStream = packageSource.getInputStream(location);
        if (inputStream == null) {
            throw new Exception("Adapter for content source [" + contentSourceId + "] failed to give us a stream to the package at location [" + location + "]");
        }
        return inputStream;
    }

    public InputStream loadDistributionFileBits(int contentSourceId, String location) throws Exception {
        ContentProvider adapter = this.getIsolatedContentProvider(contentSourceId);
        DistributionSource distSource = (DistributionSource)((Object)adapter);
        InputStream inputStream = distSource.getInputStream(location);
        if (inputStream == null) {
            throw new Exception("Adapter for content source [" + contentSourceId + "] failed to give us a stream to the distribution file at location [" + location + "]");
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean synchronizeContentSource(int contentSourceId) throws Exception {
        ContentSourceManagerLocal contentSourceManager = LookupUtil.getContentSourceManager();
        RepoManagerLocal repoManager = LookupUtil.getRepoManagerLocal();
        ContentProvider provider = this.getIsolatedContentProvider(contentSourceId);
        ContentSourceSyncResults results = null;
        SubjectManagerLocal subjMgr = LookupUtil.getSubjectManager();
        Subject overlord = subjMgr.getOverlord();
        StringBuilder progress = new StringBuilder();
        long start = System.currentTimeMillis();
        try {
            block13: {
                try {
                    PageList<Repo> repos;
                    RepoCriteria reposForContentSource;
                    ContentSource contentSource = contentSourceManager.getContentSource(overlord, contentSourceId);
                    if (contentSource == null) {
                        throw new Exception("Cannot sync a non-existing content source [" + contentSourceId + "]");
                    }
                    Object object = this.synchronizeContentSourceLock;
                    // MONITORENTER : object
                    progress.append(new Date()).append(": ");
                    progress.append("Start synchronization of content provider [").append(contentSource.getName()).append("]");
                    progress.append('\n');
                    progress.append(new Date()).append(": ");
                    progress.append("Getting currently known list of content source packages...");
                    results = new ContentSourceSyncResults(contentSource);
                    results.setResults(progress.toString());
                    results = contentSourceManager.persistContentSourceSyncResults(results);
                    // MONITOREXIT : object
                    if (results == null) {
                        log.info((Object)("Content provider [" + contentSource.getName() + "] is already currently being synchronized, this sync request will be ignored"));
                        boolean bl = false;
                        Object var23_15 = null;
                        if (results == null) return bl;
                        results.setEndTime(Long.valueOf(System.currentTimeMillis()));
                        contentSourceManager.mergeContentSourceSyncResults(results);
                        return bl;
                    }
                    if (provider instanceof RepoSource) {
                        progress.append(new Date()).append(": ");
                        progress.append("Asking content provider for repositories to import...");
                        RepoSource repoSource = (RepoSource)((Object)provider);
                        start = System.currentTimeMillis();
                        RepoImportReport report = repoSource.importRepos();
                        repoManager.processRepoImportReport(overlord, report, contentSourceId, progress);
                        log.info((Object)("importRepos: [" + contentSource.getName() + "]: report has been merged (" + (System.currentTimeMillis() - start) + ")ms"));
                    }
                    if (provider instanceof PackageSource) {
                        PackageSource packageSource = (PackageSource)((Object)provider);
                        reposForContentSource = new RepoCriteria();
                        reposForContentSource.addFilterContentSourceIds(new Integer[]{contentSourceId});
                        reposForContentSource.addFilterCandidate(Boolean.valueOf(false));
                        repos = repoManager.findReposByCriteria(overlord, reposForContentSource);
                        for (Repo repo : repos) {
                            start = System.currentTimeMillis();
                            List<PackageVersionContentSource> existingPVCS = contentSourceManager.getPackageVersionsFromContentSourceForRepo(subjMgr.getOverlord(), contentSource.getId(), repo.getId());
                            int existingCount = existingPVCS.size();
                            HashMap<ContentProviderPackageDetailsKey, PackageVersionContentSource> keyPVCSMap = new HashMap<ContentProviderPackageDetailsKey, PackageVersionContentSource>(existingCount);
                            HashSet<ContentProviderPackageDetails> allDetails = new HashSet<ContentProviderPackageDetails>(existingCount);
                            this.translateDomainToDto(existingPVCS, allDetails, keyPVCSMap);
                            log.info((Object)("synchronizePackages: [" + contentSource.getName() + "]: loaded existing list of size=[" + existingCount + "] (" + (System.currentTimeMillis() - start) + ")ms"));
                            progress.append(existingCount).append('\n');
                            progress.append(new Date()).append(": ");
                            progress.append("Asking content source to update the list of packages...");
                            results.setResults(progress.toString());
                            results = contentSourceManager.mergeContentSourceSyncResults(results);
                            start = System.currentTimeMillis();
                            PackageSyncReport report = new PackageSyncReport();
                            packageSource.synchronizePackages(repo.getName(), report, allDetails);
                            log.info((Object)("synchronizePackages: [" + contentSource.getName() + "]: got sync report from adapter=[" + report + "] (" + (System.currentTimeMillis() - start) + ")ms"));
                            progress.append("new=").append(report.getNewPackages().size());
                            progress.append(", updated=").append(report.getUpdatedPackages().size());
                            progress.append(", deleted=").append(report.getDeletedPackages().size()).append('\n');
                            progress.append(new Date()).append(": ");
                            progress.append("FULL SUMMARY FOLLOWS:").append('\n');
                            progress.append(report.getSummary()).append('\n');
                            progress.append(new Date()).append(": ");
                            progress.append("Merging the updated list of packages to database").append('\n');
                            results.setResults(progress.toString());
                            results = contentSourceManager.mergeContentSourceSyncResults(results);
                            start = System.currentTimeMillis();
                            results = contentSourceManager.mergeContentSourceSyncReport(contentSource, report, keyPVCSMap, results);
                        }
                        progress.setLength(0);
                        progress.append(results.getResults());
                        log.info((Object)("synchronizePackages: [" + contentSource.getName() + "]: report has been merged (" + (System.currentTimeMillis() - start) + ")ms"));
                        progress.append(new Date()).append(": ").append("DONE.");
                        results.setResults(progress.toString());
                        results.setStatus(ContentSourceSyncStatus.SUCCESS);
                        results = contentSourceManager.mergeContentSourceSyncResults(results);
                    }
                    log.info((Object)("Checking if provider: " + provider + " is a DistributionSource"));
                    if (!(provider instanceof DistributionSource)) break block13;
                    log.info((Object)("synchronizeContentSource(" + contentSourceId + "):  this source is a DistributionSource"));
                    log.info((Object)"We will skip the sync for now until PackageSource is working.");
                    DistributionSource distSource = (DistributionSource)((Object)provider);
                    reposForContentSource = new RepoCriteria();
                    reposForContentSource.addFilterContentSourceIds(new Integer[]{contentSourceId});
                    reposForContentSource.addFilterCandidate(Boolean.valueOf(false));
                    repos = repoManager.findReposByCriteria(overlord, reposForContentSource);
                    for (Repo repo : repos) {
                        log.info((Object)("ContentProviderManager::synchronizeContentSource  DistributionSource would be syncing repo: " + repo.getName()));
                        start = System.currentTimeMillis();
                        PageControl pc = PageControl.getUnlimitedInstance();
                        log.debug((Object)("Looking up existing distributions for repoId: " + repo.getId()));
                        PageList<Distribution> dists = repoManager.findAssociatedDistributions(overlord, repo.getId(), pc);
                        log.debug((Object)("Found " + dists.size() + " Distributions for repoId " + repo.getId()));
                        progress.append(dists.size()).append('\n');
                        progress.append(new Date()).append(": ");
                        progress.append("Asking content source to update the list of packages...");
                        DistributionSyncReport distReport = new DistributionSyncReport(repo.getId());
                        ArrayList<DistributionDetails> distDetails = new ArrayList<DistributionDetails>(dists.size());
                        this.translateDomainToDto((List<Distribution>)dists, (List<DistributionDetails>)distDetails);
                        distSource.synchronizeDistribution(repo.getName(), distReport, distDetails);
                        log.info((Object)("synchronizeDistributions: [" + contentSource.getName() + "]: loaded existing list of size=[" + dists.size() + "] (" + (System.currentTimeMillis() - start) + ")ms"));
                        results.setResults(progress.toString());
                        results = contentSourceManager.mergeContentSourceSyncResults(results);
                        start = System.currentTimeMillis();
                        distSource.synchronizeDistribution(repo.getName(), distReport, distDetails);
                        log.info((Object)("synchronizeDistributions: [" + contentSource.getName() + "]: got sync report from adapter=[" + distReport + "] (" + (System.currentTimeMillis() - start) + ")ms"));
                        progress.append("new=").append(distReport.getDistributions().size());
                        progress.append(", deleted=").append(distReport.getDeletedDistributions().size()).append('\n');
                        results.setResults(progress.toString());
                        results = contentSourceManager.mergeContentSourceSyncResults(results);
                        start = System.currentTimeMillis();
                        results = contentSourceManager.mergeContentSourceSyncReport(contentSource, distReport, results);
                    }
                    progress.setLength(0);
                    progress.append(results.getResults());
                    log.info((Object)("synchronizeDistributions: [" + contentSource.getName() + "]: report has been merged (" + (System.currentTimeMillis() - start) + ")ms"));
                    progress.append(new Date()).append(": ").append("DONE.");
                    results.setResults(progress.toString());
                    results.setStatus(ContentSourceSyncStatus.SUCCESS);
                    results = contentSourceManager.mergeContentSourceSyncResults(results);
                }
                catch (Throwable t) {
                    if (results == null) throw new Exception("Failed to sync content source [" + contentSourceId + "]", t);
                    ContentSourceSyncResults reloadedResults = contentSourceManager.getContentSourceSyncResults(results.getId());
                    if (reloadedResults != null && (results = reloadedResults).getResults() != null) {
                        progress = new StringBuilder(results.getResults());
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    t.printStackTrace(new PrintStream(baos));
                    progress.append(new Date()).append(": ");
                    progress.append("SYNCHRONIZATION ERROR - STACK TRACE FOLLOWS:\n");
                    progress.append(baos.toString());
                    results.setResults(progress.toString());
                    results.setStatus(ContentSourceSyncStatus.FAILURE);
                    throw new Exception("Failed to sync content source [" + contentSourceId + "]", t);
                }
            }
            Object var23_16 = null;
            if (results == null) return true;
            results.setEndTime(Long.valueOf(System.currentTimeMillis()));
            contentSourceManager.mergeContentSourceSyncResults(results);
            return true;
        }
        catch (Throwable throwable) {
            Object var23_17 = null;
            if (results == null) throw throwable;
            results.setEndTime(Long.valueOf(System.currentTimeMillis()));
            contentSourceManager.mergeContentSourceSyncResults(results);
            throw throwable;
        }
    }

    public boolean testConnection(int contentSourceId) throws Exception {
        ContentProvider adapter = this.getIsolatedContentProvider(contentSourceId);
        try {
            adapter.testConnection();
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ContentSource> getAllContentSources() {
        Map<ContentSource, ContentProvider> map = this.adapters;
        synchronized (map) {
            return new HashSet<ContentSource>(this.adapters.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAdapter(ContentSource contentSource) throws InitializationException {
        Map<ContentSource, ContentProvider> map = this.adapters;
        synchronized (map) {
            if (this.adapters.containsKey(contentSource)) {
                return;
            }
        }
        this.instantiateAdapter(contentSource);
        try {
            log.info((Object)("Initializing content source adapter for [" + contentSource + "] of type [" + contentSource.getContentSourceType() + "]"));
            ContentProvider adapter = this.getIsolatedContentSourceAdapter(contentSource);
            adapter.initialize(contentSource.getConfiguration());
        }
        catch (Exception e) {
            log.warn((Object)("Failed to initialize adapter for content source [" + contentSource.getName() + "]"), (Throwable)e);
            throw new InitializationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdownAdapter(ContentSource contentSource) {
        Map<ContentSource, ContentProvider> map = this.adapters;
        synchronized (map) {
            if (!this.adapters.containsKey(contentSource)) {
                return;
            }
        }
        try {
            try {
                log.info((Object)("Shutting down content source adapter for [" + contentSource + "] of type [" + contentSource.getContentSourceType() + "]"));
                ContentProvider adapter = this.getIsolatedContentSourceAdapter(contentSource);
                adapter.shutdown();
            }
            catch (Throwable t) {
                log.warn((Object)("Failed to shutdown adapter for content source [" + contentSource.getName() + "]"), t);
                Object var5_5 = null;
                this.adapters.remove(contentSource);
                return;
            }
            Object var5_4 = null;
            this.adapters.remove(contentSource);
            return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.adapters.remove(contentSource);
            throw throwable;
        }
    }

    public void restartAdapter(ContentSource contentSource) throws Exception {
        this.shutdownAdapter(contentSource);
        this.startAdapter(contentSource);
    }

    protected void initialize(ContentServerPluginManager pluginManager) {
        this.pluginManager = pluginManager;
        ContentSourceMetadataManagerLocal metadataManager = LookupUtil.getContentSourceMetadataManager();
        ContentSourceManagerLocal contentSourceManager = LookupUtil.getContentSourceManager();
        ContentSourcePluginMetadataManager pluginMetadataManager = this.pluginManager.getMetadataManager();
        Set<ContentSourceType> allTypes = pluginMetadataManager.getAllContentSourceTypes();
        metadataManager.registerTypes(allTypes);
        this.createInitialAdaptersMap();
        PageControl pc = PageControl.getUnlimitedInstance();
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        PageList<ContentSource> contentSources = contentSourceManager.getAllContentSources(overlord, pc);
        if (contentSources != null) {
            for (ContentSource contentSource : contentSources) {
                try {
                    this.startAdapter(contentSource);
                }
                catch (Exception e) {
                    log.warn((Object)("Failed to start adapator for content source [" + contentSource + "]"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() {
        HashMap<ContentSource, ContentProvider> adaptersCopy;
        Map<ContentSource, ContentProvider> map = this.adapters;
        synchronized (map) {
            adaptersCopy = new HashMap<ContentSource, ContentProvider>(this.adapters);
        }
        for (ContentSource contentSource : adaptersCopy.keySet()) {
            this.shutdownAdapter(contentSource);
        }
        map = this.adapters;
        synchronized (map) {
            this.adapters.clear();
        }
    }

    protected void createInitialAdaptersMap() {
        this.adapters = new HashMap<ContentSource, ContentProvider>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentProvider getIsolatedContentProvider(int contentProviderId) throws RuntimeException {
        Map<ContentSource, ContentProvider> map = this.adapters;
        synchronized (map) {
            for (ContentSource contentSource : this.adapters.keySet()) {
                if (contentSource.getId() != contentProviderId) continue;
                return this.getIsolatedContentSourceAdapter(contentSource);
            }
        }
        throw new RuntimeException("Content source ID [" + contentProviderId + "] doesn't exist; can't get adapter");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ContentProvider getIsolatedContentSourceAdapter(ContentSource contentSource) throws RuntimeException {
        ContentProvider adapter;
        Map<ContentSource, ContentProvider> map = this.adapters;
        synchronized (map) {
            adapter = this.adapters.get(contentSource);
        }
        if (adapter == null) {
            throw new RuntimeException("There is no adapter for content source [" + adapter + "]");
        }
        ServerPluginEnvironment env = this.pluginManager.getPluginEnvironment(contentSource.getContentSourceType());
        if (env == null) {
            throw new RuntimeException("There is no plugin env. for content source [" + contentSource + "]");
        }
        ClassLoader classLoader = env.getPluginClassLoader();
        IsolatedInvocationHandler handler = new IsolatedInvocationHandler(adapter, classLoader);
        ArrayList<Class> ifacesList = new ArrayList<Class>(1);
        ifacesList.add(ContentProvider.class);
        if (adapter instanceof RepoSource) {
            ifacesList.add(RepoSource.class);
        }
        if (adapter instanceof PackageSource) {
            ifacesList.add(PackageSource.class);
        }
        if (adapter instanceof DistributionSource) {
            ifacesList.add(DistributionSource.class);
        }
        Class[] ifaces = ifacesList.toArray(new Class[ifacesList.size()]);
        return (ContentProvider)Proxy.newProxyInstance(classLoader, ifaces, (InvocationHandler)handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContentProvider instantiateAdapter(ContentSource contentSource) {
        ContentProvider adapter = null;
        String apiClassName = "?";
        String pluginName = "?";
        try {
            ContentSourceType type = contentSource.getContentSourceType();
            apiClassName = type.getContentSourceApiClass();
            pluginName = this.pluginManager.getMetadataManager().getPluginNameFromContentSourceType(type);
            ServerPluginEnvironment pluginEnv = this.pluginManager.getPluginEnvironment(pluginName);
            ClassLoader pluginClassloader = pluginEnv.getPluginClassLoader();
            ClassLoader startingClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(pluginClassloader);
                Class<?> apiClass = Class.forName(apiClassName, true, pluginClassloader);
                if (ContentProvider.class.isAssignableFrom(apiClass)) {
                    adapter = (ContentProvider)apiClass.newInstance();
                } else {
                    log.warn((Object)("The API class [" + apiClassName + "] does not implement [" + ContentProvider.class.getName() + "] in plugin [" + pluginName + "]"));
                }
                Object var11_11 = null;
                Thread.currentThread().setContextClassLoader(startingClassLoader);
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                Thread.currentThread().setContextClassLoader(startingClassLoader);
                throw throwable;
            }
        }
        catch (Throwable t) {
            log.warn((Object)("Failed to create the API class [" + apiClassName + "] for plugin [" + pluginName + "]"), t);
        }
        if (adapter != null) {
            Map<ContentSource, ContentProvider> map = this.adapters;
            synchronized (map) {
                this.adapters.put(contentSource, adapter);
            }
        }
        return adapter;
    }

    private void translateDomainToDto(List<PackageVersionContentSource> existingPVCS, Set<ContentProviderPackageDetails> allDetails, Map<ContentProviderPackageDetailsKey, PackageVersionContentSource> keyPVCSMap) {
        for (PackageVersionContentSource pvcs : existingPVCS) {
            PackageVersion pv = pvcs.getPackageVersionContentSourcePK().getPackageVersion();
            Package p = pv.getGeneralPackage();
            ResourceType rt = p.getPackageType().getResourceType();
            ContentProviderPackageDetailsKey key = new ContentProviderPackageDetailsKey(p.getName(), pv.getVersion(), p.getPackageType().getName(), pv.getArchitecture().getName(), rt.getName(), rt.getPlugin());
            ContentProviderPackageDetails details = new ContentProviderPackageDetails(key);
            details.setClassification(pv.getGeneralPackage().getClassification());
            details.setDisplayName(pv.getDisplayName());
            details.setDisplayVersion(pv.getDisplayVersion());
            details.setExtraProperties(pv.getExtraProperties());
            details.setFileCreatedDate(pv.getFileCreatedDate());
            details.setFileName(pv.getFileName());
            details.setFileSize(pv.getFileSize());
            details.setLicenseName(pv.getLicenseName());
            details.setLicenseVersion(pv.getLicenseVersion());
            details.setLocation(pvcs.getLocation());
            details.setLongDescription(pv.getLongDescription());
            details.setMD5(pv.getMD5());
            details.setMetadata(pv.getMetadata());
            details.setSHA256(pv.getSHA256());
            details.setShortDescription(pv.getShortDescription());
            allDetails.add(details);
            keyPVCSMap.put(key, pvcs);
        }
    }

    private void translateDomainToDto(List<Distribution> dists, List<DistributionDetails> distDetails) {
        DistributionManagerLocal distManager = LookupUtil.getDistributionManagerLocal();
        for (Distribution d : dists) {
            DistributionDetails detail = new DistributionDetails(d.getLabel(), d.getDistributionType().getName());
            detail.setLabel(d.getLabel());
            detail.setDistributionPath(d.getBasePath());
            detail.setDescription(d.getDistributionType().getDescription());
            List<DistributionFile> files = distManager.getDistributionFilesByDistId(d.getId());
            for (DistributionFile f : files) {
                DistributionFileDetails dfd = new DistributionFileDetails(f.getRelativeFilename(), f.getLastModified(), f.getMd5sum());
                detail.addFile(dfd);
            }
            distDetails.add(detail);
        }
    }

    private class IsolatedInvocationHandler
    implements InvocationHandler {
        private final Object instance;
        private final ClassLoader classLoader;

        public IsolatedInvocationHandler(Object obj, ClassLoader cl) {
            this.instance = obj;
            this.classLoader = cl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            ClassLoader startingClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.classLoader);
                Object object = method.invoke(this.instance, args);
                Object var7_6 = null;
                Thread.currentThread().setContextClassLoader(startingClassLoader);
                return object;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                Thread.currentThread().setContextClassLoader(startingClassLoader);
                throw throwable;
            }
        }
    }
}

