/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc.content;

import java.util.Date;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.rhq.core.domain.content.ContentSource;
import org.rhq.enterprise.server.plugin.pc.AbstractTypeServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.MasterServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.ServerPluginManager;
import org.rhq.enterprise.server.plugin.pc.ServerPluginType;
import org.rhq.enterprise.server.plugin.pc.content.ContentProviderManager;
import org.rhq.enterprise.server.plugin.pc.content.ContentServerPluginManager;
import org.rhq.enterprise.server.scheduler.SchedulerLocal;
import org.rhq.enterprise.server.scheduler.jobs.ContentSourceSyncJob;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.content.ContentPluginDescriptorType;

public class ContentServerPluginContainer
extends AbstractTypeServerPluginContainer {
    private static final String SYNC_JOB_GROUP_NAME = "syncContentSource";
    private ContentProviderManager adapterManager;

    public ContentServerPluginContainer(MasterServerPluginContainer master) {
        super(master);
    }

    public void initialize() throws Exception {
        this.getLog().debug((Object)"Content server plugin container initializing");
        super.initialize();
        this.adapterManager = this.createAdapterManager();
        this.getLog().debug((Object)"Content server plugin container initialized");
    }

    public void start() {
        super.start();
        this.adapterManager.initialize((ContentServerPluginManager)this.getPluginManager());
    }

    public void shutdown() {
        this.getLog().debug((Object)"Content server plugin container is shutting down");
        this.adapterManager.shutdown();
        super.shutdown();
        this.getLog().debug((Object)"Content server plugin container is shutdown");
    }

    public void scheduleAllPluginJobs() throws Exception {
        super.scheduleAllPluginJobs();
        this.scheduleSyncJobs();
    }

    public ServerPluginType getSupportedServerPluginType() {
        return new ServerPluginType(ContentPluginDescriptorType.class);
    }

    public ContentProviderManager getAdapterManager() {
        return this.adapterManager;
    }

    public void syncNow(ContentSource contentSource) throws SchedulerException {
        JobDetail job = new JobDetail(ContentSourceSyncJob.createUniqueJobName(contentSource), SYNC_JOB_GROUP_NAME, ContentSourceSyncJob.class, false, false, false);
        ContentSourceSyncJob.createJobDataMap(contentSource, job);
        SimpleTrigger trigger = new SimpleTrigger(job.getName(), job.getGroup());
        trigger.setVolatility(false);
        SchedulerLocal scheduler = LookupUtil.getSchedulerBean();
        Date next = scheduler.scheduleJob(job, (Trigger)trigger);
        this.getLog().info((Object)("Scheduled content source sync job [" + job.getName() + ':' + job.getGroup() + "] to fire now at [" + next + "] for [" + contentSource + "]"));
    }

    public void scheduleSyncJob(ContentSource contentSource) throws SchedulerException {
        String syncSchedule = contentSource.getSyncSchedule();
        if (syncSchedule == null || syncSchedule.trim().length() == 0) {
            this.getLog().debug((Object)(contentSource.toString() + " does not define a sync schedule - not scheduling"));
            return;
        }
        SchedulerLocal scheduler = LookupUtil.getSchedulerBean();
        scheduler.scheduleCronJob(ContentSourceSyncJob.createJobName(contentSource), SYNC_JOB_GROUP_NAME, ContentSourceSyncJob.createJobDataMap(contentSource, null), ContentSourceSyncJob.class, true, false, syncSchedule);
    }

    public void scheduleSyncJobs() {
        if (this.adapterManager != null) {
            for (ContentSource contentSource : this.adapterManager.getAllContentSources()) {
                try {
                    this.scheduleSyncJob(contentSource);
                }
                catch (Exception e) {
                    this.getLog().warn((Object)("Could not schedule sync job for content source [" + contentSource + "]"), (Throwable)e);
                }
            }
        }
    }

    public void unscheduleSyncJob(ContentSource contentSource) throws SchedulerException {
        SchedulerLocal scheduler = LookupUtil.getSchedulerBean();
        scheduler.deleteJob(ContentSourceSyncJob.createJobName(contentSource), SYNC_JOB_GROUP_NAME);
    }

    protected ServerPluginManager createPluginManager() {
        return new ContentServerPluginManager(this);
    }

    protected ContentProviderManager createAdapterManager() {
        ContentProviderManager am = new ContentProviderManager();
        return am;
    }
}

