/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc.perspective;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import org.rhq.core.util.file.FileUtil;
import org.rhq.enterprise.server.plugin.pc.ServerPluginEnvironment;
import org.rhq.enterprise.server.plugin.pc.ServerPluginManager;
import org.rhq.enterprise.server.plugin.pc.perspective.PerspectiveServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.perspective.metadata.PerspectivePluginMetadataManager;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.PerspectivePluginDescriptorType;

public class PerspectiveServerPluginManager
extends ServerPluginManager {
    private PerspectivePluginMetadataManager metadataManager;

    public PerspectiveServerPluginManager(PerspectiveServerPluginContainer pc) {
        super(pc);
    }

    public void initialize() throws Exception {
        super.initialize();
        this.metadataManager = new PerspectivePluginMetadataManager();
    }

    public void shutdown() {
        super.shutdown();
        this.metadataManager = null;
    }

    public PerspectivePluginMetadataManager getMetadataManager() {
        return this.metadataManager;
    }

    public synchronized void loadPlugin(ServerPluginEnvironment env, boolean enabled) throws Exception {
        super.loadPlugin(env, enabled);
        this.metadataManager.loadPlugin((PerspectivePluginDescriptorType)env.getPluginDescriptor());
        String name = null;
        try {
            JarFile plugin = new JarFile(env.getPluginUrl().getFile());
            for (JarEntry entry : Collections.list(plugin.entries())) {
                name = entry.getName();
                if (!name.toLowerCase().endsWith(".war")) continue;
                this.deployWar(env, entry.getName(), plugin.getInputStream(entry));
            }
        }
        catch (Exception e) {
            this.getLog().error((Object)("Failed to deploy " + env.getPluginKey().getPluginName() + "#" + name), (Throwable)e);
        }
    }

    private void deployWar(ServerPluginEnvironment env, String name, InputStream iStream) {
        try {
            File deployFile = this.writeWarToFile(this.getDeployFile(env, name), iStream);
            InitialContext ic = new InitialContext();
            MBeanServerConnection server = (MBeanServerConnection)ic.lookup("jmx/invoker/RMIAdaptor");
            ObjectName mainDeployer = new ObjectName("jboss.system:service=MainDeployer");
            server.invoke(mainDeployer, "deploy", new Object[]{deployFile.getAbsolutePath()}, new String[]{String.class.getName()});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private File getDeployFile(ServerPluginEnvironment env, String name) throws IOException {
        File dataDir = this.getServerPluginContext(env).getDataDirectory();
        dataDir.mkdirs();
        return new File(dataDir, name);
    }

    private File writeWarToFile(File destFile, InputStream iStream) throws Exception {
        if (destFile.exists()) {
            this.getLog().debug((Object)("Existing file found and will be deleted at: " + destFile));
            destFile.delete();
        }
        FileUtil.writeFile((InputStream)iStream, (File)destFile);
        if (!destFile.exists()) {
            String err = "Temporary file for application update not written to: " + destFile;
            this.getLog().error((Object)err);
            throw new Exception(err);
        }
        return destFile;
    }

    public synchronized void startPlugins() {
        super.startPlugins();
        this.metadataManager.start();
    }

    public synchronized void stopPlugins() {
        super.stopPlugins();
    }

    public synchronized void unloadPlugin(String pluginName) throws Exception {
        ServerPluginEnvironment env = this.getPluginEnvironment(pluginName);
        String name = null;
        try {
            JarFile plugin = new JarFile(env.getPluginUrl().getFile());
            for (JarEntry entry : Collections.list(plugin.entries())) {
                name = entry.getName();
                if (!name.toLowerCase().endsWith(".war")) continue;
                this.undeployWar(this.getDeployFile(env, entry.getName()));
            }
        }
        catch (Exception e) {
            this.getLog().error((Object)("Failed to deploy " + env.getPluginKey().getPluginName() + "#" + name), (Throwable)e);
        }
        this.metadataManager.unloadPlugin((PerspectivePluginDescriptorType)env.getPluginDescriptor());
        super.unloadPlugin(pluginName);
    }

    private void undeployWar(File deployFile) {
        try {
            InitialContext ic = new InitialContext();
            MBeanServerConnection server = (MBeanServerConnection)ic.lookup("jmx/invoker/RMIAdaptor");
            ObjectName mainDeployer = new ObjectName("jboss.system:service=MainDeployer");
            URL fileUrl = deployFile.toURI().toURL();
            Boolean isDeployed = (Boolean)server.invoke(mainDeployer, "isDeployed", new Object[]{fileUrl}, new String[]{URL.class.getName()});
            if (isDeployed.booleanValue()) {
                server.invoke(mainDeployer, "undeploy", new Object[]{fileUrl}, new String[]{URL.class.getName()});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

