/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc.perspective.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.enterprise.server.perspective.MenuItem;
import org.rhq.enterprise.server.perspective.Tab;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.ActionType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.ApplicationType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.ExtensionPointType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.ExtensionType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.MenuItemType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.PerspectivePluginDescriptorType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.PlacementType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.PositionType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.TabType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.TaskType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerspectivePluginMetadataManager {
    private final String CORE_PERSPECTIVE_NAME = "CorePerspective";
    private static final String MENU_ITEM_TARGET_URL = "/rhq/common/perspective-main.xhtml?targetUrl=";
    private static final String TAB_TARGET_URL = "/rhq/resource/perspective/index.xhtml?targetUrl=";
    private Log log = LogFactory.getLog(PerspectivePluginMetadataManager.class);
    private Map<String, PerspectivePluginDescriptorType> loadedPlugins = new HashMap<String, PerspectivePluginDescriptorType>();
    private boolean isStarted = false;
    private List<Tab> resourceTabs;
    private List<MenuItem> coreMenu;

    public synchronized void loadPlugin(PerspectivePluginDescriptorType descriptor) {
        this.loadedPlugins.put(descriptor.getName(), descriptor);
    }

    public synchronized void unloadPlugin(PerspectivePluginDescriptorType descriptor) {
        this.loadedPlugins.remove(descriptor.getName());
    }

    public synchronized void start() {
        if (this.isStarted) {
            return;
        }
        this.processCorePerspective();
        this.processNonCorePerspectives();
        this.isStarted = true;
    }

    private void processCorePerspective() {
        PerspectivePluginDescriptorType cp = this.loadedPlugins.get("CorePerspective");
        if (null == cp) {
            throw new IllegalStateException("Core perspective must be loaded. Invalid startup. Load: CorePerspective");
        }
        if (null == this.coreMenu) {
            this.coreMenu = new ArrayList<MenuItem>();
        }
        if (null == this.resourceTabs) {
            this.resourceTabs = new ArrayList<Tab>();
        }
        this.processPerspective(cp);
    }

    private void processNonCorePerspectives() {
        for (String key : this.loadedPlugins.keySet()) {
            if ("CorePerspective".equals(key)) continue;
            this.processPerspective(this.loadedPlugins.get(key));
        }
    }

    private void processPerspective(PerspectivePluginDescriptorType perspective) {
        ActionType action;
        List applications = perspective.getApplication();
        for (MenuItemType rawMenuItem : perspective.getMenuItem()) {
            this.resolveUrls(applications, (ExtensionType)rawMenuItem, MENU_ITEM_TARGET_URL);
            action = rawMenuItem.getAction();
            ExtensionPointType extensionPoint = rawMenuItem.getPosition().getExtensionPoint();
            if (ExtensionPointType.CORE_MENU == extensionPoint) {
                if (ActionType.ADD == action) {
                    this.menuAdd(this.coreMenu, rawMenuItem);
                    continue;
                }
                if (ActionType.REMOVE == action) {
                    this.menuRemove(this.coreMenu, rawMenuItem);
                    continue;
                }
                if (ActionType.REPLACE != action) continue;
                this.menuReplace(this.coreMenu, rawMenuItem);
                continue;
            }
            throw new IllegalArgumentException("Unknown Extension Point defined in menuItem [" + rawMenuItem.getName() + "] : " + extensionPoint);
        }
        for (TabType rawTab : perspective.getTab()) {
            this.resolveUrls(applications, (ExtensionType)rawTab, TAB_TARGET_URL);
            action = rawTab.getAction();
            switch (action) {
                case ADD: {
                    this.addTab(rawTab);
                    break;
                }
                case REMOVE: {
                    this.removeTab(rawTab);
                    break;
                }
                case REPLACE: {
                    this.replaceTab(rawTab);
                }
            }
        }
    }

    private void resolveUrls(List<ApplicationType> applications, ExtensionType extension, String targetUrl) {
        ApplicationType applicationType = this.getApplicationByName(applications, extension.getApplication());
        if (extension instanceof TaskType) {
            TaskType task = (TaskType)extension;
            String resolvedUrl = this.resolveUrl(applicationType, task.getUrl(), targetUrl);
            task.setUrl(resolvedUrl);
        } else if (extension instanceof MenuItemType) {
            MenuItemType menuItem = (MenuItemType)extension;
            String resolvedUrl = this.resolveUrl(applicationType, menuItem.getUrl(), targetUrl);
            menuItem.setUrl(resolvedUrl);
        } else if (extension instanceof TabType) {
            TabType tab = (TabType)extension;
            String resolvedUrl = this.resolveUrl(applicationType, tab.getUrl(), targetUrl);
            tab.setUrl(resolvedUrl);
        }
        String resolvedIconUrl = this.resolveUrl(applicationType, extension.getIconUrl(), "");
        extension.setIconUrl(resolvedIconUrl);
    }

    private String resolveUrl(ApplicationType applicationType, String url, String targetUrl) {
        String result = url;
        if (null != url && this.isRelativeUrl(url)) {
            if (null == applicationType) {
                throw new IllegalArgumentException("Relative URL found without application. Add application attribute to fully resolve url '" + url + "'");
            }
            String baseUrl = applicationType.getBaseUrl();
            if (!baseUrl.endsWith("/")) {
                baseUrl = baseUrl + "/";
                applicationType.setBaseUrl(baseUrl);
            }
            result = targetUrl + baseUrl + url;
        }
        return result;
    }

    private boolean isRelativeUrl(String url) {
        return !url.startsWith("/") && !url.startsWith("http");
    }

    private ApplicationType getApplicationByName(List<ApplicationType> applications, String name) {
        ApplicationType result = null;
        if (null != applications && null != name) {
            for (ApplicationType application : applications) {
                if (!application.getName().equals(name)) continue;
                result = application;
                break;
            }
        }
        return result;
    }

    private void printMenu(List<MenuItem> menu, String indent) {
        if (null == menu) {
            return;
        }
        for (MenuItem menuItem : menu) {
            System.out.println(indent + menuItem.getItem().getName());
            this.printMenu(menuItem.getChildren(), indent + "   ");
        }
    }

    private void menuAdd(List<MenuItem> menu, MenuItemType rawMenuItem) {
        PositionType position = rawMenuItem.getPosition();
        List<MenuItem> containingMenu = this.getContainingMenu(menu, rawMenuItem);
        MenuItem menuItem = new MenuItem(rawMenuItem);
        if (PlacementType.START == position.getPlacement()) {
            containingMenu.add(0, menuItem);
        } else if (PlacementType.END == position.getPlacement()) {
            containingMenu.add(menuItem);
        } else {
            int index = this.getMenuItemIndex(containingMenu, position.getName());
            if (-1 == index) {
                throw new IllegalArgumentException("Invalid position defined for menuItem [" + rawMenuItem.getName() + "]. Referenced menuItem not found : " + position.getName() + ". Make sure supporting menus are defined for the menuItem.");
            }
            containingMenu.add(PlacementType.AFTER == position.getPlacement() ? ++index : --index, menuItem);
        }
    }

    private void menuRemove(List<MenuItem> menu, MenuItemType rawMenuItem) {
        block3: {
            PositionType position = rawMenuItem.getPosition();
            try {
                List<MenuItem> containingMenu = this.getContainingMenu(menu, rawMenuItem);
                int index = this.getMenuItemIndex(containingMenu, rawMenuItem.getName());
                if (-1 == index) {
                    throw new IllegalArgumentException("Invalid position defined for menuItem [" + rawMenuItem.getName() + "]. Referenced menuItem not found : " + position.getName() + ". Make sure supporting menus are defined for the menuItem.");
                }
                containingMenu.remove(index);
            }
            catch (IllegalArgumentException e) {
                if (!this.log.isDebugEnabled()) break block3;
                this.log.debug((Object)("Menu item not found. Ignoring removal of " + rawMenuItem.getName()), (Throwable)e);
            }
        }
    }

    private void menuReplace(List<MenuItem> menu, MenuItemType rawMenuItem) {
        PositionType position = rawMenuItem.getPosition();
        try {
            List<MenuItem> containingMenu = this.getContainingMenu(menu, rawMenuItem);
            int index = this.getMenuItemIndex(containingMenu, rawMenuItem.getName());
            if (-1 == index) {
                throw new IllegalArgumentException("Invalid position defined for menuItem [" + rawMenuItem.getName() + "]. Referenced menuItem not found : " + position.getName() + ". Make sure supporting menus are defined for the menuItem.");
            }
            containingMenu.set(index, new MenuItem(rawMenuItem));
        }
        catch (IllegalArgumentException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Menu item not found. Ignoring replacement and attempting add for " + rawMenuItem.getName()), (Throwable)e);
            }
            this.menuAdd(menu, rawMenuItem);
        }
    }

    private List<MenuItem> getContainingMenu(List<MenuItem> menu, MenuItemType rawMenuItem) {
        String name = rawMenuItem.getName();
        String[] nameTokens = null != name ? name.split("\\.") : new String[]{};
        List<MenuItem> result = menu;
        int i = 0;
        while (i + 1 < nameTokens.length) {
            int index = this.getMenuItemIndex(result, nameTokens[i]);
            if (-1 == index) {
                throw new IllegalArgumentException("Invalid position defined for menuItem [" + rawMenuItem.getName() + "]. No containing menu found for : " + name + ". Make sure supporting menus are defined for the menuItem.");
            }
            MenuItem menuItem = result.get(index);
            if (null == (result = menuItem.getChildren())) {
                result = new ArrayList<MenuItem>();
                menuItem.setChildren(result);
            }
            ++i;
        }
        return result;
    }

    private int getMenuItemIndex(List<MenuItem> menu, String name) {
        int result = -1;
        int size = menu.size();
        for (int i = 0; i < size; ++i) {
            if (!menu.get(i).getItem().getName().endsWith(name)) continue;
            result = i;
            break;
        }
        return result;
    }

    private void addTab(TabType rawTab) {
        PositionType position = rawTab.getPosition();
        List<Tab> siblingTabs = this.getSiblingTabs(rawTab);
        Tab tab = new Tab(rawTab);
        if (PlacementType.START == position.getPlacement()) {
            siblingTabs.add(0, tab);
        } else if (PlacementType.END == position.getPlacement()) {
            siblingTabs.add(tab);
        } else {
            int index = this.getTabIndex(siblingTabs, position.getName());
            if (index == -1) {
                throw new IllegalArgumentException("Invalid position defined for tab [" + rawTab.getName() + "]. Referenced tab not found : " + position.getName() + ". Make sure supporting tabs are defined for the tab.");
            }
            siblingTabs.add(PlacementType.AFTER == position.getPlacement() ? ++index : --index, tab);
        }
    }

    private void removeTab(TabType rawTab) {
        block3: {
            PositionType position = rawTab.getPosition();
            try {
                List<Tab> siblingTabs = this.getSiblingTabs(rawTab);
                int index = this.getTabIndex(siblingTabs, rawTab.getName());
                if (index == -1) {
                    throw new IllegalArgumentException("Invalid position defined for menuItem [" + rawTab.getName() + "]. Referenced menuItem not found : " + position.getName() + ". Make sure supporting menus are defined for the menuItem.");
                }
                siblingTabs.remove(index);
            }
            catch (IllegalArgumentException e) {
                if (!this.log.isDebugEnabled()) break block3;
                this.log.debug((Object)("Tab not found. Ignoring removal of tab [" + rawTab.getName() + "]."), (Throwable)e);
            }
        }
    }

    private void replaceTab(TabType rawTab) {
        PositionType position = rawTab.getPosition();
        try {
            List<Tab> siblingTabs = this.getSiblingTabs(rawTab);
            int index = this.getTabIndex(siblingTabs, rawTab.getName());
            if (-1 == index) {
                throw new IllegalArgumentException("Invalid position defined for tab [" + rawTab.getName() + "]. Referenced tab not found : " + position.getName() + ". Make sure supporting tabs are defined for the tab.");
            }
            siblingTabs.set(index, new Tab(rawTab));
        }
        catch (IllegalArgumentException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Tab not found. Ignoring replacement and attempting add for " + rawTab.getName()), (Throwable)e);
            }
            this.addTab(rawTab);
        }
    }

    private List<Tab> getSiblingTabs(TabType rawTab) {
        String name = rawTab.getName();
        String[] nameTokens = name != null ? name.split("\\.") : new String[]{};
        List<Tab> result = this.resourceTabs;
        int i = 0;
        while (i + 1 < nameTokens.length) {
            int index = this.getTabIndex(result, nameTokens[i]);
            if (index == -1) {
                throw new IllegalArgumentException("Invalid position defined for tab [" + rawTab.getName() + "]. No parent tab found for : " + name + ". Make sure supporting tabs are defined for the tab.");
            }
            Tab parentTab = result.get(index);
            result = parentTab.getChildren();
            ++i;
        }
        return result;
    }

    private int getTabIndex(List<Tab> menu, String name) {
        int result = -1;
        int size = menu.size();
        for (int i = 0; i < size; ++i) {
            if (!menu.get(i).getQualifiedName().endsWith(name)) continue;
            result = i;
            break;
        }
        return result;
    }

    public List<MenuItem> getCoreMenu() {
        return this.coreMenu;
    }

    public List<Tab> getResourceTabs() {
        ArrayList<Tab> clone = new ArrayList<Tab>(this.resourceTabs.size());
        for (Tab resourceTab : this.resourceTabs) {
            try {
                clone.add(resourceTab.clone());
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalStateException(e);
            }
        }
        return clone;
    }
}

