/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.scheduler.jobs;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.content.ContentSource;
import org.rhq.core.domain.content.DownloadMode;
import org.rhq.core.domain.content.PackageVersionContentSource;
import org.rhq.core.domain.content.PackageVersionContentSourcePK;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.content.ContentSourceManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ContentSourceSyncJob
implements StatefulJob {
    private static final String DATAMAP_CONTENT_SOURCE_NAME = "contentSourceName";
    private static final String DATAMAP_CONTENT_SOURCE_TYPE_NAME = "contentSourceTypeName";
    private static final Log log = LogFactory.getLog(ContentSourceSyncJob.class);
    private static final String SEPARATOR = "--";

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            JobDetail jobDetail = context.getJobDetail();
            if (jobDetail == null) {
                throw new IllegalStateException("The job does not have any details");
            }
            JobDataMap dataMap = jobDetail.getJobDataMap();
            if (dataMap == null) {
                throw new IllegalStateException("The job does not have any data in its details");
            }
            String name = dataMap.getString(DATAMAP_CONTENT_SOURCE_NAME);
            String typeName = dataMap.getString(DATAMAP_CONTENT_SOURCE_TYPE_NAME);
            if (name == null) {
                throw new IllegalStateException("Missing the content source name in details data");
            }
            if (typeName == null) {
                throw new IllegalStateException("Missing the content source type name in details data");
            }
            this.synchronizeAndLoad(name, typeName);
        }
        catch (Exception e) {
            String errorMsg = "Failed to sync content source in job [" + context.getJobDetail() + "]";
            log.error((Object)errorMsg, (Throwable)e);
            JobExecutionException jobExecutionException = new JobExecutionException(errorMsg, (Throwable)e, false);
            if (!(e instanceof IllegalStateException)) {
                jobExecutionException.setUnscheduleAllTriggers(false);
            }
            throw jobExecutionException;
        }
    }

    private void synchronizeAndLoad(String contentSourceName, String contentSourceTypeName) throws Exception {
        long start;
        Subject overlord;
        SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
        ContentSourceManagerLocal contentManager = LookupUtil.getContentSourceManager();
        ContentSource contentSource = contentManager.getContentSourceByNameAndType(overlord = subjectManager.getOverlord(), contentSourceName, contentSourceTypeName);
        if (contentSource == null) {
            throw new Exception("Sync job was asked to sync an unknown content source: " + contentSourceName + "|" + contentSourceTypeName);
        }
        int contentSourceId = contentSource.getId();
        boolean completed = contentManager.internalSynchronizeContentSource(contentSourceId);
        overlord = subjectManager.getOverlord();
        contentSource = contentManager.getContentSourceByNameAndType(overlord, contentSourceName, contentSourceTypeName);
        if (contentSource == null) {
            throw new Exception("Content source was deleted, aborting sync job: " + contentSourceName + "|" + contentSourceTypeName);
        }
        if (!completed) {
            log.info((Object)("Content source [" + contentSourceName + "] is currently being synchronized already. " + "Please wait for the current sync job to finish."));
        } else if (contentSource.getDownloadMode() == DownloadMode.NEVER) {
            log.info((Object)("Content source [" + contentSourceName + "] is fully synchronized now. " + "It is marked to never download bits - bits will not be downloaded now."));
        } else if (contentSource.isLazyLoad()) {
            log.info((Object)("Content source [" + contentSourceName + "] is fully synchronized now. " + "It is marked for lazy loading - bits will not be downloaded now."));
        } else {
            log.info((Object)("Content source [" + contentSourceName + "] is fully synchronized now. " + "It is not marked for lazy loading - downloading all bits now."));
            start = System.currentTimeMillis();
            PageControl pc = PageControl.getUnlimitedInstance();
            overlord = subjectManager.getOverlord();
            PageList<PackageVersionContentSource> packageVersionContentSources = contentManager.getUnloadedPackageVersionsFromContentSource(overlord, contentSourceId, pc);
            for (PackageVersionContentSource item : packageVersionContentSources) {
                PackageVersionContentSourcePK pk = item.getPackageVersionContentSourcePK();
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Downloading package version [" + pk.getPackageVersion() + "] located at [" + item.getLocation() + "]" + "] from [" + pk.getContentSource() + "]..."));
                    }
                    overlord = subjectManager.getOverlord();
                    contentManager.downloadPackageBits(overlord, item);
                }
                catch (Exception e) {
                    String errorMsg = "Failed to load package bits for package version [" + pk.getPackageVersion() + "] from content source [" + pk.getContentSource() + "] at location [" + item.getLocation() + "]." + "No more packages will be downloaded for this content source.";
                    throw new Exception(errorMsg, e);
                }
            }
            log.info((Object)("All package bits for content source [" + contentSourceName + "] have been downloaded." + "The downloads started at [" + new Date(start) + "] and ended at [" + new Date() + "]"));
        }
        if (!completed) {
            log.info((Object)("Content source [" + contentSourceName + "] is currently being synchronized already. " + "Please wait for the current sync job to finish. [DistributionSync]"));
        } else {
            log.info((Object)("Content source [" + contentSourceName + "] is fully synchronized now. " + "Downloading all Distribution bits now."));
            start = System.currentTimeMillis();
            contentManager.downloadDistributionBits(overlord, contentSource);
            log.info((Object)("All distribution bits for content source [" + contentSourceName + "] have been downloaded." + "The downloads started at [" + new Date(start) + "] and ended at [" + new Date() + "]"));
        }
    }

    public static JobDataMap createJobDataMap(ContentSource contentSource, JobDetail details) {
        JobDataMap dataMap = details != null ? details.getJobDataMap() : new JobDataMap();
        dataMap.put(DATAMAP_CONTENT_SOURCE_NAME, contentSource.getName());
        dataMap.put(DATAMAP_CONTENT_SOURCE_TYPE_NAME, contentSource.getContentSourceType().getName());
        return dataMap;
    }

    public static String createJobName(ContentSource cs) {
        String nameEncoded = Integer.toHexString(cs.getName().hashCode());
        String typeNameEncoded = Integer.toHexString(cs.getContentSourceType().getName().hashCode());
        String jobName = nameEncoded + SEPARATOR + typeNameEncoded;
        if (jobName.length() > 80) {
            throw new IllegalArgumentException("Job names max size is 80 chars due to DB column size restrictions: " + jobName);
        }
        return jobName;
    }

    public static String createUniqueJobName(ContentSource cs) {
        String nameEncoded = Integer.toHexString(cs.getName().hashCode());
        String typeNameEncoded = Integer.toHexString(cs.getContentSourceType().getName().hashCode());
        String appendStr = Long.toHexString(System.currentTimeMillis());
        String jobName = nameEncoded + SEPARATOR + typeNameEncoded + SEPARATOR + appendStr;
        if (jobName.length() > 80) {
            throw new IllegalArgumentException("Job names max size is 80 chars due to DB column size restrictions: " + jobName);
        }
        return jobName;
    }
}

