/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.util;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CriteriaQueryRunner<T> {
    private Criteria criteria;
    private CriteriaQueryGenerator queryGenerator;
    private EntityManager entityManager;

    public CriteriaQueryRunner(Criteria criteria, CriteriaQueryGenerator queryGenerator, EntityManager entityManager) {
        this.criteria = criteria;
        this.queryGenerator = queryGenerator;
        this.entityManager = entityManager;
    }

    public PageList<T> execute() {
        Query query = this.queryGenerator.getQuery(this.entityManager);
        Query countQuery = this.queryGenerator.getCountQuery(this.entityManager);
        long count = (Long)countQuery.getSingleResult();
        List results = query.getResultList();
        this.initAllPersistentBags(results);
        return new PageList((Collection)results, (int)count, this.criteria.getPageControl());
    }

    private void initAllPersistentBags(List<T> entities) {
        for (T entity : entities) {
            this.initPersistentBags(entity);
        }
    }

    private void initPersistentBags(T entity) {
        for (Field persistentBagField : this.queryGenerator.getPersistentBagFields()) {
            List persistentBag = this.getList(entity, persistentBagField);
            persistentBag.size();
        }
    }

    private List getList(T entity, Field field) {
        try {
            field.setAccessible(true);
            return (List)field.get(entity);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }
}

