/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.EntityManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.enterprise.server.util.HibernateStatisticsStopWatch;
import org.rhq.enterprise.server.util.LookupUtil;

public class HibernatePerformanceMonitor {
    private static final Log log = LogFactory.getLog(HibernatePerformanceMonitor.class);
    private ConcurrentMap<Long, HibernateStatisticsStopWatch> watches;
    private static HibernatePerformanceMonitor singleton = new HibernatePerformanceMonitor();
    private AtomicLong idGenerator = new AtomicLong(0L);

    private HibernatePerformanceMonitor() {
        this.watches = new ConcurrentHashMap<Long, HibernateStatisticsStopWatch>();
    }

    public static HibernatePerformanceMonitor get() {
        return singleton;
    }

    public long start() {
        if (log.isDebugEnabled()) {
            EntityManager entityManager = LookupUtil.getEntityManager();
            HibernateStatisticsStopWatch watch = new HibernateStatisticsStopWatch(entityManager);
            long id = this.idGenerator.incrementAndGet();
            this.watches.put(id, watch);
            watch.start();
            return id;
        }
        return 0L;
    }

    public void stop(long id, String logPrefix) {
        if (log.isDebugEnabled()) {
            HibernateStatisticsStopWatch watch = (HibernateStatisticsStopWatch)this.watches.remove(id);
            if (watch == null) {
                return;
            }
            watch.stop();
            log.debug((Object)(watch.toString() + (logPrefix == null ? "(unknown)" : " for " + logPrefix + " ")));
        }
    }
}

