/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert.engine.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.ResourceConfigurationUpdate;
import org.rhq.core.domain.event.Event;
import org.rhq.core.domain.event.EventSource;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.measurement.MeasurementData;
import org.rhq.core.domain.operation.OperationHistory;
import org.rhq.enterprise.server.alert.engine.AlertConditionCacheStats;
import org.rhq.enterprise.server.alert.engine.internal.AgentConditionCache;
import org.rhq.enterprise.server.alert.engine.internal.GlobalConditionCache;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AlertConditionCacheCoordinator {
    private static final Log log = LogFactory.getLog(AlertConditionCacheCoordinator.class);
    private static final AlertConditionCacheCoordinator instance = new AlertConditionCacheCoordinator();
    private volatile GlobalConditionCache globalCache;
    private Map<Integer, AgentConditionCache> agentCaches;
    private ReentrantReadWriteLock agentReadWriteLock;
    private AgentManagerLocal agentManager = LookupUtil.getAgentManager();

    private AlertConditionCacheCoordinator() {
        this.globalCache = new GlobalConditionCache();
        this.agentCaches = new HashMap<Integer, AgentConditionCache>();
        this.agentReadWriteLock = new ReentrantReadWriteLock();
    }

    public static AlertConditionCacheCoordinator getInstance() {
        return instance;
    }

    public void reloadGlobalCache() {
        try {
            this.globalCache = new GlobalConditionCache();
            log.debug((Object)"Reloaded global cache");
        }
        catch (Throwable t) {
            log.error((Object)"Error reloading global cache", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadCachesForAgent(int agentId) {
        AgentConditionCache agentCache = null;
        try {
            agentCache = new AgentConditionCache(agentId);
        }
        catch (Throwable t) {
            log.error((Object)("Error reloading cache for agent[id=" + agentId + "]"), t);
        }
        if (agentCache != null) {
            this.agentReadWriteLock.writeLock().lock();
            try {
                this.agentCaches.put(agentId, agentCache);
                log.debug((Object)("Reloaded agent[id=" + agentId + "] cache"));
            }
            catch (Throwable t) {
                log.error((Object)("Error reloading cache for agent[id=" + agentId + "]"), t);
            }
            finally {
                this.agentReadWriteLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlertConditionCacheStats checkConditions(MeasurementData ... measurementData) {
        if (measurementData == null || measurementData.length == 0) {
            return new AlertConditionCacheStats();
        }
        MeasurementData datum = measurementData[0];
        Integer agentId = this.getAgentId(datum);
        if (agentId == null) {
            log.error((Object)("Could not find agent for scheduleId = " + datum.getScheduleId()));
            return new AlertConditionCacheStats();
        }
        AlertConditionCacheStats stats = null;
        AgentConditionCache agentCache = null;
        this.agentReadWriteLock.readLock().lock();
        try {
            agentCache = this.agentCaches.get(agentId);
        }
        catch (Throwable t) {
            log.error((Object)"Error during checkConditions", t);
        }
        finally {
            this.agentReadWriteLock.readLock().unlock();
        }
        stats = agentCache != null ? agentCache.checkConditions(measurementData) : new AlertConditionCacheStats();
        return stats;
    }

    public AlertConditionCacheStats checkConditions(OperationHistory operationHistory) {
        AlertConditionCacheStats stats = null;
        try {
            stats = this.globalCache.checkConditions(operationHistory);
        }
        catch (Throwable t) {
            log.error((Object)"Error during checkConditions", t);
        }
        if (stats == null) {
            stats = new AlertConditionCacheStats();
        }
        return stats;
    }

    public AlertConditionCacheStats checkConditions(ResourceConfigurationUpdate update) {
        AlertConditionCacheStats stats = null;
        try {
            stats = this.globalCache.checkConditions(update);
        }
        catch (Throwable t) {
            log.error((Object)"Error during checkConditions", t);
        }
        if (stats == null) {
            stats = new AlertConditionCacheStats();
        }
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlertConditionCacheStats checkConditions(EventSource source, Event ... events) {
        if (source == null) {
            return new AlertConditionCacheStats();
        }
        Integer agentId = this.getAgentId(source);
        if (agentId == null) {
            log.error((Object)("Could not find agent for resourceId = " + source.getResource().getId()));
            return new AlertConditionCacheStats();
        }
        AlertConditionCacheStats stats = null;
        AgentConditionCache agentCache = null;
        this.agentReadWriteLock.readLock().lock();
        try {
            agentCache = this.agentCaches.get(agentId);
        }
        catch (Throwable t) {
            log.error((Object)"Error during checkConditions", t);
        }
        finally {
            this.agentReadWriteLock.readLock().unlock();
        }
        stats = agentCache != null ? agentCache.checkConditions(source, events) : new AlertConditionCacheStats();
        return stats;
    }

    public AlertConditionCacheStats checkConditions(Availability ... availabilities) {
        AlertConditionCacheStats stats = null;
        try {
            stats = this.globalCache.checkConditions(availabilities);
        }
        catch (Throwable t) {
            log.error((Object)"Error during checkConditions", t);
        }
        if (stats == null) {
            stats = new AlertConditionCacheStats();
        }
        return stats;
    }

    private Integer getAgentId(EventSource source) {
        try {
            int resourceId = source.getResource().getId();
            Integer agentId = this.agentManager.getAgentIdByResourceId(resourceId);
            return agentId;
        }
        catch (Throwable t) {
            log.error((Object)"Error looking up agent by EventSource", t);
            return null;
        }
    }

    private Integer getAgentId(MeasurementData datum) {
        try {
            int scheduleId = datum.getScheduleId();
            Integer agentId = this.agentManager.getAgentIdByScheduleId(scheduleId);
            return agentId;
        }
        catch (Throwable t) {
            log.error((Object)"Error looking up agent by MeasurementData", t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCacheSize(Cache cache) {
        int result = 0;
        if (cache.type == Cache.Type.Global) {
            result += this.globalCache.getCacheSize(cache);
        } else if (cache.type == Cache.Type.Agent) {
            ArrayList<AgentConditionCache> cachesCopy = null;
            this.agentReadWriteLock.readLock().lock();
            try {
                cachesCopy = new ArrayList<AgentConditionCache>(this.agentCaches.values());
            }
            catch (Throwable t) {
                log.error((Object)"Error during getCacheSize", t);
            }
            finally {
                this.agentReadWriteLock.readLock().unlock();
            }
            for (AgentConditionCache agentCache : cachesCopy) {
                result += agentCache.getCacheSize(cache);
            }
        } else {
            log.error((Object)("The " + AlertConditionCacheCoordinator.class.getSimpleName() + " does not support getting the size for caches of type " + (Object)((Object)cache.type)));
        }
        return result;
    }

    public Map<String, Integer> getCacheCounts() {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (Cache cache : Cache.values()) {
            counts.put(cache.name(), this.getCacheSize(cache));
        }
        return counts;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Cache {
        MeasurementDataCache(Type.Agent),
        MeasurementTraitCache(Type.Agent),
        ResourceOperationCache(Type.Global),
        AvailabilityCache(Type.Global),
        EventsCache(Type.Agent),
        ResourceConfigurationCache(Type.Global);

        public Type type;

        private Cache(Type type) {
            this.type = type;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            Global,
            Agent;

        }
    }
}

