/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.bundle;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.configuration.ConfigurationUtility;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.bundle.Bundle;
import org.rhq.core.domain.bundle.BundleDeployDefinition;
import org.rhq.core.domain.bundle.BundleDeployment;
import org.rhq.core.domain.bundle.BundleFile;
import org.rhq.core.domain.bundle.BundleType;
import org.rhq.core.domain.bundle.BundleVersion;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.content.Architecture;
import org.rhq.core.domain.content.Package;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.criteria.BundleCriteria;
import org.rhq.core.domain.criteria.BundleDeployDefinitionCriteria;
import org.rhq.core.domain.criteria.BundleDeploymentCriteria;
import org.rhq.core.domain.criteria.BundleVersionCriteria;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PersistenceUtility;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.bundle.BundleManagerHelper;
import org.rhq.enterprise.server.bundle.BundleManagerLocal;
import org.rhq.enterprise.server.bundle.BundleManagerRemote;
import org.rhq.enterprise.server.bundle.RecipeParseResults;
import org.rhq.enterprise.server.content.ContentManagerLocal;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.plugin.pc.bundle.BundleServerPluginFacet;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaQueryRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class BundleManagerBean
implements BundleManagerLocal,
BundleManagerRemote {
    private final Log log = LogFactory.getLog(this.getClass());
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    private ContentManagerLocal contentManager;
    @EJB
    private RepoManagerLocal repoManager;
    @EJB
    private ResourceTypeManagerLocal resourceTypeManager;

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public Bundle createBundle(Subject subject, String name, int bundleTypeId) {
        if (null == name || "".equals(name.trim())) {
            throw new IllegalArgumentException("Invalid bundleName: " + name);
        }
        BundleType bundleType = (BundleType)this.entityManager.find(BundleType.class, (Object)bundleTypeId);
        if (null == bundleType) {
            throw new IllegalArgumentException("Invalid bundleTypeId: " + bundleTypeId);
        }
        Bundle bundle = new Bundle(name, bundleType);
        Repo repo = new Repo(name);
        repo.setCandidate(false);
        repo.setSyncSchedule(null);
        bundle.setRepo(repo);
        this.log.info((Object)("Creating bundle: " + bundle));
        this.entityManager.persist((Object)bundle);
        return bundle;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public BundleDeployDefinition createBundleDeployDefinition(Subject subject, int bundleVersionId, String name, String description, Configuration configuration, boolean enforcePolicy, int enforcementInterval, boolean pinToBundle) throws Exception {
        if (null == name || "".equals(name.trim())) {
            throw new IllegalArgumentException("Invalid bundleDeployDefinitionName: " + name);
        }
        BundleVersion bundleVersion = (BundleVersion)this.entityManager.find(BundleVersion.class, (Object)bundleVersionId);
        if (null == bundleVersion) {
            throw new IllegalArgumentException("Invalid bundleVersionId: " + bundleVersionId);
        }
        ConfigurationDefinition configDef = bundleVersion.getConfigurationDefinition();
        if (null != configDef) {
            if (null == configuration) {
                throw new IllegalArgumentException("Missing Configuration. Configuration is required when the specified BundleVersion defines Configuration Properties.");
            }
            List errors = ConfigurationUtility.validateConfiguration((Configuration)configuration, (ConfigurationDefinition)configDef);
            if (null != errors && !errors.isEmpty()) {
                throw new IllegalArgumentException("Invalid Configuration: " + errors.toString());
            }
        }
        BundleDeployDefinition deployDef = new BundleDeployDefinition(bundleVersion, name);
        deployDef.setDescription(description);
        deployDef.setConfiguration(configuration);
        deployDef.setEnforcePolicy(enforcePolicy);
        deployDef.setEnforcementInterval(enforcementInterval);
        if (pinToBundle) {
            deployDef.setBundle(bundleVersion.getBundle());
        }
        this.entityManager.persist((Object)deployDef);
        return deployDef;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public BundleType createBundleType(Subject subject, String name, int resourceTypeId) throws Exception {
        if (null == name || "".equals(name.trim())) {
            throw new IllegalArgumentException("Invalid bundleTypeName: " + name);
        }
        ResourceType resourceType = (ResourceType)this.entityManager.find(ResourceType.class, (Object)resourceTypeId);
        if (null == resourceType) {
            throw new IllegalArgumentException("Invalid resourceeTypeId: " + resourceTypeId);
        }
        BundleType bundleType = new BundleType(name, resourceType);
        this.entityManager.persist((Object)bundleType);
        return bundleType;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public BundleVersion createBundleVersion(Subject subject, int bundleId, String name, String version, String recipe) throws Exception {
        if (null == name || "".equals(name.trim())) {
            throw new IllegalArgumentException("Invalid bundleVersionName: " + name);
        }
        Bundle bundle = (Bundle)this.entityManager.find(Bundle.class, (Object)bundleId);
        if (null == bundle) {
            throw new IllegalArgumentException("Invalid bundleId: " + bundleId);
        }
        BundleType bundleType = bundle.getBundleType();
        BundleServerPluginFacet bp = BundleManagerHelper.getPluginContainer().getBundleServerPluginManager().getBundleServerPluginFacet(bundleType.getName());
        RecipeParseResults results = bp.parseRecipe(recipe);
        version = this.getVersion(version, bundle);
        BundleVersion bundleVersion = new BundleVersion(name, version, bundle, recipe);
        bundleVersion.setConfigurationDefinition(results.getConfigDef());
        this.entityManager.persist((Object)bundleVersion);
        return bundleVersion;
    }

    private String getVersion(String version, Bundle bundle) {
        if (null != version && !"".equals(version.trim())) {
            return version;
        }
        BundleVersion currentBundleVersion = null;
        for (BundleVersion bundleVersion : bundle.getBundleVersions()) {
            if (null != currentBundleVersion && bundleVersion.getId() <= currentBundleVersion.getId()) continue;
            currentBundleVersion = bundleVersion;
        }
        String oldVersion = null == currentBundleVersion ? null : currentBundleVersion.getVersion();
        String newVersion = "1.0";
        if (oldVersion != null && oldVersion.length() != 0) {
            String[] parts = oldVersion.split("[^a-zA-Z0-9]");
            String lastPart = parts[parts.length - 1];
            try {
                int lastNumber = Integer.parseInt(lastPart);
                newVersion = oldVersion.substring(0, oldVersion.length() - lastPart.length()) + (lastNumber + 1);
            }
            catch (NumberFormatException nfe) {
                newVersion = oldVersion + ".1";
            }
        }
        return newVersion;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public BundleFile addBundleFile(Subject subject, int bundleVersionId, String name, String version, Architecture architecture, InputStream fileStream, boolean pinToPackage) throws Exception {
        if (null == name || "".equals(name.trim())) {
            throw new IllegalArgumentException("Invalid bundleFileName: " + name);
        }
        if (null == version || "".equals(version.trim())) {
            throw new IllegalArgumentException("Invalid bundleFileVersion: " + version);
        }
        if (null == fileStream) {
            throw new IllegalArgumentException("Invalid fileStream: " + null);
        }
        BundleVersion bundleVersion = (BundleVersion)this.entityManager.find(BundleVersion.class, (Object)bundleVersionId);
        if (null == bundleVersion) {
            throw new IllegalArgumentException("Invalid bundleVersionId: " + bundleVersionId);
        }
        Bundle bundle = bundleVersion.getBundle();
        PackageType packageType = this.getBundleTypePackageType(bundle.getBundleType());
        architecture = null == architecture ? this.contentManager.getNoArchitecture() : architecture;
        PackageVersion packageVersion = this.contentManager.createPackageVersion(name, packageType.getId(), version, architecture.getId(), fileStream);
        Repo repo = bundle.getRepo();
        this.repoManager.addPackageVersionsToRepo(subject, repo.getId(), new int[]{packageVersion.getId()});
        Package generalPackage = packageVersion.getGeneralPackage();
        generalPackage.setClassification(bundle.getName());
        BundleFile bundleFile = new BundleFile();
        bundleFile.setBundleVersion(bundleVersion);
        bundleFile.setPackageVersion(packageVersion);
        if (pinToPackage) {
            bundleFile.setPackage(generalPackage);
        }
        this.entityManager.persist((Object)bundleFile);
        return bundleFile;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public BundleFile addBundleFileViaByteArray(Subject subject, int bundleVersionId, String name, String version, Architecture architecture, byte[] fileBytes, boolean pinToPackage) throws Exception {
        return this.addBundleFile(subject, bundleVersionId, name, version, architecture, new ByteArrayInputStream(fileBytes), pinToPackage);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public BundleFile addBundleFileViaPackageVersion(Subject subject, int bundleVersionId, String name, int packageVersionId, boolean pinToPackage) throws Exception {
        if (null == name || "".equals(name.trim())) {
            throw new IllegalArgumentException("Invalid bundleFileName: " + name);
        }
        BundleVersion bundleVersion = (BundleVersion)this.entityManager.find(BundleVersion.class, (Object)bundleVersionId);
        if (null == bundleVersion) {
            throw new IllegalArgumentException("Invalid bundleVersionId: " + bundleVersionId);
        }
        PackageVersion packageVersion = (PackageVersion)this.entityManager.find(PackageVersion.class, (Object)packageVersionId);
        if (null == packageVersion) {
            throw new IllegalArgumentException("Invalid packageVersionId: " + packageVersionId);
        }
        BundleFile bundleFile = new BundleFile();
        bundleFile.setBundleVersion(bundleVersion);
        bundleFile.setPackageVersion(packageVersion);
        if (pinToPackage) {
            bundleFile.setPackage(packageVersion.getGeneralPackage());
        }
        this.entityManager.persist((Object)bundleFile);
        return bundleFile;
    }

    private PackageType getBundleTypePackageType(BundleType bundleType) {
        Query packageTypeQuery = this.entityManager.createNamedQuery("PackageType.findByResourceTypeIdAndName");
        packageTypeQuery.setParameter("typeId", (Object)bundleType.getResourceType().getId());
        packageTypeQuery.setParameter("name", (Object)bundleType.getName());
        return (PackageType)packageTypeQuery.getSingleResult();
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public List<BundleDeployment> deployBundle(Subject subject, int bundleDeployDefinitionId, int[] resourceIds) throws Exception {
        if (null == resourceIds || 0 == resourceIds.length) {
            throw new IllegalArgumentException("Invalid resourceIds: " + resourceIds);
        }
        BundleDeployDefinition deployDef = (BundleDeployDefinition)this.entityManager.find(BundleDeployDefinition.class, (Object)bundleDeployDefinitionId);
        if (null == deployDef) {
            throw new IllegalArgumentException("Invalid bundleDeployDefinitionId: " + bundleDeployDefinitionId);
        }
        Resource[] resources = new Resource[resourceIds.length];
        for (int i = 0; i < resourceIds.length; ++i) {
            resources[i] = (Resource)this.entityManager.find(Resource.class, (Object)resourceIds[i]);
            if (null != resources[i]) continue;
            throw new IllegalArgumentException("Invalid resourceId (Resource does not exist): " + resources[i]);
        }
        ArrayList<BundleDeployment> result = new ArrayList<BundleDeployment>(resourceIds.length);
        for (Resource resource : resources) {
            BundleDeployment deployment = new BundleDeployment(deployDef, resource);
            deployDef.addDeployment(deployment);
            result.add(deployment);
            this.entityManager.persist((Object)deployment);
        }
        return result;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public Set<String> getBundleVersionFilenames(Subject subject, int bundleVersionId, boolean withoutBundleFileOnly) throws Exception {
        BundleVersion bundleVersion = (BundleVersion)this.entityManager.find(BundleVersion.class, (Object)bundleVersionId);
        if (null == bundleVersion) {
            throw new IllegalArgumentException("Invalid bundleVersionId: " + bundleVersionId);
        }
        BundleType bundleType = bundleVersion.getBundle().getBundleType();
        BundleServerPluginFacet bp = BundleManagerHelper.getPluginContainer().getBundleServerPluginManager().getBundleServerPluginFacet(bundleType.getName());
        RecipeParseResults parseResults = bp.parseRecipe(bundleVersion.getRecipe());
        Set<String> result = parseResults.getBundleFileNames();
        if (withoutBundleFileOnly) {
            List bundleFiles = bundleVersion.getBundleFiles();
            Set<String> allFilenames = result;
            result = new HashSet<String>(allFilenames.size() - bundleFiles.size());
            for (String filename : allFilenames) {
                boolean found = false;
                for (BundleFile bundleFile : bundleFiles) {
                    String name = bundleFile.getPackageVersion().getGeneralPackage().getName();
                    if (!name.equals(filename)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                result.add(filename);
            }
        }
        return result;
    }

    @Override
    public List<BundleType> getAllBundleTypes(Subject subject) {
        Query q = this.entityManager.createNamedQuery("BundleType.findAll");
        List types = q.getResultList();
        return types;
    }

    @Override
    public PageList<BundleDeployDefinition> findBundleDeployDefinitionsByCriteria(Subject subject, BundleDeployDefinitionCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator((Criteria)criteria);
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }

    @Override
    public PageList<BundleDeployment> findBundleDeploymentsByCriteria(Subject subject, BundleDeploymentCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator((Criteria)criteria);
        if (!this.authorizationManager.isInventoryManager(subject)) {
            if (criteria.isInventoryManagerRequired()) {
                throw new PermissionException("Subject [" + subject.getName() + "] requires InventoryManager permission for requested query criteria.");
            }
            generator.setAuthorizationResourceFragment(CriteriaQueryGenerator.AuthorizationTokenType.RESOURCE, null, subject.getId());
        }
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }

    @Override
    public PageList<BundleVersion> findBundleVersionsByCriteria(Subject subject, BundleVersionCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator((Criteria)criteria);
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }

    @Override
    public PageList<Bundle> findBundlesByCriteria(Subject subject, BundleCriteria criteria) {
        Query totalCountQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Bundle.findAll");
        long totalCount = (Long)totalCountQuery.getSingleResult();
        if (totalCount == 0L) {
            List<BundleType> bundleTypes = this.getAllBundleTypes(subject);
            for (int i = 0; i < 50; ++i) {
                this.createMockBundle(subject, bundleTypes);
            }
        }
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator((Criteria)criteria);
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }

    public PageList<BundleDeployment> findBundleDeploymentsByCriteria(BundleDeploymentCriteria criteria) {
        return null;
    }

    @Override
    public void deleteBundles(Subject subject, int[] bundleIds) {
        for (int bundleId : bundleIds) {
            Bundle bundle = (Bundle)this.entityManager.find(Bundle.class, (Object)bundleId);
            this.entityManager.remove((Object)bundle);
        }
    }

    @Override
    public void deleteBundleVersions(Subject subject, int[] bundleVersionIds) {
        for (int bundleVersionId : bundleVersionIds) {
            BundleVersion bundleVersion = (BundleVersion)this.entityManager.find(BundleVersion.class, (Object)bundleVersionId);
            this.entityManager.remove((Object)bundleVersion);
        }
    }

    public BundleType createMockBundleType(Subject subject) {
        try {
            ResourceType linuxPlatformResourceType = this.resourceTypeManager.getResourceTypeByNameAndPlugin("Linux", "Platforms");
            return this.createBundleType(subject, UUID.randomUUID().toString(), linuxPlatformResourceType.getId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Bundle createMockBundle(Subject subject, List<BundleType> bundleTypes) {
        BundleType bundleType;
        Random random = new Random();
        if (bundleTypes.isEmpty()) {
            bundleType = this.createMockBundleType(subject);
        } else {
            int randomIndex = random.nextInt(bundleTypes.size());
            bundleType = bundleTypes.get(randomIndex);
        }
        Bundle bundle = this.createBundle(subject, UUID.randomUUID().toString(), bundleType.getId());
        int bundleVersionCount = random.nextInt(5) + 1;
        for (int i = 0; i < bundleVersionCount; ++i) {
            String bundleVersionName = UUID.randomUUID().toString();
            String RECIPE = "repo rhel-x86_64-5\npackage foo-1.25.rpm\npackage bar-1.25.rpm\nscript foo.bash -c some parameter\ndeploy jboss.tar %{jboss.home.directory}\nrealize %{jboss.home.directory}/server/default/setting.xml\nfile example.setting /etc/some/setting.ini\nservice example restart\n";
            BundleVersion bundleVersion = new BundleVersion(bundleVersionName, String.valueOf(i + 1), null, "repo rhel-x86_64-5\npackage foo-1.25.rpm\npackage bar-1.25.rpm\nscript foo.bash -c some parameter\ndeploy jboss.tar %{jboss.home.directory}\nrealize %{jboss.home.directory}/server/default/setting.xml\nfile example.setting /etc/some/setting.ini\nservice example restart\n");
            bundle.addBundleVersion(bundleVersion);
        }
        bundle = (Bundle)this.entityManager.merge((Object)bundle);
        return bundle;
    }
}

