/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.bundle;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.server.bundle.BundleServerService;
import org.rhq.core.clientapi.server.bundle.BundleStatusUpdate;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.bundle.BundleFile;
import org.rhq.core.domain.bundle.BundleVersion;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.criteria.BundleVersionCriteria;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.exception.WrappedRemotingException;
import org.rhq.enterprise.server.bundle.BundleManagerLocal;
import org.rhq.enterprise.server.content.ContentSourceManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleServerServiceImpl
implements BundleServerService {
    private final Log log = LogFactory.getLog(this.getClass());

    public void updateStatus(BundleStatusUpdate update) {
    }

    public List<PackageVersion> getAllBundleVersionPackageVersions(int bundleVersionId) {
        try {
            BundleManagerLocal bm = LookupUtil.getBundleManager();
            BundleVersionCriteria c = new BundleVersionCriteria();
            Subject subject = LookupUtil.getSubjectManager().getOverlord();
            c.addFilterId(Integer.valueOf(bundleVersionId));
            c.fetchBundleFiles(true);
            PageList<BundleVersion> bundleVersions = bm.findBundleVersionsByCriteria(subject, c);
            List bundleFiles = ((BundleVersion)bundleVersions.get(0)).getBundleFiles();
            ArrayList<PackageVersion> packageVersions = new ArrayList<PackageVersion>(bundleFiles.size());
            for (BundleFile bundleFile : bundleFiles) {
                packageVersions.add(bundleFile.getPackageVersion());
            }
            return packageVersions;
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to obtain bundle files for bundle version id: " + bundleVersionId), (Throwable)e);
            throw new WrappedRemotingException((Throwable)e);
        }
    }

    public long downloadPackageBits(PackageVersion packageVersion, OutputStream outputStream) {
        try {
            ContentSourceManagerLocal csm = LookupUtil.getContentSourceManager();
            long size = csm.outputPackageVersionBits(packageVersion, outputStream);
            return size;
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to obtain package version bits for package version: " + packageVersion), (Throwable)e);
            throw new WrappedRemotingException((Throwable)e);
        }
    }
}

