/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.cloud;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.cloud.AffinityGroup;
import org.rhq.core.domain.cloud.PartitionEventType;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.domain.cloud.composite.AffinityGroupCountComposite;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PersistenceUtility;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.cloud.AffinityGroupCreationException;
import org.rhq.enterprise.server.cloud.AffinityGroupException;
import org.rhq.enterprise.server.cloud.AffinityGroupManagerLocal;
import org.rhq.enterprise.server.cloud.AffinityGroupUpdateException;
import org.rhq.enterprise.server.cloud.PartitionEventManagerLocal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class AffinityGroupManagerBean
implements AffinityGroupManagerLocal {
    private final Log log = LogFactory.getLog(AffinityGroupManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private PartitionEventManagerLocal partitionEventManager;

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public AffinityGroup getById(Subject subject, int affinityGroupId) {
        AffinityGroup affinityGroup = (AffinityGroup)this.entityManager.find(AffinityGroup.class, (Object)affinityGroupId);
        return affinityGroup;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<Agent> getAgentMembers(Subject subject, int affinityGroupId, PageControl pageControl) {
        pageControl.initDefaultOrderingField("a.name");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Agent.findByAffinityGroup", (PageControl)pageControl);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Agent.findByAffinityGroup");
        query.setParameter("affinityGroupId", (Object)affinityGroupId);
        countQuery.setParameter("affinityGroupId", (Object)affinityGroupId);
        long count = (Long)countQuery.getSingleResult();
        List results = query.getResultList();
        return new PageList((Collection)results, (int)count, pageControl);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<Agent> getAgentNonMembers(Subject subject, int affinityGroupId, PageControl pageControl) {
        pageControl.initDefaultOrderingField("a.name");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Agent.findWithoutAffinityGroup", (PageControl)pageControl);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Agent.findWithoutAffinityGroup");
        long count = (Long)countQuery.getSingleResult();
        List results = query.getResultList();
        return new PageList((Collection)results, (int)count, pageControl);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<Server> getServerMembers(Subject subject, int affinityGroupId, PageControl pageControl) {
        pageControl.initDefaultOrderingField("s.name");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Server.findByAffinityGroup", (PageControl)pageControl);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Server.findByAffinityGroup");
        query.setParameter("affinityGroupId", (Object)affinityGroupId);
        countQuery.setParameter("affinityGroupId", (Object)affinityGroupId);
        long count = (Long)countQuery.getSingleResult();
        List results = query.getResultList();
        return new PageList((Collection)results, (int)count, pageControl);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<Server> getServerNonMembers(Subject subject, int affinityGroupId, PageControl pageControl) {
        pageControl.initDefaultOrderingField("s.name");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Server.findWithoutAffinityGroup", (PageControl)pageControl);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Server.findWithoutAffinityGroup");
        long count = (Long)countQuery.getSingleResult();
        List results = query.getResultList();
        return new PageList((Collection)results, (int)count, pageControl);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public AffinityGroup update(Subject subject, AffinityGroup affinityGroup) throws AffinityGroupException {
        this.validate(affinityGroup, true);
        return (AffinityGroup)this.entityManager.merge((Object)affinityGroup);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<AffinityGroupCountComposite> getComposites(Subject subject, PageControl pageControl) {
        pageControl.initDefaultOrderingField("ag.name");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"AffinityGroup.findAllComposites", (PageControl)pageControl);
        int count = this.getAffinityGroupCount();
        List results = query.getResultList();
        return new PageList((Collection)results, count, pageControl);
    }

    @Override
    public int getAffinityGroupCount() {
        Query query = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"AffinityGroup.findAll");
        try {
            long serverCount = (Long)query.getSingleResult();
            return (int)serverCount;
        }
        catch (NoResultException nre) {
            this.log.debug((Object)"Could not get AffinityGroup count, returning 0...");
            return 0;
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public int create(Subject subject, AffinityGroup affinityGroup) throws AffinityGroupException {
        this.validate(affinityGroup, false);
        this.entityManager.persist((Object)affinityGroup);
        return affinityGroup.getId();
    }

    private void validate(AffinityGroup affinityGroup, boolean alreadyExists) throws AffinityGroupException {
        String name;
        String string = name = affinityGroup.getName() == null ? "" : affinityGroup.getName().trim();
        if (name.equals("")) {
            throw new AffinityGroupCreationException("Name is a required property");
        }
        if (name.length() > 100) {
            throw new AffinityGroupCreationException("Name is limited to 100 characters");
        }
        Query query = this.entityManager.createNamedQuery("AffinityGroup.findByName");
        query.setParameter("name", (Object)name.toUpperCase());
        try {
            AffinityGroup found = (AffinityGroup)query.getSingleResult();
            if (!alreadyExists) {
                throw new AffinityGroupCreationException("AffinityGroup with name '" + name + "' already exists");
            }
            if (affinityGroup.getId() != found.getId()) {
                throw new AffinityGroupUpdateException("AffinityGroup with name '" + name + "' already exists");
            }
        }
        catch (NoResultException e) {
            // empty catch block
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public int delete(Subject subject, Integer[] affinityGroupIds) {
        for (Integer agId : affinityGroupIds) {
            AffinityGroup ag = (AffinityGroup)this.entityManager.find(AffinityGroup.class, (Object)agId);
            this.partitionEventManager.cloudPartitionEventRequest(subject, PartitionEventType.AFFINITY_GROUP_DELETE, ag.getName());
        }
        Query updateAgentsQuery = this.entityManager.createNamedQuery("AffinityGroup.updateRemoveAgents");
        Query updateServersQuery = this.entityManager.createNamedQuery("AffinityGroup.updateRemoveServers");
        Query removeQuery = this.entityManager.createNamedQuery("AffinityGroup.deleteByIds");
        List<Integer> affinityGroups = Arrays.asList(affinityGroupIds);
        updateAgentsQuery.setParameter("affinityGroupIds", affinityGroups);
        updateServersQuery.setParameter("affinityGroupIds", affinityGroups);
        removeQuery.setParameter("affinityGroupIds", affinityGroups);
        int updatedAgents = updateAgentsQuery.executeUpdate();
        int updatedServers = updateServersQuery.executeUpdate();
        int removedAffinityGroups = removeQuery.executeUpdate();
        this.log.debug((Object)("Removed " + removedAffinityGroups + " AffinityGroups: " + updatedAgents + " agents and " + updatedServers + " were updated"));
        return removedAffinityGroups;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void addAgentsToGroup(Subject subject, int affinityGroupId, Integer[] agentIds) {
        List<Integer> agentIdsList = Arrays.asList(agentIds);
        AffinityGroup group = (AffinityGroup)this.entityManager.find(AffinityGroup.class, (Object)affinityGroupId);
        Query query = this.entityManager.createNamedQuery("AffinityGroup.updateAddAgents");
        query.setParameter("affinityGroup", (Object)group);
        query.setParameter("agentIds", agentIdsList);
        query.executeUpdate();
        String auditString = group.getName() + " <-- ";
        for (Integer agentId : agentIdsList) {
            Agent agent = (Agent)this.entityManager.find(Agent.class, (Object)agentId);
            this.partitionEventManager.auditPartitionEvent(subject, PartitionEventType.AGENT_AFFINITY_GROUP_ASSIGN, auditString + agent.getName());
        }
        this.partitionEventManager.cloudPartitionEventRequest(subject, PartitionEventType.AFFINITY_GROUP_CHANGE, group.getName());
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void removeAgentsFromGroup(Subject subject, Integer[] agentIds) {
        List<Integer> agentIdsList = Arrays.asList(agentIds);
        Query query = this.entityManager.createNamedQuery("AffinityGroup.updateRemoveSpecificAgents");
        query.setParameter("agentIds", agentIdsList);
        query.executeUpdate();
        for (Integer agentId : agentIdsList) {
            Agent agent = (Agent)this.entityManager.find(Agent.class, (Object)agentId);
            this.partitionEventManager.auditPartitionEvent(subject, PartitionEventType.AGENT_AFFINITY_GROUP_REMOVE, agent.getName());
        }
        this.partitionEventManager.cloudPartitionEventRequest(subject, PartitionEventType.AFFINITY_GROUP_CHANGE, PartitionEventType.AGENT_AFFINITY_GROUP_REMOVE.name());
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void addServersToGroup(Subject subject, int affinityGroupId, Integer[] serverIds) {
        List<Integer> serverIdsList = Arrays.asList(serverIds);
        AffinityGroup group = (AffinityGroup)this.entityManager.find(AffinityGroup.class, (Object)affinityGroupId);
        Query query = this.entityManager.createNamedQuery("AffinityGroup.updateAddServers");
        query.setParameter("affinityGroup", (Object)group);
        query.setParameter("serverIds", serverIdsList);
        query.executeUpdate();
        String auditString = group.getName() + " <-- ";
        for (Integer serverId : serverIdsList) {
            Server server = (Server)this.entityManager.find(Server.class, (Object)serverId);
            this.partitionEventManager.auditPartitionEvent(subject, PartitionEventType.SERVER_AFFINITY_GROUP_ASSIGN, auditString + server.getName());
        }
        this.partitionEventManager.cloudPartitionEventRequest(subject, PartitionEventType.AFFINITY_GROUP_CHANGE, group.getName());
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void removeServersFromGroup(Subject subject, Integer[] serverIds) {
        List<Integer> serverIdsList = Arrays.asList(serverIds);
        Query query = this.entityManager.createNamedQuery("AffinityGroup.updateRemoveSpecificServers");
        query.setParameter("serverIds", serverIdsList);
        query.executeUpdate();
        for (Integer serverId : serverIdsList) {
            Server server = (Server)this.entityManager.find(Server.class, (Object)serverId);
            this.partitionEventManager.auditPartitionEvent(subject, PartitionEventType.SERVER_AFFINITY_GROUP_REMOVE, server.getName());
        }
        this.partitionEventManager.cloudPartitionEventRequest(subject, PartitionEventType.AFFINITY_GROUP_CHANGE, PartitionEventType.AGENT_AFFINITY_GROUP_REMOVE.name());
    }
}

