/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.configuration.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.ConfigurationTemplate;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionEnumeration;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertyGroupDefinition;
import org.rhq.core.domain.configuration.definition.constraint.Constraint;
import org.rhq.enterprise.server.configuration.metadata.ConfigurationMetadataManagerLocal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class ConfigurationMetadataManagerBean
implements ConfigurationMetadataManagerLocal {
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;

    @Override
    public void updateConfigurationDefinition(ConfigurationDefinition newDefinition, ConfigurationDefinition existingDefinition) {
        List existingPropertyDefinitions = existingDefinition.getNonGroupedProperties();
        List newPropertyDefinitions = newDefinition.getNonGroupedProperties();
        if (existingPropertyDefinitions != null) {
            for (PropertyDefinition newProperty : newPropertyDefinitions) {
                PropertyDefinition existingProp = existingDefinition.get(newProperty.getName());
                if (existingProp != null) {
                    this.updatePropertyDefinition(existingProp, newProperty);
                    continue;
                }
                existingDefinition.put(newProperty);
            }
            this.removeNolongerUsedProperties(newDefinition, existingDefinition, existingPropertyDefinitions, null);
        }
        this.entityManager.flush();
        List existingGroups = existingDefinition.getGroupDefinitions();
        List newGroups = newDefinition.getGroupDefinitions();
        List toPersist = this.missingInFirstList(existingGroups, newGroups);
        List toDelete = this.missingInFirstList(newGroups, existingGroups);
        List toUpdate = this.intersection(existingGroups, newGroups);
        for (PropertyGroupDefinition group : toDelete) {
            List groupedDefinitions = existingDefinition.getPropertiesInGroup(group.getName());
            for (PropertyDefinition def : groupedDefinitions) {
                existingPropertyDefinitions.remove(def);
                existingDefinition.getPropertyDefinitions().remove(def.getName());
                def.setPropertyGroupDefinition(null);
                this.entityManager.remove((Object)def);
            }
            existingGroups.remove(group);
            this.entityManager.remove((Object)group);
        }
        this.entityManager.flush();
        for (PropertyGroupDefinition group : toUpdate) {
            String groupName = group.getName();
            List newGroupedDefinitions = newDefinition.getPropertiesInGroup(groupName);
            for (PropertyDefinition nDef : newGroupedDefinitions) {
                PropertyDefinition existingProperty = (PropertyDefinition)existingDefinition.getPropertyDefinitions().get(nDef.getName());
                if (existingProperty != null) {
                    this.updatePropertyDefinition(existingProperty, nDef);
                    continue;
                }
                existingDefinition.put(nDef);
            }
            this.removeNolongerUsedProperties(newDefinition, existingDefinition, existingDefinition.getPropertiesInGroup(groupName), group);
        }
        this.entityManager.flush();
        for (PropertyGroupDefinition group : toPersist) {
            this.entityManager.persist((Object)group);
            existingGroups.add(group);
            List defs = newDefinition.getPropertiesInGroup(group.getName());
            Map exPDefs = existingDefinition.getPropertyDefinitions();
            for (PropertyDefinition def : defs) {
                this.entityManager.persist((Object)def);
                def.setPropertyGroupDefinition(group);
                def.setConfigurationDefinition(existingDefinition);
                exPDefs.put(def.getName(), def);
            }
        }
        Map existingTemplates = existingDefinition.getTemplates();
        Map newTemplates = newDefinition.getTemplates();
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String name : existingTemplates.keySet()) {
            ConfigurationTemplate exTemplate = (ConfigurationTemplate)existingTemplates.get(name);
            if (newTemplates.containsKey(name)) {
                this.updateTemplate(exTemplate, (ConfigurationTemplate)newTemplates.get(name));
                continue;
            }
            this.entityManager.remove((Object)exTemplate);
            toRemove.add(name);
        }
        for (String name : toRemove) {
            existingTemplates.remove(name);
        }
        this.entityManager.flush();
        for (String name : newTemplates.keySet()) {
            if (existingTemplates.containsKey(name)) continue;
            ConfigurationTemplate newTemplate = (ConfigurationTemplate)newTemplates.get(name);
            newTemplate.setConfigurationDefinition(existingDefinition);
            this.entityManager.persist((Object)newTemplate);
            existingTemplates.put(name, newTemplate);
        }
        this.entityManager.flush();
    }

    private void updateTemplate(ConfigurationTemplate existingDT, ConfigurationTemplate newDT) {
        try {
            PropertySimple ps;
            Property prop;
            Configuration existConf = existingDT.getConfiguration();
            Configuration newConf = newDT.getConfiguration();
            Collection exNames = existConf.getNames();
            Collection newNames = newConf.getNames();
            ArrayList<String> toRemove = new ArrayList<String>();
            for (String name : exNames) {
                prop = newConf.get(name);
                if (prop instanceof PropertySimple) {
                    ps = newConf.getSimple(name);
                    if (ps != null) {
                        Property eprop = existConf.get(name);
                        if (eprop instanceof PropertySimple) {
                            PropertySimple exps = existConf.getSimple(name);
                            if (ps.getStringValue() == null) continue;
                            exps.setStringValue(ps.getStringValue());
                            continue;
                        }
                        if (eprop == null) continue;
                    }
                    toRemove.add(name);
                    continue;
                }
                if (prop == null) continue;
            }
            for (String name : toRemove) {
                existConf.remove(name);
            }
            for (String name : newNames) {
                if (!exNames.contains(name) && (prop = newConf.get(name)) instanceof PropertySimple && (ps = newConf.getSimple(name)).getStringValue() == null) continue;
            }
            this.entityManager.flush();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void removeNolongerUsedProperties(ConfigurationDefinition newDefinition, ConfigurationDefinition existingDefinition, List<PropertyDefinition> existingProperties, PropertyGroupDefinition groupDef) {
        ArrayList<PropertyDefinition> definitionsToDelete = new ArrayList<PropertyDefinition>();
        for (PropertyDefinition exDef : existingProperties) {
            PropertyDefinition nDef = newDefinition.get(exDef.getName());
            if (nDef != null) continue;
            definitionsToDelete.add(exDef);
        }
        for (PropertyDefinition def : definitionsToDelete) {
            existingDefinition.getPropertyDefinitions().remove(def.getName());
            existingProperties.remove(def);
            this.entityManager.remove((Object)def);
        }
        this.entityManager.flush();
    }

    private void updatePropertyDefinition(PropertyDefinition existingProperty, PropertyDefinition newProperty) {
        existingProperty.setDescription(newProperty.getDescription());
        existingProperty.setDisplayName(newProperty.getDisplayName());
        existingProperty.setActivationPolicy(newProperty.getActivationPolicy());
        existingProperty.setVersion(newProperty.getVersion());
        existingProperty.setRequired(newProperty.isRequired());
        existingProperty.setReadOnly(newProperty.isReadOnly());
        existingProperty.setSummary(newProperty.isSummary());
        if (existingProperty instanceof PropertyDefinitionMap) {
            if (newProperty instanceof PropertyDefinitionMap) {
                Map existingPropDefs = ((PropertyDefinitionMap)existingProperty).getPropertyDefinitions();
                Set existingKeys = existingPropDefs.keySet();
                Set newKeys = ((PropertyDefinitionMap)newProperty).getPropertyDefinitions().keySet();
                for (String key : existingKeys) {
                    if (newKeys.contains(key)) continue;
                    this.entityManager.remove(existingPropDefs.get(key));
                    existingPropDefs.remove(key);
                }
                for (PropertyDefinition newChild : ((PropertyDefinitionMap)newProperty).getPropertyDefinitions().values()) {
                    PropertyDefinition existingChild = ((PropertyDefinitionMap)existingProperty).get(newChild.getName());
                    if (existingChild != null) {
                        this.updatePropertyDefinition(existingChild, newChild);
                        continue;
                    }
                    ((PropertyDefinitionMap)existingProperty).put(newChild);
                    this.entityManager.persist((Object)newChild);
                }
            } else {
                this.replaceProperty(existingProperty, newProperty);
            }
        } else if (existingProperty instanceof PropertyDefinitionList) {
            PropertyDefinitionList exList = (PropertyDefinitionList)existingProperty;
            if (newProperty instanceof PropertyDefinitionList) {
                PropertyDefinitionList newList = (PropertyDefinitionList)newProperty;
                exList.setMemberDefinition(newList.getMemberDefinition());
                exList.setMax(newList.getMax());
                exList.setMin(newList.getMax());
            } else {
                this.replaceProperty(existingProperty, newProperty);
            }
        } else if (existingProperty instanceof PropertyDefinitionSimple) {
            PropertyDefinitionSimple existingPDS = (PropertyDefinitionSimple)existingProperty;
            if (newProperty instanceof PropertyDefinitionSimple) {
                PropertyDefinitionSimple newPDS = (PropertyDefinitionSimple)newProperty;
                List existingOptions = existingPDS.getEnumeratedValues();
                List newOptions = newPDS.getEnumeratedValues();
                List toPersist = this.missingInFirstList(existingOptions, newOptions);
                List toDelete = this.missingInFirstList(newOptions, existingOptions);
                List changed = this.intersection(existingOptions, newOptions);
                for (PropertyDefinitionEnumeration pde : toDelete) {
                    existingOptions.remove(pde);
                    this.entityManager.remove((Object)pde);
                }
                for (PropertyDefinitionEnumeration pde : toPersist) {
                    existingPDS.addEnumeratedValues(new PropertyDefinitionEnumeration[]{pde});
                    this.entityManager.persist((Object)pde);
                }
                for (PropertyDefinitionEnumeration pde : changed) {
                    for (PropertyDefinitionEnumeration nPde : newOptions) {
                        if (!nPde.equals((Object)pde)) continue;
                        pde.setDefault(nPde.isDefault());
                        pde.setOrderIndex(nPde.getOrderIndex());
                        pde.setValue(nPde.getValue());
                        this.entityManager.merge((Object)pde);
                    }
                }
                this.entityManager.flush();
                Set exCon = existingPDS.getConstraints();
                if (exCon.size() > 0) {
                    for (Constraint con : exCon) {
                        con.setPropertyDefinitionSimple(null);
                        this.entityManager.remove((Object)con);
                    }
                    existingPDS.getConstraints().clear();
                }
                for (Constraint con : newPDS.getConstraints()) {
                    existingPDS.addConstraints(new Constraint[]{con});
                }
                existingPDS.setDefaultValue(newPDS.getDefaultValue());
            } else {
                this.replaceProperty(existingProperty, newProperty);
            }
        }
    }

    private void replaceProperty(PropertyDefinition existingProperty, PropertyDefinition newProperty) {
        newProperty.setId(existingProperty.getId());
        newProperty.setConfigurationDefinition(existingProperty.getConfigurationDefinition());
        existingProperty.getConfigurationDefinition().getPropertyDefinitions().remove(existingProperty.getName());
        existingProperty.setConfigurationDefinition(null);
        this.entityManager.remove((Object)existingProperty);
        this.entityManager.merge((Object)newProperty);
        this.entityManager.flush();
    }

    private <T> List<T> missingInFirstList(List<T> first, List<T> reference) {
        ArrayList<T> result = new ArrayList<T>();
        if (reference != null) {
            if (first == null) {
                result.addAll(reference);
                return result;
            }
            for (T item : reference) {
                if (first.contains(item)) continue;
                result.add(item);
            }
        }
        return result;
    }

    private <T> List<T> intersection(List<T> first, List<T> second) {
        ArrayList<T> result = new ArrayList<T>();
        if (first != null && second != null) {
            result.addAll(first);
            result.retainAll(second);
        }
        return result;
    }
}

