/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc.bundle;

import org.rhq.enterprise.server.plugin.pc.ServerPluginComponent;
import org.rhq.enterprise.server.plugin.pc.ServerPluginEnvironment;
import org.rhq.enterprise.server.plugin.pc.ServerPluginManager;
import org.rhq.enterprise.server.plugin.pc.bundle.BundleServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.bundle.BundleServerPluginFacet;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.bundle.BundlePluginDescriptorType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.bundle.BundleType;

public class BundleServerPluginManager
extends ServerPluginManager {
    public BundleServerPluginManager(BundleServerPluginContainer pc) {
        super(pc);
    }

    public void initialize() throws Exception {
        super.initialize();
    }

    protected void loadPlugin(ServerPluginEnvironment env, boolean enabled) throws Exception {
        if (enabled) {
            BundlePluginDescriptorType descriptor = (BundlePluginDescriptorType)env.getPluginDescriptor();
            BundleType bt = descriptor.getBundle();
            if (bt == null || bt.getType() == null || bt.getType().length() == 0) {
                throw new Exception("The bundle plugin [" + env.getPluginKey().getPluginName() + "] did not specify a valid bundle type in its descriptor");
            }
            ServerPluginComponent component = this.createServerPluginComponent(env);
            if (!(component instanceof BundleServerPluginFacet)) {
                throw new Exception("The bundle plugin [" + env.getPluginKey().getPluginName() + "] has an invalid component [" + component + "]. It does not implement [" + BundleServerPluginFacet.class + "]");
            }
        }
        super.loadPlugin(env, enabled);
    }

    public BundleServerPluginFacet getBundleServerPluginFacet(String bundleTypeName) {
        if (bundleTypeName == null) {
            throw new IllegalArgumentException("bundleTypeName == null");
        }
        for (ServerPluginEnvironment env : this.getPluginEnvironments()) {
            BundlePluginDescriptorType descriptor = (BundlePluginDescriptorType)env.getPluginDescriptor();
            if (!bundleTypeName.equals(descriptor.getBundle().getType())) continue;
            ServerPluginComponent component = this.getServerPluginComponent(env.getPluginKey().getPluginName());
            return (BundleServerPluginFacet)((Object)component);
        }
        return null;
    }
}

