/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.registration;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReleaseRepoMapping {
    private final Log log = LogFactory.getLog((String)ReleaseRepoMapping.class.getName());
    private String release;
    private String arch;
    private String version;

    public ReleaseRepoMapping(String release, String version, String arch) {
        this.release = release;
        this.arch = arch;
        this.version = version;
    }

    public String getCompatibleRepo() {
        HashMap<String, String> repomap = this.generateRepoMap();
        this.log.debug((Object)("mapping generated " + repomap));
        return repomap.get(this.release + "." + this.arch);
    }

    private HashMap<String, String> generateRepoMap() {
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("5Server.arch", "rhel-arch-server-5");
        hm.put("5Client.arch", "rhel-arch-client-5");
        String[] arches = new String[]{"i386", "x86_64", "ia64", "s390x", "ppc"};
        HashMap<String, String> newhm = new HashMap<String, String>();
        for (String k : hm.keySet()) {
            for (String arch : arches) {
                newhm.put(k.replace("arch", arch), ((String)hm.get(k)).replace("arch", arch));
            }
        }
        return newhm;
    }
}

