/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.scheduler.jobs;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.InterruptableJob;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;
import org.quartz.UnableToInterruptJobException;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.content.Repo;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class RepoSyncJob
implements StatefulJob,
InterruptableJob {
    public static final String KEY_REPO_NAME = "repoName";
    private final Log log = LogFactory.getLog(this.getClass());
    private Thread executionThread;
    private static ThreadLocal<Boolean> interruptMonitor = new ThreadLocal();

    public void execute(JobExecutionContext context) throws JobExecutionException {
        this.executionThread = Thread.currentThread();
        try {
            JobDetail jobDetail = context.getJobDetail();
            if (jobDetail == null) {
                throw new IllegalStateException("The job does not have any details");
            }
            JobDataMap dataMap = jobDetail.getJobDataMap();
            if (dataMap == null) {
                throw new IllegalStateException("The job does not have any data in its details");
            }
            String repoName = dataMap.getString(KEY_REPO_NAME);
            if (repoName == null) {
                throw new IllegalStateException("Missing repo name in details context");
            }
            this.sync(repoName);
        }
        catch (InterruptedException ie) {
            this.log.error((Object)("Cancelled job [" + context.getJobDetail() + "]"));
        }
        catch (Exception e) {
            String errorMsg = "Failed to sync repo in job [" + context.getJobDetail() + "]";
            this.log.error((Object)errorMsg, (Throwable)e);
            JobExecutionException jobExecutionException = new JobExecutionException(errorMsg, (Throwable)e, false);
            if (!(e instanceof IllegalStateException)) {
                jobExecutionException.setUnscheduleAllTriggers(false);
            }
            throw jobExecutionException;
        }
    }

    public static JobDataMap createJobDataMap(JobDetail details, Repo repo) {
        JobDataMap dataMap = details != null ? details.getJobDataMap() : new JobDataMap();
        dataMap.put(KEY_REPO_NAME, repo.getName());
        return dataMap;
    }

    public static String createJobName(Repo repo) {
        String jobName = Integer.toHexString(repo.getName().hashCode());
        if (jobName.length() > 80) {
            throw new IllegalArgumentException("Job names max size is 80 chars due to DB column size restrictions: " + jobName);
        }
        return jobName;
    }

    public static String createUniqueJobName(Repo repo) {
        String jobName = RepoSyncJob.createJobName(repo);
        String uniquifier = Long.toHexString(System.currentTimeMillis());
        if ((jobName = jobName + "-" + uniquifier).length() > 80) {
            throw new IllegalArgumentException("Job names max size is 80 chars due to DB column size restrictions: " + jobName);
        }
        return jobName;
    }

    private void sync(String repoName) throws InterruptedException {
        SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
        RepoManagerLocal repoManager = LookupUtil.getRepoManagerLocal();
        Subject overlord = subjectManager.getOverlord();
        List<Repo> repoList = repoManager.getRepoByName(repoName);
        if (repoList.size() != 1) {
            throw new RuntimeException("Unexpected number of repos found for name [" + repoName + "]. " + "Found [" + repoList.size() + "] repos");
        }
        Repo repoToSync = repoList.get(0);
        repoManager.internalSynchronizeRepos(overlord, new Integer[]{repoToSync.getId()});
    }

    public void interrupt() throws UnableToInterruptJobException {
        if (this.executionThread == null) {
            this.log.error((Object)"execution thread is null, cant interrupt", (Throwable)new IllegalStateException());
        } else {
            this.log.debug((Object)("exeThread : [" + this.executionThread.getName() + "]"));
            this.executionThread.interrupt();
        }
    }
}

