/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.search.assist;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.search.SearchSubsystem;
import org.rhq.enterprise.server.search.assist.AbstractSearchAssistant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceSearchAssistant
extends AbstractSearchAssistant {
    private static final List<String> parameterizedContexts = Collections.unmodifiableList(Arrays.asList("connection", "configuration", "trait"));
    private static final List<String> simpleContexts = Collections.unmodifiableList(Arrays.asList("availability", "category", "type", "plugin", "name"));

    @Override
    public SearchSubsystem getSearchSubsystem() {
        return SearchSubsystem.Resource;
    }

    @Override
    public List<String> getSimpleContexts() {
        return simpleContexts;
    }

    @Override
    public List<String> getParameterizedContexts() {
        return parameterizedContexts;
    }

    @Override
    public List<String> getParameters(String context, String filter) {
        if (context.equals("connection")) {
            return this.execute("SELECT DISTINCT definition.name   FROM ResourceType type   JOIN type.pluginConfigurationDefinition.propertyDefinitions definition " + this.add(" WHERE LOWER(definition.name) LIKE '%" + filter.toLowerCase() + "%'", filter) + "ORDER BY definition.name ");
        }
        if (context.equals("configuration")) {
            return this.execute("SELECT DISTINCT definition.name   FROM ResourceType type   JOIN type.resourceConfigurationDefinition.propertyDefinitions definition " + this.add(" WHERE LOWER(definition.name) LIKE '%" + filter.toLowerCase() + "%'", filter) + "ORDER BY definition.name ");
        }
        if (context.equals("trait")) {
            return this.execute("SELECT DISTINCT definition.name   FROM MeasurementDefinition definition  WHERE definition.dataType = 1 " + this.add("   AND LOWER(definition.name) LIKE '%" + filter.toLowerCase() + "%'", filter) + "ORDER BY definition.name ");
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getValues(String context, String param, String filter) {
        if (context.equals("availability")) {
            return this.filter(AvailabilityType.class, filter);
        }
        if (context.equals("category")) {
            return this.filter(ResourceCategory.class, filter);
        }
        if (context.equals("type")) {
            return this.execute("SELECT DISTINCT type.name   FROM ResourceType type " + this.add(" WHERE LOWER(type.name) LIKE '%" + filter.toLowerCase() + "%'", filter) + "ORDER BY type.name ");
        }
        if (context.equals("plugin")) {
            return this.execute("SELECT DISTINCT type.plugin   FROM ResourceType type " + this.add(" WHERE LOWER(type.plugin) LIKE '%" + filter.toLowerCase() + "%'", filter) + "ORDER BY type.plugin ");
        }
        if (context.equals("name")) {
            return this.execute("SELECT DISTINCT res.name   FROM Resource res " + this.add(" WHERE LOWER(res.name) LIKE '%" + filter.toLowerCase() + "%'", filter) + "ORDER BY res.name ");
        }
        if (context.equals("connection")) {
            return this.execute("SELECT DISTINCT simple.stringValue   FROM Resource res, PropertySimple simple   JOIN res.pluginConfiguration.properties property  WHERE simple.id = property.id    AND property.name = '" + param + "'" + this.add("   AND LOWER(property.stringValue) LIKE '%" + filter.toLowerCase() + "%'", filter) + "ORDER BY simple.stringValue ");
        }
        if (context.equals("configuration")) {
            return this.execute("SELECT DISTINCT simple.stringValue   FROM Resource res, PropertySimple simple   JOIN res.resourceConfiguration.properties property  WHERE simple.id = property.id    AND property.name = '" + param + "'" + this.add("   AND LOWER(property.stringValue) LIKE '%" + filter.toLowerCase() + "%'", filter) + "ORDER BY simple.stringValue ");
        }
        if (context.equals("trait")) {
            return this.execute("SELECT trait.value   FROM MeasurementDataTrait trait  WHERE trait.schedule.definition.dataType = 1    AND trait.schedule.definition.name = '" + param + "'" + this.add("   AND LOWER(trait.value) LIKE '%" + filter.toLowerCase() + "%'", filter) + "ORDER BY trait.value ");
        }
        return Collections.emptyList();
    }
}

