/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.search.execution;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.search.SearchSubsystem;
import org.rhq.enterprise.server.search.assist.ResourceSearchAssistant;
import org.rhq.enterprise.server.search.assist.SearchAssistant;
import org.rhq.enterprise.server.search.execution.SearchSuggestion;
import org.rhq.enterprise.server.util.HibernatePerformanceMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchAssistManager {
    private static final Log LOG = LogFactory.getLog(SearchAssistManager.class);
    private static List<String> comparisonOperators = Arrays.asList("!==", "!=", "==", "=");
    private static List<String> booleanOperators = Arrays.asList("and", "or");
    private SearchAssistant completor;

    public SearchAssistManager(SearchSubsystem searchSubsystem) {
        this.completor = this.getAutoCompletor(searchSubsystem);
    }

    protected SearchAssistant getAutoCompletor(SearchSubsystem searchSubsystem) {
        if (searchSubsystem == SearchSubsystem.Resource) {
            return new ResourceSearchAssistant();
        }
        throw new IllegalArgumentException("No SearchAssistant found for SearchSubsystem[" + searchSubsystem + "]");
    }

    public List<String> getAllContexts() {
        ArrayList<String> results = new ArrayList<String>(this.completor.getSimpleContexts());
        for (String parameterized : this.completor.getParameterizedContexts()) {
            results.add(parameterized + "[");
        }
        return results;
    }

    public List<SearchSuggestion> getAdvancedSuggestions(String expression, int caretPos) {
        this.debug("getAdvancedSuggestions: START");
        long id = HibernatePerformanceMonitor.get().start();
        SearchTermAssistant assistant = new SearchTermAssistant(expression, caretPos);
        HibernatePerformanceMonitor.get().stop(id, "SearchAssistant");
        String[] tokens = assistant.getTerms().toArray(new String[0]);
        this.debug("" + tokens.length + " tokens are " + Arrays.asList(tokens));
        if (tokens.length == 0) {
            this.debug("getAdvancedSuggestions: no terms");
            return this.convert(this.getAllContexts());
        }
        String beforeCaret = assistant.getFragmentBeforeCaret();
        this.debug("getAdvancedSuggestions: beforeCaret is '" + beforeCaret + "'");
        ParsedContext parsed = ParsedContext.get(beforeCaret);
        this.debug("getAdvancedSuggestions: parsed is " + parsed);
        switch (parsed.state) {
            case CONTEXT: {
                if (parsed.context.equals("")) {
                    if (tokens.length == 1) {
                        this.debug("getAdvancedSuggestions: no terms yet, suggesting contexts");
                        return this.convert(this.getAllContexts());
                    }
                    if (this.isBooleanTerm(assistant.getPreviousToken())) {
                        this.debug("getAdvancedSuggestions: previous term was boolean, suggesting contexts");
                        return this.convert(this.getAllContexts());
                    }
                    this.debug("getAdvancedSuggestions: previous term was not boolean, suggesting boolean");
                    return this.convert(booleanOperators);
                }
                if (this.isBooleanTerm(parsed.context)) {
                    this.debug("getAdvancedSuggestions: beforeCaret is whole boolean operator");
                    return this.convert(this.getAllContexts());
                }
                if (this.completor.getSimpleContexts().contains(parsed.context)) {
                    this.debug("getAdvancedSuggestions: search term is simple context, wants operator");
                    return this.convert(this.pad(parsed.context, comparisonOperators, ""));
                }
                if (this.completor.getParameterizedContexts().contains(parsed.context)) {
                    this.debug("getAdvancedSuggestions: search term is parameterized context, wants open bracket");
                    return this.convert(Arrays.asList(parsed.context + "["));
                }
                this.debug("getAdvancedSuggestions: search term wants context completion");
                ArrayList<String> startsWithContexts = new ArrayList<String>();
                for (String context : this.completor.getSimpleContexts()) {
                    if (context.indexOf(parsed.context) == -1) continue;
                    startsWithContexts.add(context);
                }
                for (String context : this.completor.getParameterizedContexts()) {
                    if (context.indexOf(parsed.context) == -1) continue;
                    startsWithContexts.add(context + "[");
                }
                return this.convert(startsWithContexts);
            }
            case PARAM: {
                this.debug("getAdvancedSuggestions: param state");
                return this.convert(this.pad(parsed.context + "[", this.completor.getParameters(parsed.context, parsed.param), "]"));
            }
            case OPERATOR: {
                this.debug("getAdvancedSuggestions: operator state");
                if (comparisonOperators.contains(parsed.operator)) {
                    this.debug("search term is complete operator, suggesting values instead");
                    List<String> valueSuggestions = this.pad("\"", this.completor.getValues(parsed.context, parsed.param, ""), "\"");
                    if (this.completor.getSimpleContexts().contains(parsed.context)) {
                        this.debug("getAdvancedSuggestions: suggesting value completions for a simple context");
                        return this.convert(this.pad(parsed.context + parsed.operator, valueSuggestions, ""));
                    }
                    this.debug("getAdvancedSuggestions: suggesting value completions for a parameterized context");
                    return this.convert(this.pad(parsed.context + "[" + parsed.param + "]" + parsed.operator, valueSuggestions, ""));
                }
                ArrayList<String> operatorSuggestions = new ArrayList<String>();
                for (String op : comparisonOperators) {
                    if (!op.startsWith(parsed.operator)) continue;
                    operatorSuggestions.add(op);
                }
                this.debug("getAdvancedSuggestions: providing suggestions for comparison operators");
                if (this.completor.getSimpleContexts().contains(parsed.context)) {
                    return this.convert(this.pad(parsed.context, operatorSuggestions, ""));
                }
                return this.convert(this.pad(parsed.context + "[" + parsed.param + "]", operatorSuggestions, ""));
            }
            case VALUE: {
                this.debug("getAdvancedSuggestions: value state");
                List<String> valueSuggestions = this.pad("\"", this.completor.getValues(parsed.context, parsed.param, parsed.value), "\"");
                if (this.completor.getSimpleContexts().contains(parsed.context)) {
                    this.debug("getAdvancedSuggestions: suggesting value completions for a simple context");
                    return this.convert(this.pad(parsed.context + parsed.operator, valueSuggestions, ""));
                }
                this.debug("getAdvancedSuggestions: suggesting value completions for a parameterized context");
                return this.convert(this.pad(parsed.context + "[" + parsed.param + "]" + parsed.operator, valueSuggestions, ""));
            }
        }
        return Collections.emptyList();
    }

    private boolean isBooleanTerm(String term) {
        for (String op : booleanOperators) {
            if (!op.equals(term)) continue;
            return true;
        }
        return false;
    }

    private List<SearchSuggestion> convert(List<String> suggestions) {
        ArrayList<SearchSuggestion> results = new ArrayList<SearchSuggestion>(suggestions.size());
        for (String suggestion : suggestions) {
            results.add(new SearchSuggestion(SearchSuggestion.SearchCategory.Advanced, suggestion));
        }
        return results;
    }

    private List<String> pad(String leftPad, List<String> data, String rightPad) {
        ArrayList<String> results = new ArrayList<String>();
        for (String next : data) {
            results.add(leftPad + next + rightPad);
        }
        return results;
    }

    private void debug(String message) {
        LOG.info((Object)message);
    }

    static class ParsedContext {
        public final String context;
        public final String param;
        public final String operator;
        public final String value;
        public final State state;

        private ParsedContext(String context, String param, String operator, String value) {
            this.context = context;
            this.param = param;
            this.operator = operator;
            this.value = value;
            this.state = this.computeState(context, param, operator, value);
        }

        private State computeState(String context, String param, String operator, String value) {
            if (value != null) {
                return State.VALUE;
            }
            if (operator != null) {
                return State.OPERATOR;
            }
            if (param != null) {
                return State.PARAM;
            }
            return State.CONTEXT;
        }

        public static ParsedContext get(String term) {
            int index;
            char[] expr = term.toCharArray();
            StringBuilder buffer = new StringBuilder();
            for (index = 0; index < expr.length && expr[index] != '[' && expr[index] != '!' && expr[index] != '='; ++index) {
                buffer.append(expr[index]);
            }
            String context = buffer.toString();
            buffer = new StringBuilder();
            if (index == expr.length || expr[index] != '[' && expr[index] != '!' && expr[index] != '=') {
                return new ParsedContext(context, null, null, null);
            }
            String param = null;
            if (expr[index] == '[') {
                ++index;
                while (index < expr.length && expr[index] != ']') {
                    buffer.append(expr[index]);
                    ++index;
                }
                param = buffer.toString();
                buffer = new StringBuilder();
                if (index == expr.length || expr[index] != ']') {
                    return new ParsedContext(context, param, null, null);
                }
                ++index;
            }
            while (index < expr.length && (expr[index] == '!' || expr[index] == '=')) {
                buffer.append(expr[index]);
                ++index;
            }
            String operator = buffer.toString();
            if (index == expr.length) {
                return new ParsedContext(context, param, operator, null);
            }
            String value = term.substring(index);
            if (value.length() > 0 && (value.charAt(0) == '\'' || value.charAt(0) == '\"')) {
                value = value.substring(1);
            }
            return new ParsedContext(context, param, operator, value);
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.getClass().getSimpleName()).append("[");
            buffer.append("state=").append((Object)this.state);
            buffer.append(", context(").append(this.context);
            buffer.append("), param(").append(this.param);
            buffer.append("), operator(").append(this.operator);
            buffer.append("), value(").append(this.value).append(")]");
            return buffer.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum State {
            CONTEXT,
            PARAM,
            OPERATOR,
            VALUE;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SearchTermAssistant {
        private static final String CARET = "@@@";
        String expression;
        List<String> terms;
        int currentTermIndex;
        int indexWithinTerm;

        public SearchTermAssistant(String expression, int caretPos) {
            String before = expression.substring(0, caretPos);
            String after = expression.substring(caretPos);
            this.expression = before + CARET + after;
            this.tokenize();
            for (int i = 0; i < this.terms.size(); ++i) {
                String term = this.terms.get(i);
                int index = term.indexOf(CARET);
                if (index == -1) continue;
                String replaced = term.replace(CARET, "");
                this.terms.set(i, replaced);
                this.currentTermIndex = i;
                this.indexWithinTerm = index;
                break;
            }
        }

        private void tokenize() {
            List<String> fragments = this.tokenizeIntoFragments(this.expression);
            this.terms = this.joinIntoTerms(fragments);
        }

        private List<String> tokenizeIntoFragments(String expression) {
            ArrayList<String> fragments = new ArrayList<String>();
            char quoteChar = '\u0000';
            StringBuilder term = new StringBuilder();
            for (char nextChar : expression.toCharArray()) {
                if (quoteChar != '\u0000') {
                    term.append(nextChar);
                    if (nextChar != quoteChar) continue;
                    quoteChar = '\u0000';
                    continue;
                }
                if (Character.isWhitespace(nextChar)) {
                    if (term.length() <= 0) continue;
                    fragments.add(term.toString());
                    term = new StringBuilder();
                    continue;
                }
                if (nextChar == '(' || nextChar == ')') continue;
                term.append(nextChar);
                if (nextChar != '\'' && nextChar != '\"') continue;
                quoteChar = nextChar;
            }
            if (term.length() > 0) {
                fragments.add(term.toString());
            }
            return fragments;
        }

        private List<String> joinIntoTerms(List<String> fragments) {
            if (fragments.size() < 3) {
                return fragments;
            }
            ArrayList<String> terms = new ArrayList<String>();
            int i = 1;
            while (i < fragments.size() - 1) {
                String before = fragments.get(i - 1);
                String term = fragments.get(i);
                if (comparisonOperators.contains(term)) {
                    String after = fragments.get(i + 1);
                    terms.add(before + term + after);
                    i += 3;
                    continue;
                }
                terms.add(before);
                ++i;
            }
            if (i < fragments.size()) {
                String nextToLast = fragments.get(fragments.size() - 2);
                String last = fragments.get(fragments.size() - 1);
                if (comparisonOperators.contains(last)) {
                    terms.add(nextToLast + last);
                } else {
                    terms.add(nextToLast);
                    terms.add(last);
                }
            } else if (i == fragments.size()) {
                String last = fragments.get(fragments.size() - 1);
                terms.add(last);
            }
            return terms;
        }

        public List<String> getTerms() {
            return this.terms;
        }

        public String getPreviousToken() {
            return this.terms.get(this.currentTermIndex - 1);
        }

        public String getCurrentToken() {
            return this.terms.get(this.currentTermIndex);
        }

        public String getFragmentBeforeCaret() {
            return this.getCurrentToken().substring(0, this.indexWithinTerm);
        }

        public void report(PrintStream output) {
            output.println("Expression: " + this.expression);
            List<String> fragments = this.tokenizeIntoFragments(this.expression);
            List<String> terms = this.joinIntoTerms(fragments);
            int counter = 0;
            for (String result : terms) {
                output.println("Token[" + ++counter + "]: " + result);
            }
            output.println();
        }

        public String toString() {
            return null;
        }
    }
}

