/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.search.execution;

public class SearchSuggestion {
    private final SearchCategory category;
    private final String value;
    private final String label;
    private final int startIndex;
    private final int endIndex;

    public SearchSuggestion(SearchCategory category, String value) {
        this(category, value, 0, 0);
    }

    public SearchSuggestion(SearchCategory category, String value, int startIndex, int length) {
        this.category = category;
        this.label = value;
        this.value = value;
        this.startIndex = startIndex;
        this.endIndex = startIndex + length;
    }

    public SearchCategory getCategory() {
        return this.category;
    }

    public String getLabel() {
        return this.label;
    }

    public String getValue() {
        return this.value;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public String toString() {
        String before = this.label.substring(0, this.startIndex);
        String highlight = this.label.substring(this.startIndex, this.endIndex);
        String after = this.label.substring(this.endIndex);
        return before + "(" + highlight + ")" + after + "->" + this.value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchCategory {
        Simple,
        Advanced,
        SavedSearch,
        InstructionalTextComment,
        Unknown;

    }
}

