/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.search.translation;

import org.rhq.enterprise.server.search.translation.SearchTranslator;
import org.rhq.enterprise.server.search.translation.antlr.RHQLComparisonOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSearchTranslator
implements SearchTranslator {
    protected String getJPQLForString(String fragment, RHQLComparisonOperator operator, String value) {
        if (operator == RHQLComparisonOperator.EQUALS) {
            return this.lower(fragment) + " LIKE '%" + value.toLowerCase() + "%'";
        }
        if (operator == RHQLComparisonOperator.EQUALS_STRICT) {
            return fragment + " LIKE '%" + value + "%'";
        }
        if (operator == RHQLComparisonOperator.NOT_EQUALS) {
            return this.lower(fragment) + " LIKE '%" + value.toLowerCase() + "%'";
        }
        if (operator == RHQLComparisonOperator.NOT_EQUALS_STRICT) {
            return fragment + " LIKE '%" + value + "%'";
        }
        if (operator == RHQLComparisonOperator.NULL) {
            return fragment + " IS NULL";
        }
        if (operator == RHQLComparisonOperator.NOT_NULL) {
            return fragment + " IS NOT NULL";
        }
        throw new IllegalArgumentException("Unsupported operator " + (Object)((Object)operator));
    }

    protected String getJPQLForEnum(String fragment, RHQLComparisonOperator operator, String value, Class<? extends Enum<?>> enumClass, boolean useOrdinal) {
        if (operator == RHQLComparisonOperator.EQUALS) {
            return fragment + " = " + this.getEnum(enumClass, value, useOrdinal);
        }
        if (operator == RHQLComparisonOperator.EQUALS_STRICT) {
            return fragment + " = " + this.getEnum(enumClass, value, useOrdinal);
        }
        if (operator == RHQLComparisonOperator.NOT_EQUALS) {
            return fragment + " != " + this.getEnum(enumClass, value, useOrdinal);
        }
        if (operator == RHQLComparisonOperator.NOT_EQUALS_STRICT) {
            return fragment + " != " + this.getEnum(enumClass, value, useOrdinal);
        }
        if (operator == RHQLComparisonOperator.NULL) {
            return fragment + " IS NULL";
        }
        if (operator == RHQLComparisonOperator.NOT_NULL) {
            return fragment + " IS NOT NULL";
        }
        throw new IllegalArgumentException("Unsupported operator " + (Object)((Object)operator));
    }

    protected String getEnum(Class<? extends Enum<?>> enumClass, String value, boolean useOrdinal) {
        for (Enum<?> nextEnum : enumClass.getEnumConstants()) {
            if (!nextEnum.name().toLowerCase().equals(value.toLowerCase())) continue;
            if (useOrdinal) {
                return String.valueOf(nextEnum.ordinal());
            }
            return nextEnum.name();
        }
        throw new IllegalArgumentException("No enum of type '" + enumClass.getSimpleName() + "' with name matching '" + value + "'");
    }

    protected String lower(String data) {
        return "LOWER(" + data + ")";
    }

    protected String quote(String data) {
        return "'" + data + "'";
    }
}

