/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.metadata.ConfigurationMetadataParser;
import org.rhq.core.clientapi.descriptor.configuration.ConfigurationDescriptor;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.AlertDefinitionContext;
import org.rhq.core.domain.alert.notification.AlertNotification;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.plugin.PluginKey;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.alert.AlertNotificationManagerLocal;
import org.rhq.enterprise.server.alert.AlertTemplateManagerLocal;
import org.rhq.enterprise.server.alert.GroupAlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.InvalidAlertDefinitionException;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.plugin.ServerPluginsLocal;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSenderInfo;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSenderPluginManager;
import org.rhq.enterprise.server.plugin.pc.alert.CustomAlertSenderBackingBean;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.alert.AlertPluginDescriptorType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class AlertNotificationManagerBean
implements AlertNotificationManagerLocal {
    private static final Log LOG = LogFactory.getLog(AlertNotificationManagerBean.class);
    @EJB
    private AlertDefinitionManagerLocal alertDefinitionManager;
    @EJB
    private AlertTemplateManagerLocal alertTemplateManager;
    @EJB
    private AlertManagerLocal alertManager;
    @EJB
    private GroupAlertDefinitionManagerLocal groupAlertDefintionManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private ServerPluginsLocal serverPluginsBean;
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;

    private AlertDefinition getDetachedAlertDefinition(int alertDefinitionId) {
        AlertDefinition alertDefinition = this.alertDefinitionManager.getAlertDefinitionById(this.subjectManager.getOverlord(), alertDefinitionId);
        this.checkPermission(this.subjectManager.getOverlord(), alertDefinition);
        AlertDefinitionContext context = alertDefinition.getContext();
        if (context == AlertDefinitionContext.Resource) {
            return alertDefinition;
        }
        AlertDefinition detachedDefinition = new AlertDefinition(alertDefinition, true);
        detachedDefinition.setContext(context);
        detachedDefinition.setId(alertDefinition.getId());
        return detachedDefinition;
    }

    private void checkPermission(Subject subject, AlertDefinition alertDefinition) {
        boolean hasPermission = false;
        hasPermission = alertDefinition.getResourceType() != null ? this.authorizationManager.hasGlobalPermission(subject, Permission.MANAGE_SETTINGS) : (alertDefinition.getResourceGroup() != null ? this.authorizationManager.hasGroupPermission(subject, Permission.MANAGE_ALERTS, alertDefinition.getResourceGroup().getId()) : this.authorizationManager.hasResourcePermission(subject, Permission.MANAGE_ALERTS, alertDefinition.getResource().getId()));
        if (!hasPermission) {
            throw new PermissionException(subject + " is not authorized to edit this alert definition");
        }
    }

    @Override
    public int removeNotifications(Subject subject, Integer alertDefinitionId, Integer[] notificationIds) {
        AlertDefinition alertDefinition = this.getDetachedAlertDefinition(alertDefinitionId);
        if (notificationIds == null || notificationIds.length == 0) {
            return 0;
        }
        HashSet<Integer> notificationIdSet = new HashSet<Integer>(Arrays.asList(notificationIds));
        List notifications = alertDefinition.getAlertNotifications();
        ArrayList<AlertNotification> toBeRemoved = new ArrayList<AlertNotification>();
        int removed = 0;
        for (AlertNotification notification : notifications) {
            if (!notificationIdSet.contains(notification.getId())) continue;
            toBeRemoved.add(notification);
            --removed;
        }
        for (AlertNotification notification : toBeRemoved) {
            CustomAlertSenderBackingBean bb = this.getBackingBeanForSender(notification.getSenderName(), notification.getId());
            try {
                bb.internalCleanup();
            }
            catch (Throwable t) {
                LOG.error((Object)("removeNotifications, calling backingBean.internalCleanup() resulted in " + t.getMessage()), t);
            }
        }
        alertDefinition.getAlertNotifications().removeAll(toBeRemoved);
        this.postProcessAlertDefinition(alertDefinition);
        return removed;
    }

    @Override
    public int purgeOrphanedAlertNotifications() {
        Query purgeQuery = this.entityManager.createNamedQuery("AlertNotification.deleteOrphaned");
        return purgeQuery.executeUpdate();
    }

    private void postProcessAlertDefinition(AlertDefinition definition) {
        AlertDefinitionContext context = definition.getContext();
        if (context == AlertDefinitionContext.Type) {
            try {
                this.alertTemplateManager.updateAlertTemplate(this.subjectManager.getOverlord(), definition, true);
            }
            catch (InvalidAlertDefinitionException iade) {
                LOG.error((Object)("Can not update alert template, invalid definition: " + definition));
            }
        } else if (context == AlertDefinitionContext.Group) {
            try {
                this.groupAlertDefintionManager.updateGroupAlertDefinitions(this.subjectManager.getOverlord(), definition, true);
            }
            catch (InvalidAlertDefinitionException iade) {
                LOG.error((Object)("Can not update alert template, invalid definition: " + definition));
            }
        }
    }

    @Override
    public Configuration getAlertPropertiesConfiguration(AlertNotification notification) {
        Configuration config = notification.getConfiguration();
        if (config != null) {
            config = config.deepCopy();
        }
        return config;
    }

    @Override
    public ConfigurationDefinition getConfigurationDefinitionForSender(String shortName) {
        AlertSenderPluginManager pluginmanager = this.alertManager.getAlertPluginManager();
        AlertSenderInfo senderInfo = pluginmanager.getAlertSenderInfo(shortName);
        String pluginName = senderInfo.getPluginName();
        PluginKey key = senderInfo.getPluginKey();
        try {
            AlertPluginDescriptorType descriptor = (AlertPluginDescriptorType)this.serverPluginsBean.getServerPluginDescriptor(key);
            ConfigurationDefinition pluginConfigurationDefinition = ConfigurationMetadataParser.parse((String)("alerts:" + pluginName), (ConfigurationDescriptor)descriptor.getAlertConfiguration());
            return pluginConfigurationDefinition;
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Override
    public List<String> listAllAlertSenders() {
        AlertSenderPluginManager pluginmanager = this.alertManager.getAlertPluginManager();
        List<String> senders = pluginmanager.getPluginList();
        return senders;
    }

    @Override
    public AlertSenderInfo getAlertInfoForSender(String shortName) {
        AlertSenderPluginManager pluginmanager = this.alertManager.getAlertPluginManager();
        AlertSenderInfo info = pluginmanager.getAlertSenderInfo(shortName);
        return info;
    }

    @Override
    public CustomAlertSenderBackingBean getBackingBeanForSender(String shortName, Integer alertNotificationId) {
        AlertNotification notification;
        AlertSenderPluginManager pluginmanager = this.alertManager.getAlertPluginManager();
        CustomAlertSenderBackingBean bean = pluginmanager.getBackingBeanForSender(shortName);
        if (alertNotificationId != null && (notification = (AlertNotification)this.entityManager.find(AlertNotification.class, (Object)alertNotificationId)) != null && bean != null) {
            Configuration config = notification.getConfiguration();
            Configuration config2 = config.deepCopy(true);
            bean.setAlertParameters(config2);
            try {
                bean.internalInit();
            }
            catch (Throwable t) {
                LOG.error((Object)("getBackingBean, calling backingBean.internalInit() resulted in " + t.getMessage()));
            }
        }
        return bean;
    }

    @Override
    public String getBackingBeanNameForSender(String shortName) {
        AlertSenderPluginManager pluginmanager = this.alertManager.getAlertPluginManager();
        return pluginmanager.getBackingBeanNameForSender(shortName);
    }

    @Override
    public AlertNotification addAlertNotification(Subject user, int alertDefinitionId, String senderName, Configuration configuration) {
        AlertDefinition definition = this.alertDefinitionManager.getAlertDefinition(user, alertDefinitionId);
        if (definition == null) {
            LOG.error((Object)("Did not find definition for id [" + alertDefinitionId + "]"));
            return null;
        }
        this.entityManager.persist((Object)configuration);
        AlertNotification notif = new AlertNotification(definition);
        notif.setSenderName(senderName);
        notif.setConfiguration(configuration);
        this.entityManager.persist((Object)notif);
        definition.getAlertNotifications().add(notif);
        return notif;
    }

    @Override
    public List<AlertNotification> getNotificationsForAlertDefinition(Subject user, int alertDefinitionId) {
        AlertDefinition definition = this.alertDefinitionManager.getAlertDefinition(user, alertDefinitionId);
        if (definition == null) {
            LOG.error((Object)("Did not find definition for id [" + alertDefinitionId + "]"));
            return new ArrayList<AlertNotification>();
        }
        List notifications = definition.getAlertNotifications();
        for (AlertNotification notification : notifications) {
            notification.getConfiguration().getProperties().size();
        }
        return notifications;
    }

    @Override
    public void updateAlertNotification(AlertNotification notification) {
        notification = (AlertNotification)this.entityManager.merge((Object)notification);
        this.entityManager.persist((Object)notification);
        this.entityManager.flush();
    }

    @Override
    public AlertNotification getAlertNotification(Subject user, int alertNotificationId) {
        AlertNotification notification = (AlertNotification)this.entityManager.find(AlertNotification.class, (Object)alertNotificationId);
        if (notification == null) {
            return null;
        }
        if (notification.getConfiguration() != null) {
            notification.getConfiguration().getProperties().size();
        }
        return notification;
    }
}

