/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert;

import java.util.Collection;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.server.PersistenceUtility;
import org.rhq.enterprise.server.alert.AlertDefinitionCreationException;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.AlertDefinitionUpdateException;
import org.rhq.enterprise.server.alert.AlertTemplateManagerLocal;
import org.rhq.enterprise.server.alert.InvalidAlertDefinitionException;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class AlertTemplateManagerBean
implements AlertTemplateManagerLocal {
    private static final Log LOG = LogFactory.getLog(AlertTemplateManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    private AlertDefinitionManagerLocal alertDefinitionManager;
    @EJB
    private AlertTemplateManagerLocal alertTemplateManager;
    @EJB
    private ResourceTypeManagerLocal resourceTypeManager;
    @EJB
    private SubjectManagerLocal subjectManager;

    @Override
    public PageList<AlertDefinition> getAlertTemplates(Subject user, int resourceTypeId, PageControl pageControl) {
        pageControl.initDefaultOrderingField("ctime", PageOrdering.DESC);
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"AlertDefinition.findByResourceType");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"AlertDefinition.findByResourceType", (PageControl)pageControl);
        queryCount.setParameter("typeId", (Object)resourceTypeId);
        query.setParameter("typeId", (Object)resourceTypeId);
        long totalCount = (Long)queryCount.getSingleResult();
        List list = query.getResultList();
        return new PageList((Collection)list, (int)totalCount, pageControl);
    }

    private List<Integer> getChildrenAlertDefinitionIds(Subject user, int alertTemplateId) {
        Query query = this.entityManager.createNamedQuery("AlertDefinition.findByAlertTemplateId");
        query.setParameter("alertTemplateId", (Object)alertTemplateId);
        List list = query.getResultList();
        return list;
    }

    private List<Integer> getCommittedResourceIdsNeedingTemplateApplication(Subject user, int alertTemplateId, int resourceTypeId) {
        Query query = this.entityManager.createNamedQuery("AlertDefinition.findResourceIdsNeedingTemplateApplication");
        query.setParameter("alertTemplateId", (Object)alertTemplateId);
        query.setParameter("resourceTypeId", (Object)resourceTypeId);
        query.setParameter("inventoryStatus", (Object)InventoryStatus.COMMITTED);
        List list = query.getResultList();
        return list;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public int createAlertTemplate(Subject user, AlertDefinition alertTemplate, Integer resourceTypeId) throws InvalidAlertDefinitionException, ResourceTypeNotFoundException {
        ResourceType type = this.resourceTypeManager.getResourceTypeById(user, resourceTypeId);
        alertTemplate.setResourceType(type);
        int alertTemplateId = this.alertDefinitionManager.createAlertDefinition(user, alertTemplate, null);
        int definitionCount = 0;
        Subject overlord = this.subjectManager.getOverlord();
        List<Integer> resourceIdsForType = this.getCommittedResourceIdsNeedingTemplateApplication(user, alertTemplateId, resourceTypeId);
        for (Integer resourceId : resourceIdsForType) {
            try {
                this.updateAlertDefinitionsForResource(overlord, alertTemplate, resourceId);
                if (++definitionCount % 250 != 0) continue;
                this.entityManager.flush();
                this.entityManager.clear();
            }
            catch (AlertDefinitionCreationException adce) {
                LOG.error((Object)adce);
            }
        }
        return alertTemplateId;
    }

    @Override
    public void updateAlertDefinitionsForResource(Subject user, Integer resourceId) throws AlertDefinitionCreationException, InvalidAlertDefinitionException {
        if (0 == resourceId) {
            throw new AlertDefinitionCreationException("Unexpected resourceId = 0");
        }
        if (!this.authorizationManager.isOverlord(user)) {
            throw new AlertDefinitionCreationException("Updating the alert definitions for a resource is an implicit system operation and must only be performed by the overlord");
        }
        Query query = this.entityManager.createQuery(" SELECT template    FROM AlertDefinition template, Resource res   WHERE template.resourceType.id = res.resourceType.id     AND res.id = :resourceId     AND template.deleted = false     AND template.id NOT IN ( SELECT ad.id                                FROM AlertDefinition ad                               WHERE ad.resource.id = :resourceId                                 AND ad.deleted = false ) ");
        query.setParameter("resourceId", (Object)resourceId);
        List unappliedTemplates = query.getResultList();
        for (AlertDefinition template : unappliedTemplates) {
            this.alertTemplateManager.updateAlertDefinitionsForResource(user, template, resourceId);
        }
    }

    @Override
    public void updateAlertDefinitionsForResource(Subject user, AlertDefinition alertTemplate, Integer resourceId) throws AlertDefinitionCreationException, InvalidAlertDefinitionException {
        if (!this.authorizationManager.isOverlord(user)) {
            throw new AlertDefinitionCreationException("Updating the alert definitions for a resource is an implicit system operation and must only be performed by the overlord");
        }
        AlertDefinition childAlertDefinition = new AlertDefinition(alertTemplate);
        childAlertDefinition.setParentId(Integer.valueOf(alertTemplate.getId()));
        this.alertDefinitionManager.createAlertDefinition(user, childAlertDefinition, resourceId);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void removeAlertTemplates(Subject user, Integer[] alertTemplateIds) {
        Subject overlord = this.subjectManager.getOverlord();
        for (Integer alertTemplateId : alertTemplateIds) {
            List<Integer> alertDefinitions = this.getChildrenAlertDefinitionIds(user, alertTemplateId);
            this.alertDefinitionManager.removeAlertDefinitions(user, new Integer[]{alertTemplateId});
            this.alertDefinitionManager.removeAlertDefinitions(overlord, alertDefinitions.toArray(new Integer[alertDefinitions.size()]));
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void enableAlertTemplates(Subject user, Integer[] alertTemplateIds) {
        Subject overlord = this.subjectManager.getOverlord();
        for (Integer alertTemplateId : alertTemplateIds) {
            List<Integer> alertDefinitions = this.getChildrenAlertDefinitionIds(user, alertTemplateId);
            this.alertDefinitionManager.enableAlertDefinitions(user, new Integer[]{alertTemplateId});
            this.alertDefinitionManager.enableAlertDefinitions(overlord, alertDefinitions.toArray(new Integer[alertDefinitions.size()]));
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void disableAlertTemplates(Subject user, Integer[] alertTemplateIds) {
        Subject overlord = this.subjectManager.getOverlord();
        for (Integer alertTemplateId : alertTemplateIds) {
            List<Integer> alertDefinitions = this.getChildrenAlertDefinitionIds(user, alertTemplateId);
            this.alertDefinitionManager.disableAlertDefinitions(user, new Integer[]{alertTemplateId});
            this.alertDefinitionManager.disableAlertDefinitions(overlord, alertDefinitions.toArray(new Integer[alertDefinitions.size()]));
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public AlertDefinition updateAlertTemplate(Subject user, AlertDefinition alertTemplate, boolean purgeInternals) throws InvalidAlertDefinitionException {
        AlertDefinition updatedTemplate = null;
        try {
            updatedTemplate = this.alertDefinitionManager.updateAlertDefinition(user, alertTemplate.getId(), alertTemplate, purgeInternals);
        }
        catch (AlertDefinitionUpdateException adue) {
            LOG.error((Object)("Attempt to update a deleted template " + alertTemplate.toSimpleString()));
        }
        Subject overlord = this.subjectManager.getOverlord();
        int definitionCount = 0;
        List<Integer> alertDefinitions = this.getChildrenAlertDefinitionIds(overlord, alertTemplate.getId());
        for (Integer alertDefinitionId : alertDefinitions) {
            try {
                this.alertDefinitionManager.updateAlertDefinition(overlord, alertDefinitionId, alertTemplate, purgeInternals);
            }
            catch (AlertDefinitionUpdateException adue) {
                LOG.error((Object)("Attempt to update a deleted template " + alertTemplate.toSimpleString()));
            }
            if (++definitionCount % 250 != 0) continue;
            this.entityManager.flush();
            this.entityManager.clear();
        }
        List<Integer> resourceIds = this.getCommittedResourceIdsNeedingTemplateApplication(overlord, alertTemplate.getId(), this.getResourceTypeIdAlertTemplateId(alertTemplate.getId()));
        try {
            for (Integer resourceId : resourceIds) {
                this.updateAlertDefinitionsForResource(overlord, alertTemplate, resourceId);
                if (++definitionCount % 250 != 0) continue;
                this.entityManager.flush();
                this.entityManager.clear();
            }
        }
        catch (AlertDefinitionCreationException adce) {
            LOG.error((Object)adce);
        }
        return updatedTemplate;
    }

    private int getResourceTypeIdAlertTemplateId(int alertTemplateId) {
        Query query = this.entityManager.createQuery("SELECT template.resourceType.id   FROM AlertDefinition template  WHERE template.id = :alertTemplateId");
        query.setParameter("alertTemplateId", (Object)alertTemplateId);
        int typeId = ((Number)query.getSingleResult()).intValue();
        return typeId;
    }
}

