/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.authz;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.ejb.Stateless;
import javax.interceptor.ExcludeDefaultInterceptors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExcludeDefaultInterceptors
@Stateless
public class AuthorizationManagerBean
implements AuthorizationManagerLocal {
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;

    @Override
    public Set<Permission> getExplicitGlobalPermissions(Subject subject) {
        this.entityManager.flush();
        Query query = this.entityManager.createNamedQuery("Subject.getGlobalPermissions");
        query.setParameter("subject", (Object)subject);
        List results = query.getResultList();
        EnumSet<Permission> permissions = EnumSet.noneOf(Permission.class);
        for (Permission permission : results) {
            if (permission.getTarget() != Permission.Target.GLOBAL) continue;
            permissions.add(permission);
        }
        return permissions;
    }

    @Override
    public Set<Permission> getExplicitGroupPermissions(Subject subject, int groupId) {
        Query query = this.entityManager.createNamedQuery("Subject.getPermissionsByGroup");
        query.setParameter("subject", (Object)subject);
        query.setParameter("groupId", (Object)groupId);
        List results = query.getResultList();
        EnumSet<Permission> permissions = EnumSet.noneOf(Permission.class);
        for (Permission permission : results) {
            permissions.add(permission);
        }
        return permissions;
    }

    @Override
    public Set<Permission> getImplicitGroupPermissions(Subject subject, int groupId) {
        EnumSet permissions = this.isInventoryManager(subject) ? Permission.RESOURCE_ALL : this.getExplicitGroupPermissions(subject, groupId);
        return permissions;
    }

    @Override
    public Set<Permission> getExplicitResourcePermissions(Subject subject, int resourceId) {
        Query query = this.entityManager.createNamedQuery("Subject.getPermissionsByResource");
        query.setParameter("subject", (Object)subject);
        query.setParameter("resourceId", (Object)resourceId);
        List results = query.getResultList();
        EnumSet<Permission> permissions = EnumSet.noneOf(Permission.class);
        for (Permission permission : results) {
            permissions.add(permission);
        }
        return permissions;
    }

    @Override
    public Set<Permission> getImplicitResourcePermissions(Subject subject, int resourceId) {
        EnumSet permissions = this.isInventoryManager(subject) ? Permission.RESOURCE_ALL : this.getExplicitResourcePermissions(subject, resourceId);
        return permissions;
    }

    @Override
    public boolean hasGlobalPermission(Subject subject, Permission permission) {
        if (this.isOverlord(subject)) {
            return true;
        }
        Query query = this.entityManager.createNamedQuery("Subject.hasGlobalPermission");
        query.setParameter("subject", (Object)subject);
        query.setParameter("permission", (Object)permission);
        long count = (Long)query.getSingleResult();
        return count != 0L;
    }

    @Override
    public boolean hasGroupPermission(Subject subject, Permission permission, int groupId) {
        if (this.isInventoryManager(subject)) {
            return true;
        }
        Query query = this.entityManager.createNamedQuery("Subject.hasGroupPermission");
        query.setParameter("subject", (Object)subject);
        query.setParameter("permission", (Object)permission);
        query.setParameter("groupId", (Object)groupId);
        long count = (Long)query.getSingleResult();
        return count != 0L;
    }

    @Override
    public boolean hasResourcePermission(Subject subject, Permission permission, int resourceId) {
        if (this.isInventoryManager(subject)) {
            return true;
        }
        Query query = this.entityManager.createNamedQuery("Subject.hasResourcePermission");
        query.setParameter("subject", (Object)subject);
        query.setParameter("permission", (Object)permission);
        query.setParameter("resourceId", (Object)resourceId);
        long count = (Long)query.getSingleResult();
        return count != 0L;
    }

    @Override
    public boolean canViewResource(Subject subject, int resourceId) {
        if (this.isInventoryManager(subject)) {
            return true;
        }
        Query query = this.entityManager.createNamedQuery("Subject.canViewResource");
        query.setParameter("subject", (Object)subject);
        query.setParameter("resourceId", (Object)resourceId);
        long count = (Long)query.getSingleResult();
        return count != 0L;
    }

    @Override
    public boolean canViewResources(Subject subject, List<Integer> resourceIds) {
        if (this.isInventoryManager(subject)) {
            return true;
        }
        Query query = this.entityManager.createNamedQuery("Subject.canViewResources");
        query.setParameter("subject", (Object)subject);
        query.setParameter("resourceIds", resourceIds);
        long count = (Long)query.getSingleResult();
        return count == (long)resourceIds.size();
    }

    @Override
    public boolean canViewGroup(Subject subject, int groupId) {
        if (this.isInventoryManager(subject)) {
            return true;
        }
        Query query = this.entityManager.createNamedQuery("Subject.canViewGroup");
        query.setParameter("subject", (Object)subject);
        query.setParameter("groupId", (Object)groupId);
        long count = (Long)query.getSingleResult();
        return count != 0L;
    }

    @Override
    public boolean isInventoryManager(Subject subject) {
        return this.hasGlobalPermission(subject, Permission.MANAGE_INVENTORY);
    }

    @Override
    public boolean hasResourcePermission(Subject subject, Permission permission, Collection<Integer> resourceIds) {
        if (this.isInventoryManager(subject)) {
            return true;
        }
        Query query = this.entityManager.createNamedQuery("Subject.getResourcesByPermission");
        query.setParameter("subject", (Object)subject);
        query.setParameter("permission", (Object)permission);
        List results = query.getResultList();
        return results.containsAll(resourceIds);
    }

    @Override
    public boolean isSystemSuperuser(Subject subject) {
        if (subject == null) {
            return false;
        }
        return subject.getId() == 1 || subject.getId() == 2;
    }

    @Override
    public boolean isOverlord(Subject subject) {
        if (subject == null) {
            return false;
        }
        return subject.getId() == 1;
    }
}

