/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.bundle;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.rhq.core.clientapi.agent.bundle.BundleAgentService;
import org.rhq.core.clientapi.agent.bundle.BundleScheduleRequest;
import org.rhq.core.clientapi.agent.bundle.BundleScheduleResponse;
import org.rhq.core.clientapi.agent.configuration.ConfigurationUtility;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.bundle.Bundle;
import org.rhq.core.domain.bundle.BundleDeployment;
import org.rhq.core.domain.bundle.BundleDeploymentAction;
import org.rhq.core.domain.bundle.BundleDeploymentStatus;
import org.rhq.core.domain.bundle.BundleFile;
import org.rhq.core.domain.bundle.BundleGroupDeployment;
import org.rhq.core.domain.bundle.BundleResourceDeployment;
import org.rhq.core.domain.bundle.BundleResourceDeploymentHistory;
import org.rhq.core.domain.bundle.BundleType;
import org.rhq.core.domain.bundle.BundleVersion;
import org.rhq.core.domain.bundle.composite.BundleWithLatestVersionComposite;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.content.Architecture;
import org.rhq.core.domain.content.Package;
import org.rhq.core.domain.content.PackageCategory;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.criteria.BundleCriteria;
import org.rhq.core.domain.criteria.BundleDeploymentCriteria;
import org.rhq.core.domain.criteria.BundleFileCriteria;
import org.rhq.core.domain.criteria.BundleResourceDeploymentCriteria;
import org.rhq.core.domain.criteria.BundleVersionCriteria;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.StringUtils;
import org.rhq.core.util.NumberUtil;
import org.rhq.enterprise.server.agentclient.AgentClient;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.bundle.BundleManagerHelper;
import org.rhq.enterprise.server.bundle.BundleManagerLocal;
import org.rhq.enterprise.server.bundle.BundleManagerRemote;
import org.rhq.enterprise.server.bundle.RecipeParseResults;
import org.rhq.enterprise.server.content.ContentManagerLocal;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaQueryRunner;
import org.rhq.enterprise.server.util.HibernateDetachUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class BundleManagerBean
implements BundleManagerLocal,
BundleManagerRemote {
    private final Log log = LogFactory.getLog(this.getClass());
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private AgentManagerLocal agentManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    private BundleManagerLocal bundleManager;
    @EJB
    private ContentManagerLocal contentManager;
    @EJB
    private RepoManagerLocal repoManager;

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public BundleResourceDeploymentHistory addBundleResourceDeploymentHistory(Subject subject, int bundleDeploymentId, BundleResourceDeploymentHistory history) throws Exception {
        BundleResourceDeployment resourceDeployment = (BundleResourceDeployment)this.entityManager.find(BundleResourceDeployment.class, (Object)bundleDeploymentId);
        if (null == resourceDeployment) {
            throw new IllegalArgumentException("Invalid bundleDeploymentId: " + bundleDeploymentId);
        }
        resourceDeployment.addBundleResourceDeploymentHistory(history);
        this.entityManager.persist((Object)resourceDeployment);
        return history;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public Bundle createBundle(Subject subject, String name, String description, int bundleTypeId) throws Exception {
        if (null == name || "".equals(name.trim())) {
            throw new IllegalArgumentException("Invalid bundleName: " + name);
        }
        BundleType bundleType = (BundleType)this.entityManager.find(BundleType.class, (Object)bundleTypeId);
        if (null == bundleType) {
            throw new IllegalArgumentException("Invalid bundleTypeId: " + bundleTypeId);
        }
        Repo repo = new Repo(name);
        repo.setCandidate(false);
        repo.setSyncSchedule(null);
        repo = this.repoManager.createRepo(subject, repo);
        ResourceType resourceType = (ResourceType)this.entityManager.find(ResourceType.class, (Object)bundleType.getResourceType().getId());
        PackageType packageType = new PackageType(name, resourceType);
        packageType.setDescription("Package type for content of bundle " + name);
        packageType.setCategory(PackageCategory.BUNDLE);
        packageType.setSupportsArchitecture(false);
        packageType.setDisplayName(StringUtils.deCamelCase((String)name));
        packageType.setDiscoveryInterval(-1L);
        packageType.setCreationData(false);
        packageType.setDeploymentConfigurationDefinition(null);
        Bundle bundle = new Bundle(name, bundleType, repo, packageType);
        bundle.setDescription(description);
        bundle.setPackageType(packageType);
        this.log.info((Object)("Creating bundle: " + bundle));
        this.entityManager.persist((Object)bundle);
        return bundle;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public BundleDeployment createBundleDeployment(Subject subject, int bundleVersionId, String name, String description, String installDir, Configuration configuration) throws Exception {
        if (null == name || "".equals(name.trim())) {
            throw new IllegalArgumentException("Invalid bundleDeploymentName: " + name);
        }
        BundleVersion bundleVersion = (BundleVersion)this.entityManager.find(BundleVersion.class, (Object)bundleVersionId);
        if (null == bundleVersion) {
            throw new IllegalArgumentException("Invalid bundleVersionId: " + bundleVersionId);
        }
        ConfigurationDefinition configDef = bundleVersion.getConfigurationDefinition();
        if (null != configDef) {
            if (null == configuration) {
                throw new IllegalArgumentException("Missing Configuration. Configuration is required when the specified BundleVersion defines Configuration Properties.");
            }
            List errors = ConfigurationUtility.validateConfiguration((Configuration)configuration, (ConfigurationDefinition)configDef);
            if (null != errors && !errors.isEmpty()) {
                throw new IllegalArgumentException("Invalid Configuration: " + errors.toString());
            }
        }
        BundleDeployment deployment = new BundleDeployment(bundleVersion, name, installDir);
        deployment.setDescription(description);
        deployment.setConfiguration(configuration);
        this.entityManager.persist((Object)deployment);
        return deployment;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public BundleType createBundleType(Subject subject, String name, int resourceTypeId) throws Exception {
        if (null == name || "".equals(name.trim())) {
            throw new IllegalArgumentException("Invalid bundleTypeName: " + name);
        }
        ResourceType resourceType = (ResourceType)this.entityManager.find(ResourceType.class, (Object)resourceTypeId);
        if (null == resourceType) {
            throw new IllegalArgumentException("Invalid resourceeTypeId: " + resourceTypeId);
        }
        BundleType bundleType = new BundleType(name, resourceType);
        this.entityManager.persist((Object)bundleType);
        return bundleType;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public BundleVersion createBundleAndBundleVersion(Subject subject, String bundleName, String bundleDescription, int bundleTypeId, String bundleVersionName, String bundleVersionDescription, String version, String recipe) throws Exception {
        BundleCriteria criteria = new BundleCriteria();
        criteria.addFilterBundleTypeId(Integer.valueOf(bundleTypeId));
        criteria.addFilterName(bundleName);
        PageList<Bundle> bundles = this.findBundlesByCriteria(subject, criteria);
        Bundle bundle = bundles.getTotalSize() == 0 ? this.createBundle(subject, bundleName, bundleDescription, bundleTypeId) : (Bundle)bundles.get(0);
        BundleVersion bv = this.createBundleVersion(subject, bundle.getId(), bundleVersionName, bundleVersionDescription, version, recipe);
        return bv;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public BundleVersion createBundleVersion(Subject subject, int bundleId, String name, String description, String version, String recipe) throws Exception {
        RecipeParseResults results;
        if (null == name || "".equals(name.trim())) {
            throw new IllegalArgumentException("Invalid bundleVersionName: " + name);
        }
        Bundle bundle = (Bundle)this.entityManager.find(Bundle.class, (Object)bundleId);
        if (null == bundle) {
            throw new IllegalArgumentException("Invalid bundleId: " + bundleId);
        }
        BundleType bundleType = bundle.getBundleType();
        try {
            results = BundleManagerHelper.getPluginContainer().getBundleServerPluginManager().parseRecipe(bundleType.getName(), recipe);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse recipe", e);
        }
        version = this.getVersion(version, bundle);
        ComparableVersion comparableVersion = new ComparableVersion(version);
        Query q = this.entityManager.createNamedQuery("BundleVersion.findVersionsByBundleId");
        q.setParameter("bundleId", (Object)bundle.getId());
        List list = q.getResultList();
        int versionOrder = list.size();
        boolean needToUpdateOrder = false;
        for (Object[] bv : list) {
            ComparableVersion bvv = new ComparableVersion(bv[0].toString());
            int comparision = comparableVersion.compareTo((Object)bvv);
            if (comparision == 0) {
                throw new RuntimeException("Cannot create bundle with version [" + version + "], it already exists");
            }
            if (comparision >= 0) break;
            versionOrder = ((Number)bv[1]).intValue();
            needToUpdateOrder = true;
        }
        if (needToUpdateOrder) {
            this.entityManager.flush();
            q = this.entityManager.createNamedQuery("BundleVersion.updateVersionOrderByBundleId");
            q.setParameter("bundleId", (Object)bundle.getId());
            q.setParameter("versionOrder", (Object)versionOrder);
            q.executeUpdate();
            this.entityManager.flush();
            this.entityManager.clear();
        }
        BundleVersion bundleVersion = new BundleVersion(name, version, bundle, recipe);
        bundleVersion.setVersionOrder(versionOrder);
        bundleVersion.setDescription(description);
        bundleVersion.setConfigurationDefinition(results.getConfigurationDefinition());
        this.entityManager.persist((Object)bundleVersion);
        return bundleVersion;
    }

    private String getVersion(String version, Bundle bundle) {
        if (null != version && version.trim().length() > 0) {
            return version;
        }
        BundleVersion latestBundleVersion = null;
        Query q = this.entityManager.createNamedQuery("BundleVersion.findLatestByBundleId");
        q.setParameter("bundleId", (Object)bundle.getId());
        List list = q.getResultList();
        if (list.size() > 0) {
            if (list.size() == 1) {
                latestBundleVersion = (BundleVersion)list.get(0);
            } else {
                throw new RuntimeException("Bundle [" + bundle.getName() + "] (id=" + bundle.getId() + ") has more than 1 'latest' version. This should not happen - aborting");
            }
        }
        String latestVersion = latestBundleVersion != null ? latestBundleVersion.getVersion() : null;
        String newVersion = NumberUtil.autoIncrementVersion((String)latestVersion);
        return newVersion;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public BundleFile addBundleFile(Subject subject, int bundleVersionId, String name, String version, Architecture architecture, InputStream fileStream) throws Exception {
        if (null == name || "".equals(name.trim())) {
            throw new IllegalArgumentException("Invalid bundleFileName: " + name);
        }
        if (null == version || "".equals(version.trim())) {
            throw new IllegalArgumentException("Invalid bundleFileVersion: " + version);
        }
        if (null == fileStream) {
            throw new IllegalArgumentException("Invalid fileStream: " + null);
        }
        BundleVersion bundleVersion = (BundleVersion)this.entityManager.find(BundleVersion.class, (Object)bundleVersionId);
        if (null == bundleVersion) {
            throw new IllegalArgumentException("Invalid bundleVersionId: " + bundleVersionId);
        }
        Bundle bundle = bundleVersion.getBundle();
        PackageType packageType = bundle.getPackageType();
        Architecture architecture2 = architecture = null == architecture ? this.contentManager.getNoArchitecture() : architecture;
        if (architecture.getId() == 0) {
            Query q = this.entityManager.createNamedQuery("Architecture.findByName");
            q.setParameter("name", (Object)architecture.getName());
            architecture = (Architecture)q.getSingleResult();
        }
        PackageVersion packageVersion = this.contentManager.createPackageVersion(name, packageType.getId(), version, architecture.getId(), fileStream);
        packageVersion.setFileName(name);
        packageVersion = (PackageVersion)this.entityManager.merge((Object)packageVersion);
        Repo repo = bundle.getRepo();
        this.repoManager.addPackageVersionsToRepo(subject, repo.getId(), new int[]{packageVersion.getId()});
        Package generalPackage = packageVersion.getGeneralPackage();
        generalPackage.setClassification(bundle.getName());
        BundleFile bundleFile = new BundleFile();
        bundleFile.setBundleVersion(bundleVersion);
        bundleFile.setPackageVersion(packageVersion);
        this.entityManager.persist((Object)bundleFile);
        return bundleFile;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public BundleFile addBundleFileViaByteArray(Subject subject, int bundleVersionId, String name, String version, Architecture architecture, byte[] fileBytes) throws Exception {
        return this.addBundleFile(subject, bundleVersionId, name, version, architecture, new ByteArrayInputStream(fileBytes));
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public BundleFile addBundleFileViaURL(Subject subject, int bundleVersionId, String name, String version, Architecture architecture, URL url) throws Exception {
        return this.addBundleFile(subject, bundleVersionId, name, version, architecture, url.openStream());
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public BundleFile addBundleFileViaPackageVersion(Subject subject, int bundleVersionId, String name, int packageVersionId) throws Exception {
        if (null == name || "".equals(name.trim())) {
            throw new IllegalArgumentException("Invalid bundleFileName: " + name);
        }
        BundleVersion bundleVersion = (BundleVersion)this.entityManager.find(BundleVersion.class, (Object)bundleVersionId);
        if (null == bundleVersion) {
            throw new IllegalArgumentException("Invalid bundleVersionId: " + bundleVersionId);
        }
        PackageVersion packageVersion = (PackageVersion)this.entityManager.find(PackageVersion.class, (Object)packageVersionId);
        if (null == packageVersion) {
            throw new IllegalArgumentException("Invalid packageVersionId: " + packageVersionId);
        }
        BundleFile bundleFile = new BundleFile();
        bundleFile.setBundleVersion(bundleVersion);
        bundleFile.setPackageVersion(packageVersion);
        this.entityManager.persist((Object)bundleFile);
        return bundleFile;
    }

    @Override
    public BundleResourceDeployment scheduleBundleResourceDeployment(Subject subject, int bundleDeploymentId, int resourceId) throws Exception {
        BundleDeployment deployment = (BundleDeployment)this.entityManager.find(BundleDeployment.class, (Object)bundleDeploymentId);
        if (null == deployment) {
            throw new IllegalArgumentException("Invalid bundleDeploymentId: " + bundleDeploymentId);
        }
        Resource resource = (Resource)this.entityManager.find(Resource.class, (Object)resourceId);
        if (null == resource) {
            throw new IllegalArgumentException("Invalid resourceId (Resource does not exist): " + resourceId);
        }
        return this.scheduleBundleResourceDeployment(subject, deployment, resource, null);
    }

    private BundleResourceDeployment scheduleBundleResourceDeployment(Subject subject, BundleDeployment deployment, Resource resource, BundleGroupDeployment groupDeployment) throws Exception {
        int resourceId = resource.getId();
        AgentClient agentClient = this.agentManager.getAgentClient(resourceId);
        BundleAgentService bundleAgentService = agentClient.getBundleAgentService();
        BundleResourceDeployment resourceDeployment = this.bundleManager.createBundleResourceDeployment(subject, deployment.getId(), resourceId, null == groupDeployment ? 0 : groupDeployment.getId());
        BundleVersion bundleVersion = (BundleVersion)this.entityManager.find(BundleVersion.class, (Object)deployment.getBundleVersion().getId());
        Configuration config = (Configuration)this.entityManager.find(Configuration.class, (Object)deployment.getConfiguration().getId());
        Bundle bundle = (Bundle)this.entityManager.find(Bundle.class, (Object)bundleVersion.getBundle().getId());
        BundleType bundleType = (BundleType)this.entityManager.find(BundleType.class, (Object)bundle.getBundleType().getId());
        ResourceType resourceType = (ResourceType)this.entityManager.find(ResourceType.class, (Object)bundleType.getResourceType().getId());
        bundleType.setResourceType(resourceType);
        bundle.setBundleType(bundleType);
        bundleVersion.setBundle(bundle);
        deployment.setBundleVersion(bundleVersion);
        deployment.setConfiguration(config);
        resourceDeployment.setBundleDeployment(deployment);
        resourceDeployment.setResource(resource);
        HibernateDetachUtility.nullOutUninitializedFields((Object)resourceDeployment, (HibernateDetachUtility.SerializationType)HibernateDetachUtility.SerializationType.SERIALIZATION);
        BundleScheduleRequest request = new BundleScheduleRequest(resourceDeployment);
        BundleResourceDeploymentHistory history = new BundleResourceDeploymentHistory(subject.getName(), BundleDeploymentAction.DEPLOYMENT_REQUESTED, BundleDeploymentStatus.SUCCESS, "Requested deployment time: " + request.getRequestedDeployTimeAsString());
        this.bundleManager.addBundleResourceDeploymentHistory(subject, resourceDeployment.getId(), history);
        BundleScheduleResponse response = bundleAgentService.schedule(request);
        this.entityManager.clear();
        if (!response.isSuccess()) {
            history = new BundleResourceDeploymentHistory(subject.getName(), BundleDeploymentAction.DEPLOYMENT, BundleDeploymentStatus.FAILURE, response.getErrorMessage());
            this.bundleManager.setBundleResourceDeploymentStatus(subject, resourceDeployment.getId(), BundleDeploymentStatus.FAILURE);
            this.bundleManager.addBundleResourceDeploymentHistory(subject, resourceDeployment.getId(), history);
        }
        return resourceDeployment;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public BundleGroupDeployment scheduleBundleGroupDeployment(Subject subject, int bundleDeploymentId, int resourceGroupId) throws Exception {
        BundleDeployment deployment = (BundleDeployment)this.entityManager.find(BundleDeployment.class, (Object)bundleDeploymentId);
        if (null == deployment) {
            throw new IllegalArgumentException("Invalid bundleDeploymentId: " + bundleDeploymentId);
        }
        ResourceGroup resourceGroup = (ResourceGroup)this.entityManager.find(ResourceGroup.class, (Object)resourceGroupId);
        if (null == resourceGroup) {
            throw new IllegalArgumentException("Invalid resourceGroupId (ResourceGroup does not exist): " + resourceGroupId);
        }
        BundleGroupDeployment groupDeployment = new BundleGroupDeployment(subject.getName(), deployment, resourceGroup);
        groupDeployment = this.bundleManager.createBundleGroupDeployment(groupDeployment);
        for (Resource resource : resourceGroup.getExplicitResources()) {
            BundleResourceDeployment resourceDeployment = this.scheduleBundleResourceDeployment(subject, deployment, resource, groupDeployment);
            groupDeployment.addResourceDeployment(resourceDeployment);
        }
        return groupDeployment;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public BundleResourceDeployment createBundleResourceDeployment(Subject subject, int bundleDeploymentId, int resourceId, int groupDeploymentId) throws Exception {
        BundleDeployment deployment = (BundleDeployment)this.entityManager.find(BundleDeployment.class, (Object)bundleDeploymentId);
        if (null == deployment) {
            throw new IllegalArgumentException("Invalid bundleDeploymentId: " + bundleDeploymentId);
        }
        Resource resource = (Resource)this.entityManager.find(Resource.class, (Object)resourceId);
        if (null == resource) {
            throw new IllegalArgumentException("Invalid resourceId (Resource does not exist): " + resourceId);
        }
        BundleGroupDeployment groupDeployment = (BundleGroupDeployment)this.entityManager.find(BundleGroupDeployment.class, (Object)groupDeploymentId);
        BundleResourceDeployment resourceDeployment = new BundleResourceDeployment(deployment, resource, groupDeployment);
        this.entityManager.persist((Object)resourceDeployment);
        return resourceDeployment;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public BundleResourceDeployment setBundleResourceDeploymentStatus(Subject subject, int resourceDeploymentId, BundleDeploymentStatus status) throws Exception {
        BundleResourceDeployment resourceDeployment = (BundleResourceDeployment)this.entityManager.find(BundleResourceDeployment.class, (Object)resourceDeploymentId);
        if (null == resourceDeployment) {
            throw new IllegalArgumentException("Invalid bundleDeploymentId: " + resourceDeploymentId);
        }
        resourceDeployment.setStatus(status);
        this.entityManager.persist((Object)resourceDeployment);
        BundleGroupDeployment groupDeployment = resourceDeployment.getGroupDeployment();
        if (null != groupDeployment && BundleDeploymentStatus.INPROGRESS.equals((Object)groupDeployment.getStatus())) {
            if (BundleDeploymentStatus.FAILURE.equals((Object)status)) {
                groupDeployment.setStatus(status);
            } else {
                BundleResourceDeploymentCriteria c = new BundleResourceDeploymentCriteria();
                c.addFilterGroupDeploymentId(Integer.valueOf(groupDeployment.getId()));
                c.addFilterStatus(BundleDeploymentStatus.INPROGRESS);
                PageList<BundleResourceDeployment> inProgressDeployments = this.findBundleResourceDeploymentsByCriteria(subject, c);
                if (inProgressDeployments.isEmpty()) {
                    groupDeployment.setStatus(BundleDeploymentStatus.SUCCESS);
                }
            }
        }
        return resourceDeployment;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public BundleGroupDeployment createBundleGroupDeployment(BundleGroupDeployment groupDeployment) throws Exception {
        this.entityManager.persist((Object)groupDeployment);
        return groupDeployment;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public Set<String> getBundleVersionFilenames(Subject subject, int bundleVersionId, boolean withoutBundleFileOnly) throws Exception {
        BundleVersion bundleVersion = (BundleVersion)this.entityManager.find(BundleVersion.class, (Object)bundleVersionId);
        if (null == bundleVersion) {
            throw new IllegalArgumentException("Invalid bundleVersionId: " + bundleVersionId);
        }
        BundleType bundleType = bundleVersion.getBundle().getBundleType();
        RecipeParseResults parseResults = BundleManagerHelper.getPluginContainer().getBundleServerPluginManager().parseRecipe(bundleType.getName(), bundleVersion.getRecipe());
        Set<String> result = parseResults.getBundleFileNames();
        if (withoutBundleFileOnly) {
            List bundleFiles = bundleVersion.getBundleFiles();
            Set<String> allFilenames = result;
            result = new HashSet<String>(allFilenames.size() - bundleFiles.size());
            for (String filename : allFilenames) {
                boolean found = false;
                for (BundleFile bundleFile : bundleFiles) {
                    String name = bundleFile.getPackageVersion().getGeneralPackage().getName();
                    if (!name.equals(filename)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                result.add(filename);
            }
        }
        return result;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public HashMap<String, Boolean> getAllBundleVersionFilenames(Subject subject, int bundleVersionId) throws Exception {
        BundleVersion bundleVersion = (BundleVersion)this.entityManager.find(BundleVersion.class, (Object)bundleVersionId);
        if (null == bundleVersion) {
            throw new IllegalArgumentException("Invalid bundleVersionId: " + bundleVersionId);
        }
        BundleType bundleType = bundleVersion.getBundle().getBundleType();
        RecipeParseResults parseResults = BundleManagerHelper.getPluginContainer().getBundleServerPluginManager().parseRecipe(bundleType.getName(), bundleVersion.getRecipe());
        Set<String> filenames = parseResults.getBundleFileNames();
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(filenames.size());
        List bundleFiles = bundleVersion.getBundleFiles();
        for (String filename : filenames) {
            boolean found = false;
            for (BundleFile bundleFile : bundleFiles) {
                String name = bundleFile.getPackageVersion().getGeneralPackage().getName();
                if (!name.equals(filename)) continue;
                found = true;
                break;
            }
            result.put(filename, found);
        }
        return result;
    }

    @Override
    public List<BundleType> getAllBundleTypes(Subject subject) {
        Query q = this.entityManager.createNamedQuery("BundleType.findAll");
        List types = q.getResultList();
        return types;
    }

    @Override
    public PageList<BundleDeployment> findBundleDeploymentsByCriteria(Subject subject, BundleDeploymentCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator((Criteria)criteria);
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }

    @Override
    public PageList<BundleResourceDeployment> findBundleResourceDeploymentsByCriteria(Subject subject, BundleResourceDeploymentCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator((Criteria)criteria);
        if (!this.authorizationManager.isInventoryManager(subject)) {
            if (criteria.isInventoryManagerRequired()) {
                throw new PermissionException("Subject [" + subject.getName() + "] requires InventoryManager permission for requested query criteria.");
            }
            generator.setAuthorizationResourceFragment(CriteriaQueryGenerator.AuthorizationTokenType.RESOURCE, null, subject.getId());
        }
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }

    @Override
    public PageList<BundleVersion> findBundleVersionsByCriteria(Subject subject, BundleVersionCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator((Criteria)criteria);
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }

    @Override
    public PageList<BundleFile> findBundleFilesByCriteria(Subject subject, BundleFileCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator((Criteria)criteria);
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }

    @Override
    public PageList<Bundle> findBundlesByCriteria(Subject subject, BundleCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator((Criteria)criteria);
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }

    @Override
    public PageList<BundleWithLatestVersionComposite> findBundlesWithLastestVersionCompositesByCriteria(Subject subject, BundleCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator((Criteria)criteria);
        String replacementSelectList = " new org.rhq.core.domain.bundle.composite.BundleWithLatestVersionComposite(    bundle.id,   bundle.name,   bundle.description,   ( SELECT bv1.version FROM bundle.bundleVersions bv1 WHERE bv1.versionOrder = (SELECT MAX(bv2.versionOrder) FROM BundleVersion bv2 WHERE bv2.bundle.id = bundle.id) ) AS latestVersion,   ( SELECT COUNT(bv3) FROM bundle.bundleVersions bv3 WHERE bv3.bundle.id = bundle.id) AS deploymentCount ) ";
        generator.alterProjection(replacementSelectList);
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        PageList results = queryRunner.execute();
        return results;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void deleteBundle(Subject subject, int bundleId) throws Exception {
        Bundle bundle = (Bundle)this.entityManager.find(Bundle.class, (Object)bundleId);
        if (null == bundle) {
            return;
        }
        Query q = this.entityManager.createNamedQuery("BundleVersion.findByBundleId");
        q.setParameter("bundleId", (Object)bundleId);
        List bvs = q.getResultList();
        for (BundleVersion bv : bvs) {
            this.bundleManager.deleteBundleVersion(subject, bv.getId(), false);
        }
        Repo bundleRepo = bundle.getRepo();
        this.entityManager.remove((Object)bundle);
        this.entityManager.flush();
        this.repoManager.deleteRepo(subject, bundleRepo.getId());
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void deleteBundleVersion(Subject subject, int bundleVersionId, boolean deleteBundleIfEmpty) throws Exception {
        BundleVersion bundleVersion = (BundleVersion)this.entityManager.find(BundleVersion.class, (Object)bundleVersionId);
        if (null == bundleVersion) {
            return;
        }
        int bundleId = 0;
        if (deleteBundleIfEmpty) {
            bundleId = bundleVersion.getBundle().getId();
        }
        this.entityManager.remove((Object)bundleVersion);
        if (deleteBundleIfEmpty) {
            this.entityManager.flush();
            Query q = this.entityManager.createNamedQuery("BundleVersion.findVersionsByBundleId");
            q.setParameter("bundleId", (Object)bundleId);
            if (q.getResultList().size() == 0) {
                this.deleteBundle(subject, bundleId);
            }
        }
    }
}

