/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.configuration;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.jws.WebParam;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.configuration.ConfigurationAgentService;
import org.rhq.core.clientapi.agent.configuration.ConfigurationUpdateRequest;
import org.rhq.core.clientapi.server.configuration.ConfigurationUpdateResponse;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.configuration.AbstractResourceConfigurationUpdate;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.PluginConfigurationUpdate;
import org.rhq.core.domain.configuration.RawConfiguration;
import org.rhq.core.domain.configuration.ResourceConfigurationUpdate;
import org.rhq.core.domain.configuration.composite.ConfigurationUpdateComposite;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.ConfigurationFormat;
import org.rhq.core.domain.configuration.group.AbstractGroupConfigurationUpdate;
import org.rhq.core.domain.configuration.group.GroupPluginConfigurationUpdate;
import org.rhq.core.domain.configuration.group.GroupResourceConfigurationUpdate;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceError;
import org.rhq.core.domain.resource.ResourceErrorType;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.GroupCategory;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.resource.group.composite.ResourceGroupComposite;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.server.PersistenceUtility;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.collection.ArrayUtils;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.server.agentclient.AgentClient;
import org.rhq.enterprise.server.alert.engine.AlertConditionCacheManagerLocal;
import org.rhq.enterprise.server.alert.engine.AlertConditionCacheStats;
import org.rhq.enterprise.server.alert.engine.internal.Tuple;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.auth.prefs.SubjectPreferences;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.configuration.ConfigurationManagerLocal;
import org.rhq.enterprise.server.configuration.ConfigurationManagerRemote;
import org.rhq.enterprise.server.configuration.ConfigurationUpdateException;
import org.rhq.enterprise.server.configuration.ConfigurationUpdateNotSupportedException;
import org.rhq.enterprise.server.configuration.ConfigurationUpdateStillInProgressException;
import org.rhq.enterprise.server.configuration.LiveConfigurationLoader;
import org.rhq.enterprise.server.configuration.TranslationNotSupportedException;
import org.rhq.enterprise.server.configuration.job.GroupPluginConfigurationUpdateJob;
import org.rhq.enterprise.server.configuration.job.GroupResourceConfigurationUpdateJob;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.jaxb.WebServiceTypeAdapter;
import org.rhq.enterprise.server.jaxb.adapter.ConfigurationAdapter;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceNotFoundException;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupNotFoundException;
import org.rhq.enterprise.server.resource.group.ResourceGroupUpdateException;
import org.rhq.enterprise.server.scheduler.SchedulerLocal;
import org.rhq.enterprise.server.util.QuartzUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
@XmlType(namespace="http://www.rhq-project.org/2.3/2009/9/Webservices.xsd")
public class ConfigurationManagerBean
implements ConfigurationManagerLocal,
ConfigurationManagerRemote {
    private final Log log = LogFactory.getLog(ConfigurationManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private AgentManagerLocal agentManager;
    @EJB
    private AlertConditionCacheManagerLocal alertConditionCacheManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    private ResourceGroupManagerLocal resourceGroupManager;
    @EJB
    private ResourceManagerLocal resourceManager;
    @EJB
    private ConfigurationManagerLocal configurationManager;
    @EJB
    private SchedulerLocal scheduler;
    @EJB
    private SubjectManagerLocal subjectManager;

    @Override
    @XmlJavaTypeAdapter(value=ConfigurationAdapter.class)
    @Nullable
    public Configuration getPluginConfiguration(Subject subject, int resourceId) {
        this.log.debug((Object)("Getting current plugin configuration for resource [" + resourceId + "]"));
        Resource resource = (Resource)this.entityManager.find(Resource.class, (Object)resourceId);
        if (resource == null) {
            throw new IllegalStateException("Cannot retrieve plugin config for unknown resource [" + resourceId + "]");
        }
        if (!this.authorizationManager.canViewResource(subject, resourceId)) {
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to view plugin configuration for [" + resource + "]");
        }
        Configuration pluginConfiguration = this.configurationManager.getPluginConfiguration(resourceId);
        return pluginConfiguration;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public Configuration getPluginConfiguration(int resourceId) {
        Query query = this.entityManager.createNamedQuery("Configuration.getPluginConfigByResourceId");
        query.setParameter("resourceId", (Object)resourceId);
        Configuration result = (Configuration)query.getSingleResult();
        return result;
    }

    @Override
    public void completePluginConfigurationUpdate(Integer updateId) {
        PluginConfigurationUpdate update = (PluginConfigurationUpdate)this.entityManager.find(PluginConfigurationUpdate.class, (Object)updateId);
        this.configurationManager.completePluginConfigurationUpdate(update);
    }

    @Override
    public void completePluginConfigurationUpdate(PluginConfigurationUpdate update) {
        ConfigurationUpdateResponse response = this.configurationManager.executePluginConfigurationUpdate(update);
        Resource resource = update.getResource();
        resource.setPluginConfiguration(update.getConfiguration());
        if (response.getStatus() == ConfigurationUpdateStatus.SUCCESS) {
            update.setStatus(ConfigurationUpdateStatus.SUCCESS);
            resource.setConnected(true);
            this.removeAnyExistingInvalidPluginConfigurationErrors(this.subjectManager.getOverlord(), resource);
            this.entityManager.flush();
            this.entityManager.merge((Object)update);
        } else {
            this.handlePluginConfiguratonUpdateRemoteException(resource, response.getStatus().toString(), response.getErrorMessage());
            update.setStatus(response.getStatus());
            update.setErrorMessage(response.getErrorMessage());
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public ConfigurationUpdateResponse executePluginConfigurationUpdate(PluginConfigurationUpdate update) {
        Resource resource = update.getResource();
        Configuration configuration = update.getConfiguration();
        ConfigurationUpdateResponse response = null;
        try {
            AgentClient agentClient = this.agentManager.getAgentClient(resource.getAgent());
            agentClient.getDiscoveryAgentService().updatePluginConfiguration(resource.getId(), configuration);
            try {
                agentClient.getDiscoveryAgentService().executeServiceScanDeferred();
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to execute service scan - cannot detect children of the newly connected resource [" + resource + "]"), (Throwable)e);
            }
            response = new ConfigurationUpdateResponse(update.getId(), null, ConfigurationUpdateStatus.SUCCESS, null);
        }
        catch (Exception e) {
            response = new ConfigurationUpdateResponse(update.getId(), null, (Throwable)e);
        }
        return response;
    }

    @Override
    public PluginConfigurationUpdate updatePluginConfiguration(Subject subject, int resourceId, @XmlJavaTypeAdapter(value=ConfigurationAdapter.class) Configuration configuration) throws ResourceNotFoundException {
        Subject overlord = this.subjectManager.getOverlord();
        Resource resource = this.resourceManager.getResourceById(overlord, resourceId);
        this.ensureModifyPermission(subject, resource);
        PluginConfigurationUpdate update = new PluginConfigurationUpdate(resource, configuration, subject.getName());
        update.setStatus(ConfigurationUpdateStatus.SUCCESS);
        this.entityManager.persist((Object)update);
        resource.addPluginConfigurationUpdates(update);
        Agent agent = resource.getAgent();
        if (agent != null) {
            agent.getName();
        }
        this.configurationManager.completePluginConfigurationUpdate(update);
        return update;
    }

    @Override
    @XmlJavaTypeAdapter(value=ConfigurationAdapter.class)
    public Configuration getResourceConfiguration(Subject subject, int resourceId) {
        Resource resource = (Resource)this.entityManager.find(Resource.class, (Object)resourceId);
        if (resource == null) {
            throw new NoResultException("Cannot get live configuration for unknown resource [" + resourceId + "]");
        }
        if (!this.authorizationManager.canViewResource(subject, resource.getId())) {
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to view resource configuration for [" + resource + "]");
        }
        Configuration result = this.configurationManager.getResourceConfiguration(resourceId);
        return result;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public Configuration getResourceConfiguration(int resourceId) {
        Query query = this.entityManager.createNamedQuery("Configuration.getResourceConfigByResourceId");
        query.setParameter("resourceId", (Object)resourceId);
        Configuration result = (Configuration)query.getSingleResult();
        return result;
    }

    @Override
    public ResourceConfigurationUpdate getLatestResourceConfigurationUpdate(Subject subject, int resourceId, boolean fromStructured) {
        Resource resource;
        ResourceConfigurationUpdate current;
        block11: {
            this.log.debug((Object)("Getting current resource configuration for resource [" + resourceId + "]"));
            try {
                Query query = this.entityManager.createNamedQuery("ResourceConfigurationUpdate.findCurrentlyActiveConfig");
                query.setParameter("resourceId", (Object)resourceId);
                current = (ResourceConfigurationUpdate)query.getSingleResult();
                resource = current.getResource();
            }
            catch (NoResultException nre) {
                current = null;
                resource = (Resource)this.entityManager.find(Resource.class, (Object)resourceId);
                if (resource != null) break block11;
                throw new NoResultException("Cannot get latest resource configuration for unknown resource [" + resourceId + "]");
            }
        }
        if (!this.authorizationManager.canViewResource(subject, resource.getId())) {
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to view resource configuration for [" + resource + "]");
        }
        try {
            Query query = this.entityManager.createNamedQuery("ResourceConfigurationUpdate.findByLatestByResourceId");
            query.setParameter("resourceId", (Object)resourceId);
            ResourceConfigurationUpdate latest = (ResourceConfigurationUpdate)query.getSingleResult();
            if (latest.getStatus() == ConfigurationUpdateStatus.INPROGRESS) {
                return current;
            }
        }
        catch (NoResultException nre) {
            // empty catch block
        }
        Configuration liveConfig = this.getLiveResourceConfiguration(resource, true, fromStructured);
        if (liveConfig != null) {
            boolean theSame;
            Configuration currentConfig = current != null ? current.getConfiguration() : null;
            boolean bl = theSame = currentConfig != null && currentConfig.equals((Object)liveConfig);
            if (!theSame) {
                try {
                    current = this.persistNewAgentReportedResourceConfiguration(resource, liveConfig);
                }
                catch (ConfigurationUpdateStillInProgressException e) {
                    this.log.debug((Object)("Resource is currently in progress of changing its resource configuration - since it hasn't finished yet, will use the last successful resource configuration: " + e));
                }
            }
        } else {
            this.log.warn((Object)("Could not get live resource configuration for resource [" + resource + "]; will assume latest resource configuration update is the current resource configuration."));
        }
        return current;
    }

    @Override
    @Nullable
    public ResourceConfigurationUpdate getLatestResourceConfigurationUpdate(Subject subject, int resourceId) {
        return this.getLatestResourceConfigurationUpdate(subject, resourceId, true);
    }

    private ResourceConfigurationUpdate persistNewAgentReportedResourceConfiguration(Resource resource, Configuration liveConfig) throws ConfigurationUpdateStillInProgressException {
        if (liveConfig.getRawConfigurations() != null) {
            for (RawConfiguration raw : liveConfig.getRawConfigurations()) {
                MessageDigestGenerator sha256Generator = new MessageDigestGenerator("SHA-256");
                sha256Generator.add(raw.getContents().getBytes());
                raw.setSha256(sha256Generator.getDigestString());
            }
        }
        ResourceConfigurationUpdate update = this.configurationManager.persistNewResourceConfigurationUpdateHistory(this.subjectManager.getOverlord(), resource.getId(), liveConfig, ConfigurationUpdateStatus.SUCCESS, null, false);
        resource.setResourceConfiguration(liveConfig.deepCopyWithoutProxies());
        return update;
    }

    @Override
    public PluginConfigurationUpdate getLatestPluginConfigurationUpdate(Subject subject, int resourceId) {
        Resource resource;
        PluginConfigurationUpdate current;
        block3: {
            this.log.debug((Object)("Getting current plugin configuration for resource [" + resourceId + "]"));
            try {
                Query query = this.entityManager.createNamedQuery("PluginConfigurationUpdate.findCurrentlyActiveConfig");
                query.setParameter("resourceId", (Object)resourceId);
                current = (PluginConfigurationUpdate)query.getSingleResult();
                resource = current.getResource();
            }
            catch (NoResultException nre) {
                current = null;
                resource = (Resource)this.entityManager.find(Resource.class, (Object)resourceId);
                if (resource != null) break block3;
                throw new NoResultException("Cannot get latest plugin configuration for unknown resource [" + resourceId + "]");
            }
        }
        if (!this.authorizationManager.canViewResource(subject, resource.getId())) {
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to view plugin configuration for [" + resource + "]");
        }
        return current;
    }

    @Override
    public boolean isResourceConfigurationUpdateInProgress(Subject subject, int resourceId) {
        boolean updateInProgress;
        try {
            Query query = this.entityManager.createNamedQuery("ResourceConfigurationUpdate.findByLatestByResourceId");
            query.setParameter("resourceId", (Object)resourceId);
            ResourceConfigurationUpdate latestConfigUpdate = (ResourceConfigurationUpdate)query.getSingleResult();
            if (!this.authorizationManager.canViewResource(subject, latestConfigUpdate.getResource().getId())) {
                throw new PermissionException("User [" + subject.getName() + "] does not have permission to view Resource configuration for [" + latestConfigUpdate.getResource() + "]");
            }
            updateInProgress = latestConfigUpdate.getStatus() == ConfigurationUpdateStatus.INPROGRESS;
        }
        catch (NoResultException nre) {
            updateInProgress = false;
        }
        return updateInProgress;
    }

    public boolean isPluginConfigurationUpdateInProgress(Subject subject, int resourceId) {
        boolean updateInProgress;
        try {
            Query query = this.entityManager.createNamedQuery("PluginConfigurationUpdate.findLatestByResourceId");
            query.setParameter("resourceId", (Object)resourceId);
            PluginConfigurationUpdate latestConfigUpdate = (PluginConfigurationUpdate)query.getSingleResult();
            if (!this.authorizationManager.canViewResource(subject, latestConfigUpdate.getResource().getId())) {
                throw new PermissionException("User [" + subject.getName() + "] does not have permission to view plugin configuration for [" + latestConfigUpdate.getResource() + "]");
            }
            updateInProgress = latestConfigUpdate.getStatus() == ConfigurationUpdateStatus.INPROGRESS;
        }
        catch (NoResultException nre) {
            updateInProgress = false;
        }
        return updateInProgress;
    }

    @Override
    public boolean isGroupResourceConfigurationUpdateInProgress(Subject subject, int groupId) {
        boolean updateInProgress;
        try {
            Query query = this.entityManager.createNamedQuery("GroupResourceConfigurationUpdate.findLatestByGroupId");
            query.setParameter("groupId", (Object)groupId);
            GroupResourceConfigurationUpdate latestConfigGroupUpdate = (GroupResourceConfigurationUpdate)query.getSingleResult();
            if (!this.authorizationManager.canViewGroup(subject, latestConfigGroupUpdate.getGroup().getId())) {
                throw new PermissionException("User [" + subject.getName() + "] does not have permission to view group Resource configuration for [" + latestConfigGroupUpdate.getGroup() + "]");
            }
            updateInProgress = latestConfigGroupUpdate.getStatus() == ConfigurationUpdateStatus.INPROGRESS;
        }
        catch (NoResultException nre) {
            updateInProgress = false;
        }
        return updateInProgress;
    }

    public boolean isGroupPluginConfigurationUpdateInProgress(Subject subject, int groupId) {
        boolean updateInProgress;
        try {
            Query query = this.entityManager.createNamedQuery("GroupPluginConfigurationUpdatee.findLatestByGroupId");
            query.setParameter("groupId", (Object)groupId);
            GroupPluginConfigurationUpdate latestConfigGroupUpdate = (GroupPluginConfigurationUpdate)query.getSingleResult();
            if (!this.authorizationManager.canViewGroup(subject, latestConfigGroupUpdate.getGroup().getId())) {
                throw new PermissionException("User [" + subject.getName() + "] does not have permission to view group plugin configuration for [" + latestConfigGroupUpdate.getGroup() + "]");
            }
            updateInProgress = latestConfigGroupUpdate.getStatus() == ConfigurationUpdateStatus.INPROGRESS;
        }
        catch (NoResultException nre) {
            updateInProgress = false;
        }
        return updateInProgress;
    }

    @Override
    public Map<Integer, Configuration> getResourceConfigurationsForCompatibleGroup(Subject subject, int groupId) throws ConfigurationUpdateStillInProgressException, Exception {
        AvailabilityType availability;
        ResourceGroupComposite groupComposite = this.resourceGroupManager.getResourceGroupComposite(subject, groupId);
        if (groupComposite.getExplicitAvail() == null) {
            return new HashMap<Integer, Configuration>();
        }
        AvailabilityType availabilityType = availability = groupComposite.getExplicitAvail() == 1.0 ? AvailabilityType.UP : AvailabilityType.DOWN;
        if (availability == AvailabilityType.DOWN) {
            throw new Exception("Current group Resource configuration for " + groupId + " cannot be calculated, because one or more of this group's member Resources are DOWN.");
        }
        ResourceGroup group = groupComposite.getResourceGroup();
        this.ensureNoResourceConfigurationUpdatesInProgress(group);
        int userPreferencesTimeout = new SubjectPreferences(subject).getGroupConfigurationTimeoutPeriod();
        Set groupMembers = group.getExplicitResources();
        Map<Integer, Configuration> liveConfigs = LiveConfigurationLoader.getInstance().loadLiveResourceConfigurations(groupMembers, userPreferencesTimeout);
        Map<Integer, Configuration> currentPersistedConfigs = this.getPersistedResourceConfigurationsForCompatibleGroup(group);
        for (Resource memberResource : groupMembers) {
            Configuration currentPersistedConfig;
            Configuration liveConfig = liveConfigs.get(memberResource.getId());
            if (liveConfig.equals((Object)(currentPersistedConfig = currentPersistedConfigs.get(memberResource.getId())))) continue;
            ResourceConfigurationUpdate update = this.persistNewAgentReportedResourceConfiguration(memberResource, liveConfig);
            if (update != null) {
                currentPersistedConfigs.put(memberResource.getId(), update.getConfiguration());
                continue;
            }
            this.log.error((Object)("Current Configuration for " + memberResource + " does not match latest associated ResourceConfigurationUpdate with SUCCESS status."));
        }
        return currentPersistedConfigs;
    }

    @Override
    public Map<Integer, Configuration> getPluginConfigurationsForCompatibleGroup(Subject subject, int groupId) throws ConfigurationUpdateStillInProgressException, Exception {
        ResourceGroup group = this.resourceGroupManager.getResourceGroupById(subject, groupId, GroupCategory.COMPATIBLE);
        this.ensureNoPluginConfigurationUpdatesInProgress(group);
        Map<Integer, Configuration> currentPersistedConfigs = this.getPersistedPluginConfigurationsForCompatibleGroup(group);
        return currentPersistedConfigs;
    }

    private void ensureNoResourceConfigurationUpdatesInProgress(ResourceGroup compatibleGroup) throws ConfigurationUpdateStillInProgressException {
        if (this.isGroupResourceConfigurationUpdateInProgress(this.subjectManager.getOverlord(), compatibleGroup.getId())) {
            throw new ConfigurationUpdateStillInProgressException("Current group Resource configuration for " + compatibleGroup + " cannot be calculated, because a group Resource configuration update is currently in progress " + " (please wait for this update to complete or delete it from the history).");
        }
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"ResourceConfigurationUpdate.findByGroupIdAndStatus");
        countQuery.setParameter("groupId", (Object)compatibleGroup.getId());
        countQuery.setParameter("status", (Object)ConfigurationUpdateStatus.INPROGRESS);
        long count = (Long)countQuery.getSingleResult();
        if (count != 0L) {
            Query query = this.entityManager.createNamedQuery("ResourceConfigurationUpdate.findByGroupIdAndStatus");
            query.setParameter("groupId", (Object)compatibleGroup.getId());
            query.setParameter("status", (Object)ConfigurationUpdateStatus.INPROGRESS);
            List resources = query.getResultList();
            throw new ConfigurationUpdateStillInProgressException("Current group Resource configuration for " + compatibleGroup + " cannot be calculated, because Resource configuration updates are currently in progress for the" + " following Resources (please wait for these updates to complete or delete them from the history): " + resources);
        }
    }

    private void ensureNoPluginConfigurationUpdatesInProgress(ResourceGroup compatibleGroup) throws ConfigurationUpdateStillInProgressException {
        if (this.isGroupPluginConfigurationUpdateInProgress(this.subjectManager.getOverlord(), compatibleGroup.getId())) {
            throw new ConfigurationUpdateStillInProgressException("Current group plugin configuration for " + compatibleGroup + " cannot be calculated, because a group plugin configuration update is currently in progress.");
        }
        ArrayList<Resource> resourcesWithPluginConfigUpdatesInProgress = new ArrayList<Resource>();
        for (Resource memberResource : compatibleGroup.getExplicitResources()) {
            if (!this.isPluginConfigurationUpdateInProgress(this.subjectManager.getOverlord(), memberResource.getId())) continue;
            resourcesWithPluginConfigUpdatesInProgress.add(memberResource);
        }
        if (!resourcesWithPluginConfigUpdatesInProgress.isEmpty()) {
            throw new ConfigurationUpdateStillInProgressException("Current group plugin configuration for " + compatibleGroup + " cannot be calculated, because plugin configuration updates are currently in progress for the following Resources: " + resourcesWithPluginConfigUpdatesInProgress);
        }
    }

    private Map<Integer, Configuration> getPersistedResourceConfigurationsForCompatibleGroup(ResourceGroup compatibleGroup) {
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Configuration.getResourceConfigMapByGroupId");
        countQuery.setParameter("resourceGroupId", (Object)compatibleGroup.getId());
        long count = (Long)countQuery.getSingleResult();
        if (count != (long)compatibleGroup.getExplicitResources().size()) {
            throw new IllegalStateException("Size of group changed from " + compatibleGroup.getExplicitResources().size() + " to " + count + " - please retry the operation.");
        }
        PageControl pageControl = new PageControl(0, 10);
        Query query = this.entityManager.createNamedQuery("Configuration.getResourceConfigMapByGroupId");
        query.setParameter("resourceGroupId", (Object)compatibleGroup.getId());
        HashMap<Integer, Configuration> results = new HashMap<Integer, Configuration>((int)count);
        int rowsProcessed = 0;
        while (true) {
            PersistenceUtility.setDataPage((Query)query, (PageControl)pageControl);
            List pagedResults = query.getResultList();
            if (pagedResults.size() <= 0) break;
            for (Object[] result : pagedResults) {
                results.put((Integer)result[0], (Configuration)result[1]);
            }
            if ((long)(rowsProcessed += pagedResults.size()) >= count) break;
            pageControl.setPageNumber(pageControl.getPageNumber() + 1);
        }
        return results;
    }

    private Map<Integer, Configuration> getPersistedPluginConfigurationsForCompatibleGroup(ResourceGroup compatibleGroup) {
        List pagedResults;
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Configuration.getPluginConfigMapByGroupId");
        countQuery.setParameter("resourceGroupId", (Object)compatibleGroup.getId());
        long count = (Long)countQuery.getSingleResult();
        if (count != (long)compatibleGroup.getExplicitResources().size()) {
            throw new IllegalStateException("Size of group changed from " + compatibleGroup.getExplicitResources().size() + " to " + count + " - please retry the operation.");
        }
        PageControl pageControl = new PageControl(0, 20);
        Query query = this.entityManager.createNamedQuery("Configuration.getPluginConfigMapByGroupId");
        query.setParameter("resourceGroupId", (Object)compatibleGroup.getId());
        HashMap<Integer, Configuration> results = new HashMap<Integer, Configuration>((int)count);
        int rowsProcessed = 0;
        while ((pagedResults = query.getResultList()).size() > 0) {
            for (Object[] result : pagedResults) {
                results.put((Integer)result[0], (Configuration)result[1]);
            }
            if ((long)(rowsProcessed += pagedResults.size()) >= count) break;
            pageControl.setPageNumber(pageControl.getPageNumber() + 1);
            PersistenceUtility.setDataPage((Query)query, (PageControl)pageControl);
        }
        return results;
    }

    @Override
    public Configuration getLiveResourceConfiguration(Subject subject, int resourceId, boolean pingAgentFirst) throws Exception {
        return this.getLiveResourceConfiguration(subject, resourceId, pingAgentFirst, true);
    }

    @Override
    public Configuration getLiveResourceConfiguration(Subject subject, int resourceId, boolean pingAgentFirst, boolean fromStructured) throws Exception {
        Resource resource = (Resource)this.entityManager.find(Resource.class, (Object)resourceId);
        if (resource == null) {
            throw new NoResultException("Cannot get live configuration for unknown resource [" + resourceId + "]");
        }
        if (!this.authorizationManager.canViewResource(subject, resource.getId())) {
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to view resource configuration for [" + resource + "]");
        }
        Configuration liveConfig = this.getLiveResourceConfiguration(resource, pingAgentFirst, fromStructured);
        return liveConfig;
    }

    @Override
    public void checkForTimedOutConfigurationUpdateRequests() {
        this.log.debug((Object)"Begin scanning for timed out configuration update requests");
        this.checkForTimedOutResourceConfigurationUpdateRequests();
        this.checkForTimedOutGroupResourceConfigurationUpdateRequests();
        this.log.debug((Object)"Finished scanning for timed out configuration update requests");
    }

    private void checkForTimedOutResourceConfigurationUpdateRequests() {
        try {
            Query query = this.entityManager.createNamedQuery("ResourceConfigurationUpdate.findAllInStatus");
            query.setParameter("status", (Object)ConfigurationUpdateStatus.INPROGRESS);
            List requests = query.getResultList();
            for (ResourceConfigurationUpdate request : requests) {
                long timeout = 600000L;
                long duration = request.getDuration();
                if (duration <= timeout) continue;
                this.log.info((Object)("Resource configuration update request seems to have been orphaned - timing it out: " + request));
                request.setErrorMessage("Timed out - did not complete after " + duration + " ms" + " (the timeout period was " + timeout + " ms)");
                request.setStatus(ConfigurationUpdateStatus.FAILURE);
                this.checkForCompletedGroupResourceConfigurationUpdate(request.getId());
            }
        }
        catch (Throwable t) {
            this.log.error((Object)("Failed to check for timed out Resource configuration update requests. Cause: " + t));
        }
    }

    private void checkForTimedOutGroupResourceConfigurationUpdateRequests() {
        try {
            Query query = this.entityManager.createNamedQuery("GroupResourceConfigurationUpdate.findAllInStatus");
            query.setParameter("status", (Object)ConfigurationUpdateStatus.INPROGRESS);
            List requests = query.getResultList();
            for (GroupResourceConfigurationUpdate request : requests) {
                long timeout = 660000L;
                long duration = request.getDuration();
                if (duration <= timeout) continue;
                this.log.info((Object)("Group Resource configuration update request seems to have been orphaned - timing it out: " + request));
                request.setErrorMessage("Timed out - did not complete after " + duration + " ms" + " (the timeout period was " + timeout + " ms)");
                request.setStatus(ConfigurationUpdateStatus.FAILURE);
            }
        }
        catch (Throwable t) {
            this.log.error((Object)("Failed to check for timed out group Resource configuration update requests. Cause: " + t));
        }
    }

    @Override
    public PageList<PluginConfigurationUpdate> findPluginConfigurationUpdates(Subject subject, int resourceId, Long beginDate, Long endDate, PageControl pc) {
        Resource resource = (Resource)this.entityManager.find(Resource.class, (Object)resourceId);
        if (resource.getResourceType().getPluginConfigurationDefinition() == null || resource.getResourceType().getPluginConfigurationDefinition().getPropertyDefinitions().isEmpty()) {
            return new PageList(pc);
        }
        pc.initDefaultOrderingField("cu.id", PageOrdering.DESC);
        String queryName = "PluginConfigurationUpdate.findAllByResourceId";
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)queryName);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)queryName, (PageControl)pc);
        queryCount.setParameter("resourceId", (Object)resourceId);
        query.setParameter("resourceId", (Object)resourceId);
        queryCount.setParameter("startTime", (Object)beginDate);
        query.setParameter("startTime", (Object)beginDate);
        queryCount.setParameter("endTime", (Object)endDate);
        query.setParameter("endTime", (Object)endDate);
        long totalCount = (Long)queryCount.getSingleResult();
        ArrayList<PluginConfigurationUpdate> updates = query.getResultList();
        if (updates == null || updates.size() == 0) {
            updates = new ArrayList<PluginConfigurationUpdate>();
            PluginConfigurationUpdate latest = this.getLatestPluginConfigurationUpdate(subject, resourceId);
            if (latest != null) {
                updates.add(latest);
            }
        } else if (updates.size() > 0 && !this.authorizationManager.canViewResource(subject, (resource = ((PluginConfigurationUpdate)updates.get(0)).getResource()).getId())) {
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to view resource [" + resource + "]");
        }
        return new PageList(updates, (int)totalCount, pc);
    }

    @Override
    public PageList<ResourceConfigurationUpdate> findResourceConfigurationUpdates(Subject subject, Integer resourceId, Long beginDate, Long endDate, boolean suppressOldest, PageControl pc) {
        if (!this.authorizationManager.hasResourcePermission(subject, Permission.CONFIGURE, resourceId)) {
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to manage configuration for resource[id=" + resourceId + "]");
        }
        Resource resource = (Resource)this.entityManager.find(Resource.class, (Object)resourceId);
        pc.initDefaultOrderingField("cu.id", PageOrdering.DESC);
        String queryName = "ResourceConfigurationUpdate.findAllByResourceId";
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)queryName);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)queryName, (PageControl)pc);
        queryCount.setParameter("resourceId", (Object)resourceId);
        query.setParameter("resourceId", (Object)resourceId);
        queryCount.setParameter("startTime", (Object)beginDate);
        query.setParameter("startTime", (Object)beginDate);
        queryCount.setParameter("endTime", (Object)endDate);
        query.setParameter("endTime", (Object)endDate);
        int includeAll = suppressOldest ? 0 : 1;
        queryCount.setParameter("includeAll", (Object)includeAll);
        query.setParameter("includeAll", (Object)includeAll);
        long totalCount = (Long)queryCount.getSingleResult();
        ArrayList<ResourceConfigurationUpdate> updates = query.getResultList();
        if (!suppressOldest && updates.size() == 0) {
            updates = new ArrayList<ResourceConfigurationUpdate>();
            ResourceConfigurationUpdate latest = this.getLatestResourceConfigurationUpdate(subject, resourceId);
            if (latest != null) {
                updates.add(latest);
            }
        }
        return new PageList(updates, (int)totalCount, pc);
    }

    @Override
    public PluginConfigurationUpdate getPluginConfigurationUpdate(Subject subject, int configurationUpdateId) {
        PluginConfigurationUpdate update = (PluginConfigurationUpdate)this.entityManager.find(PluginConfigurationUpdate.class, (Object)configurationUpdateId);
        if (!this.authorizationManager.canViewResource(subject, update.getResource().getId())) {
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to view plugin configuration update for [" + update.getResource() + "]");
        }
        update.getConfiguration();
        return update;
    }

    @Override
    public ResourceConfigurationUpdate getResourceConfigurationUpdate(Subject subject, int configurationUpdateId) {
        ResourceConfigurationUpdate update = (ResourceConfigurationUpdate)this.entityManager.find(ResourceConfigurationUpdate.class, (Object)configurationUpdateId);
        if (!this.authorizationManager.canViewResource(subject, update.getResource().getId())) {
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to view resource configuration update for [" + update.getResource() + "]");
        }
        update.getConfiguration();
        return update;
    }

    @Override
    public void purgePluginConfigurationUpdate(Subject subject, int configurationUpdateId, boolean purgeInProgress) {
        PluginConfigurationUpdate doomedRequest = (PluginConfigurationUpdate)this.entityManager.find(PluginConfigurationUpdate.class, (Object)configurationUpdateId);
        if (doomedRequest == null) {
            this.log.debug((Object)("Asked to purge a non-existing config update request [" + configurationUpdateId + "]"));
            return;
        }
        if (doomedRequest.getStatus() == ConfigurationUpdateStatus.INPROGRESS && !purgeInProgress) {
            throw new IllegalStateException("The update request is still in the in-progress state. Please wait for it to complete: " + doomedRequest);
        }
        Resource resource = doomedRequest.getResource();
        if (!this.authorizationManager.hasResourcePermission(subject, Permission.CONFIGURE, resource.getId())) {
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to purge a plugin configuration update audit trail for resource [" + resource + "]");
        }
        resource.getPluginConfigurationUpdates().remove(doomedRequest);
        this.entityManager.remove((Object)doomedRequest);
        this.entityManager.flush();
    }

    @Override
    public void purgeResourceConfigurationUpdate(Subject subject, int configurationUpdateId, boolean purgeInProgress) {
        ResourceConfigurationUpdate doomedRequest = (ResourceConfigurationUpdate)this.entityManager.find(ResourceConfigurationUpdate.class, (Object)configurationUpdateId);
        if (doomedRequest == null) {
            this.log.debug((Object)("Asked to purge a non-existing config update request [" + configurationUpdateId + "]"));
            return;
        }
        if (doomedRequest.getStatus() == ConfigurationUpdateStatus.INPROGRESS && !purgeInProgress) {
            throw new IllegalStateException("The update request is still in the in-progress state. Please wait for it to complete: " + doomedRequest);
        }
        Resource resource = doomedRequest.getResource();
        if (!this.authorizationManager.hasResourcePermission(subject, Permission.CONFIGURE, resource.getId())) {
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to purge a configuration update audit trail for resource [" + resource + "]");
        }
        resource.getResourceConfigurationUpdates().remove(doomedRequest);
        this.entityManager.remove((Object)doomedRequest);
        this.entityManager.flush();
    }

    @Override
    public void purgeResourceConfigurationUpdates(Subject subject, int[] configurationUpdateIds, boolean purgeInProgress) {
        if (configurationUpdateIds == null || configurationUpdateIds.length == 0) {
            return;
        }
        for (int configurationUpdateId : configurationUpdateIds) {
            this.purgeResourceConfigurationUpdate(subject, configurationUpdateId, purgeInProgress);
        }
    }

    @Override
    public ResourceConfigurationUpdate updateStructuredOrRawConfiguration(Subject subject, int resourceId, Configuration newConfiguration, boolean fromStructured) throws ResourceNotFoundException, ConfigurationUpdateStillInProgressException {
        Configuration configToUpdate = newConfiguration;
        if (this.isStructuredAndRawSupported(resourceId)) {
            configToUpdate = this.translateResourceConfiguration(subject, resourceId, newConfiguration, fromStructured);
        }
        try {
            Configuration invalidConfig = this.validateResourceConfiguration(subject, resourceId, newConfiguration, fromStructured);
            if (null != invalidConfig) {
                Resource resource = this.resourceManager.getResourceById(subject, resourceId);
                ResourceConfigurationUpdate resourceConfigurationUpdate = new ResourceConfigurationUpdate(resource, invalidConfig, subject.getName());
                resourceConfigurationUpdate.setErrorMessage("resource.validation.failed");
                resourceConfigurationUpdate.setStatus(ConfigurationUpdateStatus.FAILURE);
                return resourceConfigurationUpdate;
            }
        }
        catch (PluginContainerException e) {
            Resource resource = this.resourceManager.getResourceById(subject, resourceId);
            ResourceConfigurationUpdate resourceConfigurationUpdate = new ResourceConfigurationUpdate(resource, newConfiguration, subject.getName());
            resourceConfigurationUpdate.setErrorMessage(e.getMessage());
            resourceConfigurationUpdate.setStatus(ConfigurationUpdateStatus.FAILURE);
            return resourceConfigurationUpdate;
        }
        ResourceConfigurationUpdate newUpdate = this.configurationManager.persistNewResourceConfigurationUpdateHistory(subject, resourceId, configToUpdate, ConfigurationUpdateStatus.INPROGRESS, subject.getName(), false);
        this.executeResourceConfigurationUpdate(newUpdate, fromStructured);
        return newUpdate;
    }

    private Configuration validateResourceConfiguration(Subject subject, int resourceId, Configuration configuration, boolean isStructured) throws PluginContainerException {
        Resource resource = (Resource)this.entityManager.find(Resource.class, (Object)resourceId);
        if (resource == null) {
            throw new NoResultException("Cannot get live configuration for unknown resource [" + resourceId + "]");
        }
        if (!this.authorizationManager.canViewResource(subject, resource.getId())) {
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to view resource configuration for [" + resource + "]");
        }
        Agent agent = resource.getAgent();
        AgentClient agentClient = this.agentManager.getAgentClient(agent);
        ConfigurationAgentService configService = agentClient.getConfigurationAgentService();
        return configService.validate(configuration, resourceId, isStructured);
    }

    private boolean isRawSupported(int resourceId) {
        Resource resource = (Resource)this.entityManager.find(Resource.class, (Object)resourceId);
        ConfigurationDefinition configDef = resource.getResourceType().getResourceConfigurationDefinition();
        return ConfigurationFormat.STRUCTURED_AND_RAW == configDef.getConfigurationFormat() || ConfigurationFormat.RAW == configDef.getConfigurationFormat();
    }

    private boolean isStructuredAndRawSupported(int resourceId) {
        Resource resource = (Resource)this.entityManager.find(Resource.class, (Object)resourceId);
        ConfigurationDefinition configDef = resource.getResourceType().getResourceConfigurationDefinition();
        return ConfigurationFormat.STRUCTURED_AND_RAW == configDef.getConfigurationFormat();
    }

    @Override
    @Nullable
    public ResourceConfigurationUpdate updateResourceConfiguration(Subject subject, int resourceId, @XmlJavaTypeAdapter(value=ConfigurationAdapter.class) Configuration newConfiguration) throws ResourceNotFoundException {
        if (this.isStructuredAndRawSupported(resourceId)) {
            throw new ConfigurationUpdateNotSupportedException("Cannot update a resource configuration that supports both structured and raw configuration using this method because there is insufficient information. You should instead call updateStructuredOrRawConfiguration() which requires you whether the structured or raw was updated.");
        }
        ResourceConfigurationUpdate newUpdate = this.configurationManager.persistNewResourceConfigurationUpdateHistory(subject, resourceId, newConfiguration, ConfigurationUpdateStatus.INPROGRESS, subject.getName(), false);
        this.executeResourceConfigurationUpdate(newUpdate, true);
        return newUpdate;
    }

    @Override
    public void executeResourceConfigurationUpdate(int updateId) {
        ResourceConfigurationUpdate update = this.getResourceConfigurationUpdate(this.subjectManager.getOverlord(), updateId);
        this.executeResourceConfigurationUpdate(update, true);
    }

    private void executeResourceConfigurationUpdate(ResourceConfigurationUpdate update, boolean fromStructured) {
        block2: {
            try {
                AgentClient agentClient = this.agentManager.getAgentClient(update.getResource().getAgent());
                ConfigurationUpdateRequest request = new ConfigurationUpdateRequest(update.getId(), update.getConfiguration(), update.getResource().getId());
                agentClient.getConfigurationAgentService().updateResourceConfiguration(request);
            }
            catch (RuntimeException e) {
                if (null == update) break block2;
                update.setStatus(ConfigurationUpdateStatus.FAILURE);
                update.setErrorMessage(ThrowableUtil.getStackAsString((Throwable)e));
                this.configurationManager.mergeConfigurationUpdate((AbstractResourceConfigurationUpdate)update);
            }
        }
    }

    @Override
    public void rollbackResourceConfiguration(Subject subject, int resourceId, int configHistoryId) throws ConfigurationUpdateException {
        ResourceConfigurationUpdate configurationUpdateHistory = (ResourceConfigurationUpdate)this.entityManager.find(ResourceConfigurationUpdate.class, (Object)configHistoryId);
        Configuration configuration = configurationUpdateHistory.getConfiguration();
        if (configuration == null) {
            throw new ConfigurationUpdateException("No configuration history element exists with id = '" + configHistoryId + "'");
        }
        if (this.isStructuredAndRawSupported(resourceId)) {
            this.updateStructuredOrRawConfiguration(subject, resourceId, configuration, false);
        } else {
            this.updateResourceConfiguration(subject, resourceId, configuration);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public ResourceConfigurationUpdate persistNewResourceConfigurationUpdateHistory(Subject subject, int resourceId, Configuration newConfiguration, ConfigurationUpdateStatus newStatus, String newSubject, boolean isPartofGroupUpdate) throws ResourceNotFoundException, ConfigurationUpdateStillInProgressException {
        ResourceConfigurationUpdate current;
        Resource resource = this.resourceManager.getResourceById(subject, resourceId);
        if (!this.authorizationManager.hasResourcePermission(subject, Permission.CONFIGURE, resource.getId())) {
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to modify configuration for resource [" + resource + "]");
        }
        List previousRequests = resource.getResourceConfigurationUpdates();
        String errorMessage = null;
        if (previousRequests != null) {
            for (ResourceConfigurationUpdate previousRequest : previousRequests) {
                if (previousRequest.getStatus() != ConfigurationUpdateStatus.INPROGRESS) continue;
                if (isPartofGroupUpdate) {
                    newStatus = ConfigurationUpdateStatus.FAILURE;
                    errorMessage = "Resource configuration Update was aborted because an update request for the Resource was already in progress.";
                    continue;
                }
                throw new ConfigurationUpdateStillInProgressException("Resource [" + resource + "] has a resource configuration update request already in progress - please wait for it to finish: " + previousRequest);
            }
        }
        try {
            Query query = this.entityManager.createNamedQuery("ResourceConfigurationUpdate.findCurrentlyActiveConfig");
            query.setParameter("resourceId", (Object)resourceId);
            current = (ResourceConfigurationUpdate)query.getSingleResult();
            resource = current.getResource();
        }
        catch (NoResultException nre) {
            current = null;
        }
        if (!isPartofGroupUpdate && current != null && newConfiguration.equals((Object)current.getConfiguration())) {
            return null;
        }
        Configuration zeroedConfiguration = newConfiguration.deepCopyWithoutProxies();
        ResourceConfigurationUpdate newUpdateRequest = new ResourceConfigurationUpdate(resource, zeroedConfiguration, newSubject);
        newUpdateRequest.setStatus(newStatus);
        if (newStatus == ConfigurationUpdateStatus.FAILURE) {
            newUpdateRequest.setErrorMessage(errorMessage);
        }
        this.entityManager.persist((Object)newUpdateRequest);
        if (current != null && newStatus == ConfigurationUpdateStatus.SUCCESS) {
            this.notifyAlertConditionCacheManager("persistNewResourceConfigurationUpdateHistory", newUpdateRequest);
        }
        resource.addResourceConfigurationUpdates(newUpdateRequest);
        resource.getChildResources().size();
        Agent agent = resource.getAgent();
        if (agent != null) {
            agent.getName();
        }
        return newUpdateRequest;
    }

    private void notifyAlertConditionCacheManager(String callingMethod, ResourceConfigurationUpdate update) {
        AlertConditionCacheStats stats = this.alertConditionCacheManager.checkConditions(update);
        this.log.debug((Object)(callingMethod + ": " + stats));
    }

    @Override
    public void completeResourceConfigurationUpdate(ConfigurationUpdateResponse response) {
        this.log.debug((Object)("Received a configuration-update-completed message: " + response));
        ResourceConfigurationUpdate update = (ResourceConfigurationUpdate)this.entityManager.find(ResourceConfigurationUpdate.class, (Object)response.getConfigurationUpdateId());
        if (update == null) {
            throw new IllegalStateException("The completed request passed in does not match any request for any resource in inventory: " + response);
        }
        if (response.getStatus() == ConfigurationUpdateStatus.FAILURE) {
            if (response.getConfiguration() != null) {
                Configuration failedConfiguration = response.getConfiguration();
                failedConfiguration = (Configuration)this.entityManager.merge((Object)failedConfiguration);
                update.setConfiguration(failedConfiguration);
            }
        } else if (response.getStatus() == ConfigurationUpdateStatus.SUCCESS) {
            Resource resource = update.getResource();
            resource.setResourceConfiguration(update.getConfiguration().deepCopyWithoutProxies());
            this.notifyAlertConditionCacheManager("completeResourceConfigurationUpdate", update);
        }
        update.setStatus(response.getStatus());
        update.setErrorMessage(response.getErrorMessage());
    }

    @Override
    public void checkForCompletedGroupResourceConfigurationUpdate(int resourceConfigUpdateId) {
        ResourceConfigurationUpdate resourceConfigUpdate = (ResourceConfigurationUpdate)this.entityManager.find(ResourceConfigurationUpdate.class, (Object)resourceConfigUpdateId);
        if (resourceConfigUpdate.getStatus() == ConfigurationUpdateStatus.INPROGRESS) {
            return;
        }
        GroupResourceConfigurationUpdate groupConfigUpdate = resourceConfigUpdate.getGroupConfigurationUpdate();
        if (groupConfigUpdate == null) {
            return;
        }
        Query inProgressResourcesCountQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"ResourceConfigurationUpdate.findByParentUpdateIdAndStatus");
        inProgressResourcesCountQuery.setParameter("parentUpdateId", (Object)groupConfigUpdate.getId());
        inProgressResourcesCountQuery.setParameter("status", (Object)ConfigurationUpdateStatus.INPROGRESS);
        long inProgressResourcesCount = (Long)inProgressResourcesCountQuery.getSingleResult();
        if (inProgressResourcesCount == 0L) {
            ConfigurationUpdateStatus groupStatus;
            Query failedResourcesQuery = this.entityManager.createNamedQuery("ResourceConfigurationUpdate.findByParentUpdateIdAndStatus");
            failedResourcesQuery.setParameter("parentUpdateId", (Object)groupConfigUpdate.getId());
            failedResourcesQuery.setParameter("status", (Object)ConfigurationUpdateStatus.FAILURE);
            List failedResources = failedResourcesQuery.getResultList();
            if (failedResources.isEmpty()) {
                groupStatus = ConfigurationUpdateStatus.SUCCESS;
            } else {
                groupStatus = ConfigurationUpdateStatus.FAILURE;
                groupConfigUpdate.setErrorMessage("The following Resources failed to update their Configurations: " + failedResources);
            }
            groupConfigUpdate.setStatus(groupStatus);
            this.log.info((Object)("Group Resource configuration update [" + groupConfigUpdate.getId() + "] for " + groupConfigUpdate.getGroup() + " has completed with status [" + groupStatus + "]."));
        } else {
            this.log.debug((Object)("Group Resource configuration update [" + groupConfigUpdate.getId() + "] for " + groupConfigUpdate.getGroup() + " has " + inProgressResourcesCount + " member updates still in progress."));
        }
    }

    @Override
    public ConfigurationDefinition getPackageTypeConfigurationDefinition(Subject subject, int packageTypeId) {
        ConfigurationDefinition configurationDefinition;
        block2: {
            Query query = this.entityManager.createNamedQuery("ConfigurationDefinition.findDeploymentByPackageTypeId");
            query.setParameter("packageTypeId", (Object)packageTypeId);
            configurationDefinition = null;
            try {
                configurationDefinition = (ConfigurationDefinition)query.getSingleResult();
            }
            catch (NoResultException e) {
                PackageType packageType = (PackageType)this.entityManager.find(PackageType.class, (Object)packageTypeId);
                if (packageType != null) break block2;
                throw new EntityNotFoundException("A package type with id " + packageTypeId + " does not exist.");
            }
        }
        return configurationDefinition;
    }

    @Override
    @Nullable
    public ConfigurationDefinition getResourceConfigurationDefinitionForResourceType(Subject subject, int resourceTypeId) {
        ConfigurationDefinition configurationDefinition;
        block2: {
            Query query = this.entityManager.createNamedQuery("ConfigurationDefinition.findResourceByResourceTypeId");
            query.setParameter("resourceTypeId", (Object)resourceTypeId);
            configurationDefinition = null;
            try {
                configurationDefinition = (ConfigurationDefinition)query.getSingleResult();
            }
            catch (NoResultException e) {
                ResourceType resourceType = (ResourceType)this.entityManager.find(ResourceType.class, (Object)resourceTypeId);
                if (resourceType != null) break block2;
                throw new EntityNotFoundException("A resource type with id " + resourceTypeId + " does not exist.");
            }
        }
        return configurationDefinition;
    }

    @Override
    @Nullable
    public ConfigurationDefinition getResourceConfigurationDefinitionWithTemplatesForResourceType(Subject subject, int resourceTypeId) {
        ConfigurationDefinition configurationDefinition;
        block3: {
            Query query = this.entityManager.createNamedQuery("ConfigurationDefinition.findResourceByResourceTypeId");
            query.setParameter("resourceTypeId", (Object)resourceTypeId);
            configurationDefinition = null;
            try {
                configurationDefinition = (ConfigurationDefinition)query.getSingleResult();
            }
            catch (NoResultException e) {
                ResourceType resourceType = (ResourceType)this.entityManager.find(ResourceType.class, (Object)resourceTypeId);
                if (resourceType != null) break block3;
                throw new EntityNotFoundException("A resource type with id " + resourceTypeId + " does not exist.");
            }
        }
        if (configurationDefinition != null && configurationDefinition.getTemplates() != null) {
            configurationDefinition.getTemplates().size();
        }
        return configurationDefinition;
    }

    public boolean hasPluginConfiguration(int resourceTypeId) {
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"ConfigurationDefinition.findPluginByResourceTypeId");
        countQuery.setParameter("resourceTypeId", (Object)resourceTypeId);
        long count = (Long)countQuery.getSingleResult();
        return count != 0L;
    }

    @Override
    @Nullable
    public ConfigurationDefinition getPluginConfigurationDefinitionForResourceType(Subject subject, int resourceTypeId) {
        ConfigurationDefinition configurationDefinition;
        block3: {
            Query query = this.entityManager.createNamedQuery("ConfigurationDefinition.findPluginByResourceTypeId");
            query.setParameter("resourceTypeId", (Object)resourceTypeId);
            configurationDefinition = null;
            try {
                configurationDefinition = (ConfigurationDefinition)query.getSingleResult();
            }
            catch (NoResultException e) {
                ResourceType resourceType = (ResourceType)this.entityManager.find(ResourceType.class, (Object)resourceTypeId);
                if (resourceType != null) break block3;
                throw new EntityNotFoundException("A resource type with id " + resourceTypeId + " does not exist.");
            }
        }
        if (configurationDefinition != null && configurationDefinition.getTemplates() != null) {
            configurationDefinition.getTemplates().size();
        }
        return configurationDefinition;
    }

    private Configuration getLiveResourceConfiguration(Resource resource, boolean pingAgentFirst, boolean fromStructured) {
        Configuration liveConfig = null;
        try {
            Agent agent = resource.getAgent();
            AgentClient agentClient = this.agentManager.getAgentClient(agent);
            boolean agentPingedSuccessfully = false;
            if (pingAgentFirst) {
                agentPingedSuccessfully = agentClient.ping(5000L);
            }
            if (!pingAgentFirst || agentPingedSuccessfully) {
                liveConfig = agentClient.getConfigurationAgentService().loadResourceConfiguration(resource.getId());
                if (liveConfig == null) {
                    this.log.debug((Object)"ConfigurationAgentService.loadResourceConfiguration() returned a null Configuration.");
                    liveConfig = new Configuration();
                }
            } else {
                this.log.warn((Object)("Agent is unreachable [" + agent + "] - cannot get live configuration for resource [" + resource + "]"));
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("Could not get live configuration for resource [" + resource + "]" + ThrowableUtil.getAllMessages((Throwable)e, (boolean)true)));
        }
        return liveConfig;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public AbstractResourceConfigurationUpdate mergeConfigurationUpdate(AbstractResourceConfigurationUpdate configurationUpdate) {
        return (AbstractResourceConfigurationUpdate)this.entityManager.merge((Object)configurationUpdate);
    }

    @Override
    public Configuration getConfigurationById(int id) {
        return (Configuration)this.entityManager.find(Configuration.class, (Object)id);
    }

    @Override
    public Configuration getConfiguration(Subject subject, int configurationId) {
        return this.getConfigurationById(configurationId);
    }

    @Override
    public Configuration getConfigurationFromDefaultTemplate(ConfigurationDefinition definition) {
        ConfigurationDefinition managedDefinition = (ConfigurationDefinition)this.entityManager.find(ConfigurationDefinition.class, (Object)definition.getId());
        return managedDefinition.getDefaultTemplate().getConfiguration();
    }

    private void handlePluginConfiguratonUpdateRemoteException(Resource resource, String summary, String detail) {
        resource.setConnected(false);
        ResourceError invalidPluginConfigError = new ResourceError(resource, ResourceErrorType.INVALID_PLUGIN_CONFIGURATION, summary, detail, Calendar.getInstance().getTimeInMillis());
        this.resourceManager.addResourceError(invalidPluginConfigError);
    }

    private void removeAnyExistingInvalidPluginConfigurationErrors(Subject subject, Resource resource) {
        this.resourceManager.clearResourceConfigError(resource.getId());
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public int createGroupConfigurationUpdate(AbstractGroupConfigurationUpdate update) throws SchedulerException {
        this.entityManager.persist((Object)update);
        return update.getId();
    }

    @Override
    public int scheduleGroupPluginConfigurationUpdate(Subject subject, int compatibleGroupId, Map<Integer, Configuration> memberPluginConfigurations) throws SchedulerException {
        if (memberPluginConfigurations == null) {
            throw new IllegalArgumentException("GroupPluginConfigurationUpdate must have non-null member configurations.");
        }
        ResourceGroup group = this.getCompatibleGroupIfAuthorized(subject, compatibleGroupId);
        this.ensureModifyResourcePermission(subject, group);
        GroupPluginConfigurationUpdate groupUpdate = new GroupPluginConfigurationUpdate(group, subject.getName());
        int updateId = this.configurationManager.createGroupConfigurationUpdate((AbstractGroupConfigurationUpdate)groupUpdate);
        for (Integer resourceId : memberPluginConfigurations.keySet()) {
            Configuration memberResourceConfiguration = memberPluginConfigurations.get(resourceId);
            Resource flyWeight = new Resource(resourceId.intValue());
            PluginConfigurationUpdate memberUpdate = new PluginConfigurationUpdate(flyWeight, memberResourceConfiguration, subject.getName());
            memberUpdate.setGroupConfigurationUpdate(groupUpdate);
            this.entityManager.persist((Object)memberUpdate);
        }
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.putAsString("configGroupUpdateId", updateId);
        jobDataMap.putAsString("subjectId", subject.getId());
        JobDetail jobDetail = GroupPluginConfigurationUpdateJob.getJobDetail(group, subject, jobDataMap);
        Trigger trigger = QuartzUtil.getFireOnceOffsetTrigger(jobDetail, 10000L);
        this.scheduler.scheduleJob(jobDetail, trigger);
        this.log.debug((Object)("Scheduled plugin configuration update against compatibleGroup[id=" + compatibleGroupId + "]"));
        return updateId;
    }

    @Override
    public int scheduleGroupResourceConfigurationUpdate(Subject subject, int compatibleGroupId, @WebParam(targetNamespace="http://www.rhq-project.org/2.3/2009/9/Webservices.xsd") @XmlJavaTypeAdapter(value=WebServiceTypeAdapter.class) Map<Integer, Configuration> newResourceConfigurationMap) {
        if (newResourceConfigurationMap == null) {
            throw new IllegalArgumentException("GroupResourceConfigurationUpdate must have non-null member configurations.");
        }
        ResourceGroup group = this.getCompatibleGroupIfAuthorized(subject, compatibleGroupId);
        if (!this.authorizationManager.hasGroupPermission(subject, Permission.CONFIGURE, group.getId())) {
            throw new PermissionException("User [" + subject.getName() + "] does not have permission " + "to modify Resource configurations for members of group [" + group + "].");
        }
        this.ensureNoResourceConfigurationUpdatesInProgress(group);
        GroupResourceConfigurationUpdate groupUpdate = new GroupResourceConfigurationUpdate(group, subject.getName());
        int updateId = -1;
        try {
            updateId = this.configurationManager.createGroupConfigurationUpdate((AbstractGroupConfigurationUpdate)groupUpdate);
        }
        catch (SchedulerException sche) {
            String message = "Error scheduling update for group[id=" + group.getId() + "]:";
            this.log.error((Object)message, (Throwable)sche);
            new ResourceGroupUpdateException(message + sche.getMessage());
        }
        for (Integer resourceId : newResourceConfigurationMap.keySet()) {
            Configuration memberResourceConfiguration = newResourceConfigurationMap.get(resourceId);
            Resource flyWeight = new Resource(resourceId.intValue());
            ResourceConfigurationUpdate memberUpdate = new ResourceConfigurationUpdate(flyWeight, memberResourceConfiguration, subject.getName());
            memberUpdate.setGroupConfigurationUpdate(groupUpdate);
            this.entityManager.persist((Object)memberUpdate);
        }
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.putAsString("configGroupUpdateId", updateId);
        jobDataMap.putAsString("subjectId", subject.getId());
        JobDetail jobDetail = GroupResourceConfigurationUpdateJob.getJobDetail(group, subject, jobDataMap);
        Trigger trigger = QuartzUtil.getFireOnceOffsetTrigger(jobDetail, 10000L);
        try {
            this.scheduler.scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException e) {
            String message = "Error scheduling job named '" + jobDetail.getName() + "':";
            this.log.error((Object)message, (Throwable)e);
            new ResourceGroupUpdateException(message + e.getMessage());
        }
        this.log.debug((Object)("Scheduled Resource configuration update against compatible ResourceGroup[id=" + compatibleGroupId + "]."));
        return updateId;
    }

    private ResourceGroup getCompatibleGroupIfAuthorized(Subject subject, int compatibleGroupId) {
        ResourceGroup group;
        try {
            group = this.resourceGroupManager.getResourceGroupById(subject, compatibleGroupId, GroupCategory.COMPATIBLE);
        }
        catch (ResourceGroupNotFoundException e) {
            throw new RuntimeException("Cannot get support operations for unknown group [" + compatibleGroupId + "]: " + e, e);
        }
        return group;
    }

    private void ensureModifyPermission(Subject subject, Resource resource) throws PermissionException {
        if (!this.authorizationManager.hasResourcePermission(subject, Permission.MODIFY_RESOURCE, resource.getId())) {
            throw new PermissionException("User [" + subject.getName() + "] does not have permission " + "to modify plugin configuration for resource [" + resource + "]");
        }
    }

    private void ensureModifyResourcePermission(Subject subject, ResourceGroup group) throws PermissionException {
        if (!this.authorizationManager.hasGroupPermission(subject, Permission.MODIFY_RESOURCE, group.getId())) {
            throw new PermissionException("User [" + subject.getName() + "] does not have permission " + "to modify plugin configuration for members of group [" + group + "]");
        }
    }

    @Override
    public GroupPluginConfigurationUpdate getGroupPluginConfigurationById(int configurationUpdateId) {
        GroupPluginConfigurationUpdate update = (GroupPluginConfigurationUpdate)this.entityManager.find(GroupPluginConfigurationUpdate.class, (Object)configurationUpdateId);
        return update;
    }

    @Override
    public GroupResourceConfigurationUpdate getGroupResourceConfigurationById(int configurationUpdateId) {
        GroupResourceConfigurationUpdate update = (GroupResourceConfigurationUpdate)this.entityManager.find(GroupResourceConfigurationUpdate.class, (Object)configurationUpdateId);
        return update;
    }

    @Override
    public PageList<ConfigurationUpdateComposite> findPluginConfigurationUpdateCompositesByParentId(int configurationUpdateId, PageControl pageControl) {
        pageControl.initDefaultOrderingField("cu.modifiedTime");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"PluginConfigurationUpdate.findCompositeByParentUpdateId", (PageControl)pageControl);
        query.setParameter("groupConfigurationUpdateId", (Object)configurationUpdateId);
        long count = this.getPluginConfigurationUpdateCountByParentId(configurationUpdateId);
        List results = query.getResultList();
        return new PageList((Collection)results, (int)count, pageControl);
    }

    @Override
    public PageList<ConfigurationUpdateComposite> findResourceConfigurationUpdateCompositesByParentId(int configurationUpdateId, PageControl pageControl) {
        pageControl.initDefaultOrderingField("cu.modifiedTime");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"ResourceConfigurationUpdate.findCompositeByParentUpdateId", (PageControl)pageControl);
        query.setParameter("groupConfigurationUpdateId", (Object)configurationUpdateId);
        long count = this.getResourceConfigurationUpdateCountByParentId(configurationUpdateId);
        List results = query.getResultList();
        return new PageList((Collection)results, (int)count, pageControl);
    }

    @Override
    public PageList<Integer> findPluginConfigurationUpdatesByParentId(int configurationUpdateId, PageControl pageControl) {
        pageControl.initDefaultOrderingField("cu.modifiedTime");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"PluginConfigurationUpdate.findByParentUpdateId", (PageControl)pageControl);
        query.setParameter("groupConfigurationUpdateId", (Object)configurationUpdateId);
        long count = this.getPluginConfigurationUpdateCountByParentId(configurationUpdateId);
        List results = query.getResultList();
        return new PageList((Collection)results, (int)count, pageControl);
    }

    @Override
    public long getPluginConfigurationUpdateCountByParentId(int configurationUpdateId) {
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"PluginConfigurationUpdate.findByParentUpdateId");
        countQuery.setParameter("groupConfigurationUpdateId", (Object)configurationUpdateId);
        return (Long)countQuery.getSingleResult();
    }

    @Override
    public PageList<Integer> findResourceConfigurationUpdatesByParentId(int groupConfigurationUpdateId, PageControl pageControl) {
        pageControl.initDefaultOrderingField("cu.modifiedTime");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"ResourceConfigurationUpdate.findByParentUpdateId", (PageControl)pageControl);
        query.setParameter("groupConfigurationUpdateId", (Object)groupConfigurationUpdateId);
        long count = this.getResourceConfigurationUpdateCountByParentId(groupConfigurationUpdateId);
        List results = query.getResultList();
        return new PageList((Collection)results, (int)count, pageControl);
    }

    @Override
    public long getResourceConfigurationUpdateCountByParentId(int groupConfigurationUpdateId) {
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"ResourceConfigurationUpdate.findByParentUpdateId");
        countQuery.setParameter("groupConfigurationUpdateId", (Object)groupConfigurationUpdateId);
        return (Long)countQuery.getSingleResult();
    }

    @Override
    public Map<Integer, Configuration> getResourceConfigurationMapForGroupUpdate(Integer groupResourceConfigurationUpdateId) {
        Tuple<String, Integer> groupIdParameter = new Tuple<String, Integer>("groupConfigurationUpdateId", groupResourceConfigurationUpdateId);
        return this.executeGetConfigurationMapQuery("Configuration.getResourceConfigMapByGroupUpdateId", 100, groupIdParameter);
    }

    @Override
    public Map<Integer, Configuration> getPluginConfigurationMapForGroupUpdate(Integer groupPluginConfigurationUpdateId) {
        Tuple<String, Integer> groupIdParameter = new Tuple<String, Integer>("groupConfigurationUpdateId", groupPluginConfigurationUpdateId);
        return this.executeGetConfigurationMapQuery("Configuration.getPluginConfigMapByGroupUpdateId", 100, groupIdParameter);
    }

    @Override
    public Map<Integer, Configuration> getResourceConfigurationMapForCompatibleGroup(ResourceGroup compatibleGroup) {
        Tuple<String, Integer> groupIdParameter = new Tuple<String, Integer>("resourceGroupId", compatibleGroup.getId());
        return this.executeGetConfigurationMapQuery("Configuration.getResourceConfigMapByGroupId", 100, groupIdParameter);
    }

    private Map<Integer, Configuration> executeGetConfigurationMapQuery(String memberQueryName, int maxSize, Tuple<String, Object> ... parameters) {
        int resultsSize;
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)memberQueryName);
        Query query = this.entityManager.createNamedQuery(memberQueryName);
        for (Tuple<String, Object> param : parameters) {
            countQuery.setParameter((String)param.lefty, param.righty);
            query.setParameter((String)param.lefty, param.righty);
        }
        PersistenceUtility.setDataPage((Query)query, (PageControl)new PageControl(0, maxSize));
        long count = (Long)countQuery.getSingleResult();
        if (count > (long)maxSize) {
            this.log.error((Object)("Configuration set contains more than " + maxSize + " members - " + "returning only " + maxSize + " Configurations (the maximum allowed)."));
            resultsSize = maxSize;
        } else {
            resultsSize = (int)count;
        }
        HashMap<Integer, Configuration> results = new HashMap<Integer, Configuration>((int)((double)resultsSize * 1.5));
        List pagedResults = query.getResultList();
        for (Object[] result : pagedResults) {
            results.put((Integer)result[0], (Configuration)result[1]);
        }
        return results;
    }

    @Override
    public PageList<GroupPluginConfigurationUpdate> findGroupPluginConfigurationUpdates(int groupId, PageControl pc) {
        pc.initDefaultOrderingField("modifiedTime", PageOrdering.DESC);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"GroupPluginConfigurationUpdate.findByGroupId", (PageControl)pc);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"GroupPluginConfigurationUpdate.findByGroupId");
        query.setParameter("groupId", (Object)groupId);
        countQuery.setParameter("groupId", (Object)groupId);
        long count = (Long)countQuery.getSingleResult();
        List results = null;
        results = query.getResultList();
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    public PageList<GroupResourceConfigurationUpdate> findGroupResourceConfigurationUpdates(int groupId, PageControl pc) {
        pc.initDefaultOrderingField("modifiedTime", PageOrdering.DESC);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"GroupResourceConfigurationUpdate.findByGroupId", (PageControl)pc);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"GroupResourceConfigurationUpdate.findByGroupId");
        query.setParameter("groupId", (Object)groupId);
        countQuery.setParameter("groupId", (Object)groupId);
        long count = (Long)countQuery.getSingleResult();
        List results = null;
        results = query.getResultList();
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    public ConfigurationUpdateStatus updateGroupPluginConfigurationUpdateStatus(int groupConfigurationUpdateId, String errorMessages) {
        GroupPluginConfigurationUpdate groupUpdate = this.configurationManager.getGroupPluginConfigurationById(groupConfigurationUpdateId);
        Query query = this.entityManager.createNamedQuery("PluginConfigurationUpdate.findStatusByParentUpdateId");
        query.setParameter("groupConfigurationUpdateId", (Object)groupConfigurationUpdateId);
        List updateStatusTuples = query.getResultList();
        ConfigurationUpdateStatus groupUpdateStatus = updateStatusTuples.contains(ConfigurationUpdateStatus.FAILURE) || errorMessages != null ? ConfigurationUpdateStatus.FAILURE : ConfigurationUpdateStatus.SUCCESS;
        groupUpdate.setStatus(groupUpdateStatus);
        groupUpdate.setErrorMessage(errorMessages);
        this.configurationManager.updateGroupConfigurationUpdate((AbstractGroupConfigurationUpdate)groupUpdate);
        return groupUpdateStatus;
    }

    @Override
    public int deleteGroupPluginConfigurationUpdates(Subject subject, Integer resourceGroupId, Integer[] groupPluginConfigurationUpdateIds) {
        int removed = 0;
        for (Integer apcuId : groupPluginConfigurationUpdateIds) {
            try {
                Query q = this.entityManager.createNamedQuery("pluginConfigurationUpdate.deleteGroupUpdate");
                q.setParameter("apcuId", (Object)apcuId);
                q.executeUpdate();
                GroupPluginConfigurationUpdate update = this.getGroupPluginConfigurationById(apcuId);
                this.entityManager.remove((Object)update);
                ++removed;
            }
            catch (Exception e) {
                this.log.error((Object)"Problem removing group plugin configuration update", (Throwable)e);
            }
        }
        return removed;
    }

    @Override
    public int deleteGroupResourceConfigurationUpdates(Subject subject, Integer resourceGroupId, Integer[] groupResourceConfigurationUpdateIds) {
        if (!this.authorizationManager.hasGroupPermission(subject, Permission.CONFIGURE, resourceGroupId)) {
            this.log.error((Object)(subject + " attempted to delete " + groupResourceConfigurationUpdateIds.length + " group resource configuration updates for ResourceGroup[id" + resourceGroupId + "], but did not have the " + Permission.CONFIGURE.name() + " permission for this group"));
            return 0;
        }
        int removed = 0;
        for (Integer arcuId : groupResourceConfigurationUpdateIds) {
            try {
                Query q = this.entityManager.createNamedQuery("ResourceConfigurationUpdate.deleteGroupUpdate");
                q.setParameter("arcuId", (Object)arcuId);
                q.executeUpdate();
                GroupResourceConfigurationUpdate update = this.getGroupResourceConfigurationById(arcuId);
                this.entityManager.remove((Object)update);
                ++removed;
            }
            catch (Exception e) {
                this.log.error((Object)"Problem removing group resource configuration update", (Throwable)e);
            }
        }
        return removed;
    }

    @Override
    public void updateGroupConfigurationUpdate(AbstractGroupConfigurationUpdate groupUpdate) {
        this.entityManager.merge((Object)groupUpdate);
    }

    @Override
    public void deleteConfigurations(List<Integer> configurationIds) {
        if (configurationIds == null || configurationIds.size() == 0) {
            return;
        }
        Query propertiesQuery = this.entityManager.createNamedQuery("Property.deleteByConfigurationIds");
        Query configurationsQuery = this.entityManager.createNamedQuery("Property.deleteByConfigurationIds");
        propertiesQuery.setParameter("configurationIds", configurationIds);
        configurationsQuery.setParameter("configurationIds", configurationIds);
        propertiesQuery.executeUpdate();
        configurationsQuery.executeUpdate();
    }

    @Override
    public void deleteProperties(int[] propertyIds) {
        if (propertyIds == null || propertyIds.length == 0) {
            return;
        }
        Query propertiesQuery = this.entityManager.createNamedQuery("Property.deleteByPropertyIds");
        propertiesQuery.setParameter("propertyIds", (Object)ArrayUtils.wrapInList((int[])propertyIds));
        propertiesQuery.executeUpdate();
    }

    @Override
    public GroupPluginConfigurationUpdate getGroupPluginConfigurationUpdate(Subject subject, int configurationUpdateId) {
        GroupPluginConfigurationUpdate update = this.getGroupPluginConfigurationById(configurationUpdateId);
        int groupId = update.getGroup().getId();
        if (!this.authorizationManager.canViewGroup(subject, groupId)) {
            throw new PermissionException("User[" + subject.getName() + "] does not have permission to view group resourceConfiguration[id=" + configurationUpdateId + "]");
        }
        return update;
    }

    @Override
    public GroupResourceConfigurationUpdate getGroupResourceConfigurationUpdate(Subject subject, int configurationUpdateId) {
        GroupResourceConfigurationUpdate update = this.getGroupResourceConfigurationById(configurationUpdateId);
        int groupId = update.getGroup().getId();
        if (!this.authorizationManager.canViewGroup(subject, groupId)) {
            throw new PermissionException("User[" + subject.getName() + "] does not have permission to view group resourceConfiguration[id=" + configurationUpdateId + "]");
        }
        return update;
    }

    @Override
    public Configuration translateResourceConfiguration(Subject subject, int resourceId, Configuration configuration, boolean fromStructured) {
        if (!this.isStructuredAndRawSupported(resourceId)) {
            throw new TranslationNotSupportedException("The translation operation is only supported for configurations that support both structured and raw.");
        }
        Resource resource = (Resource)this.entityManager.find(Resource.class, (Object)resourceId);
        if (resource == null) {
            throw new NoResultException("Cannot get live configuration for unknown resource [" + resourceId + "]");
        }
        if (!this.authorizationManager.canViewResource(subject, resource.getId())) {
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to view resource configuration for [" + resource + "]");
        }
        try {
            Agent agent = resource.getAgent();
            AgentClient agentClient = this.agentManager.getAgentClient(agent);
            ConfigurationAgentService configService = agentClient.getConfigurationAgentService();
            return configService.merge(configuration, resourceId, fromStructured);
        }
        catch (PluginContainerException e) {
            this.log.error((Object)"An error occurred while trying to translate the configuration.", (Throwable)e);
            return null;
        }
    }

    @Override
    public Configuration mergeConfiguration(Configuration config) {
        Configuration out = (Configuration)this.entityManager.merge((Object)config);
        return out;
    }
}

