/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.content;

import java.util.List;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.content.Distribution;
import org.rhq.core.domain.content.DistributionFile;
import org.rhq.core.domain.content.DistributionType;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.content.DistributionException;
import org.rhq.enterprise.server.content.DistributionManagerLocal;
import org.rhq.enterprise.server.content.DistributionManagerRemote;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class DistributionManagerBean
implements DistributionManagerLocal,
DistributionManagerRemote {
    private final Log log = LogFactory.getLog(this.getClass());
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @Resource(name="RHQ_DS", mappedName="java:/RHQDS")
    private DataSource dataSource;
    @EJB
    private AgentManagerLocal agentManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    private DistributionManagerLocal distributionManager;
    @EJB
    private ResourceTypeManagerLocal resourceTypeManager;

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public Distribution createDistribution(Subject user, String kslabel, String basepath, DistributionType disttype) throws DistributionException {
        DistributionType loaded = this.distributionManager.getDistributionTypeByName(disttype.getName());
        if (loaded != null) {
            disttype = loaded;
        }
        Distribution kstree = new Distribution(kslabel, basepath, disttype);
        this.validateDistTree(kstree);
        this.entityManager.persist((Object)kstree);
        return kstree;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void deleteDistributionMappingsForRepo(Subject user, int repoId) {
        this.log.debug((Object)("User [" + user + "] is removing distribution tree mapping from repo [" + repoId + "]"));
        this.entityManager.createNamedQuery("RepoDistribution.deleteByRepoId").setParameter("repoId", (Object)repoId).executeUpdate();
    }

    @Override
    public void deleteDistributionByDistId(Subject user, int distId) {
        this.log.debug((Object)("User [" + user + "] is deleting distribution tree [" + distId + "]"));
        this.entityManager.flush();
        this.entityManager.clear();
        this.entityManager.createNamedQuery("Distribution.deleteByDistId").setParameter("distid", (Object)distId).executeUpdate();
        Distribution kstree = (Distribution)this.entityManager.find(Distribution.class, (Object)distId);
        if (kstree != null) {
            this.entityManager.remove((Object)kstree);
            this.log.debug((Object)("User [" + user + "] deleted kstree [" + kstree + "]"));
        } else {
            this.log.debug((Object)("Distribution tree ID [" + distId + "] doesn't exist - nothing to delete"));
        }
    }

    @Override
    public Distribution getDistributionByLabel(String kslabel) {
        Query query = this.entityManager.createNamedQuery("Distribution.findByDistLabel");
        query.setParameter("label", (Object)kslabel);
        List results = query.getResultList();
        if (results.size() > 0) {
            return (Distribution)results.get(0);
        }
        return null;
    }

    @Override
    public Distribution getDistributionByPath(String basepath) {
        Query query = this.entityManager.createNamedQuery("Distribution.findByDistPath");
        query.setParameter("path", (Object)basepath);
        List results = query.getResultList();
        if (results.size() > 0) {
            return (Distribution)results.get(0);
        }
        return null;
    }

    @Override
    public DistributionType getDistributionTypeByName(String name) {
        Query query = this.entityManager.createNamedQuery("DistributionType.findByName");
        query.setParameter("name", (Object)name);
        List results = query.getResultList();
        if (results.size() > 0) {
            return (DistributionType)results.get(0);
        }
        return null;
    }

    @Override
    public List<DistributionFile> getDistributionFilesByDistId(int distId) {
        Query query = this.entityManager.createNamedQuery("DistributionFile.selectByDistId");
        query.setParameter("distId", (Object)distId);
        List results = query.getResultList();
        if (results.size() > 0) {
            return results;
        }
        return null;
    }

    @Override
    public void deleteDistributionFilesByDistId(Subject user, int distId) {
        this.log.debug((Object)("User [" + user + "] is deleting distribution file from distribution [" + distId + "]"));
        this.entityManager.flush();
        this.entityManager.clear();
        Query querydel = this.entityManager.createNamedQuery("DistributionFile.selectByDistId");
        querydel.setParameter("distId", (Object)distId);
        querydel.executeUpdate();
        DistributionFile distFile = (DistributionFile)this.entityManager.find(DistributionFile.class, (Object)distId);
        if (distFile != null) {
            this.entityManager.remove((Object)distFile);
            this.log.debug((Object)("User [" + user + "] deleted distribution file [" + distFile + "]"));
        } else {
            this.log.debug((Object)("Distribution file [" + distFile + "] doesn't exist - nothing to delete"));
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void deleteDistributionTypeByName(Subject subject, String name) {
        Query query = this.entityManager.createNamedQuery("DistributionType.deleteByName");
        query.setParameter("name", (Object)name);
        query.executeUpdate();
    }

    public void validateDistTree(Distribution kstree) throws DistributionException {
        if (kstree.getLabel() == null || kstree.getLabel().trim().equals("")) {
            throw new DistributionException("A valid Distribution tree is required");
        }
        Distribution kstreeobj = this.getDistributionByLabel(kstree.getLabel());
        if (kstreeobj != null) {
            throw new DistributionException("There is already a kstree with the name of [" + kstree.getLabel() + "]");
        }
    }
}

