/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.content;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.IgnoreDependency;
import org.jboss.annotation.ejb.TransactionTimeout;
import org.quartz.CronExpression;
import org.quartz.SchedulerException;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.content.Advisory;
import org.rhq.core.domain.content.ContentSource;
import org.rhq.core.domain.content.ContentSyncResults;
import org.rhq.core.domain.content.ContentSyncStatus;
import org.rhq.core.domain.content.Distribution;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.PackageVersionContentSource;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.content.RepoAdvisory;
import org.rhq.core.domain.content.RepoContentSource;
import org.rhq.core.domain.content.RepoDistribution;
import org.rhq.core.domain.content.RepoGroup;
import org.rhq.core.domain.content.RepoGroupType;
import org.rhq.core.domain.content.RepoPackageVersion;
import org.rhq.core.domain.content.RepoRelationship;
import org.rhq.core.domain.content.RepoRelationshipType;
import org.rhq.core.domain.content.RepoRepoRelationship;
import org.rhq.core.domain.content.RepoSyncResults;
import org.rhq.core.domain.content.ResourceRepo;
import org.rhq.core.domain.content.composite.RepoComposite;
import org.rhq.core.domain.content.transfer.SubscribedRepo;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.PackageVersionCriteria;
import org.rhq.core.domain.criteria.RepoCriteria;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.server.PersistenceUtility;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.content.ContentException;
import org.rhq.enterprise.server.content.ContentManagerHelper;
import org.rhq.enterprise.server.content.ContentSourceManagerLocal;
import org.rhq.enterprise.server.content.RepoException;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.content.RepoManagerRemote;
import org.rhq.enterprise.server.plugin.pc.content.ContentProviderManager;
import org.rhq.enterprise.server.plugin.pc.content.ContentServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.content.RepoDetails;
import org.rhq.enterprise.server.plugin.pc.content.RepoGroupDetails;
import org.rhq.enterprise.server.plugin.pc.content.RepoImportReport;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaQueryRunner;
import org.rhq.enterprise.server.util.QueryUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class RepoManagerBean
implements RepoManagerLocal,
RepoManagerRemote {
    private static final String PARENT_RELATIONSHIP_NAME = "parent";
    private final Log log = LogFactory.getLog(RepoManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private AuthorizationManagerLocal authzManager;
    @IgnoreDependency
    @EJB
    private ContentSourceManagerLocal contentSourceManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private RepoManagerLocal repoManager;

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void deleteRepo(Subject subject, int repoId) {
        this.log.debug((Object)("User [" + subject + "] is deleting repository with id [" + repoId + "]..."));
        this.entityManager.flush();
        this.entityManager.clear();
        this.entityManager.createNamedQuery("ResourceRepo.deleteByRepoId").setParameter("repoId", (Object)repoId).executeUpdate();
        this.entityManager.createNamedQuery("RepoContentSource.deleteByRepoId").setParameter("repoId", (Object)repoId).executeUpdate();
        this.entityManager.createNamedQuery("RepoPackageVersion.deleteByRepoId").setParameter("repoId", (Object)repoId).executeUpdate();
        Repo repo = (Repo)this.entityManager.find(Repo.class, (Object)repoId);
        if (repo != null) {
            this.entityManager.remove((Object)repo);
            this.log.debug((Object)("User [" + subject + "] deleted repository [" + repo + "]"));
        } else {
            this.log.debug((Object)("Repository with id [" + repoId + "] doesn't exist - nothing to delete"));
        }
        this.contentSourceManager.purgeOrphanedPackageVersions(subject);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void deleteRepoGroup(Subject subject, int repoGroupId) {
        RepoGroup deleteMe = this.getRepoGroup(subject, repoGroupId);
        this.entityManager.remove((Object)deleteMe);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<Repo> findRepos(Subject subject, PageControl pc) {
        pc.initDefaultOrderingField("c.name");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Repo.findAll", (PageControl)pc);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Repo.findAll");
        List results = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public Repo getRepo(Subject subject, int repoId) {
        Repo repo = (Repo)this.entityManager.find(Repo.class, (Object)repoId);
        if (repo != null && repo.getRepoContentSources() != null) {
            repo.getRepoContentSources().size();
        }
        return repo;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public RepoGroup getRepoGroup(Subject subject, int repoGroupId) {
        RepoGroup repoGroup = (RepoGroup)this.entityManager.find(RepoGroup.class, (Object)repoGroupId);
        return repoGroup;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<ContentSource> findAssociatedContentSources(Subject subject, int repoId, PageControl pc) {
        pc.initDefaultOrderingField("cs.id");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"ContentSource.findByRepoId", (PageControl)pc);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"ContentSource.findByRepoId");
        query.setParameter("id", (Object)repoId);
        countQuery.setParameter("id", (Object)repoId);
        List results = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<Resource> findSubscribedResources(Subject subject, int repoId, PageControl pc) {
        pc.initDefaultOrderingField("rc.resource.id");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Repo.findSubscriberResources", (PageControl)pc);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Repo.findSubscriberResources");
        query.setParameter("id", (Object)repoId);
        countQuery.setParameter("id", (Object)repoId);
        List results = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    public PageList<RepoComposite> findResourceSubscriptions(Subject subject, int resourceId, PageControl pc) {
        pc.initDefaultOrderingField("c.id");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Repo.findRepoCompositesByResourceId", (PageControl)pc);
        Query countQuery = this.entityManager.createNamedQuery("Repo.findRepoCompositesByResourceId_count");
        query.setParameter("resourceId", (Object)resourceId);
        countQuery.setParameter("resourceId", (Object)resourceId);
        List results = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public List<SubscribedRepo> findSubscriptions(Subject subject, int resourceId) {
        ArrayList<SubscribedRepo> list = new ArrayList<SubscribedRepo>();
        PageControl pc = new PageControl();
        for (RepoComposite repoComposite : this.findResourceSubscriptions(subject, resourceId, pc)) {
            Repo repo = repoComposite.getRepo();
            SubscribedRepo summary = new SubscribedRepo(repo.getId(), repo.getName());
            list.add(summary);
        }
        return list;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<RepoComposite> findAvailableResourceSubscriptions(Subject subject, int resourceId, PageControl pc) {
        pc.initDefaultOrderingField("c.id");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Repo.findAvailableRepoCompositesByResourceId", (PageControl)pc);
        Query countQuery = this.entityManager.createNamedQuery("Repo.findAvailableRepoCompositesByResourceId_count");
        query.setParameter("resourceId", (Object)resourceId);
        countQuery.setParameter("resourceId", (Object)resourceId);
        List results = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    public List<RepoComposite> findResourceSubscriptions(int resourceId) {
        Query query = this.entityManager.createNamedQuery("Repo.findRepoCompositesByResourceId");
        query.setParameter("resourceId", (Object)resourceId);
        List results = query.getResultList();
        return results;
    }

    @Override
    public List<RepoComposite> findAvailableResourceSubscriptions(int resourceId) {
        Query query = this.entityManager.createNamedQuery("Repo.findAvailableRepoCompositesByResourceId");
        query.setParameter("resourceId", (Object)resourceId);
        List results = query.getResultList();
        return results;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<PackageVersion> findPackageVersionsInRepo(Subject subject, int repoId, PageControl pc) {
        pc.initDefaultOrderingField("pv.generalPackage.name, pv.version");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"PackageVersion.findByRepoIdWithPackage", (PageControl)pc);
        query.setParameter("repoId", (Object)repoId);
        List results = query.getResultList();
        long count = this.getPackageVersionCountFromRepo(subject, null, repoId);
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<PackageVersion> findPackageVersionsInRepo(Subject subject, int repoId, String filter, PageControl pc) {
        pc.initDefaultOrderingField("pv.generalPackage.name, pv.version");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"PackageVersion.findByRepoIdWithPackageFiltered", (PageControl)pc);
        query.setParameter("repoId", (Object)repoId);
        query.setParameter("filter", (Object)QueryUtility.formatSearchParameter(filter));
        query.setParameter("escapeChar", (Object)QueryUtility.getEscapeCharacter());
        List results = query.getResultList();
        long count = this.getPackageVersionCountFromRepo(subject, filter, repoId);
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public Repo updateRepo(Subject subject, Repo repo) throws RepoException {
        this.validateFields(repo);
        this.getRepo(subject, repo.getId());
        this.log.debug((Object)("User [" + subject + "] is updating [" + repo + "]..."));
        repo = (Repo)this.entityManager.merge((Object)repo);
        this.log.debug((Object)("User [" + subject + "] updated [" + repo + "]."));
        try {
            ContentServerPluginContainer pc = ContentManagerHelper.getPluginContainer();
            pc.unscheduleRepoSyncJob(repo);
            pc.scheduleRepoSyncJob(repo);
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to reschedule repository synchronization job for [" + repo + "]."), (Throwable)e);
        }
        return repo;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public Repo createRepo(Subject subject, Repo repo) throws RepoException {
        this.validateRepo(repo);
        this.log.debug((Object)("User [" + subject + "] is creating [" + repo + "]..."));
        this.entityManager.persist((Object)repo);
        this.log.debug((Object)("User [" + subject + "] created [" + repo + "]."));
        if (!repo.isCandidate()) {
            try {
                ContentServerPluginContainer pc = ContentManagerHelper.getPluginContainer();
                pc.scheduleRepoSyncJob(repo);
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to schedule repository synchronization job for [" + repo + "]."), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return repo;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void deleteCandidatesWithOnlyContentSource(Subject subject, int contentSourceId) {
        Query query = this.entityManager.createNamedQuery("Repo.findCandidatesWithOnlyContentSource");
        query.setParameter("contentSourceId", (Object)contentSourceId);
        List repoList = query.getResultList();
        for (Repo deleteMe : repoList) {
            this.deleteRepo(subject, deleteMe.getId());
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void processRepoImportReport(Subject subject, RepoImportReport report, int contentSourceId, StringBuilder result) {
        boolean autoImport = report.getRepoGroups().isEmpty() && report.getRepos().size() == 1;
        List<RepoGroupDetails> repoGroups = report.getRepoGroups();
        ArrayList<RepoGroupDetails> importedRepoGroups = new ArrayList<RepoGroupDetails>();
        for (RepoGroupDetails createMe : repoGroups) {
            String name = createMe.getName();
            RepoGroup existingGroup = this.getRepoGroupByName(name);
            if (existingGroup != null) continue;
            existingGroup = new RepoGroup(name);
            existingGroup.setDescription(createMe.getDescription());
            RepoGroupType groupType = this.getRepoGroupTypeByName(subject, createMe.getTypeName());
            existingGroup.setRepoGroupType(groupType);
            try {
                this.createRepoGroup(subject, existingGroup);
                importedRepoGroups.add(createMe);
            }
            catch (RepoException e) {
                if (e.getType() == RepoException.RepoExceptionType.NAME_ALREADY_EXISTS) {
                    result.append("Skipping existing repository group [").append(name).append("]").append('\n');
                    continue;
                }
                this.log.error((Object)("Error adding repository group [" + name + "]"), (Throwable)e);
                result.append("Could not add repository group [").append(name).append("]. See log for more information.").append('\n');
            }
        }
        if (importedRepoGroups.isEmpty()) {
            result.append("There are no new repository groups since the last time this content source was synchronized.\n");
        } else {
            result.append("Imported the following [").append(importedRepoGroups.size()).append("] repository group(s): ").append(importedRepoGroups).append('\n');
        }
        RepoCriteria candidateReposCriteria = new RepoCriteria();
        candidateReposCriteria.addFilterContentSourceIds(new Integer[]{contentSourceId});
        candidateReposCriteria.addFilterCandidate(Boolean.valueOf(true));
        PageList<Repo> candidatesForThisProvider = this.findReposByCriteria(subject, candidateReposCriteria);
        List<RepoDetails> repos = report.getRepos();
        ArrayList<RepoDetails> importedRepos = new ArrayList<RepoDetails>();
        for (RepoDetails createMe : repos) {
            if (createMe.getParentRepoName() != null) continue;
            try {
                if (this.addCandidateRepo(contentSourceId, createMe, autoImport)) {
                    importedRepos.add(createMe);
                }
                this.removeRepoFromList(createMe.getName(), (List<Repo>)candidatesForThisProvider);
            }
            catch (Exception e) {
                if (e instanceof RepoException && ((RepoException)e).getType() == RepoException.RepoExceptionType.NAME_ALREADY_EXISTS) {
                    result.append("Skipping addition of existing repository [").append(createMe.getName()).append("]").append('\n');
                    continue;
                }
                this.log.error((Object)("Error processing repository [" + createMe + "]"), (Throwable)e);
                result.append("Could not add repository [").append(createMe.getName()).append("]. See log for more information.").append('\n');
            }
        }
        for (RepoDetails createMe : repos) {
            if (createMe.getParentRepoName() == null) continue;
            try {
                if (this.addCandidateRepo(contentSourceId, createMe, autoImport)) {
                    importedRepos.add(createMe);
                }
                this.removeRepoFromList(createMe.getName(), (List<Repo>)candidatesForThisProvider);
            }
            catch (Exception e) {
                this.log.error((Object)("Error processing repository [" + createMe + "]"), (Throwable)e);
                result.append("Could not add repository [").append(createMe.getName()).append("]. See log for more information.").append('\n');
            }
        }
        if (importedRepos.isEmpty()) {
            result.append("There are no new repositories since the last time this content source was synchronized.\n");
        } else {
            result.append("Imported the following ").append(importedRepos.size()).append(" repository(s): ").append(importedRepos).append('\n');
        }
        if (!candidatesForThisProvider.isEmpty()) {
            for (Repo deleteMe : candidatesForThisProvider) {
                this.deleteRepo(subject, deleteMe.getId());
            }
            result.append("Deleted the following ").append(candidatesForThisProvider.size()).append(" obsolete repository(s): ").append(candidatesForThisProvider).append('\n');
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void importCandidateRepo(Subject subject, List<Integer> repoIds) throws RepoException {
        for (Integer repoId : repoIds) {
            Repo repo = (Repo)this.entityManager.find(Repo.class, (Object)repoId);
            if (repo == null) {
                throw new RepoException("Unable to find candidate repository with id " + repoId + " for import.");
            }
            if (!repo.isCandidate()) {
                throw new RepoException("Unable to import repository with id " + repoId + ", because it is already imported.");
            }
            repo.setCandidate(false);
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public RepoGroup createRepoGroup(Subject subject, RepoGroup repoGroup) throws RepoException {
        this.validateRepoGroup(repoGroup);
        this.entityManager.persist((Object)repoGroup);
        return repoGroup;
    }

    @Override
    public List<Repo> getRepoByName(String name) {
        Query query = this.entityManager.createNamedQuery("Repo.findByName");
        query.setParameter("name", (Object)name);
        List results = query.getResultList();
        return results;
    }

    @Override
    public RepoGroup getRepoGroupByName(String name) {
        Query query = this.entityManager.createNamedQuery("RepoGroup.findByName");
        query.setParameter("name", (Object)name);
        List results = query.getResultList();
        if (results.size() > 0) {
            return (RepoGroup)results.get(0);
        }
        return null;
    }

    @Override
    public RepoGroupType getRepoGroupTypeByName(Subject subject, String name) {
        Query query = this.entityManager.createNamedQuery("RepoGroupType.findByName");
        query.setParameter("name", (Object)name);
        List results = query.getResultList();
        if (results.size() > 0) {
            return (RepoGroupType)results.get(0);
        }
        return null;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void addContentSourcesToRepo(Subject subject, int repoId, int[] contentSourceIds) throws Exception {
        Repo repo = (Repo)this.entityManager.find(Repo.class, (Object)repoId);
        if (repo == null) {
            throw new Exception("There is no repo with an ID [" + repoId + "]");
        }
        repo.setLastModifiedDate(System.currentTimeMillis());
        this.log.debug((Object)("User [" + subject + "] is adding content sources to repo [" + repo + "]"));
        ContentServerPluginContainer pc = ContentManagerHelper.getPluginContainer();
        Query q = this.entityManager.createNamedQuery("PackageVersionContentSource.findByContentSourceIdNoFetch");
        for (int id : contentSourceIds) {
            ContentSource cs = (ContentSource)this.entityManager.find(ContentSource.class, (Object)id);
            if (cs == null) {
                throw new Exception("There is no content source with id [" + id + "]");
            }
            RepoContentSource repoContentSourceMapping = repo.addContentSource(cs);
            this.entityManager.persist((Object)repoContentSourceMapping);
            HashSet alreadyAssociatedPVs = new HashSet(repo.getPackageVersions());
            q.setParameter("id", (Object)cs.getId());
            List pvcss = q.getResultList();
            for (PackageVersionContentSource pvcs : pvcss) {
                PackageVersion pv = pvcs.getPackageVersionContentSourcePK().getPackageVersion();
                if (alreadyAssociatedPVs.contains(pv)) continue;
                RepoPackageVersion mapping = new RepoPackageVersion(repo, pv);
                this.entityManager.persist((Object)mapping);
            }
            this.entityManager.flush();
            this.entityManager.clear();
        }
    }

    @Override
    public void simpleAddContentSourcesToRepo(Subject subject, int repoId, int[] contentSourceIds) throws Exception {
        Repo repo = (Repo)this.entityManager.find(Repo.class, (Object)repoId);
        if (repo == null) {
            throw new Exception("There is no repo with an ID [" + repoId + "]");
        }
        for (int id : contentSourceIds) {
            ContentSource cs = (ContentSource)this.entityManager.find(ContentSource.class, (Object)id);
            if (cs == null) {
                throw new Exception("There is no content source with id [" + id + "]");
            }
            RepoContentSource ccsmapping = repo.addContentSource(cs);
            this.entityManager.persist((Object)ccsmapping);
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void addPackageVersionsToRepo(Subject subject, int repoId, int[] packageVersionIds) {
        Repo repo = (Repo)this.entityManager.find(Repo.class, (Object)repoId);
        for (int packageVersionId : packageVersionIds) {
            PackageVersion packageVersion = (PackageVersion)this.entityManager.find(PackageVersion.class, (Object)packageVersionId);
            RepoPackageVersion mapping = new RepoPackageVersion(repo, packageVersion);
            this.entityManager.persist((Object)mapping);
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void removeContentSourcesFromRepo(Subject subject, int repoId, int[] contentSourceIds) throws RepoException {
        Repo repo = this.getRepo(subject, repoId);
        this.log.debug((Object)("User [" + subject + "] is removing content sources from repo [" + repo + "]"));
        Set currentSet = repo.getRepoContentSources();
        if (currentSet != null && currentSet.size() > 0) {
            HashSet<RepoContentSource> toBeRemoved = new HashSet<RepoContentSource>();
            block0: for (RepoContentSource current : currentSet) {
                for (int id : contentSourceIds) {
                    if (id != current.getRepoContentSourcePK().getContentSource().getId()) continue;
                    toBeRemoved.add(current);
                    continue block0;
                }
            }
            for (RepoContentSource doomed : toBeRemoved) {
                this.entityManager.remove((Object)doomed);
            }
            currentSet.removeAll(toBeRemoved);
        }
    }

    @Override
    public void subscribeResourceToRepos(Subject subject, int resourceId, int[] repoIds) {
        if (repoIds == null || repoIds.length == 0) {
            return;
        }
        if (!this.authzManager.hasResourcePermission(subject, Permission.MANAGE_CONTENT, resourceId)) {
            throw new PermissionException("[" + subject + "] does not have permission to subscribe this resource to repos");
        }
        Resource resource = (Resource)this.entityManager.find(Resource.class, (Object)resourceId);
        if (resource == null) {
            throw new RuntimeException("There is no resource with the ID [" + resourceId + "]");
        }
        Query q = this.entityManager.createNamedQuery("Repo.findByIds");
        ArrayList<Integer> idList = new ArrayList<Integer>(repoIds.length);
        int[] arr$ = repoIds;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer id = arr$[i$];
            idList.add(id);
        }
        q.setParameter("ids", idList);
        List repos = q.getResultList();
        if (repos.size() != repoIds.length) {
            throw new RuntimeException("One or more of the repos do not exist [" + idList + "]->[" + repos + "]");
        }
        for (Repo repo : repos) {
            ResourceRepo mapping = repo.addResource(resource);
            this.entityManager.persist((Object)mapping);
        }
    }

    @Override
    public void unsubscribeResourceFromRepos(Subject subject, int resourceId, int[] repoIds) {
        if (repoIds == null || repoIds.length == 0) {
            return;
        }
        if (!this.authzManager.hasResourcePermission(subject, Permission.MANAGE_CONTENT, resourceId)) {
            throw new PermissionException("[" + subject + "] does not have permission to unsubscribe this resource from repos");
        }
        Resource resource = (Resource)this.entityManager.find(Resource.class, (Object)resourceId);
        if (resource == null) {
            throw new RuntimeException("There is no resource with the ID [" + resourceId + "]");
        }
        Query q = this.entityManager.createNamedQuery("Repo.findByIds");
        ArrayList<Integer> idList = new ArrayList<Integer>(repoIds.length);
        int[] arr$ = repoIds;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer id = arr$[i$];
            idList.add(id);
        }
        q.setParameter("ids", idList);
        List repos = q.getResultList();
        if (repos.size() != repoIds.length) {
            throw new RuntimeException("One or more of the repos do not exist [" + idList + "]->[" + repos + "]");
        }
        for (Repo repo : repos) {
            ResourceRepo mapping = repo.removeResource(resource);
            this.entityManager.remove((Object)mapping);
        }
    }

    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public long getPackageVersionCountFromRepo(Subject subject, String filter, int repoId) {
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"PackageVersion.findByRepoIdFiltered");
        countQuery.setParameter("repoId", (Object)repoId);
        countQuery.setParameter("filter", filter == null ? null : "%" + filter.toUpperCase() + "%");
        return (Long)countQuery.getSingleResult();
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public long getPackageVersionCountFromRepo(Subject subject, int repoId) {
        return this.getPackageVersionCountFromRepo(subject, null, repoId);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<Repo> findReposByCriteria(Subject subject, RepoCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator((Criteria)criteria);
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<PackageVersion> findPackageVersionsInRepoByCriteria(Subject subject, PackageVersionCriteria criteria) {
        Integer repoId = criteria.getFilterRepoId();
        if (null == repoId || repoId < 1) {
            throw new IllegalArgumentException("Illegal filterResourceId: " + repoId);
        }
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator((Criteria)criteria);
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void addRepoRelationship(Subject subject, int repoId, int relatedRepoId, String relationshipTypeName) {
        Repo repo = (Repo)this.entityManager.find(Repo.class, (Object)repoId);
        Repo relatedRepo = (Repo)this.entityManager.find(Repo.class, (Object)relatedRepoId);
        Query typeQuery = this.entityManager.createNamedQuery("RepoRelationshipType.findByName");
        typeQuery.setParameter("name", (Object)relationshipTypeName);
        RepoRelationshipType relationshipType = (RepoRelationshipType)typeQuery.getSingleResult();
        RepoRelationship repoRelationship = new RepoRelationship();
        repoRelationship.setRelatedRepo(relatedRepo);
        repoRelationship.setRepoRelationshipType(relationshipType);
        repoRelationship.addRepo(repo);
        this.entityManager.persist((Object)repoRelationship);
        relatedRepo.addRepoRelationship(repoRelationship);
        RepoRepoRelationship repoRepoRelationship = new RepoRepoRelationship(repo, repoRelationship);
        this.entityManager.persist((Object)repoRepoRelationship);
        repo.addRepoRelationship(repoRelationship);
    }

    private void validateFields(Repo repo) throws RepoException {
        if (repo.getName() == null || repo.getName().trim().equals("")) {
            throw new RepoException("Repo name is required");
        }
        if (repo.getSyncSchedule() != null) {
            try {
                CronExpression ce = new CronExpression(repo.getSyncSchedule());
            }
            catch (ParseException e) {
                throw new RepoException("Repo sync schedule is not a vaild format.");
            }
        }
    }

    private void validateRepo(Repo c) throws RepoException {
        this.validateFields(c);
        List<Repo> repos = this.getRepoByName(c.getName());
        if (repos.size() != 0) {
            RepoException e = new RepoException("There is already a repo with the name of [" + c.getName() + "]");
            e.setType(RepoException.RepoExceptionType.NAME_ALREADY_EXISTS);
            throw e;
        }
    }

    private void validateRepoGroup(RepoGroup repoGroup) throws RepoException {
        if (repoGroup.getName() == null || repoGroup.getName().trim().equals("")) {
            throw new RepoException("Repo group name is required");
        }
        RepoGroup existingRepoGroup = this.getRepoGroupByName(repoGroup.getName());
        if (existingRepoGroup != null) {
            RepoException e = new RepoException("There is already a repo group with the name [" + repoGroup.getName() + "]");
            e.setType(RepoException.RepoExceptionType.NAME_ALREADY_EXISTS);
            throw e;
        }
    }

    private boolean addCandidateRepo(int contentSourceId, RepoDetails createMe, boolean autoImport) throws Exception {
        Subject overlord = this.subjectManager.getOverlord();
        String name = createMe.getName();
        List<Repo> existingRepos = this.getRepoByName(name);
        if (!existingRepos.isEmpty()) {
            for (Repo existingRepo : existingRepos) {
                this.addContentSourcesToRepo(overlord, existingRepo.getId(), new int[]{contentSourceId});
            }
            return false;
        }
        Repo addMe = new Repo(name);
        addMe.setCandidate(!autoImport);
        addMe.setDescription(createMe.getDescription());
        String createMeGroup = createMe.getRepoGroup();
        if (createMeGroup != null) {
            RepoGroup group = this.getRepoGroupByName(createMeGroup);
            addMe.addRepoGroup(group);
        }
        addMe = this.createRepo(overlord, addMe);
        this.addContentSourcesToRepo(overlord, addMe.getId(), new int[]{contentSourceId});
        String parentName = createMe.getParentRepoName();
        if (parentName != null) {
            List<Repo> parentList = this.getRepoByName(parentName);
            if (parentList.size() == 0) {
                String error = "Attempting to create repo [" + name + "] with parent [" + parentName + "] but cannot find the parent";
                this.log.error((Object)error);
                throw new RepoException(error);
            }
            Repo parent = parentList.get(0);
            this.addRepoRelationship(overlord, addMe.getId(), parent.getId(), PARENT_RELATIONSHIP_NAME);
        }
        return true;
    }

    private void removeRepoFromList(String repoName, List<Repo> repoList) {
        Repo deleteMe = null;
        for (Repo checkMe : repoList) {
            if (!checkMe.getName().equals(repoName)) continue;
            deleteMe = checkMe;
            break;
        }
        if (deleteMe != null) {
            repoList.remove(deleteMe);
        }
    }

    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public long getDistributionCountFromRepo(Subject subject, int repoId) {
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"RepoDistribution.queryFindByRepoId");
        countQuery.setParameter("repoId", (Object)repoId);
        return (Long)countQuery.getSingleResult();
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<Distribution> findAssociatedDistributions(Subject subject, int repoid, PageControl pc) {
        pc.setPrimarySort("rkt.id", PageOrdering.ASC);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"RepoDistribution.queryFindByRepoId", (PageControl)pc);
        query.setParameter("repoId", (Object)repoid);
        List results = query.getResultList();
        ArrayList<Distribution> distros = new ArrayList<Distribution>();
        for (RepoDistribution result : results) {
            distros.add(result.getRepoDistributionPK().getDistribution());
        }
        long count = this.getDistributionCountFromRepo(subject, repoid);
        return new PageList(distros, (int)count, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<Advisory> findAssociatedAdvisory(Subject subject, int repoid, PageControl pc) {
        pc.setPrimarySort("rkt.id", PageOrdering.ASC);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"RepoAdvisory.queryFindByRepoId", (PageControl)pc);
        query.setParameter("repoId", (Object)repoid);
        List results = query.getResultList();
        ArrayList<Advisory> advs = new ArrayList<Advisory>();
        for (RepoAdvisory result : results) {
            advs.add(result.getAdvisory());
        }
        this.log.debug((Object)("list of Advisory : " + advs + " associated to the repo: " + repoid));
        long count = this.getAdvisoryCountFromRepo(subject, repoid);
        return new PageList(advs, (int)count, pc);
    }

    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public long getAdvisoryCountFromRepo(Subject subject, int repoId) {
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"RepoAdvisory.queryFindByRepoId");
        countQuery.setParameter("repoId", (Object)repoId);
        return (Long)countQuery.getSingleResult();
    }

    @Override
    public String calculateSyncStatus(Subject subject, int repoId) {
        Repo found = this.getRepo(subject, repoId);
        List syncResults = found.getSyncResults();
        int latestIndex = syncResults.size() - 1;
        if (!syncResults.isEmpty() && syncResults.get(latestIndex) != null) {
            RepoSyncResults results = (RepoSyncResults)syncResults.get(latestIndex);
            return results.getStatus().toString();
        }
        return ContentSyncStatus.NONE.toString();
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public RepoSyncResults getMostRecentSyncResults(Subject subject, int repoId) {
        Repo found = this.getRepo(subject, repoId);
        List syncResults = found.getSyncResults();
        int latestIndex = syncResults.size() - 1;
        if (syncResults != null && !syncResults.isEmpty() && syncResults.get(latestIndex) != null) {
            return (RepoSyncResults)syncResults.get(latestIndex);
        }
        return null;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public int synchronizeRepos(Subject subject, Integer[] repoIds) throws Exception {
        int syncCount = 0;
        ContentServerPluginContainer pc = ContentManagerHelper.getPluginContainer();
        for (Integer id : repoIds) {
            try {
                Repo repo = this.getRepo(subject, id);
                pc.syncRepoNow(repo);
                ++syncCount;
            }
            catch (SchedulerException e) {
                this.log.error((Object)("Error synchronizing repo with id [" + id + "]"), (Throwable)e);
            }
        }
        return syncCount;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    @TransactionTimeout(value=86400)
    public int internalSynchronizeRepos(Subject subject, Integer[] repoIds) throws InterruptedException {
        ContentServerPluginContainer pc;
        try {
            pc = ContentManagerHelper.getPluginContainer();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ContentProviderManager providerManager = pc.getAdapterManager();
        int syncCount = 0;
        for (Integer id : repoIds) {
            boolean syncExecuted = providerManager.synchronizeRepo(id);
            if (!syncExecuted) continue;
            ++syncCount;
        }
        return syncCount;
    }

    @Override
    public void cancelSync(Subject subject, int repoId) throws ContentException {
        ContentServerPluginContainer pc;
        try {
            pc = ContentManagerHelper.getPluginContainer();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Repo repo = this.getRepo(subject, repoId);
        try {
            pc.cancelRepoSync(subject, repo);
        }
        catch (SchedulerException e) {
            throw new ContentException(e);
        }
        RepoSyncResults results = this.getMostRecentSyncResults(subject, repo.getId());
        results.setStatus(ContentSyncStatus.CANCELLING);
        this.repoManager.mergeRepoSyncResults(results);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public RepoSyncResults persistRepoSyncResults(RepoSyncResults results) {
        ContentManagerHelper helper = new ContentManagerHelper(this.entityManager);
        Query q = this.entityManager.createNamedQuery("RepoSyncResults.getInProgressByRepoId");
        q.setParameter("repoId", (Object)results.getRepo().getId());
        RepoSyncResults persistedSyncResults = (RepoSyncResults)helper.persistSyncResults(q, (ContentSyncResults)results);
        return null != persistedSyncResults ? persistedSyncResults : results;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<RepoSyncResults> getRepoSyncResults(Subject subject, int repoId, PageControl pc) {
        pc.initDefaultOrderingField("cssr.startTime", PageOrdering.DESC);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"RepoSyncResults.getAllByRepoId", (PageControl)pc);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"RepoSyncResults.getAllByRepoId");
        query.setParameter("repoId", (Object)repoId);
        countQuery.setParameter("repoId", (Object)repoId);
        List results = query.getResultList();
        long count = (Long)countQuery.getSingleResult();
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public RepoSyncResults mergeRepoSyncResults(RepoSyncResults results) {
        RepoSyncResults retval = (RepoSyncResults)this.entityManager.merge((Object)results);
        return retval;
    }

    @Override
    public RepoSyncResults getRepoSyncResults(int resultsId) {
        return (RepoSyncResults)this.entityManager.find(RepoSyncResults.class, (Object)resultsId);
    }
}

