/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc.bundle;

import org.rhq.enterprise.server.bundle.RecipeParseResults;
import org.rhq.enterprise.server.plugin.pc.ServerPluginComponent;
import org.rhq.enterprise.server.plugin.pc.ServerPluginEnvironment;
import org.rhq.enterprise.server.plugin.pc.ServerPluginManager;
import org.rhq.enterprise.server.plugin.pc.bundle.BundleServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.bundle.BundleServerPluginFacet;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.bundle.BundlePluginDescriptorType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.bundle.BundleType;

public class BundleServerPluginManager
extends ServerPluginManager {
    public BundleServerPluginManager(BundleServerPluginContainer pc) {
        super(pc);
    }

    public void initialize() throws Exception {
        super.initialize();
    }

    protected void loadPlugin(ServerPluginEnvironment env, boolean enabled) throws Exception {
        if (enabled) {
            BundlePluginDescriptorType descriptor = (BundlePluginDescriptorType)env.getPluginDescriptor();
            BundleType bt = descriptor.getBundle();
            if (bt == null || bt.getType() == null || bt.getType().length() == 0) {
                throw new Exception("The bundle plugin [" + env.getPluginKey().getPluginName() + "] did not specify a valid bundle type in its descriptor");
            }
            ServerPluginComponent component = this.createServerPluginComponent(env);
            if (!(component instanceof BundleServerPluginFacet)) {
                throw new Exception("The bundle plugin [" + env.getPluginKey().getPluginName() + "] has an invalid component [" + component + "]. It does not implement [" + BundleServerPluginFacet.class + "]");
            }
        }
        super.loadPlugin(env, enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecipeParseResults parseRecipe(String bundleTypeName, String recipe) throws Exception {
        if (bundleTypeName == null) {
            throw new IllegalArgumentException("bundleTypeName == null");
        }
        if (recipe == null) {
            throw new IllegalArgumentException("recipe == null");
        }
        ServerPluginEnvironment pluginEnv = null;
        for (ServerPluginEnvironment env : this.getPluginEnvironments()) {
            BundlePluginDescriptorType descriptor = (BundlePluginDescriptorType)env.getPluginDescriptor();
            if (!bundleTypeName.equals(descriptor.getBundle().getType())) continue;
            pluginEnv = env;
            break;
        }
        if (pluginEnv == null) {
            throw new IllegalArgumentException("Bundle type [" + bundleTypeName + "] is not known to the system");
        }
        String pluginName = pluginEnv.getPluginKey().getPluginName();
        ServerPluginComponent component = this.getServerPluginComponent(pluginName);
        BundleServerPluginFacet facet = (BundleServerPluginFacet)((Object)component);
        this.getLog().debug((Object)("Bundle server plugin [" + pluginName + "] is parsing a bundle recipe"));
        ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            RecipeParseResults results;
            Thread.currentThread().setContextClassLoader(pluginEnv.getPluginClassLoader());
            RecipeParseResults recipeParseResults = results = facet.parseRecipe(recipe);
            Object var11_10 = null;
            Thread.currentThread().setContextClassLoader(originalContextClassLoader);
            return recipeParseResults;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            Thread.currentThread().setContextClassLoader(originalContextClassLoader);
            throw throwable;
        }
    }
}

