/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.scheduler.jobs;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.server.exception.UnscheduleException;
import org.rhq.enterprise.server.operation.OperationManagerLocal;
import org.rhq.enterprise.server.operation.ResourceOperationSchedule;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.scheduler.jobs.AbstractStatefulJob;
import org.rhq.enterprise.server.util.LookupUtil;

public class AsyncResourceDeleteJob
extends AbstractStatefulJob {
    private final Log log = LogFactory.getLog(AsyncResourceDeleteJob.class);

    public void executeJobCode(JobExecutionContext arg0) throws JobExecutionException {
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
        int deletedSuccessfully = 0;
        int deletedWithFailure = 0;
        long time = 0L;
        List<Integer> toBeRemovedIds = resourceManager.findResourcesMarkedForAsyncDeletion(overlord);
        for (Integer doomedResourceId : toBeRemovedIds) {
            try {
                this.log.debug((Object)("Before asynchronous deletion of resource[id=" + doomedResourceId + "]"));
                long startTime = System.currentTimeMillis();
                this.unscheduleJobs(overlord, doomedResourceId);
                resourceManager.deleteSingleResourceInNewTransaction(overlord, doomedResourceId);
                long endTime = System.currentTimeMillis();
                time += endTime - startTime;
                this.log.debug((Object)("After asynchronous deletion of resource[id=" + doomedResourceId + "], took [" + (endTime - startTime) + "]ms"));
                ++deletedSuccessfully;
            }
            catch (Throwable t) {
                this.log.debug((Object)("Error during asynchronous deletion of resource[id=" + doomedResourceId + "]"), t);
                ++deletedWithFailure;
            }
        }
        if (deletedSuccessfully > 0 || deletedWithFailure > 0) {
            this.log.info((Object)("Async resource deletion - " + deletedSuccessfully + " successful, " + deletedWithFailure + " failed, took [" + time + "]ms"));
        }
    }

    private void unscheduleJobs(Subject overlord, Integer resourceId) {
        this.log.debug((Object)("Unscheduling jobs for resource[id=" + resourceId + "]"));
        OperationManagerLocal operationManager = LookupUtil.getOperationManager();
        try {
            List<ResourceOperationSchedule> schedules = operationManager.findScheduledResourceOperations(overlord, resourceId);
            for (ResourceOperationSchedule schedule : schedules) {
                try {
                    operationManager.unscheduleResourceOperation(overlord, schedule.getJobId().toString(), resourceId);
                }
                catch (UnscheduleException ise) {
                    this.log.warn((Object)("Failed to unschedule job [" + schedule + "] for a resource being deleted [" + resourceId + "]"), (Throwable)ise);
                }
            }
        }
        catch (Throwable t) {
            this.log.warn((Object)("Failed to get jobs for a resource being deleted [" + resourceId + "]; will not attempt to unschedule anything"), t);
        }
    }
}

