/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.search.assist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Query;
import org.rhq.enterprise.server.search.assist.SearchAssistant;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSearchAssistant
implements SearchAssistant {
    private int maxResultCount = 20;

    public int getMaxResultCount() {
        return this.maxResultCount;
    }

    public void setMaxResultCount(int maxResultCount) {
        this.maxResultCount = maxResultCount;
    }

    @Override
    public List<String> getSimpleContexts() {
        return Collections.emptyList();
    }

    @Override
    public List<String> getParameterizedContexts() {
        return Collections.emptyList();
    }

    @Override
    public List<String> getParameters(String context, String filter) {
        if (!this.getParameterizedContexts().contains(context)) {
            throw new IllegalArgumentException("context[" + context + "] is not parameterized, no completions available");
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getValues(String context, String param, String filter) {
        if (this.getSimpleContexts().contains(context) && param != null) {
            throw new IllegalArgumentException("context[" + context + "] is simple, param[" + param + "] can not be handled");
        }
        if (this.getParameterizedContexts().contains(context) && param == null) {
            throw new IllegalArgumentException("context[" + context + "] is parameterized, param must not be null");
        }
        return Collections.emptyList();
    }

    protected final List<String> execute(String jpql) {
        Query query = LookupUtil.getEntityManager().createQuery(jpql);
        query.setMaxResults(this.maxResultCount);
        List results = query.getResultList();
        return results;
    }

    protected final Map<String, List<String>> executeMap(String jpql) {
        Query query = LookupUtil.getEntityManager().createQuery(jpql);
        List rawResults = query.getResultList();
        HashMap<String, List<String>> results = new HashMap<String, List<String>>();
        for (Object[] nextTuple : rawResults) {
            String key = (String)nextTuple[0];
            String value = (String)nextTuple[1];
            ArrayList<String> valueList = (ArrayList<String>)results.get(key);
            if (valueList == null) {
                valueList = new ArrayList<String>();
                results.put(key, valueList);
            }
            valueList.add(value);
        }
        return results;
    }

    protected final String add(String fragment, String parameter) {
        if (!parameter.equals("")) {
            return fragment;
        }
        return "";
    }

    protected final List<String> filter(Class<? extends Enum<?>> enumType, String filter) {
        ArrayList<String> results = new ArrayList<String>();
        for (Enum<?> next : enumType.getEnumConstants()) {
            String enumName = next.name().toLowerCase();
            if (filter != null && !filter.equals("") && !enumName.contains(filter)) continue;
            results.add(enumName);
        }
        return Collections.unmodifiableList(results);
    }

    protected final List<String> filter(List<String> data, String filter) {
        return this.filter(data, filter, 10);
    }

    protected final List<String> filter(List<String> data, String filter, int max) {
        ArrayList<String> results = new ArrayList<String>();
        int count = 0;
        for (String next : data) {
            if (!filter.equals("") && (!filter.equals("null") || next != null) && (next == null || next.toLowerCase().indexOf(filter) == -1)) continue;
            results.add(next);
            if (++count != max) continue;
            break;
        }
        return Collections.unmodifiableList(results);
    }

    protected final String quote(String data) {
        return "'" + data + "'";
    }

    protected final String getFormatterValueFragment(String data) {
        boolean hasWhitespace = false;
        for (char next : data.toCharArray()) {
            if (!Character.isWhitespace(next)) continue;
            hasWhitespace = true;
            break;
        }
        if (hasWhitespace) {
            return " = " + data.toLowerCase();
        }
        return null;
    }
}

