/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.search.execution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.TreeAdaptor;
import org.rhq.core.domain.search.SearchSubsystem;
import org.rhq.enterprise.server.search.RHQLLexer;
import org.rhq.enterprise.server.search.RHQLParser;
import org.rhq.enterprise.server.search.antlr.RHQLNodeAdaptor;
import org.rhq.enterprise.server.search.translation.SearchTranslator;
import org.rhq.enterprise.server.search.translation.SearchTranslatorFactory;
import org.rhq.enterprise.server.search.translation.antlr.RHQLComparisonOperator;
import org.rhq.enterprise.server.search.translation.antlr.RHQLTerm;
import org.rhq.enterprise.server.search.translation.antlr.RHQLTreeOperator;
import org.rhq.enterprise.server.search.translation.jpql.SearchFragment;
import org.rhq.enterprise.server.search.translation.jpql.SearchFragmentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchTranslationManager {
    private SearchSubsystem context;
    private String expression;
    private SearchTranslator translator;
    private RHQLLexer lexer;
    private RHQLParser parser;
    private RHQLNodeAdaptor adaptor;
    private String entity;
    private String alias;

    public SearchTranslationManager(SearchSubsystem context) {
        this.context = context;
        this.entity = this.context.getEntityClass().getSimpleName();
        this.alias = this.entity.toLowerCase();
    }

    public void setExpression(String expression) {
        this.expression = expression;
        this.translator = SearchTranslatorFactory.getTranslator(this.context);
        ANTLRStringStream input = new ANTLRStringStream(expression);
        this.lexer = new RHQLLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)this.lexer);
        this.parser = new RHQLParser((TokenStream)tokens);
        this.adaptor = new RHQLNodeAdaptor();
        this.parser.setTreeAdaptor((TreeAdaptor)this.adaptor);
    }

    public String getJPQLSelectStatement() throws Exception {
        String jpql = "SELECT " + this.alias + " FROM " + this.entity + " " + this.alias + " WHERE " + this.getJPQLWhereFragment();
        PrintUtils.printJPQL(jpql.split(" "));
        return jpql;
    }

    public String getJPQLWhereFragment() throws Exception {
        RHQLParser.searchExpression_return searchAST = this.parser.searchExpression();
        CommonTree searchExpressionTree = (CommonTree)searchAST.getTree();
        PrintUtils.print(searchExpressionTree, "");
        String fragment = this.generateJPQL(searchExpressionTree);
        return fragment;
    }

    private String generateJPQL(CommonTree tree) {
        StringBuilder builder = new StringBuilder();
        builder.append(" ( ");
        Token token = tree.getToken();
        if (token == null) {
            return null;
        }
        RHQLTreeOperator operator = SearchTranslationManager.getTreeOperatorFromTokenType(token.getType());
        if (operator != null) {
            for (int childIndex = 0; childIndex < tree.getChildCount(); ++childIndex) {
                CommonTree child = (CommonTree)tree.getChild(childIndex);
                if (childIndex != 0) {
                    builder.append(" " + operator.name() + " ");
                }
                builder.append(this.generateJPQL(child));
            }
        } else {
            List<RHQLTerm> terms = SearchTranslationManager.getFromAST(tree);
            boolean first = true;
            for (RHQLTerm nextTerm : terms) {
                if (!first) {
                    builder.append(" AND ");
                } else {
                    first = false;
                }
                SearchFragment searchFragment = this.translator.getSearchFragment(this.alias, nextTerm);
                String jpqlFragment = searchFragment.getFragment();
                if (searchFragment.getType() == SearchFragmentType.PRIMARY_KEY_SUBQUERY) {
                    jpqlFragment = " " + this.alias + ".id IN (" + jpqlFragment + ")";
                }
                builder.append(jpqlFragment);
            }
        }
        builder.append(" ) ");
        return builder.toString();
    }

    public static List<RHQLTerm> getFromAST(CommonTree tree) {
        ArrayList<RHQLTerm> terms = new ArrayList<RHQLTerm>();
        CommonTree contextTree = (CommonTree)tree.getChild(0);
        String lineage = null;
        String path = null;
        String param = null;
        for (int childIndex = 0; childIndex < contextTree.getChildCount(); ++childIndex) {
            CommonTree child = (CommonTree)contextTree.getChild(childIndex);
            if (child.getToken().getType() == 7) {
                lineage = PrintUtils.collapseStringChildren(child);
                continue;
            }
            if (child.getToken().getType() == 8) {
                path = PrintUtils.collapseStringChildren(child);
                continue;
            }
            if (child.getToken().getType() != 9) continue;
            child = (CommonTree)child.getChild(0);
            param = PrintUtils.collapseStringChildren(child);
        }
        String value = null;
        if (tree.getChildCount() > 1) {
            CommonTree valueTree = (CommonTree)tree.getChild(1);
            for (int childIndex = 0; childIndex < valueTree.getChildCount(); ++childIndex) {
                CommonTree indentChildTree = (CommonTree)valueTree.getChild(childIndex);
                value = PrintUtils.collapseStringChildren(indentChildTree);
                int type = tree.getToken().getType();
                RHQLComparisonOperator operator = SearchTranslationManager.getComparisonOperatorFromTokenType(type, value);
                RHQLTerm nextTerm = new RHQLTerm(lineage, path, param, operator, value);
                terms.add(nextTerm);
            }
        }
        return terms;
    }

    public static RHQLComparisonOperator getComparisonOperatorFromTokenType(int tokenType, String value) {
        boolean nullValue = value.trim().toLowerCase().equals("null");
        switch (tokenType) {
            case 12: {
                return nullValue ? RHQLComparisonOperator.NULL : RHQLComparisonOperator.EQUALS;
            }
            case 13: {
                return nullValue ? RHQLComparisonOperator.NULL : RHQLComparisonOperator.EQUALS_STRICT;
            }
            case 14: {
                return nullValue ? RHQLComparisonOperator.NOT_NULL : RHQLComparisonOperator.NOT_EQUALS;
            }
            case 15: {
                return nullValue ? RHQLComparisonOperator.NOT_NULL : RHQLComparisonOperator.NOT_EQUALS_STRICT;
            }
        }
        throw new IllegalArgumentException("There is no known RHQLComparisonOperator for token type " + tokenType);
    }

    public static RHQLTreeOperator getTreeOperatorFromTokenType(int tokenType) {
        switch (tokenType) {
            case 5: {
                return RHQLTreeOperator.AND;
            }
            case 4: {
                return RHQLTreeOperator.OR;
            }
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        SearchTranslationManager manager = new SearchTranslationManager(SearchSubsystem.RESOURCE);
        manager.setExpression("(name = rhq and category = server) or plugin = jbossas");
        String jpql = manager.getJPQLSelectStatement();
    }

    private static class PrintUtils {
        private PrintUtils() {
        }

        public static void printJPQL(String[] tokens) {
            String indent = "";
            List<String> lineBreakers = Arrays.asList("SELECT", "FROM", "WHERE", "AND", "OR", "(", ")");
            for (String next : tokens) {
                if (next.equals("(")) {
                    indent = "   " + indent;
                }
                if (lineBreakers.contains(next)) {
                    // empty if block
                }
                if (!next.equals(")")) continue;
                indent = indent.substring(3);
            }
        }

        public static void print(CommonTree tree, String indent) {
            if (tree == null) {
                return;
            }
            Token token = tree.getToken();
            if (token == null) {
                return;
            }
            if (!PrintUtils.isStringNode(token)) {
                for (int childIndex = 0; childIndex < tree.getChildCount(); ++childIndex) {
                    CommonTree child = (CommonTree)tree.getChild(childIndex);
                    PrintUtils.print(child, indent + "   ");
                }
            }
        }

        private static boolean isStringNode(Token token) {
            switch (token.getType()) {
                case 8: 
                case 10: {
                    return true;
                }
            }
            return false;
        }

        public static String collapseStringChildren(CommonTree tree) {
            StringBuilder builder = new StringBuilder();
            for (int childIndex = 0; childIndex < tree.getChildCount(); ++childIndex) {
                CommonTree child = (CommonTree)tree.getChild(childIndex);
                builder.append(child.getText());
            }
            return builder.toString();
        }
    }
}

