/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.TransactionTimeout;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.db.H2DatabaseType;
import org.rhq.core.db.OracleDatabaseType;
import org.rhq.core.db.PostgresqlDatabaseType;
import org.rhq.core.db.SQLServerDatabaseType;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.calltime.CallTimeData;
import org.rhq.core.domain.measurement.calltime.CallTimeDataComposite;
import org.rhq.core.domain.measurement.calltime.CallTimeDataValue;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.server.PersistenceUtility;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.measurement.CallTimeDataManagerLocal;
import org.rhq.enterprise.server.measurement.CallTimeDataManagerRemote;
import org.rhq.enterprise.server.measurement.MeasurementStorageException;
import org.rhq.enterprise.server.measurement.instrumentation.MeasurementMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
@Resource(name="RHQ_DS", mappedName="java:/RHQDS")
public class CallTimeDataManagerBean
implements CallTimeDataManagerLocal,
CallTimeDataManagerRemote {
    private static final String DATA_VALUE_TABLE_NAME = "RHQ_CALLTIME_DATA_VALUE";
    private static final String DATA_KEY_TABLE_NAME = "RHQ_CALLTIME_DATA_KEY";
    private static final String CALLTIME_KEY_INSERT_STATEMENT = "INSERT INTO RHQ_CALLTIME_DATA_KEY(id, schedule_id, call_destination) SELECT %s, ?, ? FROM RHQ_numbers WHERE i = 42 AND NOT EXISTS (SELECT * FROM RHQ_CALLTIME_DATA_KEY WHERE schedule_id = ? AND call_destination = ?)";
    private static final String CALLTIME_KEY_INSERT_STATEMENT_AUTOINC = "INSERT INTO RHQ_CALLTIME_DATA_KEY(schedule_id, call_destination) SELECT ?, ? FROM RHQ_numbers WHERE i = 42 AND NOT EXISTS (SELECT * FROM RHQ_CALLTIME_DATA_KEY WHERE schedule_id = ? AND call_destination = ?)";
    private static final String CALLTIME_VALUE_DELETE_SUPERCEDED_STATEMENT = "DELETE FROM RHQ_CALLTIME_DATA_VALUE WHERE key_id = (SELECT id FROM RHQ_CALLTIME_DATA_KEY WHERE schedule_id = ? AND call_destination = ?) AND begin_time = ?";
    private static final String CALLTIME_VALUE_INSERT_STATEMENT = "INSERT INTO RHQ_CALLTIME_DATA_VALUE(id, key_id, begin_time, end_time, minimum, maximum, total, count) SELECT %s, key.id, ?, ?, ?, ?, ?, ? FROM RHQ_numbers num, RHQ_calltime_data_key key WHERE num.i = 42 AND key.id = (SELECT id FROM RHQ_CALLTIME_DATA_KEY WHERE schedule_id = ? AND call_destination = ?)";
    private static final String CALLTIME_VALUE_INSERT_STATEMENT_AUTOINC = "INSERT INTO RHQ_CALLTIME_DATA_VALUE(key_id, begin_time, end_time, minimum, maximum, total, count) SELECT key.id, ?, ?, ?, ?, ?, ? FROM RHQ_numbers num, RHQ_calltime_data_key key WHERE num.i = 42 AND key.id = (SELECT id FROM RHQ_CALLTIME_DATA_KEY WHERE schedule_id = ? AND call_destination = ?)";
    private static final String CALLTIME_VALUE_PURGE_STATEMENT = "DELETE FROM RHQ_CALLTIME_DATA_VALUE WHERE end_time < ?";
    private final Log log = LogFactory.getLog(CallTimeDataManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @Resource
    private SessionContext sessionContext;
    @EJB
    private AuthorizationManagerLocal authorizationManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void addCallTimeData(@NotNull Set<CallTimeData> callTimeDataSet) {
        if (callTimeDataSet.isEmpty()) {
            return;
        }
        this.log.debug((Object)("Persisting call-time data for " + callTimeDataSet.size() + " schedules..."));
        DataSource ds = (DataSource)this.sessionContext.lookup("RHQ_DS");
        Connection conn = null;
        try {
            try {
                conn = ds.getConnection();
                this.insertCallTimeDataKeys(callTimeDataSet, conn);
                this.deleteRedundantCallTimeDataValues(callTimeDataSet, conn);
                this.insertCallTimeDataValues(callTimeDataSet, conn);
            }
            catch (SQLException e) {
                this.logSQLException(e);
                Object var6_5 = null;
                JDBCUtil.safeClose((Connection)conn);
                return;
            }
            catch (Throwable t) {
                this.log.error((Object)"Failed to persist call-time data.", t);
                Object var6_6 = null;
                JDBCUtil.safeClose((Connection)conn);
                return;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            JDBCUtil.safeClose((Connection)conn);
            throw throwable;
        }
        JDBCUtil.safeClose((Connection)conn);
    }

    @Override
    public PageList<CallTimeDataComposite> findCallTimeDataForResource(Subject subject, int scheduleId, long beginTime, long endTime, PageControl pageControl) {
        pageControl.initDefaultOrderingField("SUM(value.total)/SUM(value.count)", PageOrdering.DESC);
        pageControl.addDefaultOrderingField("key.callDestination", PageOrdering.ASC);
        MeasurementSchedule schedule = (MeasurementSchedule)this.entityManager.find(MeasurementSchedule.class, (Object)scheduleId);
        int resourceId = schedule.getResource().getId();
        if (!this.authorizationManager.canViewResource(subject, resourceId)) {
            throw new PermissionException("User [" + subject + "] does not have permission to view call time data for measurementSchedule[id=" + scheduleId + "] and resource[id=" + resourceId + "]");
        }
        String query = "CallTimeDataValue.findCompositesForResource";
        Query queryWithOrderBy = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)query, (PageControl)pageControl);
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)query);
        queryWithOrderBy.setParameter("scheduleId", (Object)scheduleId);
        queryWithOrderBy.setParameter("beginTime", (Object)beginTime);
        queryWithOrderBy.setParameter("endTime", (Object)endTime);
        List results = queryWithOrderBy.getResultList();
        queryCount.setParameter("scheduleId", (Object)scheduleId);
        queryCount.setParameter("beginTime", (Object)beginTime);
        queryCount.setParameter("endTime", (Object)endTime);
        long count = queryCount.getResultList().size();
        return new PageList((Collection)results, (int)count, pageControl);
    }

    @Override
    public PageList<CallTimeDataComposite> findCallTimeDataForCompatibleGroup(Subject subject, int groupId, int measurementDefinitionId, long beginTime, long endTime, PageControl pageControl) {
        return null;
    }

    @Override
    public PageList<CallTimeDataComposite> findCallTimeDataForAutoGroup(Subject subject, int parentResourceId, int childResourceTypeId, int measurementDefinitionId, long beginTime, long endTime, PageControl pageControl) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=21600)
    public int purgeCallTimeData(Date deleteUpToTime) throws SQLException {
        int n;
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = ((DataSource)this.sessionContext.lookup("java:/RHQDS")).getConnection();
            stmt = conn.prepareStatement(CALLTIME_VALUE_PURGE_STATEMENT);
            stmt.setLong(1, deleteUpToTime.getTime());
            long startTime = System.currentTimeMillis();
            int deletedRowCount = stmt.executeUpdate();
            MeasurementMonitor.getMBean().incrementPurgeTime(System.currentTimeMillis() - startTime);
            MeasurementMonitor.getMBean().setPurgedCallTimeData(deletedRowCount);
            n = deletedRowCount;
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            JDBCUtil.safeClose((Connection)conn, stmt, null);
            throw throwable;
        }
        JDBCUtil.safeClose((Connection)conn, (Statement)stmt, null);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertCallTimeDataKeys(Set<CallTimeData> callTimeDataSet, Connection conn) throws Exception {
        int[] results;
        PreparedStatement ps = null;
        try {
            String insertKeySql;
            DatabaseType dbType = DatabaseTypeFactory.getDatabaseType((Connection)conn);
            if (dbType instanceof PostgresqlDatabaseType || dbType instanceof OracleDatabaseType || dbType instanceof H2DatabaseType) {
                String keyNextvalSql = JDBCUtil.getNextValSql((Connection)conn, (String)"RHQ_calltime_data_key");
                insertKeySql = String.format(CALLTIME_KEY_INSERT_STATEMENT, keyNextvalSql);
            } else if (dbType instanceof SQLServerDatabaseType) {
                insertKeySql = CALLTIME_KEY_INSERT_STATEMENT_AUTOINC;
            } else {
                throw new IllegalArgumentException("Unknown database type, can't continue: " + dbType);
            }
            ps = conn.prepareStatement(insertKeySql);
            for (CallTimeData callTimeData : callTimeDataSet) {
                ps.setInt(1, callTimeData.getScheduleId());
                ps.setInt(3, callTimeData.getScheduleId());
                Set callDestinations = callTimeData.getValues().keySet();
                for (String callDestination : callDestinations) {
                    ps.setString(2, callDestination);
                    ps.setString(4, callDestination);
                    ps.addBatch();
                }
            }
            results = ps.executeBatch();
            Object var13_14 = null;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            JDBCUtil.safeClose(ps);
            throw throwable;
        }
        JDBCUtil.safeClose((Statement)ps);
        int insertedRowCount = 0;
        for (int i = 0; i < results.length; ++i) {
            if ((results[i] < 0 || results[i] > 1) && results[i] != -2) {
                throw new MeasurementStorageException("Failed to insert call-time data key rows - result [" + results[i] + "] for batch command [" + i + "] is less than 0 or greater than 1.");
            }
            insertedRowCount += results[i];
        }
        this.log.debug((Object)("Inserted new call-time data key rows for " + (insertedRowCount >= 0 ? Integer.valueOf(insertedRowCount) : "?") + " out of " + results.length + " reported key-value pairs."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteRedundantCallTimeDataValues(Set<CallTimeData> callTimeDataSet, Connection conn) throws SQLException {
        int[] results;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(CALLTIME_VALUE_DELETE_SUPERCEDED_STATEMENT);
            for (CallTimeData callTimeData : callTimeDataSet) {
                ps.setInt(1, callTimeData.getScheduleId());
                Set callDestinations = callTimeData.getValues().keySet();
                for (String callDestination : callDestinations) {
                    ps.setString(2, callDestination);
                    CallTimeDataValue value = (CallTimeDataValue)callTimeData.getValues().get(callDestination);
                    ps.setLong(3, value.getBeginTime());
                    ps.addBatch();
                }
            }
            results = ps.executeBatch();
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            JDBCUtil.safeClose((Statement)ps);
            throw throwable;
        }
        JDBCUtil.safeClose((Statement)ps);
        int deletedRowCount = 0;
        for (int i = 0; i < results.length; ++i) {
            if (results[i] < 0 && results[i] != -2) {
                throw new MeasurementStorageException("Failed to delete redundant call-time data rows - result [" + results[i] + "] for batch command [" + i + "] is less than 0.");
            }
            deletedRowCount += results[i];
        }
        this.log.debug((Object)("Deleted " + (deletedRowCount >= 0 ? Integer.valueOf(deletedRowCount) : "?") + " redundant call-time data value rows that were superceded by data in the measurement report currently being processed."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertCallTimeDataValues(Set<CallTimeData> callTimeDataSet, Connection conn) throws Exception {
        int[] results;
        PreparedStatement ps = null;
        try {
            String insertValueSql;
            DatabaseType dbType = DatabaseTypeFactory.getDatabaseType((Connection)conn);
            if (dbType instanceof PostgresqlDatabaseType || dbType instanceof OracleDatabaseType || dbType instanceof H2DatabaseType) {
                String valueNextvalSql = JDBCUtil.getNextValSql((Connection)conn, (String)"RHQ_calltime_data_value");
                insertValueSql = String.format(CALLTIME_VALUE_INSERT_STATEMENT, valueNextvalSql);
            } else if (dbType instanceof SQLServerDatabaseType) {
                insertValueSql = CALLTIME_VALUE_INSERT_STATEMENT_AUTOINC;
            } else {
                throw new IllegalArgumentException("Unknown database type, can't continue: " + dbType);
            }
            ps = conn.prepareStatement(insertValueSql);
            for (CallTimeData callTimeData : callTimeDataSet) {
                ps.setInt(7, callTimeData.getScheduleId());
                Set callDestinations = callTimeData.getValues().keySet();
                for (String callDestination : callDestinations) {
                    CallTimeDataValue callTimeDataValue = (CallTimeDataValue)callTimeData.getValues().get(callDestination);
                    ps.setLong(1, callTimeDataValue.getBeginTime());
                    ps.setLong(2, callTimeDataValue.getEndTime());
                    ps.setDouble(3, callTimeDataValue.getMinimum());
                    ps.setDouble(4, callTimeDataValue.getMaximum());
                    ps.setDouble(5, callTimeDataValue.getTotal());
                    ps.setLong(6, callTimeDataValue.getCount());
                    ps.setString(8, callDestination);
                    ps.addBatch();
                }
            }
            results = ps.executeBatch();
            Object var14_15 = null;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            JDBCUtil.safeClose(ps);
            throw throwable;
        }
        JDBCUtil.safeClose((Statement)ps);
        int insertedRowCount = 0;
        for (int i = 0; i < results.length; ++i) {
            if (results[i] != 1 && results[i] != -2) {
                throw new MeasurementStorageException("Failed to insert call-time data value rows - result [" + results[i] + "] for batch command [" + i + "] does not equal 1.");
            }
            insertedRowCount += results[i];
        }
        this.log.debug((Object)("Inserted " + (insertedRowCount >= 0 ? Integer.valueOf(insertedRowCount) : "?") + " call-time data value rows."));
    }

    private void logSQLException(SQLException e) {
        SQLException mainException = e;
        StringBuilder causes = new StringBuilder();
        int i = 1;
        while ((e = e.getNextException()) != null) {
            causes.append(i++).append("\n\t").append(e);
        }
        this.log.error((Object)("Failed to persist call-time data - causes: " + causes), (Throwable)mainException);
    }
}

