/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.interceptor.Interceptors;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.IgnoreDependency;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.db.H2DatabaseType;
import org.rhq.core.db.OracleDatabaseType;
import org.rhq.core.db.PostgresqlDatabaseType;
import org.rhq.core.db.SQLServerDatabaseType;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.MeasurementScheduleCriteria;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.DisplayType;
import org.rhq.core.domain.measurement.MeasurementCategory;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.measurement.NumericType;
import org.rhq.core.domain.measurement.ResourceMeasurementScheduleRequest;
import org.rhq.core.domain.measurement.composite.MeasurementScheduleComposite;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.GroupCategory;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.OrderingField;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.server.PersistenceUtility;
import org.rhq.core.util.collection.ArrayUtils;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.enterprise.server.agentclient.AgentClient;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.authz.RequiredPermissions;
import org.rhq.enterprise.server.common.PerformanceMonitorInterceptor;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementException;
import org.rhq.enterprise.server.measurement.MeasurementNotFoundException;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerRemote;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeNotFoundException;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaQueryRunner;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
@Resource(name="RHQ_DS", mappedName="java:/RHQDS")
@Interceptors(value={PerformanceMonitorInterceptor.class})
public class MeasurementScheduleManagerBean
implements MeasurementScheduleManagerLocal,
MeasurementScheduleManagerRemote {
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @Resource(name="RHQ_DS", mappedName="java:/RHQDS")
    private DataSource dataSource;
    @EJB
    @IgnoreDependency
    private AgentManagerLocal agentManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    private ResourceManagerLocal resourceManager;
    @EJB
    @IgnoreDependency
    private ResourceGroupManagerLocal resourceGroupManager;
    @EJB
    @IgnoreDependency
    private ResourceTypeManagerLocal resourceTypeManager;
    @EJB
    private MeasurementScheduleManagerLocal measurementScheduleManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private SystemManagerLocal systemManager;
    private final Log log = LogFactory.getLog(MeasurementScheduleManagerBean.class);

    @Override
    public Set<ResourceMeasurementScheduleRequest> findSchedulesForResourceAndItsDescendants(int[] resourceIds, boolean getDescendents) {
        HashSet<ResourceMeasurementScheduleRequest> allSchedules = new HashSet<ResourceMeasurementScheduleRequest>();
        this.getSchedulesForResourceAndItsDescendants(resourceIds, allSchedules, getDescendents);
        return allSchedules;
    }

    @Override
    public AgentClient getAgentClientForSchedule(MeasurementSchedule sched) {
        org.rhq.core.domain.resource.Resource pRes = sched.getResource();
        Agent agent = pRes.getAgent();
        AgentClient ac = this.agentManager.getAgentClient(agent);
        return ac;
    }

    public MeasurementSchedule getScheduleById(int scheduleId) {
        MeasurementSchedule ms;
        try {
            ms = (MeasurementSchedule)this.entityManager.find(MeasurementSchedule.class, (Object)scheduleId);
        }
        catch (NoResultException n) {
            ms = null;
        }
        return ms;
    }

    @Override
    public List<MeasurementSchedule> findSchedulesByIds(int[] scheduleIds) {
        if (scheduleIds == null || scheduleIds.length == 0) {
            return new ArrayList<MeasurementSchedule>();
        }
        Query q = this.entityManager.createNamedQuery("MeasurementSchedule.findByIds");
        q.setParameter("ids", (Object)ArrayUtils.wrapInList((int[])scheduleIds));
        List ret = q.getResultList();
        return ret;
    }

    @Override
    public MeasurementSchedule getScheduleById(Subject subject, int scheduleId) {
        MeasurementSchedule schedule = (MeasurementSchedule)this.entityManager.find(MeasurementSchedule.class, (Object)scheduleId);
        if (schedule == null) {
            return null;
        }
        if (!this.authorizationManager.canViewResource(subject, schedule.getResource().getId())) {
            throw new PermissionException("User[" + subject.getName() + "] does not have permission to view measurementSchedule[id=" + scheduleId + "]");
        }
        schedule.getDefinition().getId();
        return schedule;
    }

    private void verifyMinimumCollectionInterval(MeasurementSchedule schedule) {
        schedule.setInterval(this.verifyMinimumCollectionInterval(schedule.getInterval()));
    }

    private long verifyMinimumCollectionInterval(long collectionInterval) {
        if (collectionInterval < 30000L) {
            return 30000L;
        }
        return collectionInterval;
    }

    @Override
    public List<MeasurementSchedule> findSchedulesByResourceIdsAndDefinitionId(Subject subject, int[] resourceIds, int definitionId) {
        return this.findSchedulesByResourcesAndDefinitions(subject, resourceIds, new int[]{definitionId});
    }

    @Override
    public List<MeasurementSchedule> findSchedulesByResourceIdsAndDefinitionIds(int[] resourceIds, int[] definitionIds) {
        Query query = this.entityManager.createNamedQuery("MeasurementSchedule.findByResourceIdsAndDefinitionIds");
        query.setParameter("definitionIds", (Object)ArrayUtils.wrapInList((int[])definitionIds));
        query.setParameter("resourceIds", (Object)ArrayUtils.wrapInList((int[])resourceIds));
        List results = query.getResultList();
        return results;
    }

    private List<MeasurementSchedule> findSchedulesByResourcesAndDefinitions(Subject subject, int[] resourceIds, int[] definitionIds) {
        for (int resourceId : resourceIds) {
            if (this.authorizationManager.canViewResource(subject, resourceId)) continue;
            throw new PermissionException("User[" + subject.getName() + "] does not have permission to view metric schedules for resource[id=" + resourceId + "]");
        }
        return this.findSchedulesByResourceIdsAndDefinitionIds(resourceIds, definitionIds);
    }

    @Override
    public MeasurementSchedule getSchedule(Subject subject, int resourceId, int definitionId, boolean attachBaseline) throws MeasurementNotFoundException {
        try {
            List<MeasurementSchedule> results = this.findSchedulesByResourcesAndDefinitions(subject, new int[]{resourceId}, new int[]{definitionId});
            if (results.size() != 1) {
                throw new MeasurementException("Could not find measurementSchedule[resourceId=" + resourceId + ", definitionId=" + definitionId + "]");
            }
            MeasurementSchedule schedule = results.get(0);
            if (attachBaseline && schedule.getBaseline() != null) {
                schedule.getBaseline().getId();
            }
            return schedule;
        }
        catch (NoResultException nre) {
            throw new MeasurementNotFoundException(nre);
        }
    }

    @Override
    public PageList<MeasurementScheduleComposite> findSchedulesForAutoGroup(Subject subject, int parentId, int childType, PageControl pageControl) {
        ResourceType resType;
        List<org.rhq.core.domain.resource.Resource> resources = this.resourceGroupManager.findResourcesForAutoGroup(subject, parentId, childType);
        for (org.rhq.core.domain.resource.Resource res : resources) {
            if (this.authorizationManager.canViewResource(subject, res.getId())) continue;
            throw new PermissionException("User[" + subject.getName() + "] does not have permission to view metric schedules for autoGroup[parentResourceId=" + parentId + ", resourceTypeId=" + childType + "], root cause: does not have permission to view resource[id=" + res.getId() + "]");
        }
        try {
            resType = this.resourceTypeManager.getResourceTypeById(subject, childType);
        }
        catch (ResourceTypeNotFoundException e) {
            ArrayList compList = new ArrayList();
            PageList result = new PageList(compList, pageControl);
            return result;
        }
        Set definitions = resType.getMetricDefinitions();
        return this.getCurrentMeasurementSchedulesForResourcesAndType(pageControl, resources, resType, definitions);
    }

    @Override
    public PageList<MeasurementScheduleComposite> findSchedulesForCompatibleGroup(Subject subject, int groupId, PageControl pageControl) {
        if (!this.authorizationManager.canViewResource(subject, groupId)) {
            throw new PermissionException("User[" + subject.getName() + "] does not have permission to view metric schedules for resourceGroup[id=" + groupId + "]");
        }
        ResourceGroup group = this.resourceGroupManager.getResourceGroupById(subject, groupId, GroupCategory.COMPATIBLE);
        Set resources = group.getExplicitResources();
        ResourceType resType = group.getResourceType();
        Set definitions = resType.getMetricDefinitions();
        return this.getCurrentMeasurementSchedulesForResourcesAndType(pageControl, resources, resType, definitions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    PageList<MeasurementScheduleComposite> getCurrentMeasurementSchedulesForResourcesAndType(PageControl pageControl, Collection<org.rhq.core.domain.resource.Resource> resources, ResourceType resType, Set<MeasurementDefinition> definitions) {
        String queryString;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet resultSet = null;
        DatabaseType type = this.systemManager.getDatabaseType();
        if (type instanceof PostgresqlDatabaseType || type instanceof H2DatabaseType) {
            queryString = "select defi.id, defi.display_name, defi.description,defi.category,defi.data_type, foo.coMin, foo.coMax, foo.coAny, foo.coAll  from RHQ_measurement_def defi,  (    select d.id as did, min(s.coll_interval) as coMin, max(s.coll_interval) as coMax, bool_or(s.enabled) as coAny, bool_and(s.enabled) as coAll    from RHQ_MEASUREMENT_SCHED s,  RHQ_measurement_def d    where s.definition = d.id      and d.id IN (@@DEFINITIONS@@)      and s.resource_id IN (@@RESOURCES@@)    group by d.id  ) as foo  where defi.id = foo.did order by defi.display_name";
        } else {
            if (!(type instanceof OracleDatabaseType) && !(type instanceof SQLServerDatabaseType)) {
                throw new IllegalArgumentException("unknown database type, imlement this: " + type.toString());
            }
            queryString = "select defi.id, defi.display_name, defi.description, defi.category, defi.data_type, coMin, coMax, coAny, coAll  from RHQ_measurement_def defi,  (    select d.id as did,  min(s.coll_interval) as coMin, max(s.coll_interval) as coMax, min(s.enabled) as coAny, max(s.enabled) as coAll    from RHQ_MEASUREMENT_SCHED s,  RHQ_measurement_def d    where s.definition = d.id      and d.id IN (@@DEFINITIONS@@)      and s.resource_id IN (@@RESOURCES@@)    group by d.id  )  where defi.id = did order by defi.display_name";
        }
        int numDefs = definitions.size();
        queryString = JDBCUtil.transformQueryForMultipleInParameters((String)queryString, (String)"@@DEFINITIONS@@", (int)numDefs);
        int numResources = resources.size();
        if (numResources > 1000) {
            numResources = 1000;
        }
        queryString = JDBCUtil.transformQueryForMultipleInParameters((String)queryString, (String)"@@RESOURCES@@", (int)numResources);
        int[] defIds = new int[numDefs];
        int i = 0;
        for (MeasurementDefinition def : definitions) {
            defIds[i++] = def.getId();
        }
        int[] resIds = new int[numResources];
        i = 0;
        for (org.rhq.core.domain.resource.Resource res : resources) {
            resIds[i++] = res.getId();
        }
        ArrayList<MeasurementScheduleComposite> compList = new ArrayList<MeasurementScheduleComposite>(numDefs);
        try {
            try {
                conn = this.dataSource.getConnection();
                ps = conn.prepareStatement(queryString);
                JDBCUtil.bindNTimes((PreparedStatement)ps, (int[])defIds, (int)1);
                JDBCUtil.bindNTimes((PreparedStatement)ps, (int[])resIds, (int)(numDefs + 1));
                resultSet = ps.executeQuery();
                while (resultSet.next()) {
                    int minInterval;
                    int defId = resultSet.getInt(1);
                    String defDisName = resultSet.getString(2);
                    String defDescr = resultSet.getString(3);
                    int category = resultSet.getInt(4);
                    int dataType = resultSet.getInt(5);
                    int maxInterval = resultSet.getInt(6);
                    int collectionInterval = maxInterval == (minInterval = resultSet.getInt(7)) ? maxInterval : 0;
                    Boolean collectionEnabled = null;
                    if (type instanceof PostgresqlDatabaseType || type instanceof H2DatabaseType) {
                        boolean bAnd;
                        boolean bOr = resultSet.getBoolean(8);
                        if (bOr == (bAnd = resultSet.getBoolean(9))) {
                            collectionEnabled = bOr;
                        } else {
                            collectionInterval = 0;
                        }
                    } else {
                        int boAll;
                        if (!(type instanceof OracleDatabaseType) && !(type instanceof SQLServerDatabaseType)) {
                            throw new IllegalArgumentException("Unimplemented db type: " + type.toString());
                        }
                        int boAny = resultSet.getInt(8);
                        if (boAny == (boAll = resultSet.getInt(9))) {
                            collectionEnabled = boAny == 1;
                        } else {
                            collectionInterval = 0;
                        }
                    }
                    MeasurementDefinition dummy = new MeasurementDefinition(resType, defDisName);
                    dummy.setId(defId);
                    dummy.setDescription(defDescr);
                    dummy.setDisplayName(defDisName);
                    dummy.setCategory(MeasurementCategory.values()[category]);
                    dummy.setDataType(DataType.values()[dataType]);
                    MeasurementScheduleComposite comp = new MeasurementScheduleComposite(dummy, collectionEnabled, (long)collectionInterval);
                    compList.add(comp);
                }
                Object var28_32 = null;
            }
            catch (SQLException e) {
                this.log.error((Object)("Can not retrieve results: " + e.getMessage() + ", code= " + e.getErrorCode()));
                compList = new ArrayList();
                Object var28_33 = null;
                JDBCUtil.safeClose((Connection)conn, (Statement)ps, (ResultSet)resultSet);
                return new PageList(compList, pageControl);
            }
        }
        catch (Throwable throwable) {
            Object var28_34 = null;
            JDBCUtil.safeClose((Connection)conn, (Statement)ps, resultSet);
            throw throwable;
        }
        JDBCUtil.safeClose((Connection)conn, (Statement)ps, (ResultSet)resultSet);
        return new PageList(compList, pageControl);
    }

    @Override
    public PageList<MeasurementScheduleComposite> findScheduleCompositesForResource(Subject subject, int resourceId, @Nullable DataType dataType, PageControl pageControl) {
        if (!this.authorizationManager.canViewResource(subject, resourceId)) {
            throw new PermissionException("User[" + subject.getName() + "] does not have permission to view metric schedules for resource[id=" + resourceId + "]");
        }
        pageControl.addDefaultOrderingField("ms.id");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"MeasurementDefinition.findScheduleCompositeForResource", (PageControl)pageControl);
        query.setParameter("resourceId", (Object)resourceId);
        query.setParameter("dataType", (Object)dataType);
        List results = query.getResultList();
        return new PageList((Collection)results, pageControl);
    }

    @Override
    public PageList<MeasurementScheduleComposite> findSchedulesForResource(Subject subject, int resourceId, PageControl pageControl) {
        return this.findScheduleCompositesForResource(subject, resourceId, null, pageControl);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void disableDefaultCollectionForMeasurementDefinitions(Subject subject, int[] measurementDefinitionIds, boolean updateSchedules) {
        this.modifyDefaultCollectionIntervalForMeasurementDefinitions(subject, measurementDefinitionIds, -1L, updateSchedules);
    }

    private void disableSchedule(Subject subject, int resourceId, int[] measurementDefinitionIds) {
        org.rhq.core.domain.resource.Resource resource = this.resourceManager.getResourceById(subject, resourceId);
        List<MeasurementSchedule> measurementSchedules = this.findSchedulesByResourceIdAndDefinitionIds(subject, resourceId, measurementDefinitionIds);
        ResourceMeasurementScheduleRequest resourceMeasurementScheduleRequest = new ResourceMeasurementScheduleRequest(resourceId);
        for (MeasurementSchedule measurementSchedule : measurementSchedules) {
            measurementSchedule.setEnabled(false);
            MeasurementScheduleRequest measurementScheduleRequest = new MeasurementScheduleRequest(measurementSchedule);
            resourceMeasurementScheduleRequest.addMeasurementScheduleRequest(measurementScheduleRequest);
        }
        HashSet<ResourceMeasurementScheduleRequest> resourceMeasurementScheduleRequests = new HashSet<ResourceMeasurementScheduleRequest>();
        resourceMeasurementScheduleRequests.add(resourceMeasurementScheduleRequest);
        boolean synced = this.sendUpdatedSchedulesToAgent(resource.getAgent(), resourceMeasurementScheduleRequests);
        if (!synced) {
            resource.setAgentSynchronizationNeeded();
        }
        this.entityManager.merge((Object)resource);
    }

    private void enableSchedule(Subject subject, int resourceId, int[] measurementDefinitionIds) {
        org.rhq.core.domain.resource.Resource resource = this.resourceManager.getResourceById(subject, resourceId);
        List<MeasurementSchedule> measurementSchedules = this.findSchedulesByResourceIdAndDefinitionIds(subject, resourceId, measurementDefinitionIds);
        ResourceMeasurementScheduleRequest resourceMeasurementScheduleRequest = new ResourceMeasurementScheduleRequest(resourceId);
        for (MeasurementSchedule measurementSchedule : measurementSchedules) {
            measurementSchedule.setEnabled(true);
            MeasurementScheduleRequest measurementScheduleRequest = new MeasurementScheduleRequest(measurementSchedule);
            resourceMeasurementScheduleRequest.addMeasurementScheduleRequest(measurementScheduleRequest);
        }
        HashSet<ResourceMeasurementScheduleRequest> resourceMeasurementScheduleRequests = new HashSet<ResourceMeasurementScheduleRequest>();
        resourceMeasurementScheduleRequests.add(resourceMeasurementScheduleRequest);
        boolean synced = this.sendUpdatedSchedulesToAgent(resource.getAgent(), resourceMeasurementScheduleRequests);
        if (!synced) {
            resource.setAgentSynchronizationNeeded();
        }
        this.entityManager.merge((Object)resource);
    }

    @Override
    @RequiredPermissions(value={@RequiredPermission(value=Permission.MANAGE_INVENTORY), @RequiredPermission(value=Permission.MANAGE_SETTINGS)})
    public void disableAllDefaultCollections(Subject subject) {
        this.entityManager.createNamedQuery("MeasurementDefinition.disableAll").executeUpdate();
    }

    @Override
    @RequiredPermissions(value={@RequiredPermission(value=Permission.MANAGE_INVENTORY), @RequiredPermission(value=Permission.MANAGE_SETTINGS)})
    public void disableAllSchedules(Subject subject) {
        this.entityManager.createNamedQuery("MeasurementSchedule.disableAll").executeUpdate();
    }

    @Override
    public void createSchedulesForExistingResources(ResourceType type, MeasurementDefinition newDefinition) {
        long now = System.currentTimeMillis();
        List resources = type.getResources();
        if (resources != null) {
            for (org.rhq.core.domain.resource.Resource res : resources) {
                res.setMtime(now);
                MeasurementSchedule sched = new MeasurementSchedule(newDefinition, res);
                sched.setInterval(newDefinition.getDefaultInterval());
                this.entityManager.persist((Object)sched);
            }
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void updateDefaultCollectionIntervalForMeasurementDefinitions(Subject subject, int[] measurementDefinitionIds, long collectionInterval, boolean updateExistingSchedules) {
        collectionInterval = this.verifyMinimumCollectionInterval(collectionInterval);
        this.modifyDefaultCollectionIntervalForMeasurementDefinitions(subject, measurementDefinitionIds, collectionInterval, updateExistingSchedules);
    }

    private void modifyDefaultCollectionIntervalForMeasurementDefinitions(Subject subject, int[] measurementDefinitionIds, long collectionInterval, boolean updateExistingSchedules) {
        if (measurementDefinitionIds == null || measurementDefinitionIds.length == 0) {
            this.log.debug((Object)("update metric template: no definitions supplied (interval = " + collectionInterval));
            return;
        }
        boolean enableDisable = collectionInterval > 0L;
        for (int batchIndex = 0; batchIndex < measurementDefinitionIds.length; batchIndex += 1000) {
            int[] batchIdArray = ArrayUtils.copyOfRange((int[])measurementDefinitionIds, (int)batchIndex, (int)(batchIndex + 1000));
            this.modifyDefaultCollectionIntervalForMeasurementDefinitions(subject, batchIdArray, enableDisable, collectionInterval, updateExistingSchedules);
        }
    }

    private void modifyDefaultCollectionIntervalForMeasurementDefinitions(Subject subject, int[] measurementDefinitionIds, boolean enableDisable, long collectionInterval, boolean updateExistingSchedules) {
        Connection conn = null;
        PreparedStatement defUpdateStmt = null;
        PreparedStatement schedUpdateStmt = null;
        String queryString = null;
        try {
            try {
                conn = this.dataSource.getConnection();
                queryString = collectionInterval > 0L ? "UPDATE RHQ_MEASUREMENT_DEF   SET DEFAULT_ON = ?, DEFAULT_INTERVAL = ?   WHERE ID IN ( @@DEFINITION_IDS@@ )" : "UPDATE RHQ_MEASUREMENT_DEF   SET DEFAULT_ON = ?   WHERE ID IN ( @@DEFINITION_IDS@@ )";
                String transformedQuery = JDBCUtil.transformQueryForMultipleInParameters((String)queryString, (String)"@@DEFINITION_IDS@@", (int)measurementDefinitionIds.length);
                defUpdateStmt = conn.prepareStatement(transformedQuery);
                int i = 1;
                defUpdateStmt.setBoolean(i++, enableDisable);
                if (collectionInterval > 0L) {
                    defUpdateStmt.setLong(i++, collectionInterval);
                }
                JDBCUtil.bindNTimes((PreparedStatement)defUpdateStmt, (int[])measurementDefinitionIds, (int)i++);
                defUpdateStmt.executeUpdate();
                if (updateExistingSchedules) {
                    HashMap<Integer, ResourceMeasurementScheduleRequest> reqMap = new HashMap<Integer, ResourceMeasurementScheduleRequest>();
                    List idsAsList = ArrayUtils.wrapInList((int[])measurementDefinitionIds);
                    queryString = collectionInterval > 0L ? "UPDATE RHQ_MEASUREMENT_SCHED   SET ENABLED = ?, COLL_INTERVAL = ?   WHERE DEFINITION IN ( @@DEFINITION_IDS@@ )" : "UPDATE RHQ_MEASUREMENT_SCHED   SET ENABLED = ?   WHERE DEFINITION IN ( @@DEFINITION_IDS@@ )";
                    transformedQuery = JDBCUtil.transformQueryForMultipleInParameters((String)queryString, (String)"@@DEFINITION_IDS@@", (int)measurementDefinitionIds.length);
                    schedUpdateStmt = conn.prepareStatement(transformedQuery);
                    i = 1;
                    schedUpdateStmt.setBoolean(i++, enableDisable);
                    if (collectionInterval > 0L) {
                        schedUpdateStmt.setLong(i++, collectionInterval);
                    }
                    JDBCUtil.bindNTimes((PreparedStatement)schedUpdateStmt, (int[])measurementDefinitionIds, (int)i++);
                    schedUpdateStmt.executeUpdate();
                    queryString = "SELECT ms.id, ms.resource.id, ms.definition.name, ms.definition.dataType, ms.definition.numericType FROM  MeasurementSchedule ms WHERE ms.definition.id IN ( :definitionIds )";
                    Query query = this.entityManager.createQuery(queryString);
                    query.setParameter("definitionIds", (Object)idsAsList);
                    List rs = query.getResultList();
                    for (Object[] row : rs) {
                        i = 0;
                        int n = (Integer)row[i++];
                        int resourceId = (Integer)row[i++];
                        String name = (String)row[i++];
                        DataType dataType = (DataType)row[i++];
                        NumericType numericType = (NumericType)row[i++];
                        ResourceMeasurementScheduleRequest req = (ResourceMeasurementScheduleRequest)reqMap.get(resourceId);
                        if (null == req) {
                            req = new ResourceMeasurementScheduleRequest(resourceId);
                            reqMap.put(resourceId, req);
                        }
                        MeasurementScheduleRequest msr = new MeasurementScheduleRequest(n, name, collectionInterval, enableDisable, dataType, numericType);
                        req.addMeasurementScheduleRequest(msr);
                    }
                    HashMap agentUpdates = null;
                    agentUpdates = new HashMap();
                    for (Integer n : reqMap.keySet()) {
                        Agent agent = this.agentManager.getAgentByResourceId(n);
                        HashSet agentUpdate = (HashSet)agentUpdates.get(agent);
                        if (agentUpdate == null) {
                            agentUpdate = new HashSet();
                            agentUpdates.put(agent, agentUpdate);
                        }
                        agentUpdate.add(reqMap.get(n));
                    }
                    for (Map.Entry entry : agentUpdates.entrySet()) {
                        boolean synced = this.sendUpdatedSchedulesToAgent((Agent)entry.getKey(), (Set)entry.getValue());
                        if (synced) continue;
                        int agentId = ((Agent)entry.getKey()).getId();
                        this.setAgentSynchronizationNeededByDefinitionsForAgent(agentId, idsAsList);
                    }
                }
                Object var27_31 = null;
            }
            catch (Exception e) {
                this.log.error((Object)"Error updating measurement definitions: ", (Throwable)e);
                throw new MeasurementException("Error updating measurement definitions: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var27_32 = null;
            JDBCUtil.safeClose(defUpdateStmt);
            JDBCUtil.safeClose(schedUpdateStmt);
            JDBCUtil.safeClose((Connection)conn);
            throw throwable;
        }
        JDBCUtil.safeClose((Statement)defUpdateStmt);
        JDBCUtil.safeClose(schedUpdateStmt);
        JDBCUtil.safeClose((Connection)conn);
    }

    private void setAgentSynchronizationNeededByDefinitionsForAgent(int agentId, List<Integer> measurementDefinitionIds) {
        String updateSQL = "UPDATE Resource res    SET res.mtime = :now  WHERE res.agent.id = :agentId AND        res.resourceType.id IN ( SELECT md.resourceType.id                                   FROM MeasurementDefinition md                                  WHERE md.id IN ( :definitionIds ) )";
        Query updateQuery = this.entityManager.createQuery(updateSQL);
        updateQuery.setParameter("now", (Object)System.currentTimeMillis());
        updateQuery.setParameter("agentId", (Object)agentId);
        updateQuery.setParameter("definitionIds", measurementDefinitionIds);
        int updateCount = updateQuery.executeUpdate();
        this.log.info((Object)("" + updateCount + " resources mtime fields were updated as a result of this metric template update"));
    }

    public void updateSchedules(Subject subject, int resourceId, int[] measurementDefinitionIds, long collectionInterval) {
        collectionInterval = this.verifyMinimumCollectionInterval(collectionInterval);
        org.rhq.core.domain.resource.Resource resource = this.resourceManager.getResourceById(subject, resourceId);
        if (!this.authorizationManager.hasResourcePermission(subject, Permission.MANAGE_MEASUREMENTS, resourceId)) {
            throw new PermissionException("User[" + subject.getName() + "] does not have permission to change metric collection schedules for resource[id=" + resourceId + "]");
        }
        List<MeasurementSchedule> measurementSchedules = this.findSchedulesByResourceIdAndDefinitionIds(subject, resourceId, measurementDefinitionIds);
        ResourceMeasurementScheduleRequest resourceMeasurementScheduleRequest = new ResourceMeasurementScheduleRequest(resourceId);
        for (MeasurementSchedule measurementSchedule : measurementSchedules) {
            measurementSchedule.setEnabled(true);
            measurementSchedule.setInterval(collectionInterval);
            MeasurementScheduleRequest measurementScheduleRequest = new MeasurementScheduleRequest(measurementSchedule);
            resourceMeasurementScheduleRequest.addMeasurementScheduleRequest(measurementScheduleRequest);
        }
        HashSet<ResourceMeasurementScheduleRequest> resourceMeasurementScheduleRequests = new HashSet<ResourceMeasurementScheduleRequest>();
        resourceMeasurementScheduleRequests.add(resourceMeasurementScheduleRequest);
        boolean synced = this.sendUpdatedSchedulesToAgent(resource.getAgent(), resourceMeasurementScheduleRequests);
        if (!synced) {
            resource.setAgentSynchronizationNeeded();
        }
        this.entityManager.merge((Object)resource);
    }

    @Override
    public void updateSchedulesForAutoGroup(Subject subject, int parentResourceId, int childResourceType, int[] measurementDefinitionIds, long collectionInterval) {
        List<org.rhq.core.domain.resource.Resource> resources = this.resourceGroupManager.findResourcesForAutoGroup(subject, parentResourceId, childResourceType);
        for (org.rhq.core.domain.resource.Resource resource : resources) {
            this.updateSchedules(subject, resource.getId(), measurementDefinitionIds, collectionInterval);
        }
    }

    @Override
    public void disableSchedulesForAutoGroup(Subject subject, int parentResourceId, int childResourceType, int[] measurementDefinitionIds) {
        List<org.rhq.core.domain.resource.Resource> resources = this.resourceGroupManager.findResourcesForAutoGroup(subject, parentResourceId, childResourceType);
        for (org.rhq.core.domain.resource.Resource resource : resources) {
            this.disableSchedulesForResource(subject, resource.getId(), measurementDefinitionIds);
        }
    }

    @Override
    public void enableSchedulesForAutoGroup(Subject subject, int parentResourceId, int childResourceType, int[] measurementDefinitionIds) {
        List<org.rhq.core.domain.resource.Resource> resources = this.resourceGroupManager.findResourcesForAutoGroup(subject, parentResourceId, childResourceType);
        for (org.rhq.core.domain.resource.Resource resource : resources) {
            this.enableSchedulesForResource(subject, resource.getId(), measurementDefinitionIds);
        }
    }

    @Override
    public List<MeasurementSchedule> findSchedulesForResourceAndType(Subject subject, int resourceId, DataType dataType, DisplayType displayType, boolean enabledOnly) {
        OrderingField sortOrder = new OrderingField("ms.definition.displayName", PageOrdering.ASC);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"MeasurementSchedule.FIND_ALL_FOR_RESOURCE_ID", (OrderingField[])new OrderingField[]{sortOrder});
        query.setParameter("resourceId", (Object)resourceId);
        query.setParameter("dataType", (Object)dataType);
        query.setParameter("displayType", (Object)displayType);
        query.setParameter("enabled", (Object)(enabledOnly ? Boolean.valueOf(true) : null));
        List results = query.getResultList();
        return results;
    }

    private boolean sendUpdatedSchedulesToAgent(Agent agent, Set<ResourceMeasurementScheduleRequest> resourceMeasurementScheduleRequest) {
        try {
            AgentClient agentClient = LookupUtil.getAgentManager().getAgentClient(agent);
            if (!agentClient.ping(2000L)) {
                this.log.debug((Object)("Won't send MeasurementSchedules to offline Agent[id=" + agent.getId() + "]"));
                return false;
            }
            agentClient.getMeasurementAgentService().updateCollection(resourceMeasurementScheduleRequest);
            return true;
        }
        catch (Throwable t) {
            this.log.error((Object)("Error updating MeasurementSchedules for Agent[id=" + agent.getId() + "]: " + t));
            return false;
        }
    }

    @Override
    public List<MeasurementSchedule> findSchedulesByResourceIdAndDefinitionIds(Subject subject, int resourceId, int[] definitionIds) {
        return this.findSchedulesByResourcesAndDefinitions(subject, new int[]{resourceId}, definitionIds);
    }

    private List<MeasurementDefinition> getDefinitionsByIds(int[] ids) {
        Query q = this.entityManager.createNamedQuery("MeasurementDefinition.findByIds");
        List idsList = ArrayUtils.wrapInList((int[])ids);
        q.setParameter("ids", (Object)idsList);
        List results = q.getResultList();
        return results;
    }

    private void getSchedulesForResourceAndItsDescendants(int[] resourceIds, Set<ResourceMeasurementScheduleRequest> allSchedules, boolean getDescendents) {
        if (resourceIds == null || resourceIds.length == 0) {
            return;
        }
        try {
            for (int batchIndex = 0; batchIndex < resourceIds.length; batchIndex += 1000) {
                int[] batchIds = ArrayUtils.copyOfRange((int[])resourceIds, (int)batchIndex, (int)(batchIndex + 1000));
                this.measurementScheduleManager.insertSchedulesFor(batchIds);
                this.measurementScheduleManager.returnSchedulesFor(batchIds, allSchedules);
                if (!getDescendents) continue;
                int[] batchChildrenIds = this.getChildrenIdByParentIds(batchIds);
                this.getSchedulesForResourceAndItsDescendants(batchChildrenIds, allSchedules, getDescendents);
            }
        }
        catch (Throwable t) {
            this.log.warn((Object)("problem creating schedules for resourceIds [" + resourceIds + "]"), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public int insertSchedulesFor(int[] batchIds) throws Exception {
        Exception e22;
        int created;
        Connection conn;
        block18: {
            conn = null;
            Statement insertStatement = null;
            created = -1;
            try {
                conn = this.dataSource.getConnection();
                DatabaseType dbType = DatabaseTypeFactory.getDatabaseType((Connection)conn);
                String insertQueryString = null;
                if (dbType instanceof PostgresqlDatabaseType) {
                    insertQueryString = "INSERT INTO RHQ_MEASUREMENT_SCHED ( ID, ENABLED, COLL_INTERVAL, DEFINITION, RESOURCE_ID )      SELECT nextval('RHQ_MEASUREMENT_SCHED_ID_SEQ'),             def.DEFAULT_ON AS defaultOn,             def.DEFAULT_INTERVAL AS interval,             def.ID AS definitionId,             res.ID AS resourceId        FROM RHQ_RESOURCE res, RHQ_RESOURCE_TYPE type, RHQ_MEASUREMENT_DEF def       WHERE ( res.ID in ( @@RESOURCES@@ ) )         AND type.ID = res.RESOURCE_TYPE_ID         AND type.ID = def.RESOURCE_TYPE_ID         AND NOT EXISTS ( SELECT ms.id                            FROM RHQ_MEASUREMENT_SCHED ms                           WHERE ms.RESOURCE_ID = res.ID                             AND ms.DEFINITION = def.ID ) ";
                } else if (dbType instanceof OracleDatabaseType || dbType instanceof H2DatabaseType) {
                    insertQueryString = "INSERT INTO RHQ_MEASUREMENT_SCHED ( ID, ENABLED, COLL_INTERVAL, DEFINITION, RESOURCE_ID )      SELECT RHQ_MEASUREMENT_SCHED_ID_SEQ.nextval,             defaultOn, interval, definitionId, resourceId        FROM ( SELECT def.DEFAULT_ON AS defaultOn,                      def.DEFAULT_INTERVAL AS interval,                      def.ID AS definitionId,                      res.ID AS resourceId                 FROM RHQ_RESOURCE res, RHQ_RESOURCE_TYPE type, RHQ_MEASUREMENT_DEF def                WHERE ( res.ID in ( @@RESOURCES@@ ) )                  AND type.ID = res.RESOURCE_TYPE_ID                  AND type.ID = def.RESOURCE_TYPE_ID                  AND NOT EXISTS ( SELECT ms.id                                     FROM RHQ_MEASUREMENT_SCHED ms                                    WHERE ms.RESOURCE_ID = res.ID                                      AND ms.DEFINITION = def.ID ) ) ";
                } else if (dbType instanceof SQLServerDatabaseType) {
                    insertQueryString = "INSERT INTO RHQ_MEASUREMENT_SCHED ( ENABLED, COLL_INTERVAL, DEFINITION, RESOURCE_ID )      SELECT def.DEFAULT_ON AS defaultOn,             def.DEFAULT_INTERVAL AS interval,             def.ID AS definitionId,             res.ID AS resourceId        FROM RHQ_RESOURCE res, RHQ_RESOURCE_TYPE type, RHQ_MEASUREMENT_DEF def       WHERE ( res.ID in ( @@RESOURCES@@ ) )         AND type.ID = res.RESOURCE_TYPE_ID         AND type.ID = def.RESOURCE_TYPE_ID         AND NOT EXISTS ( SELECT ms.id                            FROM RHQ_MEASUREMENT_SCHED ms                           WHERE ms.RESOURCE_ID = res.ID                             AND ms.DEFINITION = def.ID ) ";
                } else {
                    throw new IllegalArgumentException("Unknown database type, can't continue: " + dbType);
                }
                insertQueryString = JDBCUtil.transformQueryForMultipleInParameters((String)insertQueryString, (String)"@@RESOURCES@@", (int)batchIds.length);
                insertStatement = conn.prepareStatement(insertQueryString);
                JDBCUtil.bindNTimes((PreparedStatement)insertStatement, (int[])batchIds, (int)1);
                created = insertStatement.executeUpdate();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Batch created [" + created + "] default measurement schedules for resource batch [" + batchIds + "]"));
                }
                Object var8_7 = null;
                if (insertStatement == null) break block18;
            }
            catch (Throwable throwable) {
                Exception e22;
                Object var8_8 = null;
                if (insertStatement != null) {
                    try {
                        insertStatement.close();
                    }
                    catch (Exception e22) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception e22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                insertStatement.close();
            }
            catch (Exception e22) {
                // empty catch block
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Exception e22) {}
        }
        return created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public int returnSchedulesFor(int[] batchIds, Set<ResourceMeasurementScheduleRequest> allSchedules) throws Exception {
        Exception e22;
        int created;
        Connection conn;
        block14: {
            conn = null;
            Statement resultsStatement = null;
            created = -1;
            try {
                conn = this.dataSource.getConnection();
                String resultsQueryString = "SELECT ms.RESOURCE_ID, ms.ID, def.NAME, ms.COLL_INTERVAL, ms.ENABLED, def.DATA_TYPE, def.RAW_NUMERIC_TYPE   FROM RHQ_MEASUREMENT_SCHED ms   JOIN RHQ_MEASUREMENT_DEF def ON ms.DEFINITION = def.ID  WHERE ms.RESOURCE_ID IN ( @@RESOURCES@@ )";
                resultsQueryString = JDBCUtil.transformQueryForMultipleInParameters((String)resultsQueryString, (String)"@@RESOURCES@@", (int)batchIds.length);
                resultsStatement = conn.prepareStatement(resultsQueryString);
                JDBCUtil.bindNTimes((PreparedStatement)resultsStatement, (int[])batchIds, (int)1);
                HashMap<Integer, ResourceMeasurementScheduleRequest> scheduleRequestMap = new HashMap<Integer, ResourceMeasurementScheduleRequest>();
                ResultSet results = resultsStatement.executeQuery();
                while (results.next()) {
                    ResourceMeasurementScheduleRequest scheduleRequest;
                    Integer resourceId = results.getInt(1);
                    Integer scheduleId = results.getInt(2);
                    String definitionName = results.getString(3);
                    Long interval = results.getLong(4);
                    Boolean enabled = results.getBoolean(5);
                    DataType dataType = DataType.values()[results.getInt(6)];
                    NumericType rawNumericType = NumericType.values()[results.getInt(7)];
                    if (results.wasNull()) {
                        rawNumericType = null;
                    }
                    if ((scheduleRequest = (ResourceMeasurementScheduleRequest)scheduleRequestMap.get(resourceId)) == null) {
                        scheduleRequest = new ResourceMeasurementScheduleRequest(resourceId.intValue());
                        scheduleRequestMap.put(resourceId, scheduleRequest);
                        allSchedules.add(scheduleRequest);
                    }
                    MeasurementScheduleRequest requestData = new MeasurementScheduleRequest(scheduleId.intValue(), definitionName, interval.longValue(), enabled.booleanValue(), dataType, rawNumericType);
                    scheduleRequest.addMeasurementScheduleRequest(requestData);
                }
                Object var19_18 = null;
                if (resultsStatement == null) break block14;
            }
            catch (Throwable throwable) {
                Exception e22;
                Object var19_19 = null;
                if (resultsStatement != null) {
                    try {
                        resultsStatement.close();
                    }
                    catch (Exception e22) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception e22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                resultsStatement.close();
            }
            catch (Exception e22) {
                // empty catch block
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Exception e22) {}
        }
        return created;
    }

    private int[] getChildrenIdByParentIds(int[] batchIds) {
        Query query = this.entityManager.createNamedQuery("Resource.findChildrenIdsByParentIds");
        query.setParameter("parentIds", (Object)ArrayUtils.wrapInList((int[])batchIds));
        List results = query.getResultList();
        int[] batchChildrenIds = ArrayUtils.unwrapCollection((Collection)results);
        return batchChildrenIds;
    }

    @Override
    public int getScheduledMeasurementsPerMinute() {
        Number rate = 0;
        try {
            Query query = this.entityManager.createNamedQuery("MeasurementSchedule.getScheduledMeasurementsPerMinute");
            query.setParameter("status", (Object)InventoryStatus.COMMITTED);
            rate = (Number)query.getSingleResult();
        }
        catch (Throwable t) {
            this.measurementScheduleManager.errorCorrectSchedules();
        }
        return rate == null ? 0 : rate;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void errorCorrectSchedules() {
        try {
            long now = System.currentTimeMillis();
            String updateResourcesQueryString = " UPDATE Resource     SET mtime = :currentTime   WHERE id IN ( SELECT ms.resource.id                   FROM MeasurementSchedule ms                  WHERE ms.interval < 30000 ) ";
            Query updateResourcesQuery = this.entityManager.createQuery(updateResourcesQueryString);
            updateResourcesQuery.setParameter("currentTime", (Object)now);
            int resourcesUpdatedCount = updateResourcesQuery.executeUpdate();
            String updateSchedulesQueryString = " UPDATE MeasurementSchedule     SET interval = 30000   WHERE interval < 30000 ";
            Query updateSchedulesQuery = this.entityManager.createQuery(updateSchedulesQueryString);
            int schedulesUpdatedCount = updateSchedulesQuery.executeUpdate();
            if (resourcesUpdatedCount > 0) {
                String findResourcesQueryString = " SELECT res.id    FROM Resource res   WHERE res.mtime = :currentTime ";
                Query findResourcesQuery = this.entityManager.createQuery(findResourcesQueryString);
                findResourcesQuery.setParameter("currentTime", (Object)now);
                List updatedResourceIds = findResourcesQuery.getResultList();
                this.updateMeasurementSchedulesForResources(ArrayUtils.unwrapCollection((Collection)updatedResourceIds));
                this.log.error((Object)("MeasurementSchedule data was corrupt: automatically updated " + resourcesUpdatedCount + " resources and " + schedulesUpdatedCount + " to correct the issue; agents were notified"));
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"MeasurementSchedule data was checked for corruption, but all data was consistent");
            }
        }
        catch (Throwable t) {
            this.log.error((Object)"There was a problem correcting errors for MeasurementSchedules", t);
        }
    }

    private void updateMeasurementSchedulesForResources(int[] resourceIds) {
        Agent agent;
        if (resourceIds.length == 0) {
            return;
        }
        Subject overlord = this.subjectManager.getOverlord();
        PageList<org.rhq.core.domain.resource.Resource> resources = this.resourceManager.findResourceByIds(overlord, resourceIds, false, PageControl.getUnlimitedInstance());
        Set<ResourceMeasurementScheduleRequest> requests = this.findSchedulesForResourceAndItsDescendants(resourceIds, false);
        HashMap agentScheduleMap = new HashMap();
        for (org.rhq.core.domain.resource.Resource resource : resources) {
            agent = resource.getAgent();
            HashSet<ResourceMeasurementScheduleRequest> agentSchedules = (HashSet<ResourceMeasurementScheduleRequest>)agentScheduleMap.get(agent);
            if (agentSchedules == null) {
                agentSchedules = new HashSet<ResourceMeasurementScheduleRequest>();
                agentScheduleMap.put(agent, agentSchedules);
            }
            for (ResourceMeasurementScheduleRequest request : requests) {
                int resId = resource.getId();
                if (request.getResourceId() != resId) continue;
                agentSchedules.add(request);
            }
        }
        for (Map.Entry agentScheduleEntry : agentScheduleMap.entrySet()) {
            agent = (Agent)agentScheduleEntry.getKey();
            Set schedules = (Set)agentScheduleEntry.getValue();
            try {
                this.sendUpdatedSchedulesToAgent(agent, schedules);
            }
            catch (Throwable t) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Tried to immediately sync agent[name=" + agent.getName() + "] with error-corrected schedules failed"));
            }
        }
    }

    @Override
    public void disableSchedulesForResource(Subject subject, int resourceId, int[] measurementDefinitionIds) {
        if (!this.authorizationManager.hasResourcePermission(subject, Permission.MANAGE_MEASUREMENTS, resourceId)) {
            throw new PermissionException("User[" + subject.getName() + "] does not have permission to disable metric collection schedules for resource[id=" + resourceId + "]");
        }
        this.disableSchedule(subject, resourceId, measurementDefinitionIds);
    }

    @Override
    public void disableSchedulesForCompatibleGroup(Subject subject, int groupId, int[] measurementDefinitionIds) {
        if (!this.authorizationManager.hasGroupPermission(subject, Permission.MANAGE_MEASUREMENTS, groupId)) {
            throw new PermissionException("User[" + subject.getName() + "] does not have permission to disable metric collection schedules for resourceGroup[id=" + groupId + "]");
        }
        List<Integer> explicitIds = this.resourceManager.findExplicitResourceIdsByResourceGroup(groupId);
        for (Integer resourceId : explicitIds) {
            this.disableSchedule(subject, resourceId, measurementDefinitionIds);
        }
    }

    @Override
    public void disableMeasurementTemplates(Subject subject, int[] measurementDefinitionIds) {
        this.disableDefaultCollectionForMeasurementDefinitions(subject, measurementDefinitionIds, true);
    }

    @Override
    public void enableSchedulesForResource(Subject subject, int resourceId, int[] measurementDefinitionIds) {
        if (!this.authorizationManager.hasResourcePermission(subject, Permission.MANAGE_MEASUREMENTS, resourceId)) {
            throw new PermissionException("User[" + subject.getName() + "] does not have permission to enable metric collection schedules for resource[id=" + resourceId + "]");
        }
        this.enableSchedule(subject, resourceId, measurementDefinitionIds);
    }

    @Override
    public void enableSchedulesForCompatibleGroup(Subject subject, int groupId, int[] measurementDefinitionIds) {
        if (!this.authorizationManager.hasGroupPermission(subject, Permission.MANAGE_MEASUREMENTS, groupId)) {
            throw new PermissionException("User[" + subject.getName() + "] does not have permission to enable metric collection schedules for resourceGroup[id=" + groupId + "]");
        }
        List<Integer> explicitIds = this.resourceManager.findExplicitResourceIdsByResourceGroup(groupId);
        for (Integer resourceId : explicitIds) {
            this.enableSchedule(subject, resourceId, measurementDefinitionIds);
        }
    }

    @Override
    public void enableMeasurementTemplates(Subject subject, int[] measurementDefinitionIds) {
        this.modifyDefaultCollectionIntervalForMeasurementDefinitions(subject, measurementDefinitionIds, true, -1L, true);
    }

    @Override
    public void updateSchedule(Subject subject, MeasurementSchedule schedule) {
        MeasurementSchedule attached = (MeasurementSchedule)this.entityManager.find(MeasurementSchedule.class, (Object)schedule.getId());
        if (!this.authorizationManager.hasResourcePermission(subject, Permission.MANAGE_MEASUREMENTS, attached.getResource().getId())) {
            throw new PermissionException("User[" + subject.getName() + "] does not have permission to view measurementSchedule[id=" + schedule.getId() + "]");
        }
        this.verifyMinimumCollectionInterval(schedule);
        this.entityManager.merge((Object)schedule);
    }

    @Override
    public void updateSchedulesForResource(Subject subject, int resourceId, int[] measurementDefinitionIds, long collectionInterval) {
        this.updateSchedules(subject, resourceId, measurementDefinitionIds, collectionInterval);
    }

    @Override
    public void updateSchedulesForCompatibleGroup(Subject subject, int groupId, int[] measurementDefinitionIds, long collectionInterval) {
        List<Integer> explicitIds = this.resourceManager.findExplicitResourceIdsByResourceGroup(groupId);
        for (Integer resourceId : explicitIds) {
            this.updateSchedules(subject, resourceId, measurementDefinitionIds, collectionInterval);
        }
    }

    @Override
    public void updateMeasurementTemplates(Subject subject, int[] measurementDefinitionIds, long collectionInterval) {
        this.updateDefaultCollectionIntervalForMeasurementDefinitions(subject, measurementDefinitionIds, collectionInterval, true);
    }

    @Override
    public PageList<MeasurementSchedule> findSchedulesByCriteria(Subject subject, MeasurementScheduleCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator((Criteria)criteria);
        if (!this.authorizationManager.isInventoryManager(subject)) {
            generator.setAuthorizationResourceFragment(CriteriaQueryGenerator.AuthorizationTokenType.RESOURCE, subject.getId());
        }
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }
}

