/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement.util;

import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataPK;
import org.rhq.core.domain.measurement.composite.MeasurementDataNumericHighLowComposite;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.enterprise.server.measurement.MeasurementAggregate;
import org.rhq.enterprise.server.measurement.MeasurementNotFoundException;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasurementDataManagerUtility {
    private static final Log LOG = LogFactory.getLog(MeasurementDataManagerUtility.class);
    public static final int STORED_DAYS = 7;
    public static final int TABLES_PER_DAY = 2;
    public static final int BUFFER_TABLES = 1;
    public static final int LIVE_TABLES = 14;
    public static final int TABLE_COUNT = 15;
    private static final String TABLE_PREFIX = "RHQ_MEAS_DATA_NUM_R";
    static final String TABLE_DATA_1H = "RHQ_MEASUREMENT_DATA_NUM_1H";
    static final String TABLE_DATA_6H = "RHQ_MEASUREMENT_DATA_NUM_6H";
    static final String TABLE_DATA_1D = "RHQ_MEASUREMENT_DATA_NUM_1D";
    private static final int MAX_IN_CLAUSE_PARAMS = 1000;
    private static NumberFormat nf = new DecimalFormat("00");
    private static final long MILLISECONDS_PER_DAY = 86400000L;
    public static final long MILLESECONDS_PER_TABLE = 43200000L;
    public static final long RAW_PURGE = 604800000L;
    public static final int DEFAULT_NUM_DATA_POINTS = 60;
    private Connection connection;
    private DataSource datasource;
    private static long purge1h;
    private static long purge6h;
    private static long purge1d;
    private static long purgeRt;
    private static long purgeAlert;

    public static MeasurementDataManagerUtility getInstance(DataSource dataSource) {
        MeasurementDataManagerUtility util = new MeasurementDataManagerUtility();
        util.datasource = dataSource;
        return util;
    }

    public static MeasurementDataManagerUtility getInstance(Connection connection) {
        MeasurementDataManagerUtility util = new MeasurementDataManagerUtility();
        util.connection = connection;
        return util;
    }

    public static String getTable(long time) {
        return TABLE_PREFIX + nf.format(MeasurementDataManagerUtility.getTableIndex(time));
    }

    public static String[] getAllRawTables() {
        String[] tables = new String[15];
        for (int i = 0; i < 15; ++i) {
            tables[i] = TABLE_PREFIX + nf.format(i);
        }
        return tables;
    }

    public static String[] getAllRawTables(int startIndex) {
        String[] tables = new String[15];
        for (int i = 0; i < 15; ++i) {
            tables[i] = TABLE_PREFIX + nf.format((i + startIndex) % 15);
        }
        return tables;
    }

    public static String[] getTables(long beginTime, long endTime) {
        ArrayList<String> tables = new ArrayList<String>();
        long now = System.currentTimeMillis();
        if (now - 604800000L < beginTime) {
            int startIndex = MeasurementDataManagerUtility.getTableIndex(beginTime);
            int endIndex = MeasurementDataManagerUtility.getTableIndex(endTime);
            int tableCount = (endIndex + 15 - startIndex) % 15 + 1;
            if (endTime - beginTime > 604800000L) {
                throw new RuntimeException("Time span greater than raw data storage");
            }
            for (int i = 0; i < tableCount; ++i) {
                tables.add(TABLE_PREFIX + nf.format((startIndex + i) % 15));
            }
            return tables.toArray(new String[tables.size()]);
        }
        if (now - purge1h < beginTime) {
            return new String[]{TABLE_DATA_1H};
        }
        if (now - purge6h < beginTime) {
            return new String[]{TABLE_DATA_6H};
        }
        return new String[]{TABLE_DATA_1D};
    }

    public static String getDeadTable(long time) {
        long tableIndex = MeasurementDataManagerUtility.getTableIndex(time);
        return TABLE_PREFIX + nf.format((tableIndex + 1L) % 15L);
    }

    public static String getCurrentRawTable() {
        return MeasurementDataManagerUtility.getTable(System.currentTimeMillis());
    }

    public static String getNextRotationTime() {
        long day;
        long timeOfDay;
        long remaining;
        long now = System.currentTimeMillis();
        long nextRotation = now + (remaining = 43200000L - (timeOfDay = now - (day = now / 86400000L) * 86400000L));
        if (nextRotation < now) {
            nextRotation += 43200000L;
        }
        return DateFormat.getDateTimeInstance(1, 0).format(new Date(nextRotation));
    }

    private static int getTableIndex(long time) {
        long day = time / 86400000L;
        long timeOfDay = time - day * 86400000L;
        long table = day * 2L + timeOfDay / 43200000L;
        long tableIndex = table % 15L;
        return (int)tableIndex;
    }

    public static int getTableNameIndex(String tableName) {
        int result;
        String indexString = tableName.substring(TABLE_PREFIX.length());
        try {
            result = Integer.valueOf(indexString);
        }
        catch (NumberFormatException e) {
            LOG.error((Object)("Invalid raw table name: " + tableName + ", returning table index 0."));
            result = 0;
        }
        return result;
    }

    private static void loadPurgeDefaults() {
        LOG.debug((Object)"Loading default purge intervals");
        try {
            Properties conf = LookupUtil.getSystemManager().getSystemConfiguration();
            purge1h = Long.parseLong(conf.getProperty("CAM_DATA_PURGE_1H"));
            purge6h = Long.parseLong(conf.getProperty("CAM_DATA_PURGE_6H"));
            purge1d = Long.parseLong(conf.getProperty("CAM_DATA_PURGE_1D"));
            purgeRt = Long.parseLong(conf.getProperty("RT_DATA_PURGE"));
            purgeAlert = Long.parseLong(conf.getProperty("ALERT_PURGE"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<List<MeasurementDataNumericHighLowComposite>> getMeasurementDataForResource(long beginTime, long endTime, int resourceId, int[] measurementDefinitionIds) throws MeasurementNotFoundException {
        return this.getMeasurementDataForResource(beginTime, endTime, resourceId, measurementDefinitionIds, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<MeasurementDataNumericHighLowComposite>> getMeasurementDataForResource(long beginTime, long endTime, int resourceId, int[] measurementDefinitionIds, int numDataPoints) throws MeasurementNotFoundException {
        String otherTable = ", RHQ_MEASUREMENT_SCHED s ";
        String conditions = "  AND d.schedule_id = s.id  AND s.resource_id = ? \n  AND s.definition = ? \n";
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection myConnection = null;
        ArrayList<List<MeasurementDataNumericHighLowComposite>> data = new ArrayList<List<MeasurementDataNumericHighLowComposite>>();
        try {
            myConnection = this.getConnection();
            for (int measurementDefinitionId : measurementDefinitionIds) {
                ps = null;
                rs = null;
                try {
                    ps = this.getFullQuery(myConnection, beginTime, endTime, numDataPoints, otherTable, conditions, resourceId, measurementDefinitionId);
                    rs = ps.executeQuery();
                    ArrayList<MeasurementDataNumericHighLowComposite> compositeList = new ArrayList<MeasurementDataNumericHighLowComposite>();
                    while (rs.next()) {
                        long timestamp = rs.getLong(1);
                        double value = rs.getDouble(2);
                        if (rs.wasNull()) {
                            value = Double.NaN;
                        }
                        double peak = rs.getDouble(3);
                        if (rs.wasNull()) {
                            peak = Double.NaN;
                        }
                        double low = rs.getDouble(4);
                        if (rs.wasNull()) {
                            low = Double.NaN;
                        }
                        MeasurementDataNumericHighLowComposite next = new MeasurementDataNumericHighLowComposite(timestamp, value, peak, low);
                        compositeList.add(next);
                    }
                    data.add(compositeList);
                }
                catch (Throwable throwable) {
                    JDBCUtil.safeClose(ps, rs);
                    throw throwable;
                }
                JDBCUtil.safeClose((Statement)ps, (ResultSet)rs);
            }
        }
        catch (SQLException e) {
            throw new MeasurementNotFoundException(e);
        }
        finally {
            JDBCUtil.safeClose((Connection)myConnection);
            this.connection = null;
        }
        return data;
    }

    public List<List<MeasurementDataNumericHighLowComposite>> getMeasurementDataForSiblingResources(long beginTime, long endTime, int[] resourceIds, int measurementDefinitionId) throws MeasurementNotFoundException {
        return this.getMeasurementDataForSiblingResources(beginTime, endTime, resourceIds, measurementDefinitionId, 0);
    }

    public List<List<MeasurementDataNumericHighLowComposite>> getMeasurementDataForSiblingResources(long beginTime, long endTime, int[] resourceIds, int measurementDefinitionId, int numDataPoints) throws MeasurementNotFoundException {
        String otherTable = ", RHQ_MEASUREMENT_SCHED s ";
        String conditions = "  AND d.schedule_id = s.id  AND s.resource_id = ? \n  AND s.definition = ? \n";
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection myConnection = null;
        ArrayList<List<MeasurementDataNumericHighLowComposite>> data = new ArrayList<List<MeasurementDataNumericHighLowComposite>>();
        for (int resourceId : resourceIds) {
            try {
                myConnection = this.getConnection();
                ps = this.getFullQuery(myConnection, beginTime, endTime, numDataPoints, otherTable, conditions, resourceId, measurementDefinitionId);
                rs = ps.executeQuery();
                ArrayList<MeasurementDataNumericHighLowComposite> compositeList = new ArrayList<MeasurementDataNumericHighLowComposite>();
                while (rs.next()) {
                    long timestamp = rs.getLong(1);
                    double value = rs.getDouble(2);
                    if (rs.wasNull()) {
                        value = Double.NaN;
                    }
                    double peak = rs.getDouble(3);
                    if (rs.wasNull()) {
                        peak = Double.NaN;
                    }
                    double low = rs.getDouble(4);
                    if (rs.wasNull()) {
                        low = Double.NaN;
                    }
                    MeasurementDataNumericHighLowComposite next = new MeasurementDataNumericHighLowComposite(timestamp, value, peak, low);
                    compositeList.add(next);
                }
                data.add(compositeList);
            }
            catch (SQLException e) {
                try {
                    throw new MeasurementNotFoundException(e);
                }
                catch (Throwable throwable) {
                    JDBCUtil.safeClose((Connection)myConnection, ps, rs);
                    this.connection = null;
                    throw throwable;
                }
            }
            JDBCUtil.safeClose((Connection)myConnection, (Statement)ps, (ResultSet)rs);
            this.connection = null;
        }
        return data;
    }

    public List<List<MeasurementDataNumericHighLowComposite>> getMeasurementDataAggregatesForSiblingResources(long beginTime, long endTime, int[] resourceIds, int measurementDefinitionId) throws MeasurementNotFoundException {
        return this.getMeasurementDataAggregatesForSiblingResources(beginTime, endTime, resourceIds, measurementDefinitionId, 0);
    }

    public List<List<MeasurementDataNumericHighLowComposite>> getMeasurementDataAggregatesForSiblingResources(long beginTime, long endTime, int[] resourceIds, int measurementDefinitionId, int numDataPoints) throws MeasurementNotFoundException {
        List<List<MeasurementDataNumericHighLowComposite>> list;
        String otherTable = ", RHQ_MEASUREMENT_SCHED s ";
        String conditions = "  AND d.schedule_id = s.id  AND s.resource_id IN ( " + JDBCUtil.generateInBinds((int)resourceIds.length) + ") \n" + "  AND s.definition = ? \n";
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection myConnection = null;
        ArrayList data = new ArrayList();
        try {
            myConnection = this.getConnection();
            ps = this.getFullQuery(myConnection, beginTime, endTime, numDataPoints, otherTable, conditions, resourceIds, measurementDefinitionId);
            rs = ps.executeQuery();
            ArrayList<MeasurementDataNumericHighLowComposite> compositeList = new ArrayList<MeasurementDataNumericHighLowComposite>();
            while (rs.next()) {
                long timestamp = rs.getLong(1);
                double value = rs.getDouble(2);
                if (rs.wasNull()) {
                    value = Double.NaN;
                }
                double peak = rs.getDouble(3);
                if (rs.wasNull()) {
                    peak = Double.NaN;
                }
                double low = rs.getDouble(4);
                if (rs.wasNull()) {
                    low = Double.NaN;
                }
                MeasurementDataNumericHighLowComposite next = new MeasurementDataNumericHighLowComposite(timestamp, value, peak, low);
                compositeList.add(next);
            }
            data.add(compositeList);
            list = Collections.singletonList(compositeList);
        }
        catch (SQLException e) {
            try {
                throw new MeasurementNotFoundException(e);
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose((Connection)myConnection, ps, rs);
                this.connection = null;
                throw throwable;
            }
        }
        JDBCUtil.safeClose((Connection)myConnection, (Statement)ps, (ResultSet)rs);
        this.connection = null;
        return list;
    }

    public MeasurementAggregate getAggregateByScheduleId(long beginTime, long endTime, long scheduleId) throws MeasurementNotFoundException {
        ResultSet rs;
        PreparedStatement ps;
        Connection myConnection;
        block5: {
            MeasurementAggregate measurementAggregate;
            myConnection = null;
            ps = null;
            rs = null;
            myConnection = this.getConnection();
            String condition = "         AND d.schedule_id = ?\n";
            ps = this.getFullQuery(myConnection, beginTime, endTime, 1, "", condition, scheduleId);
            rs = ps.executeQuery();
            if (!rs.next()) break block5;
            MeasurementAggregate measurementAggregate2 = measurementAggregate = this.fillAggregateFromResultSet(rs);
            JDBCUtil.safeClose((Connection)myConnection, (Statement)ps, (ResultSet)rs);
            this.connection = null;
            return measurementAggregate2;
        }
        try {
            try {
                throw new MeasurementNotFoundException("Data not found");
            }
            catch (SQLException e) {
                throw new MeasurementNotFoundException(e);
            }
        }
        catch (Throwable throwable) {
            JDBCUtil.safeClose((Connection)myConnection, ps, rs);
            this.connection = null;
            throw throwable;
        }
    }

    public MeasurementAggregate getAggregateByGroupAndDefinition(long beginTime, long endTime, int groupId, int definitionId) throws MeasurementNotFoundException {
        ResultSet rs;
        PreparedStatement ps;
        Connection myConnection;
        block5: {
            MeasurementAggregate measurementAggregate;
            myConnection = null;
            ps = null;
            rs = null;
            myConnection = this.getConnection();
            String condition = " AND d.schedule_id IN ( SELECT m_sched.id \n                                       FROM rhq_measurement_sched m_sched, \n                                            rhq_resource_group_res_imp_map imp_map \n                                      WHERE m_sched.resource_id = imp_map.resource_id \n                                        AND imp_map.resource_group_id = ? \n                                        AND m_sched.definition = ? ) \n";
            ps = this.getFullQuery(myConnection, beginTime, endTime, 1, "", condition, groupId, definitionId);
            rs = ps.executeQuery();
            if (!rs.next()) break block5;
            MeasurementAggregate measurementAggregate2 = measurementAggregate = this.fillAggregateFromResultSet(rs);
            JDBCUtil.safeClose((Connection)myConnection, (Statement)ps, (ResultSet)rs);
            this.connection = null;
            return measurementAggregate2;
        }
        try {
            try {
                throw new MeasurementNotFoundException("Data not found");
            }
            catch (SQLException e) {
                throw new MeasurementNotFoundException(e);
            }
        }
        catch (Throwable throwable) {
            JDBCUtil.safeClose((Connection)myConnection, ps, rs);
            this.connection = null;
            throw throwable;
        }
    }

    private MeasurementAggregate fillAggregateFromResultSet(ResultSet rs) throws SQLException {
        Double min = rs.getDouble(4);
        if (rs.wasNull()) {
            min = Double.NaN;
        }
        Double avg = rs.getDouble(2);
        if (rs.wasNull()) {
            avg = Double.NaN;
        }
        Double max = rs.getDouble(3);
        if (rs.wasNull()) {
            max = Double.NaN;
        }
        MeasurementAggregate measurementAggregate = new MeasurementAggregate(min, avg, max);
        return measurementAggregate;
    }

    public MeasurementAggregate getAggregateByScheduleIds(long beginTime, long endTime, int[] scheduleIds) throws MeasurementNotFoundException {
        String condition;
        ResultSet rs;
        PreparedStatement ps;
        Connection myConnection;
        block5: {
            MeasurementAggregate measurementAggregate;
            myConnection = null;
            ps = null;
            rs = null;
            condition = null;
            condition = "         AND d.schedule_id IN ( " + JDBCUtil.generateInBinds((int)scheduleIds.length) + ")\n";
            myConnection = this.getConnection();
            ps = this.getFullQuery(myConnection, beginTime, endTime, 1, "", condition, new Object[]{scheduleIds});
            rs = ps.executeQuery();
            if (!rs.next()) break block5;
            MeasurementAggregate measurementAggregate2 = measurementAggregate = this.fillAggregateFromResultSet(rs);
            JDBCUtil.safeClose((Connection)myConnection, (Statement)ps, (ResultSet)rs);
            this.connection = null;
            return measurementAggregate2;
        }
        try {
            try {
                throw new MeasurementNotFoundException("Data not found");
            }
            catch (SQLException e) {
                LOG.warn((Object)("Error condition :" + condition));
                throw new MeasurementNotFoundException(e);
            }
        }
        catch (Throwable throwable) {
            JDBCUtil.safeClose(myConnection, ps, rs);
            this.connection = null;
            throw throwable;
        }
    }

    public MeasurementDataNumeric getLatestValueForSchedule(int scheduleId) {
        long now = System.currentTimeMillis();
        int index = MeasurementDataManagerUtility.getTableIndex(now);
        do {
            ResultSet rs;
            PreparedStatement ps;
            Connection myConnection;
            block5: {
                MeasurementDataNumeric measurementDataNumeric;
                myConnection = null;
                ps = null;
                rs = null;
                try {
                    myConnection = this.getConnection();
                    String table = TABLE_PREFIX + nf.format(index);
                    String query = "SELECT d.time_stamp, d.value \nFROM " + table + " d \n" + "WHERE d.schedule_id = ? \n" + "AND d.time_stamp = ( SELECT MAX(dd.time_stamp) \n" + "FROM " + table + " dd \n" + "WHERE dd.schedule_id = ? )";
                    ps = myConnection.prepareStatement(query);
                    ps.setInt(1, scheduleId);
                    ps.setInt(2, scheduleId);
                    rs = ps.executeQuery();
                    if (!rs.next()) break block5;
                    measurementDataNumeric = new MeasurementDataNumeric(new MeasurementDataPK(rs.getLong(1), scheduleId), Double.valueOf(rs.getDouble(2)));
                }
                catch (SQLException e) {
                    try {
                        throw new MeasurementNotFoundException(e);
                    }
                    catch (Throwable throwable) {
                        JDBCUtil.safeClose((Connection)myConnection, ps, rs);
                        this.connection = null;
                        throw throwable;
                    }
                }
                JDBCUtil.safeClose((Connection)myConnection, (Statement)ps, (ResultSet)rs);
                this.connection = null;
                return measurementDataNumeric;
            }
            JDBCUtil.safeClose((Connection)myConnection, (Statement)ps, (ResultSet)rs);
            this.connection = null;
            if (--index >= 0) continue;
            index = 14;
        } while (!(TABLE_PREFIX + nf.format(index)).equals(MeasurementDataManagerUtility.getDeadTable(now)));
        return null;
    }

    private PreparedStatement getFullQuery(Connection connection, long beginTime, long endTime, int numDataPoints, String otherTables, String conditions, Object ... bindParameters) throws SQLException {
        String[] tables;
        numDataPoints = numDataPoints <= 0 ? 60 : numDataPoints;
        long interval = (endTime - beginTime) / (long)numDataPoints;
        String valuesClause = MeasurementDataManagerUtility.isRawTimePeriod(beginTime) ? "avg(value), max(value) as peak, min(value) as low" : "avg(value), max(maxvalue) as peak, min(minvalue) as low";
        StringBuilder unions = new StringBuilder();
        for (String table : tables = MeasurementDataManagerUtility.getTables(beginTime, endTime)) {
            if (unions.length() != 0) {
                unions.append("   UNION ALL \n ");
            }
            unions.append(MeasurementDataManagerUtility.getTableString(table, valuesClause, otherTables, conditions));
        }
        String sql = "SELECT timestamp, max(av), max(peak), max(low) FROM ( \n   (SELECT timestamp, avg(value) as av, max(value) as peak, min(value) as low FROM (\n" + unions.toString() + "   ) data GROUP BY timestamp) \n" + "   UNION ALL (select ? + (? * i) as timestamp, null as av, null as peak, null as low from RHQ_numbers where i < ?) ) alldata \n" + "GROUP BY timestamp ORDER BY timestamp";
        PreparedStatement ps = connection.prepareStatement(sql);
        StringBuilder fullSql = null;
        if (LOG.isDebugEnabled()) {
            fullSql = new StringBuilder(sql);
        }
        int i = 1;
        for (String table : tables) {
            ps.setLong(i++, beginTime);
            ps.setLong(i++, interval);
            ps.setInt(i++, numDataPoints);
            ps.setLong(i++, interval);
            if (LOG.isDebugEnabled()) {
                fullSql.replace(fullSql.indexOf("?"), fullSql.indexOf("?") + 1, String.valueOf(beginTime));
                fullSql.replace(fullSql.indexOf("?"), fullSql.indexOf("?") + 1, String.valueOf(interval));
                fullSql.replace(fullSql.indexOf("?"), fullSql.indexOf("?") + 1, String.valueOf(numDataPoints));
                fullSql.replace(fullSql.indexOf("?"), fullSql.indexOf("?") + 1, String.valueOf(interval));
            }
            for (Object param : bindParameters) {
                if (param.getClass().isArray()) {
                    int length = Array.getLength(param);
                    if (length > 1000) {
                        throw new IllegalArgumentException("Number of resource id's must be less than or equal to 1000.");
                    }
                    for (int x = 0; x < length; ++x) {
                        ps.setObject(i++, Array.get(param, x));
                        if (!LOG.isDebugEnabled()) continue;
                        fullSql.replace(fullSql.indexOf("?"), fullSql.indexOf("?") + 1, String.valueOf(param));
                    }
                    continue;
                }
                ps.setObject(i++, param);
                if (!LOG.isDebugEnabled()) continue;
                fullSql.replace(fullSql.indexOf("?"), fullSql.indexOf("?") + 1, String.valueOf(param));
            }
        }
        ps.setLong(i++, beginTime);
        ps.setLong(i++, interval);
        ps.setInt(i++, numDataPoints);
        if (LOG.isDebugEnabled()) {
            fullSql.replace(fullSql.indexOf("?"), fullSql.indexOf("?") + 1, String.valueOf(beginTime));
            fullSql.replace(fullSql.indexOf("?"), fullSql.indexOf("?") + 1, String.valueOf(interval));
            fullSql.replace(fullSql.indexOf("?"), fullSql.indexOf("?") + 1, String.valueOf(numDataPoints));
            LOG.debug((Object)fullSql);
        }
        return ps;
    }

    public static String getTableString(String table, String valuesClause, String otherTables, String conditions) {
        return "      (SELECT beginTS as timestamp, value \n      FROM (select ? + (? * i) as beginTS, i from RHQ_numbers where i < ?) n,\n         " + table + " d " + otherTables + " \n" + "      WHERE time_stamp BETWEEN beginTS AND (beginTS + ?)\n" + "      " + conditions + "      ) \n";
    }

    public long getPurge1h() {
        return purge1h;
    }

    public long getPurge6h() {
        return purge6h;
    }

    public long getPurge1d() {
        return purge1d;
    }

    public long getPurgeRt() {
        return purgeRt;
    }

    public long getPurgeAlert() {
        return purgeAlert;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(MeasurementDataManagerUtility.getNextRotationTime());
        Class.forName("oracle.jdbc.driver.OracleDriver");
        String db = "jdbc:oracle:thin:@192.168.1.5:1521:xe";
        System.out.println("=============getAggregateByScheduleId=================================================");
        Connection c = DriverManager.getConnection(db, "jon", "jon");
        long now = System.currentTimeMillis();
        long start = now - 79200000L;
        MeasurementAggregate ag = MeasurementDataManagerUtility.getInstance(c).getAggregateByScheduleId(start, now, 1L);
        System.out.println(ag);
        System.out.println("=============getAggregateByScheduleIds=================================================");
        c = DriverManager.getConnection(db, "jon", "jon");
        ag = MeasurementDataManagerUtility.getInstance(c).getAggregateByScheduleIds(start, now, new int[]{1, 2, 3});
        System.out.println(ag);
        System.out.println("=============getMeasurementDataForResource=================================================");
        c = DriverManager.getConnection(db, "jon", "jon");
        List<List<MeasurementDataNumericHighLowComposite>> data = MeasurementDataManagerUtility.getInstance(c).getMeasurementDataForResource(start, now, 50, new int[]{166});
        System.out.println(data);
        System.out.println("===========getMeasurementDataForSiblingResources===================================================");
        c = DriverManager.getConnection(db, "jon", "jon");
        data = MeasurementDataManagerUtility.getInstance(c).getMeasurementDataForSiblingResources(start, now, new int[]{50}, 166);
        System.out.println(data);
        System.out.println("=============getMeasurementDataAggregatesForSiblingResources=================================================");
        c = DriverManager.getConnection(db, "jon", "jon");
        data = MeasurementDataManagerUtility.getInstance(c).getMeasurementDataAggregatesForSiblingResources(start, now, new int[]{50}, 166);
        System.out.println(data);
        Object[] ts = MeasurementDataManagerUtility.getTables(now - 28800000L, now);
        System.out.println(Arrays.toString(ts));
        System.out.println("NOW: " + MeasurementDataManagerUtility.getTable(now));
    }

    public static long getRawTimePeriodStart(long end) {
        long now = System.currentTimeMillis();
        return end - 604800000L;
    }

    public static boolean isRawTimePeriod(long beginTime) {
        long now = System.currentTimeMillis();
        return now - 604800000L < beginTime;
    }

    public static boolean isRawTable(String tableName) {
        return null != tableName && tableName.startsWith(TABLE_PREFIX);
    }

    private Connection getConnection() throws SQLException {
        if (this.connection != null) {
            return this.connection;
        }
        return this.datasource.getConnection();
    }

    static {
        MeasurementDataManagerUtility.loadPurgeDefaults();
    }
}

