/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.perspective;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.domain.resource.Resource;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.cloud.instance.ServerManagerLocal;
import org.rhq.enterprise.server.perspective.Extension;
import org.rhq.enterprise.server.perspective.MenuItem;
import org.rhq.enterprise.server.perspective.PageLink;
import org.rhq.enterprise.server.perspective.PerspectiveException;
import org.rhq.enterprise.server.perspective.PerspectiveManagerHelper;
import org.rhq.enterprise.server.perspective.PerspectiveManagerLocal;
import org.rhq.enterprise.server.perspective.PerspectiveManagerRemote;
import org.rhq.enterprise.server.perspective.PerspectiveTarget;
import org.rhq.enterprise.server.perspective.Tab;
import org.rhq.enterprise.server.perspective.activator.Activator;
import org.rhq.enterprise.server.perspective.activator.context.ActivationContext;
import org.rhq.enterprise.server.perspective.activator.context.ActivationContextScope;
import org.rhq.enterprise.server.perspective.activator.context.GlobalActivationContext;
import org.rhq.enterprise.server.perspective.activator.context.ResourceActivationContext;
import org.rhq.enterprise.server.plugin.pc.perspective.metadata.PerspectivePluginMetadataManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class PerspectiveManagerBean
implements PerspectiveManagerLocal,
PerspectiveManagerRemote {
    private static final Map<Integer, CacheEntry> CACHE = new HashMap<Integer, CacheEntry>();
    private static Server server = null;
    private final Log log = LogFactory.getLog(PerspectiveManagerBean.class);
    @EJB
    private ServerManagerLocal serverManager;
    @EJB
    private SubjectManagerLocal subjectManager;

    @Override
    public synchronized List<MenuItem> getMenu(Subject subject) throws PerspectiveException {
        CacheEntry cacheEntry = this.getCacheEntry(subject);
        List<MenuItem> menu = cacheEntry.getMenu();
        return menu;
    }

    @Override
    @NotNull
    public List<Tab> getResourceTabs(Subject subject, Resource resource) {
        CacheEntry cacheEntry = this.getCacheEntry(subject);
        List<Tab> tabs = cacheEntry.getTabs();
        ResourceActivationContext context = new ResourceActivationContext(subject, resource);
        EnumSet<ActivationContextScope> scopes = EnumSet.of(ActivationContextScope.RESOURCE_OR_GROUP);
        List<Tab> filteredTabs = this.applyActivatorsToTabs(context, scopes, tabs);
        return filteredTabs;
    }

    @Override
    public String getPageLink(Subject subject, String pageName, String linkName, String defaultValue) {
        CacheEntry cacheEntry = this.getCacheEntry(subject);
        List<PageLink> pageLinks = cacheEntry.getPageLinks();
        String result = defaultValue;
        for (PageLink pageLink : pageLinks) {
            if (!pageLink.getPageName().equals(pageName) || !pageLink.getName().equals(linkName)) continue;
            result = pageLink.getUrl();
            break;
        }
        return result;
    }

    private List<MenuItem> applyActivatorsToMenu(ActivationContext context, EnumSet<ActivationContextScope> scopes, List<MenuItem> menu) {
        ArrayList<MenuItem> filteredMenu = new ArrayList<MenuItem>();
        for (MenuItem menuItem : menu) {
            if (!this.isActive(context, scopes, menuItem)) continue;
            MenuItem clone = null;
            try {
                clone = (MenuItem)menuItem.clone();
            }
            catch (CloneNotSupportedException e) {
                this.log.error((Object)("Invalid Clone - This should not happen: " + e));
            }
            filteredMenu.add(clone);
            List<MenuItem> filteredChildren = this.applyActivatorsToMenu(context, scopes, clone.getChildren());
            clone.setChildren(filteredChildren);
        }
        return filteredMenu;
    }

    private List<Tab> applyActivatorsToTabs(ActivationContext context, EnumSet<ActivationContextScope> scopes, List<Tab> tabs) {
        ArrayList<Tab> filteredTabs = new ArrayList<Tab>();
        for (Tab tab : tabs) {
            if (!this.isActive(context, scopes, tab)) continue;
            Tab clone = null;
            try {
                clone = (Tab)tab.clone();
            }
            catch (CloneNotSupportedException e) {
                this.log.error((Object)("Invalid Clone - This should not happen: " + e));
            }
            filteredTabs.add(clone);
            List<Tab> filteredChildren = this.applyActivatorsToTabs(context, scopes, clone.getChildren());
            clone.setChildren(filteredChildren);
        }
        return filteredTabs;
    }

    private List<PageLink> applyActivatorsToPageLinks(ActivationContext context, EnumSet<ActivationContextScope> scopes, List<PageLink> pageLinks) {
        ArrayList<PageLink> filteredPageLinks = new ArrayList<PageLink>();
        for (PageLink pageLink : pageLinks) {
            if (!this.isActive(context, scopes, pageLink)) continue;
            filteredPageLinks.add(pageLink);
        }
        return filteredPageLinks;
    }

    private boolean isActive(ActivationContext context, EnumSet<ActivationContextScope> scopes, Extension extension) {
        List<Activator<?>> activators = extension.getActivators();
        for (Activator<?> activator : activators) {
            if (!scopes.contains((Object)activator.getScope()) || activator.isActive(context)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheEntry getCacheEntry(Subject subject) {
        CacheEntry cacheEntry;
        Integer sessionId = subject.getSessionId();
        Map<Integer, CacheEntry> map = CACHE;
        synchronized (map) {
            cacheEntry = CACHE.get(sessionId);
        }
        long metadataLastModifiedTime = this.getPluginMetadataManager().getLastModifiedTime();
        if (cacheEntry == null || cacheEntry.getMetadataLastModifiedTime() < metadataLastModifiedTime) {
            this.cleanCache();
            GlobalActivationContext context = new GlobalActivationContext(subject);
            EnumSet<ActivationContextScope> scopes = EnumSet.of(ActivationContextScope.GLOBAL);
            List<MenuItem> baseMenu = this.getPluginMetadataManager().getMenu();
            List<MenuItem> filteredMenu = this.applyActivatorsToMenu(context, scopes, baseMenu);
            List<Tab> baseTabs = this.getPluginMetadataManager().getResourceTabs();
            List<Tab> filteredTabs = this.applyActivatorsToTabs(context, scopes, baseTabs);
            List<PageLink> basePageLinks = this.getPluginMetadataManager().getPageLinks();
            List<PageLink> filteredPageLinks = this.applyActivatorsToPageLinks(context, scopes, basePageLinks);
            cacheEntry = new CacheEntry(metadataLastModifiedTime, filteredMenu, filteredTabs, filteredPageLinks);
            Map<Integer, CacheEntry> map2 = CACHE;
            synchronized (map2) {
                CACHE.put(sessionId, cacheEntry);
            }
        }
        return cacheEntry;
    }

    private PerspectivePluginMetadataManager getPluginMetadataManager() {
        return PerspectiveManagerHelper.getPluginMetadataManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanCache() {
        Map<Integer, CacheEntry> map = CACHE;
        synchronized (map) {
            Iterator<Integer> iterator = CACHE.keySet().iterator();
            while (iterator.hasNext()) {
                Integer sessionId = iterator.next();
                try {
                    Subject subject = this.subjectManager.getSubjectBySessionId(sessionId);
                    if (null != subject) continue;
                    this.log.debug((Object)("Removing perspective cache entry for session. " + sessionId));
                    iterator.remove();
                }
                catch (Exception e) {
                    this.log.debug((Object)("Removing perspective cache entry for session: " + sessionId));
                    iterator.remove();
                }
            }
        }
    }

    private void printMenu(List<MenuItem> menu, String indent) {
        if (null == menu) {
            return;
        }
        for (MenuItem menuItem : menu) {
            System.out.println(indent + menuItem.getName());
            this.printMenu(menuItem.getChildren(), indent + "..");
        }
    }

    @Override
    public String getUrlViaKey(int key) throws PerspectiveException {
        try {
            return this.getPluginMetadataManager().getUrlViaKey(key);
        }
        catch (Exception e) {
            throw new PerspectiveException("Failed to get URL for key: " + key, e);
        }
    }

    @Override
    public String getMenuItemUrl(Subject subject, String menuItemName, boolean makeExplicit, boolean makeSecure) {
        if (null == menuItemName) {
            throw new IllegalArgumentException("Invalid menuItemName: null ");
        }
        String result = null;
        try {
            result = this.getMenuItemUrlByName(menuItemName, this.getMenu(subject));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid menuItemName: " + menuItemName, e);
        }
        return null == result ? result : this.makeUrl(result, makeExplicit, makeSecure);
    }

    private String getMenuItemUrlByName(String menuItemName, List<MenuItem> menuItems) {
        if (null == menuItems) {
            return null;
        }
        String result = null;
        for (MenuItem menuItem : menuItems) {
            String url = menuItem.getUrl();
            if (null != url && menuItemName.equals(menuItem.getName())) {
                result = url;
                break;
            }
            result = this.getMenuItemUrlByName(menuItemName, menuItem.getChildren());
            if (null == result) continue;
            break;
        }
        return result;
    }

    @Override
    public String getResourceTabUrl(Subject subject, String tabName, int resourceId, boolean makeExplicit, boolean makeSecure) {
        if (null == tabName) {
            throw new IllegalArgumentException("Invalid tabName: null ");
        }
        String result = null;
        try {
            result = this.getResourceTabUrlByName(tabName, this.getPluginMetadataManager().getResourceTabs());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid tabName: " + tabName, e);
        }
        return null == result ? result : this.makeUrl(result, makeExplicit, makeSecure);
    }

    private String getResourceTabUrlByName(String tabName, List<Tab> tabs) {
        if (null == tabs) {
            return null;
        }
        String result = null;
        for (Tab tab : tabs) {
            String url = tab.getUrl();
            if (null != url && tabName.equals(tab.getName())) {
                result = url;
                break;
            }
            result = this.getResourceTabUrlByName(tabName, tab.getChildren());
            if (null == result) continue;
            break;
        }
        return result;
    }

    @Override
    public String getRootUrl(Subject subject, boolean makeExplicit, boolean makeSecure) {
        return this.makeUrl("/", makeExplicit, makeSecure);
    }

    @Override
    public String getTargetUrl(Subject subject, PerspectiveTarget target, int targetId, boolean makeExplicit, boolean makeSecure) {
        return this.makeUrl(target.getTargetUrl(targetId), makeExplicit, makeSecure);
    }

    @Override
    public Map<Integer, String> getTargetUrls(Subject subject, PerspectiveTarget target, int[] targetIds, boolean makeExplicit, boolean makeSecure) {
        HashMap<Integer, String> result = new HashMap<Integer, String>(targetIds.length);
        for (int targetId : targetIds) {
            result.put(targetId, this.makeUrl(target.getTargetUrl(targetId), makeExplicit, makeSecure));
        }
        return result;
    }

    @Override
    public String getResourceTargetUrl(Subject subject, int resourceId, PerspectiveTarget target, int targetId, boolean makeExplicit, boolean makeSecure) {
        return this.makeUrl(target.getResourceTargetUrl(resourceId, targetId), makeExplicit, makeSecure);
    }

    @Override
    public Map<Integer, String> getResourceTargetUrls(Subject subject, int resourceId, PerspectiveTarget target, int[] targetIds, boolean makeExplicit, boolean makeSecure) {
        HashMap<Integer, String> result = new HashMap<Integer, String>(targetIds.length);
        for (int targetId : targetIds) {
            result.put(targetId, this.makeUrl(target.getResourceTargetUrl(resourceId, targetId), makeExplicit, makeSecure));
        }
        return result;
    }

    @Override
    public String getTemplateTargetUrl(Subject subject, int resourceId, PerspectiveTarget target, int targetId, boolean makeExplicit, boolean makeSecure) {
        return this.makeUrl(target.getTemplateTargetUrl(resourceId, targetId), makeExplicit, makeSecure);
    }

    private String makeUrl(String url, boolean makeExplicit, boolean makeSecure) {
        if (null == url || !makeExplicit || url.startsWith("http")) {
            return url;
        }
        if (null == server) {
            server = this.serverManager.getServer();
        }
        String protocol = makeSecure ? "https://" : "http://";
        int port = makeSecure ? server.getSecurePort() : server.getPort();
        String result = protocol + server.getAddress() + ":" + port + url;
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CacheEntry {
        private long metadataLastModifiedTime;
        private List<MenuItem> menu;
        private List<Tab> tabs;
        private List<PageLink> pageLinks;

        public CacheEntry(long metadataLastModifiedTime, List<MenuItem> menu, List<Tab> tabs, List<PageLink> pageLinks) {
            this.metadataLastModifiedTime = metadataLastModifiedTime;
            this.menu = menu;
            this.tabs = tabs;
            this.pageLinks = pageLinks;
        }

        public long getMetadataLastModifiedTime() {
            return this.metadataLastModifiedTime;
        }

        public List<MenuItem> getMenu() {
            return this.menu;
        }

        public List<Tab> getTabs() {
            return this.tabs;
        }

        public List<PageLink> getPageLinks() {
            return this.pageLinks;
        }
    }
}

