/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc.content;

import java.util.Date;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.content.ContentSource;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.content.ContentSourceManagerLocal;
import org.rhq.enterprise.server.plugin.pc.AbstractTypeServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.MasterServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.ServerPluginManager;
import org.rhq.enterprise.server.plugin.pc.ServerPluginType;
import org.rhq.enterprise.server.plugin.pc.content.ContentProviderManager;
import org.rhq.enterprise.server.plugin.pc.content.ContentServerPluginManager;
import org.rhq.enterprise.server.scheduler.SchedulerLocal;
import org.rhq.enterprise.server.scheduler.jobs.ContentProviderSyncJob;
import org.rhq.enterprise.server.scheduler.jobs.RepoSyncJob;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.content.ContentPluginDescriptorType;

public class ContentServerPluginContainer
extends AbstractTypeServerPluginContainer {
    private static final String CONTENT_SRC_SYNC_JOB_GROUP_NAME = "syncContentSource";
    private static final String REPO_SYNC_JOB_GROUP_NAME = "syncRepo";
    private static final String REPO_SYNC_JOB_IMMEDIATE_GROUP_NAME = "syncRepoImmediate";
    private ContentProviderManager adapterManager;

    public ContentServerPluginContainer(MasterServerPluginContainer master) {
        super(master);
    }

    public void initialize() throws Exception {
        this.getLog().debug((Object)"Content server plugin container initializing...");
        super.initialize();
        this.adapterManager = this.createAdapterManager();
        this.getLog().debug((Object)"Content server plugin container initialized.");
    }

    public void start() {
        super.start();
        this.adapterManager.initialize((ContentServerPluginManager)this.getPluginManager());
    }

    public void shutdown() {
        this.getLog().debug((Object)"Content server plugin container is shutting down...");
        this.adapterManager.shutdown();
        super.shutdown();
        this.getLog().debug((Object)"Content server plugin container is shutdown.");
    }

    public void scheduleAllPluginJobs() throws Exception {
        super.scheduleAllPluginJobs();
        this.scheduleSyncJobs();
    }

    public ServerPluginType getSupportedServerPluginType() {
        return new ServerPluginType(ContentPluginDescriptorType.class);
    }

    public ContentProviderManager getAdapterManager() {
        return this.adapterManager;
    }

    public void syncProviderNow(ContentSource contentSource) throws SchedulerException {
        JobDetail job = new JobDetail(ContentProviderSyncJob.createUniqueJobName(contentSource), CONTENT_SRC_SYNC_JOB_GROUP_NAME, ContentProviderSyncJob.class, false, false, false);
        JobDataMap jobDataMap = ContentProviderSyncJob.createJobDataMap(contentSource, job);
        jobDataMap.putAsString("syncImportedRepos", true);
        SimpleTrigger trigger = new SimpleTrigger(job.getName(), job.getGroup());
        trigger.setVolatility(false);
        SchedulerLocal scheduler = LookupUtil.getSchedulerBean();
        Date next = scheduler.scheduleJob(job, (Trigger)trigger);
        this.getLog().info((Object)("Scheduled content source sync job [" + job.getName() + ':' + job.getGroup() + "] to fire now at [" + next + "] for [" + contentSource + "]."));
    }

    public void syncRepoNow(Repo repo) throws SchedulerException {
        Date nextExecution;
        String jobName = RepoSyncJob.createJobName(repo);
        JobDetail job = new JobDetail(jobName, REPO_SYNC_JOB_IMMEDIATE_GROUP_NAME, RepoSyncJob.class, false, false, false);
        RepoSyncJob.createJobDataMap(job, repo);
        SchedulerLocal scheduler = LookupUtil.getSchedulerBean();
        Trigger trigger = scheduler.getTrigger(jobName, REPO_SYNC_JOB_IMMEDIATE_GROUP_NAME);
        if (trigger == null) {
            trigger = new SimpleTrigger(jobName, job.getGroup());
            trigger.setVolatility(false);
            nextExecution = scheduler.scheduleJob(job, trigger);
        } else {
            nextExecution = scheduler.rescheduleJob(jobName, REPO_SYNC_JOB_IMMEDIATE_GROUP_NAME, trigger);
        }
        this.getLog().info((Object)("Scheduled repo sync job [" + job.getName() + ':' + job.getGroup() + "] to fire now at [" + nextExecution + "] for [" + repo + "]."));
    }

    public void cancelRepoSync(Subject subject, Repo repo) throws SchedulerException {
        JobDetail jobDetail = new JobDetail(RepoSyncJob.createJobName(repo), REPO_SYNC_JOB_IMMEDIATE_GROUP_NAME, RepoSyncJob.class, false, false, false);
        RepoSyncJob.createJobDataMap(jobDetail, repo);
        SimpleTrigger trigger = new SimpleTrigger(jobDetail.getName(), jobDetail.getGroup());
        trigger.setVolatility(false);
        SchedulerLocal scheduler = LookupUtil.getSchedulerBean();
        boolean cancelled = scheduler.interrupt(RepoSyncJob.createJobName(repo), REPO_SYNC_JOB_IMMEDIATE_GROUP_NAME);
        this.getLog().info((Object)("Cancelled repo sync job [" + jobDetail.getName() + ':' + jobDetail.getGroup() + "]."));
    }

    public void scheduleProviderSyncJob(ContentSource contentSource) throws SchedulerException {
        String syncSchedule = contentSource.getSyncSchedule();
        if (syncSchedule == null || syncSchedule.trim().length() == 0) {
            this.getLog().debug((Object)(contentSource.toString() + " does not define a sync schedule - not scheduling."));
            return;
        }
        SchedulerLocal scheduler = LookupUtil.getSchedulerBean();
        scheduler.scheduleCronJob(ContentProviderSyncJob.createJobName(contentSource), CONTENT_SRC_SYNC_JOB_GROUP_NAME, ContentProviderSyncJob.createJobDataMap(contentSource, null), ContentProviderSyncJob.class, true, false, syncSchedule);
    }

    public void scheduleRepoSyncJob(Repo repo) throws SchedulerException {
        String syncSchedule = repo.getSyncSchedule();
        if (syncSchedule == null || syncSchedule.trim().length() == 0) {
            this.getLog().warn((Object)(repo.toString() + " does not define a sync schedule - not scheduling."));
            return;
        }
        SchedulerLocal scheduler = LookupUtil.getSchedulerBean();
        scheduler.scheduleCronJob(RepoSyncJob.createJobName(repo), REPO_SYNC_JOB_GROUP_NAME, RepoSyncJob.createJobDataMap(null, repo), RepoSyncJob.class, true, false, syncSchedule);
    }

    public void scheduleSyncJobs() {
        if (this.adapterManager != null) {
            for (ContentSource contentSource : this.adapterManager.getAllContentSources()) {
                try {
                    this.getLog().debug((Object)("scheduleSyncJobs :: Scheduling CP job: " + contentSource.getName()));
                    this.scheduleProviderSyncJob(contentSource);
                    ContentSourceManagerLocal contentSourceManager = LookupUtil.getContentSourceManager();
                    PageList<Repo> repos = contentSourceManager.getAssociatedRepos(LookupUtil.getSubjectManager().getOverlord(), contentSource.getId(), PageControl.getUnlimitedInstance());
                    if (repos == null) continue;
                    for (Repo repo : repos) {
                        this.getLog().debug((Object)("scheduleSyncJobs :: Scheduling REPO job: " + repo.getName()));
                        this.scheduleRepoSyncJob(repo);
                    }
                }
                catch (Exception e) {
                    this.getLog().warn((Object)("Could not schedule sync job for content source [" + contentSource + "]."), (Throwable)e);
                }
            }
        }
    }

    public void unscheduleProviderSyncJob(ContentSource contentSource) throws SchedulerException {
        SchedulerLocal scheduler = LookupUtil.getSchedulerBean();
        scheduler.deleteJob(ContentProviderSyncJob.createJobName(contentSource), CONTENT_SRC_SYNC_JOB_GROUP_NAME);
    }

    public void unscheduleRepoSyncJob(Repo repo) throws SchedulerException {
        SchedulerLocal scheduler = LookupUtil.getSchedulerBean();
        scheduler.deleteJob(RepoSyncJob.createJobName(repo), REPO_SYNC_JOB_GROUP_NAME);
    }

    protected ServerPluginManager createPluginManager() {
        return new ContentServerPluginManager(this);
    }

    protected ContentProviderManager createAdapterManager() {
        ContentProviderManager am = new ContentProviderManager();
        return am;
    }
}

