/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.registration;

import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.IgnoreDependency;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.ConfigurationTemplate;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.configuration.ConfigurationManagerLocal;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.registration.RegistrationException;
import org.rhq.enterprise.server.registration.RegistrationManagerLocal;
import org.rhq.enterprise.server.registration.RegistrationManagerRemote;
import org.rhq.enterprise.server.registration.ReleaseRepoMapping;
import org.rhq.enterprise.server.resource.ResourceAlreadyExistsException;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class RegistrationManagerBean
implements RegistrationManagerLocal,
RegistrationManagerRemote {
    private final Log log = LogFactory.getLog((String)RegistrationManagerBean.class.getName());
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    @IgnoreDependency
    private ResourceManagerLocal resourceManager;
    @EJB
    @IgnoreDependency
    private ConfigurationManagerLocal configManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private AgentManagerLocal agentManager;

    @Override
    public void registerPlatform(Subject user, Resource platform, int parentId) {
        ConfigurationTemplate template;
        try {
            this.validatePlatform(platform);
        }
        catch (RegistrationException e) {
            throw new IllegalStateException(e);
        }
        ResourceType resourceType = platform.getResourceType();
        ConfigurationDefinition configDefinition = this.configManager.getPluginConfigurationDefinitionForResourceType(user, resourceType.getId());
        Configuration platformConfig = null;
        if (configDefinition != null && (template = configDefinition.getDefaultTemplate()) != null) {
            platformConfig = template.getConfiguration();
        }
        platform.setPluginConfiguration(platformConfig);
        platform.setInventoryStatus(InventoryStatus.COMMITTED);
        Agent agent = this.createFakeAgent(platform);
        platform.setAgent(agent);
        try {
            this.resourceManager.createResource(user, platform, parentId);
        }
        catch (ResourceAlreadyExistsException e) {
            throw new IllegalStateException(e);
        }
        this.log.error((Object)("Resource " + platform + "persisted"));
    }

    @Override
    public void importPlatform(Subject user, Resource resource) {
        resource.setInventoryStatus(InventoryStatus.COMMITTED);
        this.entityManager.persist((Object)resource);
    }

    @Override
    public void subscribePlatformToBaseRepo(Subject user, Resource platform, String release, String version, String arch) throws RegistrationException {
        this.log.debug((Object)("Trying to subscribe " + platform + " to a compatible baserepo"));
        ReleaseRepoMapping rm = new ReleaseRepoMapping(release, version, arch);
        String repoName = rm.getCompatibleRepo();
        try {
            RepoManagerLocal repoManager = LookupUtil.getRepoManagerLocal();
            List<Repo> repos = repoManager.getRepoByName(repoName);
            int[] repoIds = this.getIntRepoIdArray(repos);
            repoManager.subscribeResourceToRepos(user, platform.getId(), repoIds);
        }
        catch (Exception e) {
            throw new RegistrationException("No Compatible Base repo Found." + e);
        }
    }

    private void validatePlatform(Resource platform) throws RegistrationException {
        if (platform.getResourceType() == null) {
            throw new RegistrationException("Reported resource [" + platform + "] has a null type.");
        }
        if (platform.getResourceKey() == null) {
            throw new RegistrationException("Reported resource [" + platform + "] has a null key.");
        }
        if (platform.getInventoryStatus() == InventoryStatus.DELETED) {
            throw new RegistrationException("Reported resource [" + platform + "] has an illegal inventory status of 'DELETED' - agents are not allowed to delete platforms from inventory.");
        }
        Resource existingPlatform = this.checkResourceExists(platform);
        if (existingPlatform != null) {
            throw new RegistrationException("Reported resource [" + platform + "] Already Exists.");
        }
    }

    private Resource checkResourceExists(Resource platform) {
        Resource existingResource = null;
        if (platform.getId() != 0) {
            existingResource = (Resource)this.entityManager.find(Resource.class, (Object)platform.getId());
        }
        if (existingResource == null) {
            ResourceType resourceType = platform.getResourceType();
            existingResource = this.resourceManager.getResourceByParentAndKey(this.subjectManager.getOverlord(), platform.getParentResource(), platform.getResourceKey(), resourceType.getPlugin(), resourceType.getName());
            if (existingResource != null) {
                platform.setId(existingResource.getId());
            } else if (platform.getId() != 0) {
                platform.setId(0);
            }
        }
        return existingResource;
    }

    private Agent createFakeAgent(Resource resource) {
        String address = resource.getName();
        int port = 16163;
        String endPoint = "socket://" + address + ":" + port + "/?rhq.communications.connector.rhqtype=agent";
        Agent agent = this.agentManager.getAgentByAddressAndPort(resource.getName(), 16163);
        if (agent == null) {
            agent = new Agent(resource.getName(), address, port, endPoint, resource.getResourceKey());
            this.entityManager.persist((Object)agent);
            this.entityManager.flush();
        }
        return agent;
    }

    private int[] getIntRepoIdArray(List<Repo> input) {
        if (input == null) {
            return new int[0];
        }
        int[] output = new int[input.size()];
        for (int i = 0; i < input.size(); ++i) {
            output[i] = input.get(i).getId();
        }
        return output;
    }
}

