/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.remote;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.MBeanServer;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.invocation.NameBasedInvocation;
import org.rhq.core.server.ExternalizableStrategy;
import org.rhq.enterprise.server.util.HibernateDetachUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteWsInvocationHandler
implements ServerInvocationHandler {
    private static final Log log = LogFactory.getLog(RemoteWsInvocationHandler.class);
    private static final Map<String, Class<?>> PRIMITIVE_CLASSES;
    private static Map<String, Class<?>> WS_MAP_CLASSES;
    private static Object objFactory;
    private static HashMap<String, Object> remoteList;

    public void addListener(InvokerCallbackHandler arg0) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Object invoke(InvocationRequest invocationRequest) throws Throwable {
        Object result;
        block36: {
            long time;
            String methodName;
            block35: {
                System.out.println("In WS Invocation handler ...:" + invocationRequest);
                if (invocationRequest == null) {
                    throw new IllegalArgumentException("WS-InvocationRequest was null.");
                }
                methodName = null;
                boolean successful = false;
                result = null;
                time = System.currentTimeMillis();
                InitialContext ic = new InitialContext();
                NameBasedInvocation nbi = (NameBasedInvocation)invocationRequest.getParameter();
                if (null == nbi) {
                    throw new IllegalArgumentException("WS-InvocationRequest did not supply method.");
                }
                methodName = nbi.getMethodName();
                String[] methodInfo = methodName.split(":");
                String jndiName = "rhq/" + methodInfo[0];
                Object target = ic.lookup(jndiName + "/remote");
                target = ic.lookup(jndiName + "/local");
                String[] signature = nbi.getSignature();
                int signatureLength = signature.length;
                Class[] sig = new Class[signatureLength];
                for (int i = 0; i < signatureLength; ++i) {
                    sig[i] = this.getClass(signature[i]);
                }
                Method m = target.getClass().getMethod(methodInfo[1], sig);
                result = m.invoke(target, nbi.getParameters());
                System.out.println("echo curr meth SIGNATURE:" + signature + ":size:" + signature.length);
                for (int i = 0; i < signature.length; ++i) {
                    System.out.println("SIG:" + signature[i] + ":");
                }
                try {
                    Object remoteWsRef = null;
                    String remoteClassKey = "WebservicesManagerBeanService";
                    if (!remoteList.containsKey(remoteClassKey)) {
                        Class<?> located = Class.forName("org.rhq.enterprise.server.ws." + remoteClassKey);
                        System.out.println("Located service ref:" + located);
                        URL sUrl = RemoteWsInvocationHandler.generateRemoteWebserviceURL(located, "127.0.0.1", 7080, false);
                        QName sQName = RemoteWsInvocationHandler.generateRemoteWebserviceQName(located);
                        Constructor<?> constructor = located.getConstructor(URL.class, QName.class);
                        System.out.println("Constructor for service located:" + constructor);
                        Object servInstance = constructor.newInstance(sUrl, sQName);
                        System.out.println("ServiceInstance:" + servInstance);
                        Method portMethod = servInstance.getClass().getMethod("getWebservicesManagerBeanPort", null);
                        Object remoteInst = portMethod.invoke(servInstance, null);
                        System.out.println("Remote Instance:" + remoteInst);
                        remoteWsRef = remoteInst;
                        remoteList.put(remoteClassKey, remoteInst);
                        System.out.println("Added key:" + remoteClassKey + " value:" + remoteInst);
                    } else {
                        remoteWsRef = remoteList.get(remoteClassKey);
                    }
                    Class[] statSignature = new Class[nbi.getSignature().length];
                    int index = 0;
                    for (String type : nbi.getSignature()) {
                        System.out.println("Original signature element:" + type + ":");
                        StringTokenizer bag = new StringTokenizer(type, ".");
                        System.out.println("Bag:" + bag + ":size:" + bag.countTokens());
                        String terminal = "";
                        while (bag.hasMoreTokens()) {
                            terminal = bag.nextToken();
                        }
                        System.out.println("terminal bagToken:" + terminal + ":");
                        Class<?> newSignatureInstance = this.getClass(type);
                        Class<?> locatedWsClass = null;
                        if (!WS_MAP_CLASSES.containsKey(terminal)) {
                            System.out.println("Map Key '" + terminal + "' is not located");
                            try {
                                locatedWsClass = Class.forName("org.rhq.enterprise.server.ws." + terminal);
                                newSignatureInstance = locatedWsClass;
                            }
                            catch (ClassNotFoundException cnfe) {
                                // empty catch block
                            }
                            System.out.println("Located Class is :" + locatedWsClass + ":");
                            if (locatedWsClass != null) {
                                WS_MAP_CLASSES.put(terminal, locatedWsClass);
                            }
                        } else {
                            newSignatureInstance = WS_MAP_CLASSES.get(terminal);
                        }
                        statSignature[index++] = newSignatureInstance;
                    }
                    System.out.println("Static signature Map:" + statSignature);
                    for (int kl = 0; kl < statSignature.length; ++kl) {
                        System.out.println("Signature :" + statSignature[kl] + ":");
                    }
                    System.out.println("Meth lookup for:" + methodInfo[1] + ":" + statSignature + ":");
                    Method methodCall = remoteWsRef.getClass().getMethod(methodInfo[1], statSignature);
                    System.out.println("Successfully found Method call:" + methodCall);
                    Object[] values = new Object[nbi.getParameters().length];
                    for (int k = 0; k < nbi.getParameters().length; ++k) {
                        Object passedIn = nbi.getParameters()[k];
                        System.out.println("Object passed in :" + passedIn + ":class:" + passedIn.getClass());
                        Object translated = this.copyValue(passedIn);
                        System.out.println("Object translated:" + translated + ":class:" + translated.getClass());
                        values[k] = translated;
                    }
                    Object wsResult = methodCall.invoke(remoteWsRef, values);
                    System.out.println("Type Returned is:" + wsResult + ":class:" + wsResult.getClass());
                    System.out.println("OrigType Returned is:" + result + ":class:" + result.getClass());
                    Object updated = this.updateRhqType(wsResult, result);
                    System.out.println("Updated type returned:" + updated);
                    result = updated;
                    successful = true;
                }
                catch (Exception ex) {
                    System.out.println("Exception [" + methodInfo[0] + "Service]" + " is:" + ex);
                    throw new InvocationTargetException(ex);
                }
                if (result == null) break block35;
                ExternalizableStrategy.setStrategy((ExternalizableStrategy.Subsystem)ExternalizableStrategy.Subsystem.REFLECTIVE_SERIALIZATION);
                try {
                    HibernateDetachUtility.nullOutUninitializedFields((Object)result, (HibernateDetachUtility.SerializationType)HibernateDetachUtility.SerializationType.SERIALIZATION);
                }
                catch (Exception e) {
                    log.error((Object)"Failed to null out uninitialized fields", (Throwable)e);
                    return e;
                }
            }
            long executionTime = System.currentTimeMillis() - time;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Remote request [" + methodName + "] execution time (ms): " + executionTime));
            }
            break block36;
            catch (InvocationTargetException e) {
                log.error((Object)"WS-Failed to invoke remote request", (Throwable)e);
                Throwable throwable = e.getTargetException();
                return throwable;
            }
            catch (Exception e2) {
                log.error((Object)"WS-Failed to invoke remote request", (Throwable)e2);
                Exception exception = e2;
                return exception;
                {
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                }
            }
            finally {
                if (result != null) {
                    ExternalizableStrategy.setStrategy((ExternalizableStrategy.Subsystem)ExternalizableStrategy.Subsystem.REFLECTIVE_SERIALIZATION);
                    try {
                        HibernateDetachUtility.nullOutUninitializedFields(result, (HibernateDetachUtility.SerializationType)HibernateDetachUtility.SerializationType.SERIALIZATION);
                    }
                    catch (Exception e) {
                        log.error((Object)"Failed to null out uninitialized fields", (Throwable)e);
                        return e;
                    }
                }
                long executionTime2 = System.currentTimeMillis() - time;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Remote request [" + methodName + "] execution time (ms): " + executionTime2));
                }
            }
        }
        return result;
    }

    private Object copyValue(Object passedIn) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        System.out.println("In copyValue the translation method:");
        Object translated = passedIn;
        String type = passedIn.getClass().getName();
        System.out.println("Type passed in is:" + type + ":");
        StringTokenizer bag = new StringTokenizer(type, ".");
        System.out.println("Bag:" + bag + ":size:" + bag.countTokens());
        String terminal = "";
        while (bag.hasMoreTokens()) {
            terminal = bag.nextToken();
        }
        System.out.println("Terminal value is :" + terminal);
        System.out.println("Does map contain key:" + WS_MAP_CLASSES.containsKey(terminal) + ":");
        if (WS_MAP_CLASSES.containsKey(terminal)) {
            if (!WS_MAP_CLASSES.containsKey("objectFactory") && objFactory == null) {
                Class<?> ofRef = Class.forName("org.rhq.enterprise.server.ws.ObjectFactory");
                System.out.println("Located object factory class:" + ofRef + ":");
                Constructor<?> ofConstructor = ofRef.getConstructor(null);
                Object retValue = ofConstructor.newInstance(null);
                System.out.println("ObjectFactory instantiated:" + retValue + ":");
                objFactory = retValue;
            }
            Method mJxbType = objFactory.getClass().getMethod("create" + terminal, null);
            System.out.println("Located CreateMethod for type passed in:" + mJxbType + ":");
            Object jaxbType = mJxbType.invoke(objFactory, null);
            System.out.println("Jaxb Type created:" + jaxbType + ":");
            Method[] jxbTypeMethList = jaxbType.getClass().getDeclaredMethods();
            Method[] rhqTypeMethList = passedIn.getClass().getDeclaredMethods();
            HashMap<String, Method> getRhqMethmap = this.createReferenceMap(rhqTypeMethList, "");
            for (int m = 0; m < jxbTypeMethList.length; ++m) {
                String meth = jxbTypeMethList[m].getName();
                if (!meth.startsWith("set")) continue;
                System.out.println("Working on method:" + meth + ":obj:" + jxbTypeMethList[m] + ":" + meth.substring(3) + ":");
                Method getMethod = getRhqMethmap.get("get" + meth.substring(3));
                System.out.println("Just located coreMeth:" + getMethod + ":");
                if (getMethod == null) {
                    getMethod = getRhqMethmap.get("is" + meth.substring(3));
                    System.out.println("2nd Attempt: Looked up coreMeth for rhq:" + getMethod + ": meth:" + meth.substring(3) + ":F:" + meth);
                    if (getMethod == null) {
                        getMethod = getRhqMethmap.get("fetch" + meth.substring(3));
                        System.out.println("3rd Attempt: Looked up coreMeth for rhq:" + getMethod + ": meth:" + meth.substring(3) + ":F:" + meth);
                    }
                }
                System.out.println("ABOUT to RUN with in/out:" + jxbTypeMethList[m].getParameterTypes()[0] + " # with input " + getMethod.getReturnType());
                Class<?> inParam = jxbTypeMethList[m].getParameterTypes()[0];
                Class<?> outParam = getMethod.getReturnType();
                if (inParam.getCanonicalName().equals(outParam.getCanonicalName())) {
                    System.out.println("In/out parms equal.jx:" + jaxbType + " ## passedIn:" + passedIn);
                    jxbTypeMethList[m].invoke(jaxbType, getMethod.invoke(passedIn, null));
                    continue;
                }
                System.out.println("@@@@@ copyVal in/out NOT MATCHING @@@@@@@@@@@");
                System.out.println("inP:" + inParam.getCanonicalName());
                System.out.println("outParam:" + outParam.getCanonicalName());
                Object returnValue = getMethod.invoke(passedIn, null);
                if (returnValue == null) {
                    System.out.println("NULL VALUE DETECTED .. bailing .. not transfer necessary.");
                    continue;
                }
                String terminalString = this.locateTerminalString(inParam.getCanonicalName());
                System.out.println("Term Str:" + terminalString + " # meth: " + "create" + terminalString);
                if (inParam.getEnumConstants() == null) {
                    Method obFacMethod = objFactory.getClass().getMethod("create" + terminalString, null);
                    System.out.println("Located method:" + obFacMethod);
                    System.out.println("UNFINISHED!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                    continue;
                }
                System.out.println("LOCATED an ENUM:... processing");
                Object rtype = getMethod.invoke(passedIn, null);
                System.out.println("Input value evaluated:" + rtype + ":running :" + getMethod);
                Method valueOfMethod = inParam.getMethod("valueOf", String.class);
                String value = rtype.toString();
                System.out.println("RETRIEVED ENUM methods:" + valueOfMethod + "##" + rtype.getClass().getCanonicalName() + "ValueAsString:" + value);
                jaxbType = valueOfMethod.invoke(inParam, value);
                System.out.println("Completed assignment...should be good:" + jaxbType);
            }
            translated = jaxbType;
        }
        System.out.println("Exiting translation method.");
        return translated;
    }

    private String locateTerminalString(String canonicalName) {
        String terminal = "";
        if (canonicalName != null && canonicalName.trim().length() > 0) {
            StringTokenizer bag = new StringTokenizer(canonicalName, ".");
            while (bag.hasMoreTokens()) {
                terminal = bag.nextToken();
            }
        }
        return terminal;
    }

    private Object updateRhqType(Object jaxbType, Object rhqType) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        System.out.println("In updateRhqType the translation method:");
        System.out.println("JAXBTYPE:" + jaxbType + ":class:" + jaxbType.getClass() + ":canon:" + jaxbType.getClass().getCanonicalName());
        System.out.println("RHQTYPE:" + rhqType + ":class:" + rhqType.getClass() + ":canon:" + rhqType.getClass().getCanonicalName());
        Object updated = rhqType;
        System.out.println("Jaxb Type passed in:" + jaxbType + ":");
        Method[] jaxbTypeMethList = jaxbType.getClass().getDeclaredMethods();
        Method[] rhqTypeMethList = rhqType.getClass().getDeclaredMethods();
        HashMap<String, Method> rMap = this.createReferenceMap(rhqTypeMethList, "");
        HashMap<String, Method> map = this.createReferenceMap(jaxbTypeMethList, "");
        System.out.println("Ref r-map created:" + rMap + ":");
        System.out.println("Ref j-map created:" + map + ":");
        for (Method method : jaxbTypeMethList) {
            String meth = method.getName();
            Method rhqSetMethod = rMap.get("set" + meth.substring(3));
            System.out.println("Looked up set method for rhq:" + rhqSetMethod + ": meth:" + meth.substring(3) + ":F:" + meth);
            if (rhqSetMethod == null) {
                rhqSetMethod = rMap.get("set" + meth.substring(2));
                System.out.println("2nd Attempt: Looked up set method for rhq:" + rhqSetMethod + ": meth:" + meth.substring(2) + ":F:" + meth);
            }
            if (!meth.startsWith("get") && !meth.startsWith("is")) continue;
            System.out.println("Working on j-get-method:" + meth + ":obj:" + method + ":" + meth.substring(3) + ":f:" + meth);
            System.out.println("Working on r-set-method:" + meth + ":obj:" + rhqSetMethod + ":" + meth.substring(3) + ":f:" + meth);
            if (this.methodOutputInputSame(rhqSetMethod.getParameterTypes(), method.getReturnType())) {
                rhqSetMethod.invoke(rhqType, method.invoke(jaxbType, null));
                continue;
            }
            System.out.println("$$$$$$$$$$$ PROBLEM@@@ type mismatch ");
            String from = method.getReturnType().getCanonicalName();
            String to = rhqSetMethod.getParameterTypes()[0].getCanonicalName();
            System.out.println("moving:" + method.getReturnType() + ": data to " + rhqSetMethod.getParameterTypes()[0]);
            if (from.equals("java.util.List") && to.equals("java.util.Set")) {
                HashSet input = new HashSet();
                Object jxbReturnValue = method.invoke(jaxbType, null);
                input.addAll((Collection)jxbReturnValue);
                rhqSetMethod.invoke(rhqType, input);
                System.out.println("Completed List to Set translation.");
                continue;
            }
            System.out.println("Assuming a JAXB -> RHQ copy needs to occur");
            System.out.println("JAXBtype:" + jaxbType + ":method:" + meth + ":");
            Object jxbNonTrivType = method.invoke(jaxbType, null);
            System.out.println("Retrieved non-trivial jxb type:" + jxbNonTrivType + ":");
            if (jxbNonTrivType != null) {
                Method rhqNonTrivTypeMethod = rMap.get("get" + rhqSetMethod.getName().substring(3));
                System.out.println("Retrieved Meth for non-triv type:" + rhqNonTrivTypeMethod + ":");
                Object rhqNonTrivTypeInst = rhqNonTrivTypeMethod.invoke(rhqType, null);
                Object updatedRhqValue = this.updateRhqType(jxbNonTrivType, rhqNonTrivTypeInst);
                rhqSetMethod.invoke(rhqType, updatedRhqValue);
                System.out.println("Completed RHQ type update.");
                continue;
            }
            System.out.println("NULL value detected. Not copying result of method:" + method);
        }
        updated = rhqType;
        System.out.println("Exiting update method.");
        return updated;
    }

    private boolean methodOutputInputSame(Class<?>[] rhqParamTypeList, Class<?> paramTypeList) {
        boolean paramsEqual = true;
        if (rhqParamTypeList.length > 1) {
            System.out.println("##### parameter count mismatch!!! ATTENTION REQUIRED.");
            return false;
        }
        for (int i = 0; i < rhqParamTypeList.length; ++i) {
            if (rhqParamTypeList[i].getCanonicalName().equals(paramTypeList.getCanonicalName())) continue;
            paramsEqual = false;
            System.out.println("###########Mismatch detected####################");
            System.out.println("PARAM-R-" + i + ":" + rhqParamTypeList[i].getCanonicalName());
            System.out.println("PARAM-J-" + i + ":" + paramTypeList.getCanonicalName());
        }
        return paramsEqual;
    }

    private HashMap<String, Method> createReferenceMap(Method[] rhqTypeMethList, String prefix) {
        HashMap<String, Method> map = new HashMap<String, Method>();
        for (int i = 0; i < rhqTypeMethList.length; ++i) {
            if (prefix != null && prefix.trim().length() > 0) {
                if (!rhqTypeMethList[i].getName().startsWith(prefix)) continue;
                map.put(rhqTypeMethList[i].getName(), rhqTypeMethList[i]);
                continue;
            }
            map.put(rhqTypeMethList[i].getName(), rhqTypeMethList[i]);
        }
        return map;
    }

    Class<?> getClass(String name) throws ClassNotFoundException {
        if (PRIMITIVE_CLASSES.containsKey(name)) {
            return PRIMITIVE_CLASSES.get(name);
        }
        return Class.forName(name);
    }

    public static URL generateRemoteWebserviceURL(Class remote, String host, int port, boolean useHttps) throws MalformedURLException {
        URL wsdlLocation = null;
        if (host == null || host.trim().length() == 0 || port <= 0) {
            return wsdlLocation;
        }
        if (remote != null && remote.isAnnotationPresent(WebServiceClient.class)) {
            String beanName = remote.getSimpleName();
            String protocol = "https://";
            if (!useHttps) {
                protocol = "http://";
            }
            wsdlLocation = new URL(protocol + host + ":" + port + "/rhq-rhq-enterprise-server-ejb3/" + beanName.substring(0, beanName.length() - "Service".length()) + "?wsdl");
        }
        return wsdlLocation;
    }

    public static QName generateRemoteWebserviceQName(Class remote) {
        QName generated = null;
        if (remote != null && remote.isAnnotationPresent(WebServiceClient.class)) {
            WebServiceClient annot;
            String annotatedQnameValue = "";
            WebServiceClient annotated = annot = remote.getAnnotation(WebServiceClient.class);
            annotatedQnameValue = annotated.targetNamespace();
            String beanName = remote.getSimpleName();
            generated = new QName(annotatedQnameValue, beanName);
        }
        return generated;
    }

    public void removeListener(InvokerCallbackHandler arg0) {
    }

    public void setInvoker(ServerInvoker arg0) {
    }

    public void setMBeanServer(MBeanServer arg0) {
    }

    static {
        WS_MAP_CLASSES = new HashMap();
        objFactory = null;
        remoteList = new HashMap();
        PRIMITIVE_CLASSES = new HashMap();
        PRIMITIVE_CLASSES.put(Short.TYPE.getName(), Short.TYPE);
        PRIMITIVE_CLASSES.put(Integer.TYPE.getName(), Integer.TYPE);
        PRIMITIVE_CLASSES.put(Long.TYPE.getName(), Long.TYPE);
        PRIMITIVE_CLASSES.put(Float.TYPE.getName(), Float.TYPE);
        PRIMITIVE_CLASSES.put(Double.TYPE.getName(), Double.TYPE);
        PRIMITIVE_CLASSES.put(Boolean.TYPE.getName(), Boolean.TYPE);
        PRIMITIVE_CLASSES.put(Character.TYPE.getName(), Character.TYPE);
        PRIMITIVE_CLASSES.put(Byte.TYPE.getName(), Byte.TYPE);
    }
}

