/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource;

import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.InventorySummary;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.group.GroupCategory;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.resource.ResourceBossLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.resource.group.definition.GroupDefinitionManagerLocal;

@Stateless
public class ResourceBossBean
implements ResourceBossLocal {
    @EJB
    private ResourceManagerLocal resourceManager;
    @EJB
    private ResourceGroupManagerLocal groupManager;
    @EJB
    private MeasurementScheduleManagerLocal scheduleManager;
    @EJB
    private GroupDefinitionManagerLocal groupDefinitionManager;

    public InventorySummary getInventorySummary(Subject user) {
        InventorySummary summary = new InventorySummary();
        summary.setPlatformCount(this.resourceManager.getResourceCountByCategory(user, ResourceCategory.PLATFORM, InventoryStatus.COMMITTED));
        summary.setServerCount(this.resourceManager.getResourceCountByCategory(user, ResourceCategory.SERVER, InventoryStatus.COMMITTED));
        summary.setServiceCount(this.resourceManager.getResourceCountByCategory(user, ResourceCategory.SERVICE, InventoryStatus.COMMITTED));
        summary.setCompatibleGroupCount(this.groupManager.getResourceGroupCountByCategory(user, GroupCategory.COMPATIBLE));
        summary.setMixedGroupCount(this.groupManager.getResourceGroupCountByCategory(user, GroupCategory.MIXED));
        summary.setGroupDefinitionCount(this.groupDefinitionManager.getGroupDefinitionCount(user));
        summary.setScheduledMeasurementsPerMinute(this.scheduleManager.getScheduledMeasurementsPerMinute());
        return summary;
    }
}

