/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.group.definition.framework;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.enterprise.server.common.EntityManagerFacadeLocal;
import org.rhq.enterprise.server.resource.group.definition.framework.InvalidExpressionException;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.QueryUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionEvaluator
implements Iterable<Result> {
    private final Log log = LogFactory.getLog(ExpressionEvaluator.class);
    private static final String INVALID_EXPRESSION_FORM_MSG = "Expression must be in one of the follow forms: 'groupBy condition', 'condition = value', 'empty condition', 'not empty condition";
    private static final String PROP_SIMPLE_ALIAS = "simple";
    private static final String PROP_SIMPLE_DEF_ALIAS = "simpleDef";
    private static final String TRAIT_ALIAS = "trait";
    private static final String METRIC_DEF_ALIAS = "def";
    private Map<JoinCondition, ResourceRelativeContext> joinConditions;
    private Map<String, String> whereConditions;
    private Map<String, Object> whereReplacements;
    private Map<String, Class<?>> whereReplacementTypes;
    private Set<String> whereStatics;
    private List<String> groupByElements;
    private List<String> simpleSubExpressions;
    private List<String> groupedSubExpressions;
    private int expressionCount = 0;
    private boolean isInvalid = false;
    private boolean isTestMode = false;
    private boolean resultsComputed = false;
    private String computedJPQLStatement = "";
    private String computedJPQLGroupStatement = "";
    private EntityManagerFacadeLocal entityManagerFacade;
    private ParseContext context = ParseContext.BEGIN;
    private ParseSubContext subcontext = null;
    private int parseIndex = 0;
    private boolean isGroupBy = false;
    private ComparisonType comparisonType = null;
    private Class<?> expressionType;
    private ParseContext deepestResourceContext = null;
    private int counter = 0;
    private final String[] functions = new String[]{"contains", "startswith", "endswith"};

    public ExpressionEvaluator() {
        this.joinConditions = new HashMap<JoinCondition, ResourceRelativeContext>();
        this.whereConditions = new LinkedHashMap<String, String>();
        this.whereReplacements = new HashMap<String, Object>();
        this.whereReplacementTypes = new HashMap();
        this.whereStatics = new LinkedHashSet<String>();
        this.groupByElements = new ArrayList<String>();
        this.simpleSubExpressions = new ArrayList<String>();
        this.groupedSubExpressions = new ArrayList<String>();
        this.entityManagerFacade = LookupUtil.getEntityManagerFacade();
        this.whereStatics.add("res.inventoryStatus = org.rhq.core.domain.resource.InventoryStatus.COMMITTED");
    }

    public void setTestMode(boolean mode) {
        this.isTestMode = mode;
        this.whereStatics.remove("res.inventoryStatus = org.rhq.core.domain.resource.InventoryStatus.COMMITTED");
    }

    public ExpressionEvaluator addExpression(String expression) throws InvalidExpressionException {
        if (this.isInvalid) {
            throw new IllegalStateException("This evaluator previously threw an exception and can no longer be used");
        }
        try {
            this.parseExpression(expression);
            ++this.expressionCount;
        }
        catch (InvalidExpressionException iee) {
            this.isInvalid = true;
            throw iee;
        }
        return this;
    }

    public String getComputedJPQLStatement() {
        if (!this.resultsComputed) {
            throw new IllegalStateException("Results must be computed before this method can be called");
        }
        return this.computedJPQLStatement;
    }

    public String getComputedJPQLGroupStatement() {
        if (!this.resultsComputed) {
            throw new IllegalStateException("Results must be computed before this method can be called");
        }
        return this.computedJPQLGroupStatement;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseExpression(String expression) throws InvalidExpressionException {
        String condition;
        if (expression.trim().equals("")) {
            return;
        }
        String value = null;
        int equalsIndex = -1;
        boolean insideBrackets = false;
        for (int i = expression.length() - 1; i >= 0; --i) {
            char next = expression.charAt(i);
            if (insideBrackets) {
                if (next != '[') continue;
                insideBrackets = false;
                continue;
            }
            if (next == ']') {
                insideBrackets = true;
                continue;
            }
            if (next != '=') continue;
            equalsIndex = i;
            break;
        }
        if (equalsIndex == -1) {
            condition = expression;
        } else {
            condition = expression.substring(0, equalsIndex);
            value = expression.substring(equalsIndex + 1).trim();
            if (value.equals("")) {
                throw new InvalidExpressionException(INVALID_EXPRESSION_FORM_MSG);
            }
        }
        List<String> originalTokens = this.tokenizeCondition(condition);
        Object[] tokens = new String[originalTokens.size()];
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = originalTokens.get(i).toLowerCase();
        }
        this.log.debug((Object)("TOKENS: " + Arrays.asList(tokens)));
        StringBuilder normalizedSubExpressionBuilder = new StringBuilder();
        for (String string : tokens) {
            if (string.equals("groupby") || string.equals("not") || string.equals("empty")) continue;
            normalizedSubExpressionBuilder.append(string);
        }
        String normalizedSubExpression = normalizedSubExpressionBuilder.toString();
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokens[i].trim();
        }
        this.context = ParseContext.BEGIN;
        this.subcontext = null;
        this.parseIndex = 0;
        this.isGroupBy = false;
        this.comparisonType = ComparisonType.EQUALS;
        this.deepestResourceContext = null;
        this.expressionType = String.class;
        while (this.parseIndex < tokens.length) {
            String nextToken = tokens[this.parseIndex];
            if (this.context == ParseContext.BEGIN) {
                if (nextToken.equals("resource")) {
                    this.deepestResourceContext = this.context = ParseContext.Resource;
                } else if (nextToken.equals("groupby")) {
                    this.context = ParseContext.Modifier;
                    this.subcontext = ParseSubContext.Pivot;
                } else if (nextToken.equals("not")) {
                    this.context = ParseContext.Modifier;
                    this.subcontext = ParseSubContext.Negated;
                } else {
                    if (!nextToken.equals("empty")) throw new InvalidExpressionException("Expression must either start with 'resource', 'groupby', 'empty', or 'not empty' tokens");
                    this.context = ParseContext.Modifier;
                    this.subcontext = ParseSubContext.Empty;
                }
            } else if (this.context == ParseContext.Modifier) {
                if (this.subcontext == ParseSubContext.Negated) {
                    if (!nextToken.equals("empty")) throw new InvalidExpressionException("Expression starting with 'not' must be followed by the 'empty' token");
                    this.subcontext = ParseSubContext.NotEmpty;
                } else {
                    if ((this.subcontext == ParseSubContext.Pivot || this.subcontext == ParseSubContext.Empty || this.subcontext == ParseSubContext.NotEmpty) && value != null) {
                        throw new InvalidExpressionException(INVALID_EXPRESSION_FORM_MSG);
                    }
                    if (this.subcontext == ParseSubContext.Pivot) {
                        this.validateSubExpressionAgainstPreviouslySeen(normalizedSubExpression, true);
                        this.isGroupBy = true;
                        this.comparisonType = ComparisonType.NONE;
                    } else if (this.subcontext == ParseSubContext.NotEmpty) {
                        this.comparisonType = ComparisonType.NOT_EMPTY;
                    } else {
                        if (this.subcontext != ParseSubContext.Empty) throw new InvalidExpressionException("Unknown or unsupported ParseSubContext[" + (Object)((Object)this.subcontext) + "] for ParseContext[" + (Object)((Object)this.context) + "]");
                        this.comparisonType = ComparisonType.EMPTY;
                    }
                    if (!nextToken.equals("resource")) throw new InvalidExpressionException("Grouped expressions must be followed by the 'resource' token");
                    this.deepestResourceContext = this.context = ParseContext.Resource;
                }
            } else if (this.context == ParseContext.Resource) {
                if (this.comparisonType == ComparisonType.EQUALS) {
                    if (value == null) {
                        throw new InvalidExpressionException(INVALID_EXPRESSION_FORM_MSG);
                    }
                    this.validateSubExpressionAgainstPreviouslySeen(normalizedSubExpression, false);
                }
                if (nextToken.equals("parent")) {
                    this.deepestResourceContext = this.context = ParseContext.ResourceParent;
                } else if (nextToken.equals("grandparent")) {
                    this.deepestResourceContext = this.context = ParseContext.ResourceGrandParent;
                } else if (nextToken.equals("greatgrandparent")) {
                    this.deepestResourceContext = this.context = ParseContext.ResourceGreatGrandParent;
                } else if (nextToken.equals("greatgreatgrandparent")) {
                    this.deepestResourceContext = this.context = ParseContext.ResourceGreatGreatGrandParent;
                } else if (nextToken.equals("child")) {
                    this.deepestResourceContext = this.context = ParseContext.ResourceChild;
                } else {
                    this.parseExpression_resourceContext(value, (String[])tokens, nextToken);
                }
            } else if (this.context == ParseContext.ResourceParent || this.context == ParseContext.ResourceGrandParent || this.context == ParseContext.ResourceGreatGrandParent || this.context == ParseContext.ResourceGreatGreatGrandParent || this.context == ParseContext.ResourceChild) {
                this.parseExpression_resourceContext(value, (String[])tokens, nextToken);
            } else if (this.context == ParseContext.ResourceType) {
                if (nextToken.equals("plugin")) {
                    this.populatePredicateCollections(this.getResourceRelativeContextToken() + ".resourceType.plugin", value);
                } else if (nextToken.equals("name")) {
                    this.populatePredicateCollections(this.getResourceRelativeContextToken() + ".resourceType.name", value);
                } else {
                    if (!nextToken.equals("category")) throw new InvalidExpressionException("Invalid 'type' subexpression: " + PrintUtils.getDelimitedString(tokens, this.parseIndex, "."));
                    this.populatePredicateCollections(this.getResourceRelativeContextToken() + ".resourceType.category", value == null ? null : ResourceCategory.valueOf((String)value.toUpperCase()));
                }
            } else if (this.context == ParseContext.Availability) {
                AvailabilityType type = null;
                if (!this.isGroupBy && value != null) {
                    if ("up".equalsIgnoreCase(value)) {
                        type = AvailabilityType.UP;
                    } else {
                        if (!"down".equalsIgnoreCase(value)) throw new InvalidExpressionException("Invalid 'resource.availability' comparision value, only 'UP' and 'DOWN' are valid values");
                        type = AvailabilityType.DOWN;
                    }
                }
                this.addJoinCondition(JoinCondition.AVAILABILITY);
                this.populatePredicateCollections(JoinCondition.AVAILABILITY.alias + ".availabilityType", type);
            } else if (this.context == ParseContext.Trait) {
                String traitName = this.parseTraitName(originalTokens);
                this.addJoinCondition(JoinCondition.SCHEDULES);
                this.populatePredicateCollections("def.name", traitName, false);
                this.populatePredicateCollections("trait.value", value);
                this.whereStatics.add("trait.schedule = " + JoinCondition.SCHEDULES.alias);
                this.whereStatics.add("trait.id.timestamp = (SELECT max(mdt.id.timestamp) FROM MeasurementDataTrait mdt WHERE " + JoinCondition.SCHEDULES.alias + ".id = mdt.schedule.id)");
            } else if (this.context == ParseContext.Configuration) {
                void var12_24;
                JoinCondition definitionJoinCondition;
                String prefix;
                if (this.subcontext == ParseSubContext.PluginConfiguration) {
                    prefix = "pluginconfiguration";
                    JoinCondition joinCondition = JoinCondition.PLUGIN_CONFIGURATION;
                    definitionJoinCondition = JoinCondition.PLUGIN_CONFIGURATION_DEFINITION;
                } else {
                    if (this.subcontext != ParseSubContext.ResourceConfiguration) throw new InvalidExpressionException("Invalid 'configuration' subexpression: " + (Object)((Object)this.subcontext));
                    prefix = "resourceconfiguration";
                    JoinCondition joinCondition = JoinCondition.RESOURCE_CONFIGURATION;
                    definitionJoinCondition = JoinCondition.RESOURCE_CONFIGURATION_DEFINITION;
                }
                String suffix = originalTokens.get(this.parseIndex).substring(prefix.length());
                if (suffix.length() < 3) {
                    throw new InvalidExpressionException("Unrecognized connection property '" + suffix + "'");
                }
                if (suffix.charAt(0) != '[' || suffix.charAt(suffix.length() - 1) != ']') {
                    throw new InvalidExpressionException("Property '" + suffix + "' must be contained within '[' and ']' characters");
                }
                String propertyName = suffix.substring(1, suffix.length() - 1);
                this.addJoinCondition((JoinCondition)var12_24);
                this.addJoinCondition(definitionJoinCondition);
                this.populatePredicateCollections("simple.name", propertyName, false);
                this.populatePredicateCollections("simple.stringValue", value);
                this.whereStatics.add("simple.configuration = " + var12_24.alias);
                this.whereStatics.add("simpleDef.configurationDefinition = " + definitionJoinCondition.alias);
                this.whereStatics.add("simple.name = simpleDef.name");
                this.whereStatics.add("simpleDef.type != 'PASSWORD'");
            } else if (this.context == ParseContext.StringMatch) {
                void var12_29;
                if (this.expressionType != String.class) {
                    throw new InvalidExpressionException("Can not apply a string function to an expression that resolves to " + this.expressionType.getSimpleName());
                }
                String lastArgumentName = this.getLastArgumentName();
                String string = (String)this.whereReplacements.get(lastArgumentName);
                if (nextToken.equals("startswith")) {
                    String string2 = QueryUtility.escapeSearchParameter(string) + "%";
                } else if (nextToken.equals("endswith")) {
                    String string3 = "%" + QueryUtility.escapeSearchParameter(string);
                } else {
                    if (!nextToken.equals("contains")) throw new InvalidExpressionException("Unrecognized string function '" + nextToken + "' at end of condition");
                    String string4 = "%" + QueryUtility.escapeSearchParameter(string) + "%";
                }
                this.whereReplacements.put(lastArgumentName, var12_29);
                this.context = ParseContext.END;
            } else {
                if (this.context != ParseContext.END) throw new InvalidExpressionException("Unknown parse context: " + (Object)((Object)this.context));
                throw new InvalidExpressionException("Unrecognized tokens at end of expression");
            }
            ++this.parseIndex;
        }
        if (this.context.isExpressionTerminator()) return;
        throw new InvalidExpressionException("Unexpected termination of expression");
    }

    private void addJoinCondition(JoinCondition condition) {
        this.joinConditions.put(condition, this.getResourceRelativeContext());
    }

    private String getResourceRelativeContextToken() {
        return this.getResourceRelativeContext().pathToken;
    }

    private ResourceRelativeContext getResourceRelativeContext() {
        if (this.deepestResourceContext == ParseContext.Resource) {
            return ResourceRelativeContext.Resource;
        }
        if (this.deepestResourceContext == ParseContext.ResourceParent) {
            return ResourceRelativeContext.ResourceParent;
        }
        if (this.deepestResourceContext == ParseContext.ResourceGrandParent) {
            return ResourceRelativeContext.ResourceGrandParent;
        }
        if (this.deepestResourceContext == ParseContext.ResourceGreatGrandParent) {
            return ResourceRelativeContext.ResourceGreatGrandParent;
        }
        if (this.deepestResourceContext == ParseContext.ResourceGreatGreatGrandParent) {
            return ResourceRelativeContext.ResourceGreatGreatGrandParent;
        }
        if (this.deepestResourceContext == ParseContext.ResourceChild) {
            this.joinConditions.put(JoinCondition.RESOURCE_CHILD, ResourceRelativeContext.Resource);
            return ResourceRelativeContext.ResourceChild;
        }
        throw new IllegalStateException("Expression only supports filtering on two levels of resource ancestry");
    }

    private void parseExpression_resourceContext(String value, String[] tokens, String nextToken) throws InvalidExpressionException {
        if (nextToken.equals("id")) {
            this.expressionType = Integer.class;
            this.populatePredicateCollections(this.getResourceRelativeContextToken() + ".id", value);
        } else if (nextToken.equals("name")) {
            this.populatePredicateCollections(this.getResourceRelativeContextToken() + ".name", value);
        } else if (nextToken.equals("version")) {
            this.populatePredicateCollections(this.getResourceRelativeContextToken() + ".version", value);
        } else if (nextToken.equals("type")) {
            this.context = ParseContext.ResourceType;
        } else if (nextToken.startsWith("availability")) {
            this.context = ParseContext.Availability;
            --this.parseIndex;
        } else if (nextToken.startsWith(TRAIT_ALIAS)) {
            this.context = ParseContext.Trait;
            --this.parseIndex;
        } else if (nextToken.startsWith("pluginconfiguration")) {
            this.context = ParseContext.Configuration;
            this.subcontext = ParseSubContext.PluginConfiguration;
            --this.parseIndex;
        } else if (nextToken.startsWith("resourceconfiguration")) {
            this.context = ParseContext.Configuration;
            this.subcontext = ParseSubContext.ResourceConfiguration;
            --this.parseIndex;
        } else {
            throw new InvalidExpressionException("Invalid 'resource' subexpression: " + PrintUtils.getDelimitedString(tokens, this.parseIndex, "."));
        }
    }

    private String getNextArgumentName() {
        ++this.counter;
        String argumentName = "arg" + this.counter;
        return argumentName;
    }

    private String getLastArgumentName() {
        String argumentName = "arg" + this.counter;
        return argumentName;
    }

    private void populatePredicateCollections(String predicateName, Object value) throws InvalidExpressionException {
        this.populatePredicateCollections(predicateName, value, this.isGroupBy);
    }

    private void populatePredicateCollections(String predicateName, Object value, boolean groupBy) throws InvalidExpressionException {
        if (groupBy) {
            this.groupByElements.add(predicateName);
        } else {
            String argumentName = this.getNextArgumentName();
            if (this.comparisonType == ComparisonType.EMPTY) {
                if (value == null) {
                    value = Literal.NULL;
                }
            } else if (this.comparisonType == ComparisonType.NOT_EMPTY) {
                if (value == null) {
                    value = Literal.NOTNULL;
                }
            } else if (this.comparisonType != ComparisonType.EQUALS && this.comparisonType != ComparisonType.NONE) {
                throw new InvalidExpressionException("Unknown or unsupported ComparisonType[" + (Object)((Object)this.comparisonType) + "] for predicate population");
            }
            this.whereConditions.put(predicateName, argumentName);
            this.whereReplacements.put(argumentName, value);
            this.whereReplacementTypes.put(argumentName, this.expressionType);
        }
        this.context = ParseContext.StringMatch;
    }

    public void execute() {
        if (this.isInvalid) {
            throw new IllegalStateException("This evaluator previously threw an exception and can no longer be used");
        }
        if (this.expressionCount == 0) {
            return;
        }
        String selectExpression = this.getQuerySelectExpression(false);
        String queryStr = "SELECT " + selectExpression + " FROM Resource res ";
        queryStr = queryStr + this.getQueryJoinConditions();
        queryStr = queryStr + this.getQueryWhereConditions();
        queryStr = queryStr + this.getQueryGroupBy(selectExpression);
        this.computedJPQLStatement = queryStr = queryStr.trim();
        if (this.groupByElements.size() > 0) {
            String groupQueryStr = "SELECT " + this.getQuerySelectExpression(true) + " FROM Resource res ";
            groupQueryStr = groupQueryStr + this.getQueryJoinConditions();
            for (String groupedElement : this.groupByElements) {
                String argumentName = this.getNextArgumentName();
                this.whereConditions.put(groupedElement, argumentName);
            }
            this.computedJPQLGroupStatement = groupQueryStr = groupQueryStr + this.getQueryWhereConditions();
        }
        this.resultsComputed = true;
    }

    @Override
    public Iterator<Result> iterator() {
        if (!this.resultsComputed) {
            this.execute();
        }
        if (this.groupByElements.size() == 0) {
            return new SingleQueryIterator();
        }
        return new MultipleQueryIterator();
    }

    private List getSingleResultList(String queryStr) {
        Class<?> bindType;
        String bindArgument;
        if (this.log.isDebugEnabled()) {
            String resolvedQuery = queryStr;
            for (Map.Entry<String, Object> replacement : this.whereReplacements.entrySet()) {
                bindArgument = replacement.getKey();
                String bindValueAsString = replacement.getValue().toString();
                bindType = this.whereReplacementTypes.get(bindArgument);
                if (bindType.equals(Integer.class)) {
                    resolvedQuery = resolvedQuery.replace(":" + bindArgument, bindValueAsString);
                    continue;
                }
                if (bindType.equals(String.class)) {
                    resolvedQuery = resolvedQuery.replace(":" + bindArgument, "'" + bindValueAsString + "'");
                    continue;
                }
                throw new IllegalArgumentException("Unknown bindType " + bindType + " for " + bindArgument + " having value " + bindValueAsString);
            }
            this.log.debug((Object)("Query: " + resolvedQuery));
        }
        if (this.isTestMode) {
            return Collections.emptyList();
        }
        Query query = this.entityManagerFacade.createQuery(queryStr);
        for (Map.Entry<String, Object> replacement : this.whereReplacements.entrySet()) {
            bindArgument = replacement.getKey();
            Object bindValue = replacement.getValue();
            bindType = this.whereReplacementTypes.get(bindArgument);
            if (bindType.equals(Integer.class)) {
                try {
                    query.setParameter(bindArgument, (Object)Integer.valueOf(bindValue.toString()));
                }
                catch (NumberFormatException nfe) {
                    query.setParameter(bindArgument, bindValue);
                }
                continue;
            }
            if (bindType.equals(String.class)) {
                query.setParameter(bindArgument, bindValue);
                continue;
            }
            throw new IllegalArgumentException("Unknown bindType " + bindType + " for " + bindArgument + " having value " + bindValue);
        }
        return query.getResultList();
    }

    private String getQuerySelectExpression(boolean returnDefault) {
        String selectExpression = "";
        if (!returnDefault && this.groupByElements.size() > 0) {
            selectExpression = this.groupByElements.get(0);
            for (int i = 1; i < this.groupByElements.size(); ++i) {
                selectExpression = selectExpression + ", " + this.groupByElements.get(i);
            }
        } else {
            selectExpression = "res.id";
        }
        return selectExpression;
    }

    private String getQueryGroupBy(String selectExpression) {
        if (this.groupByElements.size() > 0) {
            return " GROUP BY " + selectExpression;
        }
        return "";
    }

    private String getQueryJoinConditions() {
        JoinCondition[] orderedConditionProcessing;
        String result = "";
        for (JoinCondition joinCondition : orderedConditionProcessing = new JoinCondition[]{JoinCondition.RESOURCE_CHILD, JoinCondition.AVAILABILITY, JoinCondition.SCHEDULES, JoinCondition.PLUGIN_CONFIGURATION, JoinCondition.PLUGIN_CONFIGURATION_DEFINITION, JoinCondition.RESOURCE_CONFIGURATION, JoinCondition.RESOURCE_CONFIGURATION_DEFINITION}) {
            ResourceRelativeContext context = this.joinConditions.get((Object)joinCondition);
            if (context == null) continue;
            result = result + " JOIN " + context.pathToken + joinCondition.subexpression + " " + joinCondition.alias;
            if (joinCondition == JoinCondition.SCHEDULES) {
                result = result + " JOIN " + joinCondition.alias + ".definition " + METRIC_DEF_ALIAS;
                result = result + ", MeasurementDataTrait trait ";
                continue;
            }
            if (joinCondition != JoinCondition.PLUGIN_CONFIGURATION && joinCondition != JoinCondition.RESOURCE_CONFIGURATION) continue;
            result = result + ", PropertySimple simple";
            result = result + ", PropertyDefinition simpleDef";
        }
        return result;
    }

    private String getQueryWhereConditions() {
        boolean first;
        String result = "";
        if (this.whereConditions.size() > 0) {
            result = result + " WHERE ";
            first = true;
            for (Map.Entry entry : this.whereConditions.entrySet()) {
                Object bindValue;
                if (!first) {
                    result = result + " AND ";
                }
                if ((bindValue = this.whereReplacements.get(entry.getValue())) == Literal.NOTNULL) {
                    result = result + (String)entry.getKey() + " IS NOT NULL ";
                    this.whereReplacements.remove(entry.getValue());
                } else if (bindValue == Literal.NULL) {
                    result = result + (String)entry.getKey() + " IS NULL ";
                    this.whereReplacements.remove(entry.getValue());
                } else {
                    String bindValueAsString;
                    String whereConditionOperator = " = ";
                    String ending = " ";
                    if (bindValue != null && (bindValueAsString = bindValue.toString()) != null && (bindValueAsString.startsWith("%") || bindValueAsString.endsWith("%"))) {
                        whereConditionOperator = " LIKE ";
                        ending = QueryUtility.getEscapeClause();
                    }
                    result = result + (String)entry.getKey() + whereConditionOperator + ":" + (String)entry.getValue() + ending;
                }
                first = false;
            }
        }
        if (this.whereStatics.size() > 0) {
            if (result.length() == 0) {
                result = result + " WHERE ";
                first = true;
            } else {
                first = false;
            }
            for (String string : this.whereStatics) {
                if (!first) {
                    result = result + " AND ";
                }
                result = result + string + " ";
                first = false;
            }
        }
        return result;
    }

    public List<String> tokenizeCondition(String condition) {
        ArrayList<String> results = new ArrayList<String>();
        boolean insideBracket = false;
        StringBuilder currentToken = new StringBuilder();
        for (char c : condition.trim().toCharArray()) {
            if (insideBracket) {
                if (c == ']') {
                    insideBracket = false;
                }
                currentToken.append(c);
                continue;
            }
            if (c == '.' || c == ' ') {
                String token = currentToken.toString();
                if (token.length() > 0) {
                    results.add(token);
                }
                currentToken = new StringBuilder();
                continue;
            }
            if (c == '[') {
                insideBracket = true;
            }
            currentToken.append(c);
        }
        String token = currentToken.toString();
        if (token.length() > 0) {
            results.add(token);
        }
        return results;
    }

    private String parseTraitName(List<String> originalTokens) throws InvalidExpressionException {
        String prefix = TRAIT_ALIAS;
        String suffix = originalTokens.get(this.parseIndex).substring(prefix.length());
        if (suffix.length() < 3) {
            throw new InvalidExpressionException("Unrecognized trait name '" + suffix + "'");
        }
        if (suffix.charAt(0) != '[' || suffix.charAt(suffix.length() - 1) != ']') {
            throw new InvalidExpressionException("Trait name '" + suffix + "' must be contained within '[' and ']' characters");
        }
        return suffix.substring(1, suffix.length() - 1);
    }

    private void validateSubExpressionAgainstPreviouslySeen(String normalizedSubExpression, boolean grouped) throws InvalidExpressionException {
        normalizedSubExpression = this.stripFunctionSuffix(normalizedSubExpression);
        if (grouped) {
            if (this.groupedSubExpressions.contains(normalizedSubExpression)) {
                throw new InvalidExpressionException("Redundant 'groupby' expression[" + normalizedSubExpression + "] - these expressions must be unique");
            }
            if (this.simpleSubExpressions.contains(normalizedSubExpression)) {
                throw new InvalidExpressionException("Can not group by the same condition you are filtering on, expression[" + normalizedSubExpression + "]");
            }
            this.groupedSubExpressions.add(normalizedSubExpression);
        } else {
            if (this.groupedSubExpressions.contains(normalizedSubExpression)) {
                throw new InvalidExpressionException("Can not group by the same condition you are filtering on, expression[" + normalizedSubExpression + "]");
            }
            this.simpleSubExpressions.add(normalizedSubExpression);
        }
    }

    private String stripFunctionSuffix(String expression) {
        for (String function : this.functions) {
            if (!expression.endsWith(function)) continue;
            return expression.substring(0, expression.length() - function.length());
        }
        return expression;
    }

    private static class PrintUtils {
        private PrintUtils() {
        }

        public static String getDelimitedString(Object[] tokens, int fromIndex, String delimiter) {
            StringBuilder builder = new StringBuilder();
            for (int j = fromIndex; j < tokens.length; ++j) {
                Object token;
                if (j != fromIndex) {
                    builder.append(delimiter);
                }
                if ((token = tokens[j]) == null) {
                    builder.append("empty");
                    continue;
                }
                builder.append(token.toString());
            }
            return builder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MultipleQueryIterator
    implements Iterator<Result> {
        private static final String nullHandlerPattern = "\\s+((\\=|LIKE)\\s+(:arg[0-9]*))";
        List uniqueTuples;
        int index;

        public MultipleQueryIterator() {
            ExpressionEvaluator.this.log.debug((Object)("MultipleQueryIterator: '" + ExpressionEvaluator.this.computedJPQLStatement + "'"));
            this.uniqueTuples = ExpressionEvaluator.this.getSingleResultList(ExpressionEvaluator.this.computedJPQLStatement);
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.uniqueTuples.size();
        }

        @Override
        public Result next() {
            Object nextResult;
            int i = 0;
            Object[] groupByExpression = (nextResult = this.uniqueTuples.get(this.index++)) == null ? new Object[]{null} : (nextResult.getClass().isArray() ? (Object[])nextResult : new Object[]{nextResult});
            for (String groupedElement : ExpressionEvaluator.this.groupByElements) {
                Object groupByExpressionElement;
                String bindArgumentName = (String)ExpressionEvaluator.this.whereConditions.get(groupedElement);
                if ((groupByExpressionElement = groupByExpression[i++]) == null) {
                    ExpressionEvaluator.this.whereReplacements.remove(bindArgumentName);
                    String patternWtihArgument = "\\Q" + groupedElement + "\\E" + nullHandlerPattern;
                    Pattern nullHandler = Pattern.compile(patternWtihArgument);
                    Matcher nullMatcher = nullHandler.matcher(ExpressionEvaluator.this.computedJPQLGroupStatement);
                    if (!nullMatcher.find()) {
                        ExpressionEvaluator.this.log.warn((Object)"Did not match for pivoted NULL result");
                        ExpressionEvaluator.this.log.warn((Object)("Handler pattern was: " + patternWtihArgument));
                        ExpressionEvaluator.this.log.warn((Object)("Computed statement was: " + ExpressionEvaluator.this.computedJPQLGroupStatement));
                        return null;
                    }
                    ExpressionEvaluator.this.log.debug((Object)("Dynamic replacement made for pivoted NULL result on subexpression bind argument '" + bindArgumentName + "'"));
                    ExpressionEvaluator.this.log.debug((Object)("Orginal query: " + ExpressionEvaluator.this.computedJPQLGroupStatement));
                    ExpressionEvaluator.this.computedJPQLGroupStatement = nullMatcher.replaceFirst(groupedElement + " IS NULL ");
                    ExpressionEvaluator.this.log.debug((Object)("Updated query: " + ExpressionEvaluator.this.computedJPQLGroupStatement));
                    continue;
                }
                ExpressionEvaluator.this.whereReplacements.put(bindArgumentName, groupByExpressionElement);
                ExpressionEvaluator.this.whereReplacementTypes.put(bindArgumentName, String.class);
            }
            ExpressionEvaluator.this.log.debug((Object)("MultipleQueryIterator: '" + ExpressionEvaluator.this.computedJPQLGroupStatement + "'"));
            List results = ExpressionEvaluator.this.getSingleResultList(ExpressionEvaluator.this.computedJPQLGroupStatement);
            return new Result(results, PrintUtils.getDelimitedString(groupByExpression, 0, ","));
        }

        @Override
        public void remove() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SingleQueryIterator
    implements Iterator<Result> {
        boolean firstTime = true;

        private SingleQueryIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.firstTime;
        }

        @Override
        public Result next() {
            ExpressionEvaluator.this.log.debug((Object)("SingleQueryIterator: '" + ExpressionEvaluator.this.computedJPQLStatement + "'"));
            List results = ExpressionEvaluator.this.getSingleResultList(ExpressionEvaluator.this.computedJPQLStatement);
            this.firstTime = false;
            return new Result(results);
        }

        @Override
        public void remove() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ResourceRelativeContext {
        Resource("res"),
        ResourceParent("res.parentResource"),
        ResourceGrandParent("res.parentResource.parentResource"),
        ResourceGreatGrandParent("res.parentResource.parentResource.parentResource"),
        ResourceGreatGreatGrandParent("res.parentResource.parentResource.parentResource.parentResource"),
        ResourceChild("child");

        public String pathToken;

        private ResourceRelativeContext(String pathToken) {
            this.pathToken = pathToken;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Literal {
        NULL,
        NOTNULL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ComparisonType {
        NONE,
        EQUALS,
        EMPTY,
        NOT_EMPTY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ParseSubContext {
        Negated,
        NotEmpty,
        Empty,
        Pivot,
        PluginConfiguration,
        ResourceConfiguration;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ParseContext {
        BEGIN(false),
        Modifier(false),
        Resource(false),
        ResourceParent(false),
        ResourceGrandParent(false),
        ResourceGreatGrandParent(false),
        ResourceGreatGreatGrandParent(false),
        ResourceChild(false),
        ResourceType(false),
        Availability(true),
        Trait(true),
        Configuration(true),
        StringMatch(true),
        END(true);

        private boolean canTerminateExpression;

        private ParseContext(boolean canTerminateExpression) {
            this.canTerminateExpression = canTerminateExpression;
        }

        public boolean isExpressionTerminator() {
            return this.canTerminateExpression;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Result {
        private final List<Integer> data;
        private final String groupByClause;

        public Result(List<Integer> data) {
            this.data = data;
            this.groupByClause = "";
        }

        public Result(List<Integer> data, String groupByExpression) {
            this.data = data;
            this.groupByClause = groupByExpression;
        }

        public List<Integer> getData() {
            return this.data;
        }

        public String getGroupByClause() {
            return this.groupByClause;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum JoinCondition {
        RESOURCE_CONFIGURATION(".resourceConfiguration", "conf"),
        PLUGIN_CONFIGURATION(".pluginConfiguration", "pluginConf"),
        SCHEDULES(".schedules", "sched"),
        RESOURCE_CHILD(".childResources", "child"),
        AVAILABILITY(".currentAvailability", "avail"),
        RESOURCE_CONFIGURATION_DEFINITION(".resourceType.resourceConfigurationDefinition", "confDef"),
        PLUGIN_CONFIGURATION_DEFINITION(".resourceType.pluginConfigurationDefinition", "pluginConfDef");

        String subexpression;
        String alias;

        private JoinCondition(String subexpression, String alias) {
            this.subexpression = subexpression;
            this.alias = alias;
        }
    }
}

