/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.metadata.PluginDependencyGraph;
import org.rhq.core.clientapi.agent.metadata.PluginMetadataManager;
import org.rhq.core.clientapi.agent.metadata.SubCategoriesMetadataParser;
import org.rhq.core.clientapi.descriptor.AgentPluginDescriptorUtil;
import org.rhq.core.clientapi.descriptor.plugin.PluginDescriptor;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.bundle.BundleType;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.ConfigurationTemplate;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.event.EventDefinition;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.plugin.Plugin;
import org.rhq.core.domain.resource.ProcessScan;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceSubCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.configuration.metadata.ConfigurationDefinitionUpdateReport;
import org.rhq.enterprise.server.configuration.metadata.ConfigurationMetadataManagerLocal;
import org.rhq.enterprise.server.event.EventManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementDefinitionManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.metadata.ResourceMetadataManagerLocal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
@Resource(name="RHQ_DS", mappedName="java:/RHQDS")
public class ResourceMetadataManagerBean
implements ResourceMetadataManagerLocal {
    private final Log log = LogFactory.getLog(ResourceMetadataManagerBean.class);
    @Resource(name="RHQ_DS")
    private DataSource dataSource;
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    private static final PluginMetadataManager PLUGIN_METADATA_MANAGER = new PluginMetadataManager();
    @EJB
    private MeasurementDefinitionManagerLocal measurementDefinitionManager;
    @EJB
    private MeasurementScheduleManagerLocal scheduleManager;
    @EJB
    private ConfigurationMetadataManagerLocal configurationMetadataManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private ResourceManagerLocal resourceManager;
    @EJB
    private ResourceTypeManagerLocal resourceTypeManager;
    @EJB
    private EventManagerLocal eventManager;
    @EJB
    private ResourceMetadataManagerLocal resourceMetadataManager;

    @Override
    public List<Plugin> getAllPluginsById(List<Integer> pluginIds) {
        if (pluginIds == null || pluginIds.size() == 0) {
            return new ArrayList<Plugin>();
        }
        Query query = this.entityManager.createNamedQuery("Plugin.findAllByIds");
        query.setParameter("ids", pluginIds);
        return query.getResultList();
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void enablePlugins(Subject subject, List<Integer> pluginIds) throws Exception {
        if (pluginIds == null || pluginIds.size() == 0) {
            return;
        }
        PluginDependencyGraph graph = PLUGIN_METADATA_MANAGER.buildDependencyGraph();
        List<Plugin> allPlugins = this.getPlugins();
        HashSet<String> pluginsThatNeedToBeEnabled = new HashSet<String>();
        for (Integer pluginId : pluginIds) {
            Plugin plugin = this.getPluginFromListById(allPlugins, pluginId);
            if (plugin == null) continue;
            Collection dependencyNames = graph.getAllDependencies(plugin.getName());
            for (String dependencyName : dependencyNames) {
                Plugin dependencyPlugin = this.getPluginFromListByName(allPlugins, dependencyName);
                if (dependencyPlugin == null || dependencyPlugin.isEnabled() || pluginIds.contains(dependencyPlugin.getId())) continue;
                pluginsThatNeedToBeEnabled.add(dependencyPlugin.getDisplayName());
            }
        }
        if (!pluginsThatNeedToBeEnabled.isEmpty()) {
            throw new IllegalArgumentException("You must enable the following plugin dependencies also: " + pluginsThatNeedToBeEnabled);
        }
        for (Integer pluginId : pluginIds) {
            this.resourceMetadataManager.setPluginEnabledFlag(subject, pluginId, true);
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void disablePlugins(Subject subject, List<Integer> pluginIds) throws Exception {
        if (pluginIds == null || pluginIds.size() == 0) {
            return;
        }
        PluginDependencyGraph graph = PLUGIN_METADATA_MANAGER.buildDependencyGraph();
        List<Plugin> allPlugins = this.getPlugins();
        HashSet<String> pluginsThatNeedToBeDisabled = new HashSet<String>();
        for (Integer pluginId : pluginIds) {
            Plugin plugin = this.getPluginFromListById(allPlugins, pluginId);
            if (plugin == null) continue;
            Collection dependentNames = graph.getAllDependents(plugin.getName());
            for (String dependentName : dependentNames) {
                Plugin dependentPlugin = this.getPluginFromListByName(allPlugins, dependentName);
                if (dependentPlugin == null || !dependentPlugin.isEnabled() || pluginIds.contains(dependentPlugin.getId())) continue;
                pluginsThatNeedToBeDisabled.add(dependentPlugin.getDisplayName());
            }
        }
        if (!pluginsThatNeedToBeDisabled.isEmpty()) {
            throw new IllegalArgumentException("You must disable the following dependent plugins also: " + pluginsThatNeedToBeDisabled);
        }
        for (Integer pluginId : pluginIds) {
            this.resourceMetadataManager.setPluginEnabledFlag(subject, pluginId, false);
        }
    }

    private Plugin getPluginFromListByName(List<Plugin> plugins, String name) {
        for (Plugin plugin : plugins) {
            if (!name.equals(plugin.getName())) continue;
            return plugin;
        }
        return null;
    }

    private Plugin getPluginFromListById(List<Plugin> plugins, int id) {
        for (Plugin plugin : plugins) {
            if (id != plugin.getId()) continue;
            return plugin;
        }
        return null;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void setPluginEnabledFlag(Subject subject, int pluginId, boolean enabled) throws Exception {
        Query q = this.entityManager.createNamedQuery("Plugin.updatePluginEnabledById");
        q.setParameter("id", (Object)pluginId);
        q.setParameter("enabled", (Object)enabled);
        q.executeUpdate();
        this.log.info((Object)((enabled ? "Enabling" : "Disabling") + " plugin [" + pluginId + "]"));
    }

    @Override
    public Plugin getPlugin(String name) {
        Query query = this.entityManager.createNamedQuery("Plugin.findByName");
        query.setParameter("name", (Object)name);
        Plugin plugin = (Plugin)query.getSingleResult();
        return plugin;
    }

    @Override
    public List<Plugin> getPlugins() {
        Query q = this.entityManager.createNamedQuery("Plugin.findAllInstalled");
        return q.getResultList();
    }

    @Override
    public List<Plugin> getPluginsByResourceTypeAndCategory(String resourceTypeName, ResourceCategory resourceCategory) {
        Query query = this.entityManager.createNamedQuery("Plugin.findByResourceType");
        query.setParameter("resourceTypeName", (Object)resourceTypeName);
        query.setParameter("resourceCategory", (Object)resourceCategory);
        List results = query.getResultList();
        return results;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void registerPlugin(Subject whoami, Plugin plugin, PluginDescriptor pluginDescriptor, File pluginFile, boolean forceUpdate) throws Exception {
        boolean typesUpdated = this.resourceMetadataManager.registerPluginInNewTransaction(whoami, plugin, pluginDescriptor, pluginFile, forceUpdate);
        if (typesUpdated) {
            this.resourceMetadataManager.removeObsoleteTypesInNewTransaction(plugin.getName());
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean registerPluginInNewTransaction(Subject whoami, Plugin plugin, PluginDescriptor pluginDescriptor, File pluginFile, boolean forceUpdate) throws Exception {
        Plugin existingPlugin = null;
        boolean newOrUpdated = false;
        boolean typesUpdated = false;
        try {
            existingPlugin = this.getPlugin(plugin.getName());
        }
        catch (NoResultException nre) {
            newOrUpdated = true;
        }
        if (existingPlugin != null) {
            Plugin obsolete = AgentPluginDescriptorUtil.determineObsoletePlugin((Plugin)plugin, (Plugin)existingPlugin);
            if (obsolete == existingPlugin) {
                newOrUpdated = true;
            }
            plugin.setId(existingPlugin.getId());
            plugin.setEnabled(existingPlugin.isEnabled());
        }
        if (newOrUpdated) {
            if (plugin.getDisplayName() == null) {
                plugin.setDisplayName(plugin.getName());
            }
            plugin = this.updatePluginExceptContent(plugin);
            if (pluginFile != null) {
                this.entityManager.flush();
                this.streamPluginFileContentToDatabase(plugin.getId(), pluginFile);
            }
            this.log.debug((Object)("Updated plugin entity [" + plugin + "]"));
        }
        if (newOrUpdated || forceUpdate || !PLUGIN_METADATA_MANAGER.getPluginNames().contains(plugin.getName())) {
            Set rootResourceTypes = PLUGIN_METADATA_MANAGER.loadPlugin(pluginDescriptor);
            if (rootResourceTypes == null) {
                throw new Exception("Failed to load plugin [" + plugin.getName() + "].");
            }
            if (newOrUpdated || forceUpdate) {
                this.updateTypes(rootResourceTypes);
                typesUpdated = true;
            }
        }
        return typesUpdated;
    }

    private Plugin updatePluginExceptContent(Plugin plugin) throws Exception {
        if (plugin.getId() == 0) {
            this.entityManager.persist((Object)plugin);
        } else {
            Plugin pluginEntity = (Plugin)this.entityManager.getReference(Plugin.class, (Object)plugin.getId());
            pluginEntity.setName(plugin.getName());
            pluginEntity.setPath(plugin.getPath());
            pluginEntity.setDisplayName(plugin.getDisplayName());
            pluginEntity.setEnabled(plugin.isEnabled());
            pluginEntity.setStatus(plugin.getStatus());
            pluginEntity.setMd5(plugin.getMD5());
            pluginEntity.setVersion(plugin.getVersion());
            pluginEntity.setAmpsVersion(plugin.getAmpsVersion());
            pluginEntity.setDeployment(plugin.getDeployment());
            pluginEntity.setDescription(plugin.getDescription());
            pluginEntity.setHelp(plugin.getHelp());
            pluginEntity.setMtime(plugin.getMtime());
            try {
                this.entityManager.flush();
            }
            catch (Exception e) {
                throw new Exception("Failed to update a plugin that matches [" + plugin + "]");
            }
        }
        return plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void streamPluginFileContentToDatabase(int id, File file) throws Exception {
        FileInputStream fis;
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        block6: {
            conn = null;
            ps = null;
            rs = null;
            fis = new FileInputStream(file);
            try {
                conn = this.dataSource.getConnection();
                ps = conn.prepareStatement("UPDATE RHQ_PLUGIN SET CONTENT = ? WHERE ID = ?");
                ps.setBinaryStream(1, (InputStream)new BufferedInputStream(fis), (int)file.length());
                ps.setInt(2, id);
                int updateResults = ps.executeUpdate();
                if (updateResults == 1) break block6;
                throw new Exception("Failed to update content for plugin [" + id + "] from [" + file + "]");
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose((Connection)conn, ps, rs);
                try {
                    fis.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        JDBCUtil.safeClose((Connection)conn, (Statement)ps, rs);
        try {
            fis.close();
        }
        catch (Throwable t) {}
    }

    private void updateTypes(Set<ResourceType> rootResourceTypes) throws Exception {
        for (ResourceType rootResourceType : rootResourceTypes) {
            this.updateType(rootResourceType);
        }
        for (ResourceType rootResourceType : rootResourceTypes) {
            this.updateTypes(rootResourceType.getChildResourceTypes());
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void removeObsoleteTypesInNewTransaction(String pluginName) {
        Query query = this.entityManager.createNamedQuery("ResourceType.findByPlugin");
        query.setParameter("plugin", (Object)pluginName);
        List existingTypes = query.getResultList();
        if (existingTypes != null) {
            Subject overlord = this.subjectManager.getOverlord();
            Iterator iter = existingTypes.iterator();
            while (iter.hasNext()) {
                ResourceType existingType = (ResourceType)iter.next();
                if (PLUGIN_METADATA_MANAGER.getType(existingType.getName(), existingType.getPlugin()) != null) continue;
                if (this.entityManager.contains((Object)existingType)) {
                    this.entityManager.refresh((Object)existingType);
                }
                this.removeFromParents(existingType);
                List resources = existingType.getResources();
                if (resources != null) {
                    Iterator resIter = resources.iterator();
                    while (resIter.hasNext()) {
                        org.rhq.core.domain.resource.Resource res = (org.rhq.core.domain.resource.Resource)resIter.next();
                        List<Integer> deletedIds = this.resourceManager.deleteResource(overlord, res.getId());
                        for (Integer deletedResourceId : deletedIds) {
                            this.resourceManager.deleteSingleResourceInNewTransaction(overlord, deletedResourceId);
                        }
                        resIter.remove();
                    }
                }
                this.entityManager.flush();
                Set definitions = existingType.getMetricDefinitions();
                if (definitions != null) {
                    Iterator defIter = definitions.iterator();
                    while (defIter.hasNext()) {
                        MeasurementDefinition def = (MeasurementDefinition)defIter.next();
                        if (this.entityManager.contains((Object)def)) {
                            this.entityManager.refresh((Object)def);
                            this.measurementDefinitionManager.removeMeasurementDefinition(def);
                        }
                        defIter.remove();
                    }
                }
                this.entityManager.flush();
                this.entityManager.remove((Object)existingType);
                this.entityManager.flush();
                iter.remove();
            }
            for (ResourceType remainingType : existingTypes) {
                ResourceType updateType = PLUGIN_METADATA_MANAGER.getType(remainingType.getName(), remainingType.getPlugin());
                if (updateType == null) continue;
                this.removeSubCategories(updateType, remainingType);
                this.entityManager.flush();
            }
        }
    }

    private void removeFromParents(ResourceType typeToBeRemoved) {
        HashSet parents = new HashSet(typeToBeRemoved.getParentResourceTypes());
        for (ResourceType parent : parents) {
            parent.removeChildResourceType(typeToBeRemoved);
        }
    }

    private void updateType(ResourceType resourceType) {
        ResourceType existingType;
        this.entityManager.flush();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Updating resource type [" + resourceType.getName() + "] from plugin [" + resourceType.getPlugin() + "]..."));
        }
        try {
            existingType = this.resourceTypeManager.getResourceTypeByNameAndPlugin(resourceType.getName(), resourceType.getPlugin());
        }
        catch (NonUniqueResultException nure) {
            this.log.debug((Object)("Found more than one existing ResourceType for " + resourceType));
            throw new IllegalStateException(nure);
        }
        this.updateParentResourceTypes(resourceType, existingType);
        if (existingType == null) {
            this.persistNewType(resourceType);
        } else {
            this.mergeExistingType(resourceType, existingType);
        }
    }

    private void mergeExistingType(ResourceType resourceType, ResourceType existingType) {
        this.log.debug((Object)("Merging type [" + resourceType + "] + into existing type [" + existingType + "]..."));
        this.updateChildSubCategories(resourceType, existingType);
        this.entityManager.flush();
        this.updatePluginConfiguration(resourceType, existingType);
        this.entityManager.flush();
        this.updateResourceConfiguration(resourceType, existingType);
        this.updateMeasurementDefinitions(resourceType, existingType);
        this.updateContentDefinitions(resourceType, existingType);
        this.updateOperationDefinitions(resourceType, existingType);
        this.updateProcessScans(resourceType, existingType);
        this.updateEventDefinitions(resourceType, existingType);
        existingType.setDescription(resourceType.getDescription());
        existingType.setCreateDeletePolicy(resourceType.getCreateDeletePolicy());
        existingType.setCreationDataType(resourceType.getCreationDataType());
        existingType.setSingleton(resourceType.isSingleton());
        existingType.setSupportsManualAdd(resourceType.isSupportsManualAdd());
        ResourceSubCategory oldSubCat = existingType.getSubCategory();
        ResourceSubCategory newSubCat = resourceType.getSubCategory();
        if (oldSubCat == null || !oldSubCat.equals((Object)newSubCat)) {
            if (newSubCat == null) {
                if (oldSubCat != null) {
                    this.log.debug((Object)("Metadata update: Subcategory of ResourceType [" + resourceType.getName() + "] changed from " + oldSubCat + " to " + newSubCat));
                    existingType.setSubCategory(null);
                }
            } else {
                ResourceSubCategory existingSubCat = SubCategoriesMetadataParser.findSubCategoryOnResourceTypeAncestor((ResourceType)existingType, (String)newSubCat.getName());
                if (existingSubCat == null) {
                    throw new IllegalStateException("Resource type [" + resourceType.getName() + "] in plugin [" + resourceType.getPlugin() + "] has a subcategory (" + newSubCat.getName() + ") which was not defined as a child subcategory of one of its ancestor resource types.");
                }
                this.log.debug((Object)("Metadata update: Subcategory of ResourceType [" + resourceType.getName() + "] changed from " + oldSubCat + " to " + existingSubCat));
                existingType.setSubCategory(existingSubCat);
            }
        }
        existingType = (ResourceType)this.entityManager.merge((Object)existingType);
        this.entityManager.flush();
    }

    private void persistNewType(ResourceType resourceType) {
        this.log.info((Object)("Persisting new type [" + resourceType + "]..."));
        this.checkForValidSubcategories(resourceType.getChildSubCategories());
        this.linkSubCategoryToParents(resourceType);
        this.entityManager.persist((Object)resourceType);
        this.entityManager.flush();
    }

    private void linkSubCategoryToParents(ResourceType resourceType) {
        if (resourceType.getSubCategory() == null) {
            return;
        }
        ResourceSubCategory mySubCategory = resourceType.getSubCategory();
        ResourceSubCategory existingCat = SubCategoriesMetadataParser.findSubCategoryOnResourceTypeAncestor((ResourceType)resourceType, (String)mySubCategory.getName());
        if (existingCat == null) {
            throw new IllegalStateException("Subcategory " + mySubCategory.getName() + " defined on resource type " + resourceType.getName() + " in plugin " + resourceType.getPlugin() + " is not defined in a parent type");
        }
        resourceType.setSubCategory(existingCat);
    }

    private void updateParentResourceTypes(ResourceType newType, ResourceType existingType) {
        Set newParentTypes = newType.getParentResourceTypes();
        this.log.debug((Object)("Setting parent types on type: " + (existingType != null ? existingType : newType) + " to [" + newParentTypes + "]..."));
        newType.setParentResourceTypes(new HashSet());
        HashSet originalExistingParentTypes = new HashSet();
        if (existingType != null) {
            originalExistingParentTypes.addAll(existingType.getParentResourceTypes());
        }
        for (ResourceType newParentType : newParentTypes) {
            try {
                boolean parentNew = existingType == null || !originalExistingParentTypes.remove(newParentType);
                if (!parentNew) continue;
                ResourceType realParentType = (ResourceType)this.entityManager.createNamedQuery("ResourceType.findByNameAndPlugin").setParameter("name", (Object)newParentType.getName()).setParameter("plugin", (Object)newParentType.getPlugin()).getSingleResult();
                ResourceType type = existingType != null ? existingType : newType;
                this.log.info((Object)("Adding type [" + ResourceMetadataManagerBean.toConciseString(type) + "] as child of type [" + ResourceMetadataManagerBean.toConciseString(realParentType) + "]..."));
                realParentType.addChildResourceType(type);
            }
            catch (NoResultException nre) {
                throw new RuntimeException("Couldn't persist type [" + newType + "] because parent [" + newParentType + "] wasn't already persisted.");
            }
        }
        for (ResourceType obsoleteParentType : originalExistingParentTypes) {
            this.log.info((Object)("Removing type [" + ResourceMetadataManagerBean.toConciseString(existingType) + "] from parent type [" + ResourceMetadataManagerBean.toConciseString(obsoleteParentType) + "]..."));
            obsoleteParentType.removeChildResourceType(existingType);
            this.moveResourcesToNewParent(existingType, obsoleteParentType, newParentTypes);
        }
        this.entityManager.flush();
    }

    private static String toConciseString(ResourceType type) {
        return type != null ? type.getPlugin() + ":" + type.getName() + "(id=" + type.getId() + ")" : "null";
    }

    private void moveResourcesToNewParent(ResourceType existingType, ResourceType obsoleteParentType, Set<ResourceType> newParentTypes) {
        Subject overlord = this.subjectManager.getOverlord();
        ResourceCriteria criteria = new ResourceCriteria();
        criteria.addFilterResourceTypeId(Integer.valueOf(existingType.getId()));
        criteria.addFilterParentResourceTypeId(obsoleteParentType.getId());
        PageList<org.rhq.core.domain.resource.Resource> resources = this.resourceManager.findResourcesByCriteria(overlord, criteria);
        for (org.rhq.core.domain.resource.Resource resource : resources) {
            org.rhq.core.domain.resource.Resource newParent = null;
            block1: for (ResourceType newParentType : newParentTypes) {
                for (org.rhq.core.domain.resource.Resource ancestorResource = resource.getParentResource(); ancestorResource != null; ancestorResource = ancestorResource.getParentResource()) {
                    if (!ancestorResource.getResourceType().equals((Object)newParentType)) continue;
                    newParent = ancestorResource;
                    break block1;
                }
                for (org.rhq.core.domain.resource.Resource childResource : resource.getChildResources()) {
                    if (!childResource.getResourceType().equals((Object)newParentType)) continue;
                    newParent = childResource;
                    break block1;
                }
            }
            if (newParent != null) {
                if (resource.getParentResource() != null) {
                    resource.getParentResource().removeChildResource(resource);
                }
                newParent.addChildResource(resource);
                continue;
            }
            this.log.debug((Object)("We were unable to move " + resource + " from invalid parent " + resource.getParentResource() + " to a new valid parent with one of the following types: " + newParentTypes));
        }
    }

    private void checkForValidSubcategories(List<ResourceSubCategory> subCategories) {
        HashSet<String> subCatNames = new HashSet<String>();
        for (ResourceSubCategory subCategory : subCategories) {
            List<ResourceSubCategory> allSubcategories = this.getAllSubcategories(subCategory);
            for (ResourceSubCategory subCategory2 : allSubcategories) {
                if (subCatNames.contains(subCategory2.getName())) {
                    throw new RuntimeException("Subcategory [" + subCategory.getName() + "] is duplicated");
                }
                subCatNames.add(subCategory2.getName());
            }
        }
    }

    private List<ResourceSubCategory> getAllSubcategories(ResourceSubCategory cat) {
        ArrayList<ResourceSubCategory> result = new ArrayList<ResourceSubCategory>();
        if (cat.getChildSubCategories() != null) {
            for (ResourceSubCategory cat2 : cat.getChildSubCategories()) {
                result.addAll(this.getAllSubcategories(cat2));
            }
        }
        result.add(cat);
        return result;
    }

    private void updateEventDefinitions(ResourceType newType, ResourceType existingType) {
        Set newEventDefs = newType.getEventDefinitions();
        for (EventDefinition def : newEventDefs) {
            def.setResourceTypeId(existingType.getId());
        }
        Set existingEventDefs = existingType.getEventDefinitions();
        for (EventDefinition def : existingEventDefs) {
            this.entityManager.refresh((Object)def);
        }
        Set toDelete = this.missingInFirstSet(newEventDefs, existingEventDefs);
        Set newOnes = this.missingInFirstSet(existingEventDefs, newEventDefs);
        Set toUpdate = this.intersection(newEventDefs, existingEventDefs);
        for (EventDefinition eDef : existingEventDefs) {
            for (EventDefinition nDef : toUpdate) {
                if (!eDef.equals((Object)nDef)) continue;
                eDef.setDescription(nDef.getDescription());
                eDef.setDisplayName(nDef.getDisplayName());
            }
        }
        for (EventDefinition eDef : newOnes) {
            EventDefinition e2 = new EventDefinition(existingType, eDef.getName());
            e2.setDescription(eDef.getDescription());
            e2.setDisplayName(eDef.getDisplayName());
            this.entityManager.persist((Object)e2);
            existingType.addEventDefinition(e2);
        }
        existingEventDefs.removeAll(toDelete);
        this.entityManager.flush();
        for (EventDefinition eDef : toDelete) {
            this.eventManager.deleteEventSourcesForDefinition(eDef);
            this.entityManager.remove((Object)eDef);
        }
    }

    private void updatePluginConfiguration(ResourceType resourceType, ResourceType existingType) {
        ConfigurationDefinition existingConfigurationDefinition = existingType.getPluginConfigurationDefinition();
        if (resourceType.getPluginConfigurationDefinition() != null) {
            if (existingConfigurationDefinition == null) {
                this.entityManager.persist((Object)resourceType.getPluginConfigurationDefinition());
                existingType.setPluginConfigurationDefinition(resourceType.getPluginConfigurationDefinition());
            } else {
                ConfigurationDefinitionUpdateReport updateReport = this.configurationMetadataManager.updateConfigurationDefinition(resourceType.getPluginConfigurationDefinition(), existingConfigurationDefinition);
                if (updateReport.getNewPropertyDefinitions().size() > 0) {
                    Subject overlord = this.subjectManager.getOverlord();
                    ResourceCriteria criteria = new ResourceCriteria();
                    criteria.addFilterResourceTypeId(Integer.valueOf(existingType.getId()));
                    PageList<org.rhq.core.domain.resource.Resource> resources = this.resourceManager.findResourcesByCriteria(overlord, criteria);
                    for (org.rhq.core.domain.resource.Resource resource : resources) {
                        this.updateResourcePluginConfiguration(resource, updateReport);
                    }
                }
            }
        } else if (existingConfigurationDefinition != null) {
            existingType.setPluginConfigurationDefinition(null);
            this.entityManager.remove((Object)existingConfigurationDefinition);
        }
    }

    private void updateResourcePluginConfiguration(org.rhq.core.domain.resource.Resource resource, ConfigurationDefinitionUpdateReport updateReport) {
        Configuration pluginConfiguration = resource.getPluginConfiguration();
        int numberOfProperties = pluginConfiguration.getProperties().size();
        ConfigurationTemplate template = updateReport.getConfigurationDefinition().getDefaultTemplate();
        Configuration templateConfiguration = template.getConfiguration();
        for (PropertyDefinition propertyDef : updateReport.getNewPropertyDefinitions()) {
            if (!propertyDef.isRequired()) continue;
            Property templateProperty = templateConfiguration.get(propertyDef.getName());
            pluginConfiguration.put(templateProperty.deepCopy(false));
        }
        if (pluginConfiguration.getProperties().size() > numberOfProperties) {
            resource.setMtime(new Date().getTime());
        }
    }

    private void updateProcessScans(ResourceType resourceType, ResourceType existingType) {
        Set existingScans = existingType.getProcessScans();
        Set newScans = resourceType.getProcessScans();
        Set scansToPersist = this.missingInFirstSet(existingScans, newScans);
        Set scansToDelete = this.missingInFirstSet(newScans, existingScans);
        Set scansToUpdate = this.intersection(existingScans, newScans);
        for (ProcessScan scan : scansToUpdate) {
            for (ProcessScan nScan : newScans) {
                if (!scan.equals((Object)nScan)) continue;
                scan.setName(nScan.getName());
            }
        }
        for (ProcessScan scan : scansToPersist) {
            existingType.addProcessScan(scan);
        }
        for (ProcessScan scan : scansToDelete) {
            existingScans.remove(scan);
            this.entityManager.remove((Object)scan);
        }
    }

    private void updateOperationDefinitions(ResourceType resourceType, ResourceType existingType) {
        Set existingDefinitions = existingType.getOperationDefinitions();
        Set newDefinitions = resourceType.getOperationDefinitions();
        Set newOps = this.missingInFirstSet(existingDefinitions, newDefinitions);
        Set opsToRemove = this.missingInFirstSet(newDefinitions, existingDefinitions);
        existingDefinitions.retainAll(newDefinitions);
        for (OperationDefinition def : existingDefinitions) {
            for (OperationDefinition nDef : newDefinitions) {
                if (!def.equals((Object)nDef)) continue;
                def.setDescription(nDef.getDescription());
                def.setDisplayName(nDef.getDisplayName());
                def.setParametersConfigurationDefinition(nDef.getParametersConfigurationDefinition());
                def.setResourceVersionRange(nDef.getResourceVersionRange());
                def.setResultsConfigurationDefinition(nDef.getResultsConfigurationDefinition());
                def.setTimeout(nDef.getTimeout());
            }
        }
        for (OperationDefinition newOp : newOps) {
            existingType.addOperationDefinition(newOp);
        }
        existingDefinitions.removeAll(opsToRemove);
        for (OperationDefinition opToDelete : opsToRemove) {
            this.entityManager.remove((Object)opToDelete);
        }
    }

    private void updateMeasurementDefinitions(ResourceType newType, ResourceType existingType) {
        if (newType.getMetricDefinitions() != null) {
            Set existingDefinitions = existingType.getMetricDefinitions();
            if (existingDefinitions.isEmpty()) {
                for (MeasurementDefinition newDefinition : newType.getMetricDefinitions()) {
                    if (newDefinition.getDefaultInterval() < 30000L) {
                        newDefinition.setDefaultInterval(30000L);
                        this.log.info((Object)("Definition [" + newDefinition + "] has too short of a default interval, setting to minimum"));
                    }
                    existingType.addMetricDefinition(newDefinition);
                    this.entityManager.persist((Object)newDefinition);
                    this.scheduleManager.createSchedulesForExistingResources(existingType, newDefinition);
                }
            } else {
                for (MeasurementDefinition newDefinition : newType.getMetricDefinitions()) {
                    boolean found = false;
                    for (MeasurementDefinition existingDefinition : existingDefinitions) {
                        if (!existingDefinition.getName().equals(newDefinition.getName()) || existingDefinition.isPerMinute() != newDefinition.isPerMinute()) continue;
                        found = true;
                        existingDefinition.update(newDefinition, false);
                        if (existingDefinition.getDefaultInterval() < 30000L) {
                            existingDefinition.setDefaultInterval(30000L);
                            this.log.info((Object)("Definition [" + existingDefinition + "] has too short of a default interval, setting to minimum"));
                        }
                        this.entityManager.merge((Object)existingDefinition);
                        break;
                    }
                    if (found) continue;
                    existingType.addMetricDefinition(newDefinition);
                    this.entityManager.persist((Object)newDefinition);
                    this.scheduleManager.createSchedulesForExistingResources(existingType, newDefinition);
                }
                ArrayList<MeasurementDefinition> definitionsToDelete = new ArrayList<MeasurementDefinition>();
                for (MeasurementDefinition existingDefinition : existingDefinitions) {
                    if (newType.getMetricDefinitions().contains(existingDefinition)) continue;
                    definitionsToDelete.add(existingDefinition);
                }
                existingDefinitions.removeAll(definitionsToDelete);
                for (MeasurementDefinition definitionToDelete : definitionsToDelete) {
                    this.measurementDefinitionManager.removeMeasurementDefinition(definitionToDelete);
                }
                if (!definitionsToDelete.isEmpty() && this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Metadata update: Measurement definitions deleted from resource type [" + existingType.getName() + "]:" + definitionsToDelete));
                }
                this.entityManager.flush();
            }
        }
    }

    private void updateContentDefinitions(ResourceType newType, ResourceType existingType) {
        BundleType newBundleType = newType.getBundleType();
        if (newBundleType != null) {
            BundleType existingBundleType = existingType.getBundleType();
            newBundleType.setResourceType(existingType);
            if (existingBundleType != null) {
                newBundleType.setId(existingBundleType.getId());
                newBundleType = (BundleType)this.entityManager.merge((Object)newBundleType);
            }
            existingType.setBundleType(newBundleType);
        } else {
            existingType.setBundleType(null);
        }
        if (newType.getPackageTypes() == null || newType.getPackageTypes().size() == 0) {
            existingType.setPackageTypes(null);
            return;
        }
        if (existingType.getPackageTypes() == null || existingType.getPackageTypes().size() == 0) {
            for (PackageType newPackageType : newType.getPackageTypes()) {
                newPackageType.setResourceType(existingType);
                this.entityManager.persist((Object)newPackageType);
            }
            existingType.setPackageTypes(newType.getPackageTypes());
            return;
        }
        Set existingPackageTypes = existingType.getPackageTypes();
        HashMap<String, PackageType> newPackageTypeDefinitions = new HashMap<String, PackageType>(newType.getPackageTypes().size());
        for (PackageType newPackageType : newType.getPackageTypes()) {
            newPackageTypeDefinitions.put(newPackageType.getName(), newPackageType);
        }
        ArrayList removedPackageTypes = new ArrayList(existingType.getPackageTypes());
        removedPackageTypes.removeAll(newType.getPackageTypes());
        for (PackageType removedPackageType : removedPackageTypes) {
            existingType.removePackageType(removedPackageType);
            this.entityManager.remove((Object)removedPackageType);
        }
        ArrayList mergedPackageTypes = new ArrayList(existingType.getPackageTypes());
        mergedPackageTypes.retainAll(newType.getPackageTypes());
        for (PackageType mergedPackageType : mergedPackageTypes) {
            this.updatePackageConfigurations((PackageType)newPackageTypeDefinitions.get(mergedPackageType.getName()), mergedPackageType);
            mergedPackageType.update((PackageType)newPackageTypeDefinitions.get(mergedPackageType.getName()));
            this.entityManager.merge((Object)mergedPackageType);
        }
        ArrayList newPackageTypes = new ArrayList(newType.getPackageTypes());
        newPackageTypes.removeAll(existingType.getPackageTypes());
        for (PackageType newPackageType : newPackageTypes) {
            newPackageType.setResourceType(existingType);
            this.entityManager.persist((Object)newPackageType);
            existingPackageTypes.add(newPackageType);
        }
    }

    private void updateChildSubCategories(ResourceType newType, ResourceType existingType) {
        if (existingType.getChildSubCategories() == null) {
            for (ResourceSubCategory newSubCategory : newType.getChildSubCategories()) {
                this.log.debug((Object)("Metadata update: Adding new child SubCategory [" + newSubCategory.getName() + "] to ResourceType [" + existingType.getName() + "]..."));
                existingType.addChildSubCategory(newSubCategory);
                this.entityManager.persist((Object)newSubCategory);
            }
            return;
        }
        HashMap<String, ResourceSubCategory> subCategoriesFromNewType = new HashMap<String, ResourceSubCategory>(newType.getChildSubCategories().size());
        for (ResourceSubCategory newSubCategory : newType.getChildSubCategories()) {
            subCategoriesFromNewType.put(newSubCategory.getName(), newSubCategory);
        }
        ArrayList mergedSubCategories = new ArrayList(existingType.getChildSubCategories());
        mergedSubCategories.retainAll(subCategoriesFromNewType.values());
        for (ResourceSubCategory existingSubCat : mergedSubCategories) {
            this.updateSubCategory(existingSubCat, (ResourceSubCategory)subCategoriesFromNewType.get(existingSubCat.getName()));
            this.entityManager.merge((Object)existingSubCat);
        }
        ArrayList newSubCategories = new ArrayList(newType.getChildSubCategories());
        newSubCategories.removeAll(existingType.getChildSubCategories());
        for (ResourceSubCategory newSubCat : newSubCategories) {
            this.log.debug((Object)("Metadata update: Adding new child SubCategory [" + newSubCat.getName() + "] to ResourceType [" + existingType.getName() + "]..."));
            existingType.addChildSubCategory(newSubCat);
            this.entityManager.persist((Object)newSubCat);
        }
    }

    private void updateSubCategory(ResourceSubCategory existingSubCat, ResourceSubCategory newSubCategory) {
        existingSubCat.update(newSubCategory);
        if (existingSubCat.getChildSubCategories() == null || existingSubCat.getChildSubCategories().isEmpty()) {
            for (ResourceSubCategory newChildSubCategory : newSubCategory.getChildSubCategories()) {
                this.log.debug((Object)("Metadata update: Adding new child SubCategory [" + newChildSubCategory.getName() + "] to SubCategory [" + existingSubCat.getName() + "]..."));
                existingSubCat.addChildSubCategory(newChildSubCategory);
                this.entityManager.persist((Object)newChildSubCategory);
            }
            return;
        }
        HashMap<String, ResourceSubCategory> childSubCategoriesFromNewSubCat = new HashMap<String, ResourceSubCategory>(newSubCategory.getChildSubCategories().size());
        for (ResourceSubCategory newChildSubCategory : newSubCategory.getChildSubCategories()) {
            childSubCategoriesFromNewSubCat.put(newChildSubCategory.getName(), newChildSubCategory);
        }
        ArrayList mergedChildSubCategories = new ArrayList(existingSubCat.getChildSubCategories());
        mergedChildSubCategories.retainAll(childSubCategoriesFromNewSubCat.values());
        for (ResourceSubCategory existingChildSubCategory : mergedChildSubCategories) {
            this.updateSubCategory(existingChildSubCategory, (ResourceSubCategory)childSubCategoriesFromNewSubCat.get(existingChildSubCategory.getName()));
            this.entityManager.merge((Object)existingChildSubCategory);
        }
        ArrayList newChildSubCategories = new ArrayList(newSubCategory.getChildSubCategories());
        newChildSubCategories.removeAll(existingSubCat.getChildSubCategories());
        for (ResourceSubCategory newChildSubCategory : newChildSubCategories) {
            this.log.debug((Object)("Metadata update: Adding new child SubCategory [" + newChildSubCategory.getName() + "] to SubCategory [" + existingSubCat.getName() + "]..."));
            existingSubCat.addChildSubCategory(newChildSubCategory);
            this.entityManager.persist((Object)newChildSubCategory);
        }
    }

    private void removeSubCategories(ResourceType newType, ResourceType existingType) {
        ArrayList removedSubCategories = new ArrayList(existingType.getChildSubCategories());
        removedSubCategories.removeAll(newType.getChildSubCategories());
        for (ResourceSubCategory removedSubCat : removedSubCategories) {
            existingType.getChildSubCategories().remove(removedSubCat);
            this.entityManager.remove((Object)removedSubCat);
        }
        this.removeChildSubCategories(existingType.getChildSubCategories(), newType.getChildSubCategories());
    }

    private void removeChildSubCategories(List<ResourceSubCategory> existingSubCategories, List<ResourceSubCategory> newSubCategories) {
        HashMap<String, ResourceSubCategory> mapOfNewSubCategories = new HashMap<String, ResourceSubCategory>(newSubCategories.size());
        for (ResourceSubCategory newSubCategory : newSubCategories) {
            mapOfNewSubCategories.put(newSubCategory.getName(), newSubCategory);
        }
        for (ResourceSubCategory existingSubCat : existingSubCategories) {
            ArrayList removedChildSubCategories = new ArrayList(existingSubCat.getChildSubCategories());
            List newChildSubCategories = ((ResourceSubCategory)mapOfNewSubCategories.get(existingSubCat.getName())).getChildSubCategories();
            removedChildSubCategories.removeAll(newChildSubCategories);
            for (ResourceSubCategory removedChildSubCat : removedChildSubCategories) {
                existingSubCat.removeChildSubCategory(removedChildSubCat);
                this.entityManager.remove((Object)removedChildSubCat);
            }
            this.removeChildSubCategories(existingSubCat.getChildSubCategories(), newChildSubCategories);
        }
    }

    private void updatePackageConfigurations(PackageType newType, PackageType existingType) {
        ConfigurationDefinition existingDefinition;
        ConfigurationDefinition newConfigurationDefinition = newType.getDeploymentConfigurationDefinition();
        if (newConfigurationDefinition != null) {
            if (existingType.getDeploymentConfigurationDefinition() == null) {
                this.entityManager.persist((Object)newConfigurationDefinition);
                existingType.setDeploymentConfigurationDefinition(newConfigurationDefinition);
            } else {
                existingDefinition = existingType.getDeploymentConfigurationDefinition();
                this.configurationMetadataManager.updateConfigurationDefinition(newConfigurationDefinition, existingDefinition);
            }
        } else if (existingType.getDeploymentConfigurationDefinition() != null) {
            existingType.setDeploymentConfigurationDefinition(null);
        }
        newConfigurationDefinition = newType.getPackageExtraPropertiesDefinition();
        if (newConfigurationDefinition != null) {
            if (existingType.getPackageExtraPropertiesDefinition() == null) {
                this.entityManager.persist((Object)newConfigurationDefinition);
                existingType.setPackageExtraPropertiesDefinition(newConfigurationDefinition);
            } else {
                existingDefinition = existingType.getPackageExtraPropertiesDefinition();
                this.configurationMetadataManager.updateConfigurationDefinition(newConfigurationDefinition, existingDefinition);
            }
        } else if (existingType.getPackageExtraPropertiesDefinition() != null) {
            existingType.setPackageExtraPropertiesDefinition(null);
        }
    }

    private void updateResourceConfiguration(ResourceType newType, ResourceType existingType) {
        ConfigurationDefinition newResourceConfigurationDefinition = newType.getResourceConfigurationDefinition();
        if (newResourceConfigurationDefinition != null) {
            if (existingType.getResourceConfigurationDefinition() == null) {
                this.entityManager.persist((Object)newResourceConfigurationDefinition);
                existingType.setResourceConfigurationDefinition(newResourceConfigurationDefinition);
            } else {
                ConfigurationDefinition existingDefinition = existingType.getResourceConfigurationDefinition();
                this.configurationMetadataManager.updateConfigurationDefinition(newResourceConfigurationDefinition, existingDefinition);
            }
        } else if (existingType.getResourceConfigurationDefinition() != null) {
            existingType.setResourceConfigurationDefinition(null);
        }
    }

    private <T> Set<T> missingInFirstSet(Set<T> first, Set<T> reference) {
        HashSet<T> result = new HashSet<T>();
        if (reference != null) {
            if (first == null) {
                result.addAll(reference);
                return result;
            }
            for (T item : reference) {
                boolean found = false;
                for (T f : first) {
                    if (!f.equals(item)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                result.add(item);
            }
        }
        return result;
    }

    private <T> Set<T> intersection(Set<T> first, Set<T> second) {
        HashSet<T> result = new HashSet<T>();
        if (first != null && second != null) {
            result.addAll(first);
            Iterator iter = result.iterator();
            while (iter.hasNext()) {
                Object item = iter.next();
                boolean found = false;
                for (T s : second) {
                    if (!s.equals(item)) continue;
                    found = true;
                }
                if (found) continue;
                iter.remove();
            }
        }
        return result;
    }
}

