/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.search.execution;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.criteria.SavedSearchCriteria;
import org.rhq.core.domain.search.SavedSearch;
import org.rhq.core.domain.search.SearchSubsystem;
import org.rhq.core.domain.search.SearchSuggestion;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.enterprise.server.search.SavedSearchManagerLocal;
import org.rhq.enterprise.server.search.assist.SearchAssistant;
import org.rhq.enterprise.server.search.assist.SearchAssistantFactory;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchAssistManager {
    private static final Log LOG = LogFactory.getLog(SearchAssistManager.class);
    private SavedSearchManagerLocal savedSearchManager = LookupUtil.getSavedSearchManager();
    private static List<String> comparisonOperators = Arrays.asList("!==", "!=", "==", "=");
    private static List<String> booleanOperators = Arrays.asList("and", "or", "|");
    private Subject subject;
    private SearchSubsystem searchSubsystem;

    public SearchAssistManager(Subject subject, SearchSubsystem searchSubsystem) {
        this.subject = subject;
        this.searchSubsystem = searchSubsystem;
    }

    protected SearchAssistant getSearchAssistant() {
        return SearchAssistantFactory.getAssistant(this.searchSubsystem);
    }

    private List<String> getAllContexts() {
        ArrayList<String> results = new ArrayList<String>(this.getSearchAssistant().getSimpleContexts());
        for (String parameterized : this.getSearchAssistant().getParameterizedContexts()) {
            results.add(parameterized + "[");
        }
        return results;
    }

    public List<SearchSuggestion> getSuggestions(String expression, int caretPos) {
        if (expression == null) {
            expression = "";
        }
        List<SearchSuggestion> simple = this.getSimpleSuggestions(expression, caretPos);
        List<SearchSuggestion> advanced = this.getAdvancedSuggestions(expression, caretPos);
        List<SearchSuggestion> userSavedSearches = this.getUserSavedSearchSuggestions(expression);
        ArrayList<SearchSuggestion> results = new ArrayList<SearchSuggestion>();
        results.addAll(simple);
        results.addAll(advanced);
        results.addAll(userSavedSearches);
        Collections.sort(results);
        return results;
    }

    public List<SearchSuggestion> getSimpleSuggestions(String expression, int caretPos) {
        SearchAssistant completor = this.getSearchAssistant();
        this.debug("getSimpleSuggestions: START");
        SearchTermAssistant assistant = new SearchTermAssistant(expression, caretPos);
        String beforeCaret = assistant.getFragmentBeforeCaret();
        ParsedContext parsed = ParsedContext.get(beforeCaret);
        if (!parsed.isSimple()) {
            return Collections.emptyList();
        }
        String parsedTerm = parsed.context;
        String primarySimpleContext = completor.getPrimarySimpleContext();
        this.debug("getSimpleSuggestions: suggesting value completions for a simple context [" + primarySimpleContext + "]");
        List<String> valueSuggestions = this.pad("\"", completor.getValues(primarySimpleContext, null, parsedTerm), "\"");
        List<SearchSuggestion> suggestions = this.convert(valueSuggestions, parsed, parsedTerm, SearchSuggestion.Kind.Simple);
        return suggestions;
    }

    public List<SearchSuggestion> getAdvancedSuggestions(String expression, int caretPos) {
        SearchAssistant completor = this.getSearchAssistant();
        this.debug("getAdvancedSuggestions: START");
        SearchTermAssistant assistant = new SearchTermAssistant(expression, caretPos);
        String[] tokens = assistant.getTerms().toArray(new String[0]);
        this.debug("" + tokens.length + " tokens are " + Arrays.asList(tokens));
        if (tokens.length == 0 || caretPos == 0) {
            this.debug("getAdvancedSuggestions: no terms");
            return this.convert(this.getAllContexts());
        }
        String beforeCaret = assistant.getFragmentBeforeCaret();
        this.debug("getAdvancedSuggestions: beforeCaret is '" + beforeCaret + "'");
        ParsedContext parsed = ParsedContext.get(beforeCaret);
        this.debug("getAdvancedSuggestions: parsed is " + parsed);
        switch (parsed.state) {
            case CONTEXT: {
                if (parsed.context.equals("")) {
                    if (tokens.length == 1) {
                        this.debug("getAdvancedSuggestions: no terms yet, suggesting contexts");
                        return this.convert(this.getAllContexts());
                    }
                    if (this.isBooleanTerm(assistant.getPreviousToken())) {
                        this.debug("getAdvancedSuggestions: previous term was boolean, suggesting contexts");
                        return this.convert(this.getAllContexts());
                    }
                    this.debug("getAdvancedSuggestions: previous term was not boolean, suggesting boolean");
                    return this.convert(booleanOperators);
                }
                if (this.isBooleanTerm(parsed.context)) {
                    this.debug("getAdvancedSuggestions: beforeCaret is whole boolean operator");
                    return this.convert(this.getAllContexts());
                }
                if (completor.getSimpleContexts().contains(parsed.context)) {
                    this.debug("getAdvancedSuggestions: search term is simple context, wants operator");
                    return this.convert(this.pad(parsed.context, comparisonOperators, ""), parsed, parsed.context);
                }
                if (completor.getParameterizedContexts().contains(parsed.context)) {
                    this.debug("getAdvancedSuggestions: search term is parameterized context, wants open bracket");
                    return this.convert(Arrays.asList(parsed.context + "["), parsed, parsed.context);
                }
                this.debug("getAdvancedSuggestions: search term wants context completion");
                ArrayList<String> startsWithContexts = new ArrayList<String>();
                String lowerCaseParsedContext = parsed.context.toLowerCase();
                for (String context : completor.getSimpleContexts()) {
                    if (context.indexOf(lowerCaseParsedContext) == -1) continue;
                    startsWithContexts.add(context);
                }
                for (String context : completor.getParameterizedContexts()) {
                    if (context.indexOf(lowerCaseParsedContext) == -1) continue;
                    startsWithContexts.add(context + "[");
                }
                return this.convert(startsWithContexts, parsed, parsed.context);
            }
            case PARAM: {
                this.debug("getAdvancedSuggestions: param state");
                return this.convert(this.pad(parsed.context + "[", completor.getParameters(parsed.context, parsed.param), "]"), parsed, parsed.param);
            }
            case OPERATOR: {
                this.debug("getAdvancedSuggestions: operator state");
                if (comparisonOperators.contains(parsed.operator)) {
                    this.debug("search term is complete operator, suggesting values instead");
                    List<String> valueSuggestions = this.pad("\"", completor.getValues(parsed.context, parsed.param, ""), "\"");
                    if (completor.getSimpleContexts().contains(parsed.context)) {
                        this.debug("getAdvancedSuggestions: suggesting value completions for a simple context");
                        return this.convert(this.pad(parsed.context + parsed.operator, valueSuggestions, ""));
                    }
                    this.debug("getAdvancedSuggestions: suggesting value completions for a parameterized context");
                    return this.convert(this.pad(parsed.context + "[" + parsed.param + "]" + parsed.operator, valueSuggestions, ""));
                }
                ArrayList<String> operatorSuggestions = new ArrayList<String>();
                for (String op : comparisonOperators) {
                    if (!op.startsWith(parsed.operator)) continue;
                    operatorSuggestions.add(op);
                }
                this.debug("getAdvancedSuggestions: providing suggestions for comparison operators");
                if (completor.getSimpleContexts().contains(parsed.context)) {
                    return this.convert(this.pad(parsed.context, operatorSuggestions, ""));
                }
                return this.convert(this.pad(parsed.context + "[" + parsed.param + "]", operatorSuggestions, ""));
            }
            case VALUE: {
                this.debug("getAdvancedSuggestions: value state");
                List<String> valueSuggestions = this.pad("\"", completor.getValues(parsed.context, parsed.param, parsed.value), "\"");
                if (completor.getSimpleContexts().contains(parsed.context)) {
                    this.debug("getAdvancedSuggestions: suggesting value completions for a simple context");
                    return this.convert(this.pad(parsed.context + parsed.operator, valueSuggestions, ""), parsed, parsed.value);
                }
                this.debug("getAdvancedSuggestions: suggesting value completions for a parameterized context");
                return this.convert(this.pad(parsed.context + "[" + parsed.param + "]" + parsed.operator, valueSuggestions, ""), parsed, parsed.value);
            }
        }
        return Collections.emptyList();
    }

    public List<SearchSuggestion> getUserSavedSearchSuggestions(String expression) {
        expression = expression.trim().toLowerCase().replaceAll("\\s+", " ");
        SavedSearchCriteria criteria = new SavedSearchCriteria();
        criteria.addFilterSubjectId(Integer.valueOf(this.subject.getId()));
        criteria.addFilterSearchSubsystem(this.searchSubsystem);
        if (!expression.equals("")) {
            criteria.addFilterName(expression);
        }
        criteria.setCaseSensitive(false);
        criteria.addSortName(PageOrdering.ASC);
        PageList<SavedSearch> savedSearchResults = this.savedSearchManager.findSavedSearchesByCriteria(this.subject, criteria);
        ArrayList<SearchSuggestion> results = new ArrayList<SearchSuggestion>();
        for (SavedSearch next : savedSearchResults) {
            String label = next.getName();
            String value = next.getPattern();
            int index = next.getName().toLowerCase().indexOf(expression);
            SearchSuggestion suggestion = new SearchSuggestion(SearchSuggestion.Kind.UserSavedSearch, label, value, index, expression.length());
            results.add(suggestion);
        }
        return results;
    }

    public List<SearchSuggestion> getGlobalSavedSearchSuggestions(String expression) {
        expression = expression.trim().toLowerCase().replaceAll("\\s+", " ");
        SavedSearchCriteria criteria = new SavedSearchCriteria();
        criteria.addFilterGlobal(Boolean.valueOf(true));
        criteria.addFilterSearchSubsystem(this.searchSubsystem);
        if (!expression.equals("")) {
            criteria.addFilterName(expression);
        }
        criteria.setCaseSensitive(false);
        criteria.addSortName(PageOrdering.ASC);
        PageList<SavedSearch> savedSearchResults = this.savedSearchManager.findSavedSearchesByCriteria(this.subject, criteria);
        ArrayList<SearchSuggestion> results = new ArrayList<SearchSuggestion>();
        for (SavedSearch next : savedSearchResults) {
            String label = next.getName();
            String value = next.getPattern();
            int index = next.getName().toLowerCase().indexOf(expression);
            SearchSuggestion suggestion = new SearchSuggestion(SearchSuggestion.Kind.GlobalSavedSearch, label, value, index, expression.length());
            results.add(suggestion);
        }
        return results;
    }

    private boolean isBooleanTerm(String term) {
        for (String op : booleanOperators) {
            if (!op.equals(term)) continue;
            return true;
        }
        return false;
    }

    private List<SearchSuggestion> convert(List<String> suggestions) {
        return this.convert(suggestions, null, "", SearchSuggestion.Kind.Advanced);
    }

    private List<SearchSuggestion> convert(List<String> suggestions, ParsedContext parsed, String term) {
        return this.convert(suggestions, parsed, term, SearchSuggestion.Kind.Advanced);
    }

    private List<SearchSuggestion> convert(List<String> suggestions, ParsedContext parsed, String term, SearchSuggestion.Kind kind) {
        int startIndex = this.getStartIndex(parsed);
        term = term.toLowerCase();
        ArrayList<SearchSuggestion> results = new ArrayList<SearchSuggestion>(suggestions.size());
        for (String suggestion : suggestions) {
            int index = suggestion.toLowerCase().indexOf(term, startIndex);
            results.add(new SearchSuggestion(kind, suggestion, index, term.length()));
        }
        return results;
    }

    private int getStartIndex(ParsedContext parsed) {
        if (parsed == null) {
            return 0;
        }
        switch (parsed.state) {
            case PARAM: {
                return parsed.context.length();
            }
            case OPERATOR: {
                return parsed.context.length() + (parsed.param != null ? parsed.param.length() : 0);
            }
            case VALUE: {
                return parsed.context.length() + (parsed.param != null ? parsed.param.length() : 0) + parsed.operator.length();
            }
        }
        return 0;
    }

    private List<String> pad(String leftPad, List<String> data, String rightPad) {
        ArrayList<String> results = new ArrayList<String>();
        for (String next : data) {
            results.add(leftPad + next + rightPad);
        }
        return results;
    }

    private void debug(String message) {
        LOG.debug((Object)message);
    }

    static class ParsedContext {
        public final String context;
        public final String param;
        public final String operator;
        public final String value;
        public final State state;

        private ParsedContext(String context, String param, String operator, String value) {
            this.context = context;
            this.param = param;
            this.operator = operator;
            this.value = value;
            this.state = this.computeState(context, param, operator, value);
        }

        private State computeState(String context, String param, String operator, String value) {
            if (value != null) {
                return State.VALUE;
            }
            if (operator != null) {
                return State.OPERATOR;
            }
            if (param != null) {
                return State.PARAM;
            }
            return State.CONTEXT;
        }

        public static ParsedContext get(String term) {
            int index;
            char[] expr = term.toCharArray();
            StringBuilder buffer = new StringBuilder();
            for (index = 0; index < expr.length && expr[index] != '[' && expr[index] != '!' && expr[index] != '='; ++index) {
                buffer.append(expr[index]);
            }
            String context = buffer.toString();
            buffer = new StringBuilder();
            if (index == expr.length || expr[index] != '[' && expr[index] != '!' && expr[index] != '=') {
                return new ParsedContext(context, null, null, null);
            }
            String param = null;
            if (expr[index] == '[') {
                ++index;
                while (index < expr.length && expr[index] != ']') {
                    buffer.append(expr[index]);
                    ++index;
                }
                param = buffer.toString();
                buffer = new StringBuilder();
                if (index == expr.length || expr[index] != ']') {
                    return new ParsedContext(context, param, null, null);
                }
                ++index;
            }
            while (index < expr.length && (expr[index] == '!' || expr[index] == '=')) {
                buffer.append(expr[index]);
                ++index;
            }
            String operator = buffer.toString();
            if (index == expr.length) {
                return new ParsedContext(context, param, operator, null);
            }
            String value = term.substring(index);
            if (value.length() > 0 && (value.charAt(0) == '\'' || value.charAt(0) == '\"')) {
                value = value.substring(1);
            }
            return new ParsedContext(context, param, operator, value);
        }

        public boolean isSimple() {
            if (this.operator != null) {
                return false;
            }
            return this.param == null;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.getClass().getSimpleName()).append("[");
            buffer.append("state=").append((Object)this.state);
            buffer.append(", context(").append(this.context);
            buffer.append("), param(").append(this.param);
            buffer.append("), operator(").append(this.operator);
            buffer.append("), value(").append(this.value).append(")]");
            return buffer.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum State {
            CONTEXT,
            PARAM,
            OPERATOR,
            VALUE;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SearchTermAssistant {
        private static final String CARET = "@@@";
        String expression;
        List<String> terms;
        int currentTermIndex;
        int indexWithinTerm;

        public SearchTermAssistant(String expression, int caretPos) {
            String before = expression.substring(0, caretPos);
            String after = expression.substring(caretPos);
            this.expression = before + CARET + after;
            this.tokenize();
            for (int i = 0; i < this.terms.size(); ++i) {
                String term = this.terms.get(i);
                int index = term.indexOf(CARET);
                if (index == -1) continue;
                String replaced = term.replace(CARET, "");
                this.terms.set(i, replaced);
                this.currentTermIndex = i;
                this.indexWithinTerm = index;
                break;
            }
        }

        private void tokenize() {
            List<String> fragments = this.tokenizeIntoFragments(this.expression);
            this.terms = this.joinIntoTerms(fragments);
        }

        private List<String> tokenizeIntoFragments(String expression) {
            ArrayList<String> fragments = new ArrayList<String>();
            char quoteChar = '\u0000';
            StringBuilder term = new StringBuilder();
            for (char nextChar : expression.toCharArray()) {
                if (quoteChar != '\u0000') {
                    term.append(nextChar);
                    if (nextChar != quoteChar) continue;
                    quoteChar = '\u0000';
                    continue;
                }
                if (Character.isWhitespace(nextChar)) {
                    if (term.length() <= 0) continue;
                    fragments.add(term.toString());
                    term = new StringBuilder();
                    continue;
                }
                if (nextChar == '(' || nextChar == ')') continue;
                term.append(nextChar);
                if (nextChar != '\'' && nextChar != '\"') continue;
                quoteChar = nextChar;
            }
            if (term.length() > 0) {
                fragments.add(term.toString());
            }
            return fragments;
        }

        private List<String> joinIntoTerms(List<String> fragments) {
            if (fragments.size() < 3) {
                return fragments;
            }
            ArrayList<String> terms = new ArrayList<String>();
            int i = 1;
            while (i < fragments.size() - 1) {
                String before = fragments.get(i - 1);
                String term = fragments.get(i);
                if (comparisonOperators.contains(term)) {
                    String after = fragments.get(i + 1);
                    terms.add(before + term + after);
                    i += 3;
                    continue;
                }
                terms.add(before);
                ++i;
            }
            if (i < fragments.size()) {
                String nextToLast = fragments.get(fragments.size() - 2);
                String last = fragments.get(fragments.size() - 1);
                if (comparisonOperators.contains(last)) {
                    terms.add(nextToLast + last);
                } else {
                    terms.add(nextToLast);
                    terms.add(last);
                }
            } else if (i == fragments.size()) {
                String last = fragments.get(fragments.size() - 1);
                terms.add(last);
            }
            return terms;
        }

        public List<String> getTerms() {
            return this.terms;
        }

        public String getPreviousToken() {
            return this.terms.get(this.currentTermIndex - 1);
        }

        public String getCurrentToken() {
            return this.terms.get(this.currentTermIndex);
        }

        public String getFragmentBeforeCaret() {
            return this.getCurrentToken().substring(0, this.indexWithinTerm);
        }

        public void report(PrintStream output) {
            output.println("Expression: " + this.expression);
            List<String> fragments = this.tokenizeIntoFragments(this.expression);
            List<String> terms = this.joinIntoTerms(fragments);
            int counter = 0;
            for (String result : terms) {
                output.println("Token[" + ++counter + "]: " + result);
            }
            output.println();
        }

        public String toString() {
            return null;
        }

        public String getExpressionWithReplacement(String replacement) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.terms.size(); ++i) {
                if (i == this.currentTermIndex) {
                    builder.append(replacement);
                } else {
                    builder.append(this.terms.get(i));
                }
                builder.append(' ');
            }
            return builder.toString();
        }
    }
}

