/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.perspective;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.rhq.enterprise.server.perspective.RenderedExtension;
import org.rhq.enterprise.server.perspective.activator.ActivatorHelper;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.MenuItemFeatureType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.MenuItemType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.RenderedExtensionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuItem
extends RenderedExtension
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private MenuItemFeatureType feature;
    private boolean newWindow;
    private boolean addBreak;
    private List<MenuItem> children;

    public MenuItem(MenuItemType rawMenuItem, String perspectiveName) {
        super((RenderedExtensionType)rawMenuItem, perspectiveName, rawMenuItem.getUrl());
        this.feature = rawMenuItem.getFeature();
        this.newWindow = rawMenuItem.isNewWindow();
        this.addBreak = rawMenuItem.isAddBreak();
        this.children = new ArrayList<MenuItem>();
        this.debugMode = ActivatorHelper.initGlobalActivators(rawMenuItem.getActivators(), this.getActivators());
    }

    public MenuItemFeatureType getFeature() {
        return this.feature;
    }

    public boolean isNewWindow() {
        return this.newWindow;
    }

    public boolean isAddBreak() {
        return this.addBreak;
    }

    @NotNull
    public List<MenuItem> getChildren() {
        return this.children;
    }

    public void setChildren(List<MenuItem> children) {
        this.children = children != null ? children : new ArrayList();
    }

    public boolean isMenuGroup() {
        return null != this.children && this.children.size() > 0;
    }

    public boolean isGraphic() {
        String displayName = this.getDisplayName();
        return null == displayName || "".equals(displayName.trim());
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

