/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.disambiguation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.rhq.enterprise.server.resource.disambiguation.DisambiguationPolicy;
import org.rhq.enterprise.server.resource.disambiguation.MutableDisambiguationReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportPartitions<T> {
    private static final long serialVersionUID = 1L;
    private DisambiguationPolicy disambiguationPolicy;
    private List<List<MutableDisambiguationReport<T>>> partitions;

    public ReportPartitions(DisambiguationPolicy disambiguationPolicy) {
        this.disambiguationPolicy = disambiguationPolicy;
        this.partitions = new ArrayList<List<MutableDisambiguationReport<T>>>();
    }

    public ReportPartitions(DisambiguationPolicy disambiguationPolicy, ReportPartitions<T> other) {
        this(disambiguationPolicy);
        this.putAll(other);
    }

    public ReportPartitions(DisambiguationPolicy disambiguationPolicy, List<List<MutableDisambiguationReport<T>>> partitions) {
        this(disambiguationPolicy);
        for (List<MutableDisambiguationReport<T>> partition : partitions) {
            this.putAll(partition);
        }
    }

    public DisambiguationPolicy getDisambiguationPolicy() {
        return this.disambiguationPolicy;
    }

    public List<List<MutableDisambiguationReport<T>>> getAmbiguousPartitions() {
        ArrayList<List<MutableDisambiguationReport<T>>> ret = new ArrayList<List<MutableDisambiguationReport<T>>>();
        for (List<MutableDisambiguationReport<T>> partition : this.partitions) {
            if (partition.size() <= 1) continue;
            ret.add(partition);
        }
        return ret;
    }

    public List<List<MutableDisambiguationReport<T>>> getUniquePartitions() {
        ArrayList<List<MutableDisambiguationReport<T>>> ret = new ArrayList<List<MutableDisambiguationReport<T>>>();
        for (List<MutableDisambiguationReport<T>> partition : this.partitions) {
            if (partition.size() != 1) continue;
            ret.add(partition);
        }
        return ret;
    }

    public List<List<MutableDisambiguationReport<T>>> getAllPartitions() {
        return Collections.unmodifiableList(this.partitions);
    }

    public void put(MutableDisambiguationReport<T> value) {
        boolean found = false;
        for (List<MutableDisambiguationReport<T>> partition : this.partitions) {
            for (MutableDisambiguationReport<T> partitionPrototype : partition) {
                if (!this.disambiguationPolicy.areAmbiguous(partitionPrototype, value)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            partition.add(value);
            break;
        }
        if (!found) {
            ArrayList<MutableDisambiguationReport<T>> newPartition = new ArrayList<MutableDisambiguationReport<T>>();
            newPartition.add(value);
            this.partitions.add(newPartition);
        }
    }

    public void putAll(List<MutableDisambiguationReport<T>> values) {
        for (MutableDisambiguationReport<T> v : values) {
            this.put(v);
        }
    }

    public void putAll(ReportPartitions<T> other) {
        for (List<MutableDisambiguationReport<T>> partition : other.getAllPartitions()) {
            this.putAll(partition);
        }
    }

    public boolean isPartitionsUnique() {
        for (List<MutableDisambiguationReport<T>> partition : this.partitions) {
            if (partition.size() <= 1) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "ReportPartitions[policy=" + this.disambiguationPolicy + ", partitions=" + this.partitions + "]";
    }
}

