/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.group.definition.mbean;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.server.resource.group.definition.mbean.GroupDefinitionRecalculationThreadMonitorMBean;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupDefinitionRecalculationThreadMonitor
implements GroupDefinitionRecalculationThreadMonitorMBean,
MBeanRegistration {
    private static AtomicLong lastAutoRecalculationThreadTime = new AtomicLong(0L);
    private static ConcurrentMap<String, GroupDefinitionRecalculationStatistic> statistics = new ConcurrentHashMap<String, GroupDefinitionRecalculationStatistic>();
    private static MBeanServer mbeanServer;
    private static ObjectName objectName;
    private static GroupDefinitionRecalculationThreadMonitorMBean proxy;

    public static GroupDefinitionRecalculationThreadMonitorMBean getMBean() {
        if (proxy == null) {
            proxy = objectName != null ? MBeanServerInvocationHandler.newProxyInstance(mbeanServer, objectName, GroupDefinitionRecalculationThreadMonitorMBean.class, false) : new GroupDefinitionRecalculationThreadMonitor();
        }
        return proxy;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        objectName = name;
        mbeanServer = server;
        return name;
    }

    @Override
    public void clear() {
        statistics.clear();
    }

    @Override
    public long getGroupDefinitionCount() {
        return LookupUtil.getGroupDefinitionManager().getGroupDefinitionCount(this.getOverlord());
    }

    @Override
    public long getAutoRecalculatingGroupDefinitionCount() {
        return LookupUtil.getGroupDefinitionManager().getAutoRecalculationGroupDefinitionCount(this.getOverlord());
    }

    @Override
    public long getDynaGroupCount() {
        return LookupUtil.getGroupDefinitionManager().getDynaGroupCount(this.getOverlord());
    }

    private Subject getOverlord() {
        return LookupUtil.getSubjectManager().getOverlord();
    }

    @Override
    public long getAutoRecalculationThreadTime() {
        return lastAutoRecalculationThreadTime.get();
    }

    @Override
    public void updateAutoRecalculationThreadTime(long timeInMillis) {
        lastAutoRecalculationThreadTime.set(timeInMillis);
    }

    @Override
    public void updateStatistic(String groupDefinitionName, int newDynaGroupCount, boolean success, long executionTime) {
        statistics.putIfAbsent(groupDefinitionName, new GroupDefinitionRecalculationStatistic());
        GroupDefinitionRecalculationStatistic stat = (GroupDefinitionRecalculationStatistic)statistics.get(groupDefinitionName);
        stat.update(newDynaGroupCount, success, executionTime);
    }

    @Override
    public Map<String, Map<String, Object>> getStatistics() {
        HashMap<String, Map<String, Object>> results = new HashMap<String, Map<String, Object>>();
        for (Map.Entry stat : statistics.entrySet()) {
            String groupDefinitionName = (String)stat.getKey();
            Map<String, Object> groupDefinitionStatistics = ((GroupDefinitionRecalculationStatistic)stat.getValue()).getStatistics();
            results.put(groupDefinitionName, groupDefinitionStatistics);
        }
        return results;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
        mbeanServer = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GroupDefinitionRecalculationStatistic {
        private long dynaGroupCount;
        private long recalculationCount;
        private long successfulCount;
        private long minExecutionTime;
        private long maxExecutionTime;
        private long totalEexecutionTime;

        public synchronized void update(int newDynaGroupCount, boolean success, long executionTime) {
            this.dynaGroupCount = newDynaGroupCount;
            if (success) {
                ++this.successfulCount;
            }
            ++this.recalculationCount;
            if (executionTime < this.minExecutionTime) {
                this.minExecutionTime = executionTime;
            } else if (executionTime > this.maxExecutionTime) {
                this.maxExecutionTime = executionTime;
            }
            this.totalEexecutionTime += executionTime;
        }

        public synchronized Map<String, Object> getStatistics() {
            HashMap<String, Object> stats = new HashMap<String, Object>();
            stats.put("dynaGroupCount", this.dynaGroupCount);
            stats.put("recalculationCount", this.recalculationCount);
            stats.put("successfulCount", this.successfulCount);
            stats.put("failureCount", this.recalculationCount - this.successfulCount);
            stats.put("minExecutionTime", this.minExecutionTime);
            stats.put("maxExecutionTime", this.maxExecutionTime);
            stats.put("avgEexecutionTime", (double)this.totalEexecutionTime / (double)this.recalculationCount);
            return stats;
        }
    }
}

