/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc.perspective.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.enterprise.server.perspective.MenuItem;
import org.rhq.enterprise.server.perspective.PageLink;
import org.rhq.enterprise.server.perspective.Tab;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.ActionType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.ApplicationType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.ExtensionType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.MenuItemType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.PageLinkType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.PageType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.PerspectivePluginDescriptorType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.PlacementType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.PositionType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.RenderedExtensionType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.TabType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.perspective.TaskType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerspectivePluginMetadataManager {
    private final String CORE_PERSPECTIVE_NAME = "CorePerspective";
    private static final String TARGET_MAIN_URL = "/rhq/perspective/main.xhtml?targetUrlKey=";
    private static final String TARGET_RESOURCE_URL = "/rhq/perspective/resource.xhtml?targetUrlKey=";
    private static final Map<Integer, String> KEY_URL_MAP = new HashMap<Integer, String>();
    private final Log log = LogFactory.getLog(this.getClass());
    private Map<String, PerspectivePluginDescriptorType> loadedPlugins = new HashMap<String, PerspectivePluginDescriptorType>();
    private boolean isStarted;
    private long lastModifiedTime;
    private List<Tab> resourceTabs;
    private List<MenuItem> menu;
    private List<PageLink> pageLinks;

    public synchronized void loadPlugin(PerspectivePluginDescriptorType descriptor) {
        this.loadedPlugins.put(descriptor.getName(), descriptor);
    }

    public synchronized void unloadPlugin(PerspectivePluginDescriptorType descriptor) {
        this.loadedPlugins.remove(descriptor.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        if (this.isStarted) {
            return;
        }
        this.menu = new ArrayList<MenuItem>();
        this.resourceTabs = new ArrayList<Tab>();
        this.pageLinks = new ArrayList<PageLink>();
        try {
            this.processCorePerspective();
            this.processNonCorePerspectives();
            Object var2_1 = null;
            this.isStarted = true;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.isStarted = true;
            this.lastModifiedTime = System.currentTimeMillis();
            throw throwable;
        }
        this.lastModifiedTime = System.currentTimeMillis();
    }

    public synchronized void stop() {
        if (!this.isStarted) {
            return;
        }
        this.menu = null;
        this.resourceTabs = null;
        this.isStarted = false;
    }

    private void processCorePerspective() {
        PerspectivePluginDescriptorType corePerspectiveDescriptor = this.loadedPlugins.get("CorePerspective");
        if (corePerspectiveDescriptor == null) {
            throw new IllegalStateException("Core perspective is required but is missing.");
        }
        try {
            this.processPerspective(corePerspectiveDescriptor);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to load core perspective.", e);
        }
    }

    private void processNonCorePerspectives() {
        for (String perspectiveName : this.loadedPlugins.keySet()) {
            if ("CorePerspective".equals(perspectiveName)) continue;
            PerspectivePluginDescriptorType pluginDescriptor = this.loadedPlugins.get(perspectiveName);
            try {
                this.processPerspective(pluginDescriptor);
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to load perspective [" + perspectiveName + "]."), (Throwable)e);
            }
        }
    }

    private void processPerspective(PerspectivePluginDescriptorType perspective) {
        ActionType action;
        List applications = perspective.getApplication();
        for (MenuItemType rawMenuItem : perspective.getMenuItem()) {
            this.resolveUrls(applications, (ExtensionType)rawMenuItem, TARGET_MAIN_URL);
            action = rawMenuItem.getAction();
            switch (action) {
                case ADD: {
                    this.menuAdd(rawMenuItem, perspective.getName());
                    break;
                }
                case REMOVE: {
                    this.menuRemove(rawMenuItem);
                }
            }
        }
        for (TabType rawTab : perspective.getTab()) {
            this.resolveUrls(applications, (ExtensionType)rawTab, TARGET_RESOURCE_URL);
            action = rawTab.getAction();
            switch (action) {
                case ADD: {
                    this.addTab(rawTab, perspective.getName());
                    break;
                }
                case REMOVE: {
                    this.removeTab(rawTab);
                }
            }
        }
        for (PageType rawPage : perspective.getPage()) {
            for (PageLinkType rawPageLink : rawPage.getPageLink()) {
                this.resolveUrls(applications, (ExtensionType)rawPageLink, TARGET_MAIN_URL);
                this.pageLinks.add(new PageLink(rawPageLink, perspective.getName(), rawPage.getName(), rawPageLink.getUrl()));
            }
        }
    }

    private void resolveUrls(List<ApplicationType> applications, ExtensionType extension, String targetUrl) {
        ApplicationType applicationType = this.getApplicationByName(applications, extension.getApplication());
        if (extension instanceof TaskType) {
            TaskType task = (TaskType)extension;
            String resolvedUrl = this.resolveUrl(applicationType, task.getUrl(), targetUrl);
            task.setUrl(resolvedUrl);
        } else if (extension instanceof MenuItemType) {
            MenuItemType menuItem = (MenuItemType)extension;
            String resolvedUrl = this.resolveUrl(applicationType, menuItem.getUrl(), targetUrl);
            menuItem.setUrl(resolvedUrl);
        } else if (extension instanceof TabType) {
            TabType tab = (TabType)extension;
            String resolvedUrl = this.resolveUrl(applicationType, tab.getUrl(), targetUrl);
            tab.setUrl(resolvedUrl);
        } else if (extension instanceof PageLinkType) {
            PageLinkType pageLink = (PageLinkType)extension;
            String resolvedUrl = this.resolveUrl(applicationType, pageLink.getUrl(), targetUrl);
            pageLink.setUrl(resolvedUrl);
        }
        if (extension instanceof RenderedExtensionType) {
            String resolvedIconUrl = this.resolveUrl(applicationType, ((RenderedExtensionType)extension).getIconUrl(), null);
            ((RenderedExtensionType)extension).setIconUrl(resolvedIconUrl);
        }
    }

    private String resolveUrl(ApplicationType applicationType, String url, String targetUrl) {
        String result = url;
        if (null != url && PerspectivePluginMetadataManager.isPerspectiveUrl(url)) {
            if (null == applicationType) {
                throw new IllegalArgumentException("Relative URL found without application. Add application attribute to fully resolve url '" + url + "'");
            }
            String baseUrl = applicationType.getBaseUrl();
            if (!baseUrl.endsWith("/")) {
                baseUrl = baseUrl + "/";
                applicationType.setBaseUrl(baseUrl);
            }
            result = baseUrl + url;
            if (null != targetUrl) {
                String keyedUrl = baseUrl + url;
                int key = this.getUrlKey(keyedUrl);
                result = targetUrl + key;
            }
        }
        return result;
    }

    private static boolean isPerspectiveUrl(String url) {
        return !url.startsWith("/") && !url.startsWith("http");
    }

    private ApplicationType getApplicationByName(List<ApplicationType> applications, String name) {
        ApplicationType result = null;
        if (null != applications && null != name) {
            for (ApplicationType application : applications) {
                if (!application.getName().equals(name)) continue;
                result = application;
                break;
            }
        }
        return result;
    }

    public synchronized int getUrlKey(String url) {
        int key = url.hashCode();
        String mapEntry = KEY_URL_MAP.get(key);
        while (null != mapEntry && !mapEntry.equals(url)) {
            mapEntry = KEY_URL_MAP.get(key *= 13);
        }
        if (null == mapEntry) {
            KEY_URL_MAP.put(key, url);
        }
        return key;
    }

    public String getUrlViaKey(int key) {
        return KEY_URL_MAP.get(key);
    }

    private void printMenu(List<MenuItem> menu, String indent) {
        if (null == menu) {
            return;
        }
        for (MenuItem menuItem : menu) {
            System.out.println(indent + menuItem.getName());
            this.printMenu(menuItem.getChildren(), indent + "   ");
        }
    }

    private void menuAdd(MenuItemType rawMenuItem, String perspectiveName) {
        PositionType position = rawMenuItem.getPosition();
        List<MenuItem> containingMenu = this.getContainingMenu(rawMenuItem);
        MenuItem menuItem = new MenuItem(rawMenuItem, perspectiveName);
        if (PlacementType.FIRST_CHILD == position.getPlacement()) {
            containingMenu.add(0, menuItem);
        } else if (PlacementType.LAST_CHILD == position.getPlacement()) {
            containingMenu.add(menuItem);
        } else {
            int index = this.getMenuItemIndex(containingMenu, position.getName());
            if (-1 == index) {
                throw new IllegalArgumentException("Invalid position defined for menuItem [" + rawMenuItem.getName() + "]. Referenced menuItem not found : " + position.getName() + ". Make sure supporting menus are defined for the menuItem.");
            }
            containingMenu.add(PlacementType.AFTER == position.getPlacement() ? ++index : --index, menuItem);
        }
    }

    private void menuRemove(MenuItemType rawMenuItem) {
        PositionType position = rawMenuItem.getPosition();
        try {
            List<MenuItem> containingMenu = this.getContainingMenu(rawMenuItem);
            int index = this.getMenuItemIndex(containingMenu, rawMenuItem.getName());
            if (-1 == index) {
                throw new IllegalArgumentException("Invalid position defined for menuItem [" + rawMenuItem.getName() + "]. Referenced menuItem not found : " + position.getName() + ". Make sure supporting menus are defined for the menuItem.");
            }
            MenuItem menuItem = containingMenu.get(index);
            if (!menuItem.getPerspectiveName().equals("CorePerspective")) {
                throw new IllegalArgumentException("Invalid position defined for menuItem [" + rawMenuItem.getName() + "]. Referenced menuItem is defined but not by the Core perspective : " + position.getName() + ". Only Core menuItems can be removed.");
            }
            containingMenu.remove(index);
        }
        catch (IllegalArgumentException e) {
            this.log.debug((Object)("Menu item not found. Ignoring removal of menu item [" + rawMenuItem.getName() + "]: " + e));
        }
    }

    private List<MenuItem> getContainingMenu(MenuItemType rawMenuItem) {
        List<MenuItem> result = this.menu;
        String name = rawMenuItem.getName();
        String[] nameTokens = null != name ? name.split("\\.") : new String[]{};
        int i = 0;
        while (i + 1 < nameTokens.length) {
            int index = this.getMenuItemIndex(result, nameTokens[i]);
            if (-1 == index) {
                throw new IllegalArgumentException("Invalid position defined for menuItem [" + rawMenuItem.getName() + "]. No containing menu found for : " + name + ". Make sure supporting menus are defined for the menuItem.");
            }
            MenuItem menuItem = result.get(index);
            result = menuItem.getChildren();
            ++i;
        }
        return result;
    }

    private int getMenuItemIndex(List<MenuItem> menu, String name) {
        int size = menu.size();
        for (int i = 0; i < size; ++i) {
            if (!menu.get(i).getName().endsWith(name)) continue;
            return i;
        }
        return -1;
    }

    private void addTab(TabType rawTab, String perspectiveName) {
        PositionType position = rawTab.getPosition();
        List<Tab> siblingTabs = this.getSiblingTabs(rawTab);
        Tab tab = new Tab(rawTab, perspectiveName);
        if (PlacementType.FIRST_CHILD == position.getPlacement()) {
            siblingTabs.add(0, tab);
        } else if (PlacementType.LAST_CHILD == position.getPlacement()) {
            siblingTabs.add(tab);
        } else {
            int index = this.getTabIndex(siblingTabs, position.getName());
            if (index == -1) {
                throw new IllegalArgumentException("Invalid position defined for tab [" + rawTab.getName() + "]. Referenced tab not found : " + position.getName() + ". Make sure supporting tabs are defined for the tab.");
            }
            siblingTabs.add(PlacementType.AFTER == position.getPlacement() ? ++index : --index, tab);
        }
    }

    private void removeTab(TabType rawTab) {
        PositionType position = rawTab.getPosition();
        try {
            List<Tab> siblingTabs = this.getSiblingTabs(rawTab);
            int index = this.getTabIndex(siblingTabs, rawTab.getName());
            if (index == -1) {
                throw new IllegalArgumentException("Invalid position defined for menuItem [" + rawTab.getName() + "]. Referenced menuItem not found : " + position.getName() + ". Make sure supporting menus are defined for the menuItem.");
            }
            Tab tab = siblingTabs.get(index);
            if (!tab.getPerspectiveName().equals("CorePerspective")) {
                throw new IllegalArgumentException("Invalid position defined for tab [" + tab.getName() + "]. Referenced tab is defined but not by the Core perspective : " + position.getName() + ". Only Core tabs can be removed.");
            }
            siblingTabs.remove(index);
        }
        catch (IllegalArgumentException e) {
            this.log.debug((Object)("Tab not found. Ignoring removal of tab [" + rawTab.getName() + "]: " + e));
        }
    }

    private List<Tab> getSiblingTabs(TabType rawTab) {
        List<Tab> result = this.resourceTabs;
        String name = rawTab.getName();
        String[] nameTokens = name != null ? name.split("\\.") : new String[]{};
        int i = 0;
        while (i + 1 < nameTokens.length) {
            int index = this.getTabIndex(result, nameTokens[i]);
            if (index == -1) {
                throw new IllegalArgumentException("Invalid position defined for tab [" + rawTab.getName() + "]. No parent tab found for tab [" + name + "]. Make sure supporting tabs are defined for the tab.");
            }
            Tab parentTab = result.get(index);
            result = parentTab.getChildren();
            ++i;
        }
        return result;
    }

    private int getTabIndex(List<Tab> tabs, String name) {
        int size = tabs.size();
        for (int i = 0; i < size; ++i) {
            if (!tabs.get(i).getQualifiedName().endsWith(name)) continue;
            return i;
        }
        return -1;
    }

    public List<MenuItem> getMenu() {
        return this.menu;
    }

    public List<Tab> getResourceTabs() {
        return this.resourceTabs;
    }

    public List<PageLink> getPageLinks() {
        return this.pageLinks;
    }

    public synchronized boolean isStarted() {
        return this.isStarted;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }
}

